/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.jmol.app;

import java.util.Hashtable;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import org.openscience.jmol.app.JmolResourceHandler;

class GuiMap {
    Hashtable map = new Hashtable();

    GuiMap() {
    }

    String getLabel(String key) {
        String label = JmolResourceHandler.getStringX(key + "Label");
        if (label == null) {
            label = key;
        }
        return label;
    }

    JMenu newJMenu(String key) {
        return new KeyJMenu(key, this.getLabel(key));
    }

    JMenuItem newJMenuItem(String key) {
        return new KeyJMenuItem(key, this.getLabel(key));
    }

    JCheckBoxMenuItem newJCheckBoxMenuItem(String key, boolean isChecked) {
        return new KeyJCheckBoxMenuItem(key, this.getLabel(key), isChecked);
    }

    JRadioButtonMenuItem newJRadioButtonMenuItem(String key) {
        return new KeyJRadioButtonMenuItem(key, this.getLabel(key));
    }

    JCheckBox newJCheckBox(String key, boolean isChecked) {
        return new KeyJCheckBox(key, this.getLabel(key), isChecked);
    }

    Object get(String key) {
        return this.map.get(key);
    }

    String getKey(Object obj) {
        return ((GetKey)obj).getKey();
    }

    void setSelected(String key, boolean b) {
        ((AbstractButton)this.get(key)).setSelected(b);
    }

    boolean isSelected(String key) {
        return ((AbstractButton)this.get(key)).isSelected();
    }

    class KeyJCheckBox
    extends JCheckBox
    implements GetKey {
        String key;

        KeyJCheckBox(String key, String label, boolean isChecked) {
            super(label, isChecked);
            this.key = key;
            GuiMap.this.map.put(key, this);
        }

        public String getKey() {
            return this.key;
        }
    }

    class KeyJRadioButtonMenuItem
    extends JRadioButtonMenuItem
    implements GetKey {
        String key;

        KeyJRadioButtonMenuItem(String key, String label) {
            super(label);
            this.key = key;
            GuiMap.this.map.put(key, this);
        }

        public String getKey() {
            return this.key;
        }
    }

    class KeyJCheckBoxMenuItem
    extends JCheckBoxMenuItem
    implements GetKey {
        String key;

        KeyJCheckBoxMenuItem(String key, String label, boolean isChecked) {
            super(label, isChecked);
            this.key = key;
            GuiMap.this.map.put(key, this);
        }

        public String getKey() {
            return this.key;
        }
    }

    class KeyJMenuItem
    extends JMenuItem
    implements GetKey {
        String key;

        KeyJMenuItem(String key, String label) {
            super(label);
            this.key = key;
            GuiMap.this.map.put(key, this);
        }

        public String getKey() {
            return this.key;
        }
    }

    class KeyJMenu
    extends JMenu
    implements GetKey {
        String key;

        KeyJMenu(String key, String label) {
            super(label);
            this.key = key;
            GuiMap.this.map.put(key, this);
        }

        public String getKey() {
            return this.key;
        }
    }

    static interface GetKey {
        public String getKey();
    }
}

