/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.jmol.viewer;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.io.Reader;
import java.net.URL;
import java.util.BitSet;
import java.util.Hashtable;
import javax.vecmath.AxisAngle4f;
import javax.vecmath.Matrix3f;
import javax.vecmath.Matrix4f;
import javax.vecmath.Point3f;
import javax.vecmath.Point3i;
import javax.vecmath.Vector3f;
import org.jmol.api.ModelAdapter;
import org.jmol.g3d.Font3D;
import org.jmol.g3d.Graphics3D;
import org.openscience.jmol.viewer.JmolConstants;
import org.openscience.jmol.viewer.JmolStatusListener;
import org.openscience.jmol.viewer.datamodel.Atom;
import org.openscience.jmol.viewer.datamodel.AtomIterator;
import org.openscience.jmol.viewer.datamodel.Bond;
import org.openscience.jmol.viewer.datamodel.BondIterator;
import org.openscience.jmol.viewer.datamodel.Frame;
import org.openscience.jmol.viewer.datamodel.FrameRenderer;
import org.openscience.jmol.viewer.managers.ColorManager;
import org.openscience.jmol.viewer.managers.FileManager;
import org.openscience.jmol.viewer.managers.ModelManager;
import org.openscience.jmol.viewer.managers.MouseManager;
import org.openscience.jmol.viewer.managers.MouseManager10;
import org.openscience.jmol.viewer.managers.MouseWrapper11;
import org.openscience.jmol.viewer.managers.MouseWrapper14;
import org.openscience.jmol.viewer.managers.RepaintManager;
import org.openscience.jmol.viewer.managers.SelectionManager;
import org.openscience.jmol.viewer.managers.StyleManager;
import org.openscience.jmol.viewer.managers.TempManager;
import org.openscience.jmol.viewer.managers.TransformManager;
import org.openscience.jmol.viewer.script.Eval;

public final class JmolViewer {
    public Component awtComponent;
    public ColorManager colorManager;
    public TransformManager transformManager;
    public SelectionManager selectionManager;
    public MouseManager mouseManager;
    public FileManager fileManager;
    public ModelManager modelManager;
    public RepaintManager repaintManager;
    public StyleManager styleManager;
    public TempManager tempManager;
    public Eval eval;
    public Graphics3D g3d;
    public ModelAdapter modelAdapter;
    public String strJavaVendor;
    public String strJavaVersion;
    public String strOSName;
    public boolean jvm11orGreater = false;
    public boolean jvm12orGreater = false;
    public boolean jvm14orGreater = false;
    JmolStatusListener jmolStatusListener;
    public final Hashtable imageCache = new Hashtable();
    static final float radiansPerDegree = (float)Math.PI / 180;
    static final float degreesPerRadian = 57.29578f;
    final Dimension dimScreen = new Dimension();
    final Rectangle rectClip = new Rectangle();
    public boolean selectionHaloEnabled = false;
    private boolean bondSelectionModeOr;
    public int motionEventNumber;
    public boolean wasInMotion = false;
    int hoverAtomIndex = -1;
    int strandsCount = 5;
    boolean rasmolHydrogenSetting = true;
    boolean rasmolHeteroSetting = true;
    boolean debugScript = false;
    public boolean testFlag1;
    public boolean testFlag2;
    public boolean testFlag3;
    boolean tOversampleStopped;
    boolean tOversampleAlways;
    final AtomIterator nullAtomIterator = new NullAtomIterator();
    final BondIterator nullBondIterator = new NullBondIterator();

    public JmolViewer(Component awtComponent, ModelAdapter modelAdapter) {
        this.awtComponent = awtComponent;
        this.modelAdapter = modelAdapter;
        this.strJavaVendor = System.getProperty("java.vendor");
        this.strOSName = System.getProperty("os.name");
        this.strJavaVersion = System.getProperty("java.version");
        this.jvm11orGreater = this.strJavaVersion.compareTo("1.1") >= 0 && (!this.strJavaVendor.startsWith("Netscape") || this.strJavaVersion.compareTo("1.1.5") > 0 || !"Mac OS".equals(this.strOSName));
        this.jvm12orGreater = this.strJavaVersion.compareTo("1.2") >= 0;
        this.jvm14orGreater = this.strJavaVersion.compareTo("1.4") >= 0;
        System.out.println("(C) 2004 The Jmol Development Team\nJmol Version 10pre15  " + JmolConstants.date + "\njava.vendor:" + this.strJavaVendor + "\njava.version:" + this.strJavaVersion + "\nos.name:" + this.strOSName);
        this.g3d = new Graphics3D(awtComponent);
        this.colorManager = new ColorManager(this, this.g3d);
        this.transformManager = new TransformManager(this);
        this.selectionManager = new SelectionManager(this);
        this.mouseManager = this.jvm14orGreater ? MouseWrapper14.alloc(awtComponent, this) : (this.jvm11orGreater ? MouseWrapper11.alloc(awtComponent, this) : new MouseManager10(awtComponent, this));
        this.fileManager = new FileManager(this, modelAdapter);
        this.repaintManager = new RepaintManager(this);
        this.modelManager = new ModelManager(this, modelAdapter);
        this.styleManager = new StyleManager(this);
        this.tempManager = new TempManager(this);
    }

    public Component getAwtComponent() {
        return this.awtComponent;
    }

    public boolean handleOldJvm10Event(Event e) {
        return this.mouseManager.handleOldJvm10Event(e);
    }

    public void homePosition() {
        this.setCenter(null);
        this.selectAll();
        this.transformManager.homePosition();
        this.refresh();
    }

    public void flushCachedImages() {
        this.imageCache.clear();
        this.colorManager.flushCachedColors();
    }

    public void logError(String strMsg) {
        System.out.println("strMsg");
    }

    public void rotateXYBy(int xDelta, int yDelta) {
        this.transformManager.rotateXYBy(xDelta, yDelta);
        this.refresh();
    }

    public void rotateZBy(int zDelta) {
        this.transformManager.rotateZBy(zDelta);
        this.refresh();
    }

    public void rotateFront() {
        this.transformManager.rotateFront();
        this.refresh();
    }

    public void rotateToX(float angleRadians) {
        this.transformManager.rotateToX(angleRadians);
        this.refresh();
    }

    public void rotateToY(float angleRadians) {
        this.transformManager.rotateToY(angleRadians);
        this.refresh();
    }

    public void rotateToZ(float angleRadians) {
        this.transformManager.rotateToZ(angleRadians);
        this.refresh();
    }

    public void rotateToX(int angleDegrees) {
        this.rotateToX((float)angleDegrees * ((float)Math.PI / 180));
    }

    public void rotateToY(int angleDegrees) {
        this.rotateToY((float)angleDegrees * ((float)Math.PI / 180));
    }

    public void rotateToZ(int angleDegrees) {
        this.rotateToZ((float)angleDegrees * ((float)Math.PI / 180));
    }

    public void rotateXRadians(float angleRadians) {
        this.transformManager.rotateXRadians(angleRadians);
        this.refresh();
    }

    public void rotateYRadians(float angleRadians) {
        this.transformManager.rotateYRadians(angleRadians);
        this.refresh();
    }

    public void rotateZRadians(float angleRadians) {
        this.transformManager.rotateZRadians(angleRadians);
        this.refresh();
    }

    public void rotateXDegrees(float angleDegrees) {
        this.rotateXRadians(angleDegrees * ((float)Math.PI / 180));
    }

    public void rotateYDegrees(float angleDegrees) {
        this.rotateYRadians(angleDegrees * ((float)Math.PI / 180));
    }

    public void rotateZDegrees(float angleDegrees) {
        this.rotateZRadians(angleDegrees * ((float)Math.PI / 180));
    }

    public void rotateZDegreesScript(float angleDegrees) {
        this.transformManager.rotateZRadiansScript(angleDegrees * ((float)Math.PI / 180));
        this.refresh();
    }

    public void rotate(AxisAngle4f axisAngle) {
        this.transformManager.rotate(axisAngle);
        this.refresh();
    }

    public void rotateAxisAngle(float x, float y, float z, float degrees) {
        this.transformManager.rotateAxisAngle(x, y, z, degrees);
    }

    public void rotateTo(float xAxis, float yAxis, float zAxis, float degrees) {
        this.transformManager.rotateTo(xAxis, yAxis, zAxis, degrees);
    }

    public void rotateTo(AxisAngle4f axisAngle) {
        this.transformManager.rotateTo(axisAngle);
    }

    public void translateXYBy(int xDelta, int yDelta) {
        this.transformManager.translateXYBy(xDelta, yDelta);
        this.refresh();
    }

    public void translateToXPercent(int percent) {
        this.transformManager.translateToXPercent(percent);
        this.refresh();
    }

    public void translateToYPercent(int percent) {
        this.transformManager.translateToYPercent(percent);
        this.refresh();
    }

    public void translateToZPercent(int percent) {
        this.transformManager.translateToZPercent(percent);
        this.refresh();
    }

    public int getTranslationXPercent() {
        return this.transformManager.getTranslationXPercent();
    }

    public int getTranslationYPercent() {
        return this.transformManager.getTranslationYPercent();
    }

    public int getTranslationZPercent() {
        return this.transformManager.getTranslationZPercent();
    }

    public void translateByXPercent(int percent) {
        this.translateToXPercent(this.getTranslationXPercent() + percent);
    }

    public void translateByYPercent(int percent) {
        this.translateToYPercent(this.getTranslationYPercent() + percent);
    }

    public void translateByZPercent(int percent) {
        this.translateToZPercent(this.getTranslationZPercent() + percent);
    }

    public void zoomBy(int pixels) {
        this.transformManager.zoomBy(pixels);
        this.refresh();
    }

    public int getZoomPercent() {
        return this.transformManager.zoomPercent;
    }

    public int getZoomPercentSetting() {
        return this.transformManager.zoomPercentSetting;
    }

    public void zoomToPercent(int percent) {
        this.transformManager.zoomToPercent(percent);
        this.refresh();
    }

    public void zoomByPercent(int percent) {
        this.transformManager.zoomByPercent(percent);
        this.refresh();
    }

    public void setZoomEnabled(boolean zoomEnabled) {
        this.transformManager.setZoomEnabled(zoomEnabled);
        this.refresh();
    }

    public boolean getSlabEnabled() {
        return this.transformManager.slabEnabled;
    }

    public int getSlabPercentSetting() {
        return this.transformManager.slabPercentSetting;
    }

    public void slabBy(int pixels) {
        this.transformManager.slabBy(pixels);
        this.refresh();
    }

    public void slabToPercent(int percentSlab) {
        this.transformManager.slabToPercent(percentSlab);
        this.refresh();
    }

    public void depthToPercent(int percentDepth) {
        this.transformManager.depthToPercent(percentDepth);
        this.refresh();
    }

    public void slabByPercent(int percentSlab) {
        this.transformManager.slabByPercent(percentSlab);
        this.refresh();
    }

    public void setSlabEnabled(boolean slabEnabled) {
        this.transformManager.setSlabEnabled(slabEnabled);
        this.refresh();
    }

    public void setModeSlab(int modeSlab) {
        this.transformManager.setModeSlab(modeSlab);
        this.refresh();
    }

    public int getModeSlab() {
        return this.transformManager.modeSlab;
    }

    public Matrix4f getUnscaledTransformMatrix() {
        return this.transformManager.getUnscaledTransformMatrix();
    }

    public void calcTransformMatrices() {
        this.transformManager.calcTransformMatrices();
    }

    public Point3i transformPoint(Point3f pointAngstroms) {
        return this.transformManager.transformPoint(pointAngstroms);
    }

    public Point3i transformPoint(Point3f pointAngstroms, Vector3f vibrationVector) {
        return this.transformManager.transformPoint(pointAngstroms, vibrationVector);
    }

    public void transformPoint(Point3f pointAngstroms, Vector3f vibrationVector, Point3i pointScreen) {
        this.transformManager.transformPoint(pointAngstroms, vibrationVector, pointScreen);
    }

    public void transformPoint(Point3f pointAngstroms, Point3i pointScreen) {
        this.transformManager.transformPoint(pointAngstroms, pointScreen);
    }

    public void transformPoint(Point3f pointAngstroms, Point3f pointScreen) {
        this.transformManager.transformPoint(pointAngstroms, pointScreen);
    }

    public void transformPoints(Point3f[] pointsAngstroms, Point3i[] pointsScreens) {
        this.transformManager.transformPoints(pointsAngstroms.length, pointsAngstroms, pointsScreens);
    }

    public void transformVector(Vector3f vectorAngstroms, Vector3f vectorTransformed) {
        this.transformManager.transformVector(vectorAngstroms, vectorTransformed);
    }

    public float getScalePixelsPerAngstrom() {
        return this.transformManager.scalePixelsPerAngstrom;
    }

    public float scaleToScreen(int z, float sizeAngstroms) {
        return this.transformManager.scaleToScreen(z, sizeAngstroms);
    }

    public short scaleToScreen(int z, int milliAngstroms) {
        return this.transformManager.scaleToScreen(z, milliAngstroms);
    }

    public float scaleToPerspective(int z, float sizeAngstroms) {
        return this.transformManager.scaleToPerspective(z, sizeAngstroms);
    }

    public void scaleFitToScreen() {
        this.transformManager.scaleFitToScreen();
    }

    public void setPerspectiveDepth(boolean perspectiveDepth) {
        this.transformManager.setPerspectiveDepth(perspectiveDepth);
        this.refresh();
    }

    public void setAxesOrientationRasmol(boolean axesOrientationRasmol) {
        this.transformManager.setAxesOrientationRasmol(axesOrientationRasmol);
        this.refresh();
    }

    public boolean getAxesOrientationRasmol() {
        return this.transformManager.axesOrientationRasmol;
    }

    public boolean getPerspectiveDepth() {
        return this.transformManager.perspectiveDepth;
    }

    public void setCameraDepth(float depth) {
        this.transformManager.setCameraDepth(depth);
    }

    public float getCameraDepth() {
        return this.transformManager.cameraDepth;
    }

    public void checkCameraDistance() {
        if (this.transformManager.increaseRotationRadius) {
            this.modelManager.increaseRotationRadius(this.transformManager.getRotationRadiusIncrease());
        }
    }

    public void setScreenDimension(Dimension dim) {
        if (dim.width == this.dimScreen.width && dim.height == this.dimScreen.height) {
            return;
        }
        this.dimScreen.width = dim.width;
        this.dimScreen.height = dim.height;
        this.transformManager.setScreenDimension(dim.width, dim.height);
        this.transformManager.scaleFitToScreen();
        this.g3d.setSize(dim);
    }

    public int getScreenWidth() {
        return this.dimScreen.width;
    }

    public int getScreenHeight() {
        return this.dimScreen.height;
    }

    public void setRectClip(Rectangle clip) {
        if (clip == null) {
            this.rectClip.y = 0;
            this.rectClip.x = 0;
            this.rectClip.setSize(this.dimScreen);
        } else {
            this.rectClip.setBounds(clip);
            if (this.rectClip.x < 0) {
                this.rectClip.x = 0;
            }
            if (this.rectClip.y < 0) {
                this.rectClip.y = 0;
            }
            if (this.rectClip.x + this.rectClip.width > this.dimScreen.width) {
                this.rectClip.width = this.dimScreen.width - this.rectClip.x;
            }
            if (this.rectClip.y + this.rectClip.height > this.dimScreen.height) {
                this.rectClip.height = this.dimScreen.height - this.rectClip.y;
            }
        }
    }

    public void setScaleAngstromsPerInch(float angstromsPerInch) {
        this.transformManager.setScaleAngstromsPerInch(angstromsPerInch);
    }

    public void setSlabAndDepthValues(int slabValue, int depthValue) {
        this.g3d.setSlabAndDepthValues(slabValue, depthValue);
    }

    public void setVibrationPeriod(float period) {
        this.transformManager.setVibrationPeriod(period);
    }

    public void setVibrationT(float t) {
        this.transformManager.setVibrationT(t);
    }

    public float getVibrationRadians() {
        return this.transformManager.vibrationRadians;
    }

    public void setSpinX(int value) {
        this.transformManager.setSpinX(value);
    }

    public int getSpinX() {
        return this.transformManager.spinX;
    }

    public void setSpinY(int value) {
        this.transformManager.setSpinY(value);
    }

    public int getSpinY() {
        return this.transformManager.spinY;
    }

    public void setSpinZ(int value) {
        this.transformManager.setSpinZ(value);
    }

    public int getSpinZ() {
        return this.transformManager.spinZ;
    }

    public void setSpinFps(int value) {
        this.transformManager.setSpinFps(value);
    }

    public int getSpinFps() {
        return this.transformManager.spinFps;
    }

    public void setSpinOn(boolean spinOn) {
        this.transformManager.setSpinOn(spinOn);
    }

    public boolean getSpinOn() {
        return this.transformManager.spinOn;
    }

    public String getOrientationText() {
        return this.transformManager.getOrientationText();
    }

    public void getAxisAngle(AxisAngle4f axisAngle) {
        this.transformManager.getAxisAngle(axisAngle);
    }

    public String getTransformText() {
        return this.transformManager.getTransformText();
    }

    public void setRotation(Matrix3f matrixRotation) {
        this.transformManager.setRotation(matrixRotation);
    }

    public void getRotation(Matrix3f matrixRotation) {
        this.transformManager.getRotation(matrixRotation);
    }

    public void setModeAtomColorProfile(byte palette) {
        this.colorManager.setPaletteDefault(palette);
        this.refresh();
    }

    public byte getModeAtomColorProfile() {
        return this.colorManager.paletteDefault;
    }

    public void setColorScheme(String colorScheme) {
        this.colorManager.setColorScheme(colorScheme);
    }

    public void setColorSelection(Color c) {
        this.colorManager.setColorSelection(c);
        this.refresh();
    }

    public Color getColorSelection() {
        return this.colorManager.getColorSelection();
    }

    public short getColixSelection() {
        return this.colorManager.getColixSelection();
    }

    public short getColixRubberband() {
        return this.colorManager.colixRubberband;
    }

    public void setColorLabel(Color color) {
        this.colorManager.setColorLabel(color);
        this.setShapeColorProperty(4, color);
        this.refresh();
    }

    public void setColorDotsSaddle(Color color) {
        this.colorManager.setColorDotsSaddle(color);
        this.setShapeProperty(7, "dotssaddle", color);
    }

    public short getColixDotsSaddle() {
        return this.colorManager.colixDotsSaddle;
    }

    public void setColorDotsConvex(Color color) {
        this.colorManager.setColorDotsConvex(color);
        this.setShapeProperty(7, "dotsconvex", color);
    }

    public short getColixDotsConvex() {
        return this.colorManager.colixDotsConvex;
    }

    public void setColorDotsConcave(Color color) {
        this.colorManager.setColorDotsConcave(color);
        this.setShapeProperty(7, "dotsconcave", color);
    }

    public short getColixDotsConcave() {
        return this.colorManager.colixDotsConcave;
    }

    public Color getColorLabel() {
        return this.colorManager.colorLabel;
    }

    public short getColixLabel() {
        return this.colorManager.colixLabel;
    }

    public void setColorMeasurement(Color c) {
        this.colorManager.setColorMeasurement(c);
        this.refresh();
    }

    public void setColorDistance(Color c) {
        this.colorManager.setColorDistance(c);
        this.refresh();
    }

    public Color getColorDistance() {
        return this.colorManager.colorDistance;
    }

    public short getColixDistance() {
        return this.colorManager.colixDistance;
    }

    public void setColorAngle(Color c) {
        this.colorManager.setColorAngle(c);
        this.refresh();
    }

    public Color getColorAngle() {
        return this.colorManager.colorAngle;
    }

    public short getColixAngle() {
        return this.colorManager.colixAngle;
    }

    public void setColorTorsion(Color c) {
        this.colorManager.setColorTorsion(c);
        this.refresh();
    }

    public Color getColorTorsion() {
        return this.colorManager.colorTorsion;
    }

    public short getColixTorsion() {
        return this.colorManager.colixTorsion;
    }

    public void setColorVector(Color c) {
        this.colorManager.setColorVector(c);
        this.refresh();
    }

    public Color getColorVector() {
        return this.colorManager.colorVector;
    }

    public short getColixVector() {
        return this.colorManager.colixVector;
    }

    public float getVectorScale() {
        return this.transformManager.vectorScale;
    }

    public void setVectorScale(float scale) {
        this.transformManager.setVectorScale(scale);
    }

    public void setVibrationScale(float scale) {
        this.transformManager.setVibrationScale(scale);
    }

    public float getVibrationScale() {
        return this.transformManager.vibrationScale;
    }

    public void setColorBackground(Color bg) {
        this.colorManager.setColorBackground(bg);
        this.refresh();
    }

    public Color getColorBackground() {
        return this.colorManager.colorBackground;
    }

    public void setColorBackground(String colorName) {
        this.colorManager.setColorBackground(colorName);
        this.refresh();
    }

    public Color getColorFromString(String colorName) {
        return Graphics3D.getColorFromString(colorName);
    }

    public void setSpecular(boolean specular) {
        this.colorManager.setSpecular(specular);
    }

    public boolean getSpecular() {
        return this.colorManager.getSpecular();
    }

    public void setSpecularPower(int specularPower) {
        this.colorManager.setSpecularPower(specularPower);
    }

    public void setAmbientPercent(int ambientPercent) {
        this.colorManager.setAmbientPercent(ambientPercent);
    }

    public void setDiffusePercent(int diffusePercent) {
        this.colorManager.setDiffusePercent(diffusePercent);
    }

    public void setSpecularPercent(int specularPercent) {
        this.colorManager.setSpecularPercent(specularPercent);
    }

    public void setLightsourceZ(float z) {
        this.colorManager.setLightsourceZ(z);
    }

    public int calcIntensity(float x, float y, float z) {
        return this.colorManager.calcIntensity(x, y, z);
    }

    public int calcSurfaceIntensity(Point3f pointA, Point3f pointB, Point3f pointC) {
        return this.colorManager.calcSurfaceIntensity(pointA, pointB, pointC);
    }

    public short getColixAtom(Atom atom) {
        return this.colorManager.getColixAtom(atom);
    }

    public short getColixAtomPalette(Atom atom, byte palette) {
        return this.colorManager.getColixAtomPalette(atom, palette);
    }

    public short getColixHbondType(short order) {
        return this.colorManager.getColixHbondType(order);
    }

    public short getColixAxes() {
        return this.colorManager.colixAxes;
    }

    public short getColixAxesText() {
        return this.colorManager.colixAxesText;
    }

    public void addSelection(int atomIndex) {
        this.selectionManager.addSelection(atomIndex);
        this.refresh();
    }

    public void addSelection(BitSet set) {
        this.selectionManager.addSelection(set);
        this.refresh();
    }

    public void toggleSelection(int atomIndex) {
        this.selectionManager.toggleSelection(atomIndex);
        this.refresh();
    }

    public boolean isSelected(Atom atom) {
        return this.selectionManager.isSelected(atom.atomIndex);
    }

    public boolean isSelected(int atomIndex) {
        return this.selectionManager.isSelected(atomIndex);
    }

    public boolean hasSelectionHalo(Atom atom) {
        return this.selectionHaloEnabled && !this.repaintManager.wireframeRotating && this.isSelected(atom);
    }

    public void setSelectionHaloEnabled(boolean selectionHaloEnabled) {
        if (this.selectionHaloEnabled != selectionHaloEnabled) {
            this.selectionHaloEnabled = selectionHaloEnabled;
            this.refresh();
        }
    }

    public boolean getSelectionHaloEnabled() {
        return this.selectionHaloEnabled;
    }

    public void setBondSelectionModeOr(boolean bondSelectionModeOr) {
        this.bondSelectionModeOr = bondSelectionModeOr;
        this.refresh();
    }

    public boolean getBondSelectionModeOr() {
        return this.bondSelectionModeOr;
    }

    public void selectAll() {
        this.selectionManager.selectAll();
        this.refresh();
    }

    public void clearSelection() {
        this.selectionManager.clearSelection();
        this.refresh();
    }

    public void setSelectionSet(BitSet set) {
        this.selectionManager.setSelectionSet(set);
        this.refresh();
    }

    public void invertSelection() {
        this.selectionManager.invertSelection();
    }

    public void excludeSelectionSet(BitSet set) {
        this.selectionManager.excludeSelectionSet(set);
    }

    public BitSet getSelectionSet() {
        return this.selectionManager.bsSelection;
    }

    public int getSelectionCount() {
        return this.selectionManager.getSelectionCount();
    }

    public void setModeMouse(int modeMouse) {
        this.mouseManager.setMode(modeMouse);
    }

    public int getModeMouse() {
        return this.mouseManager.modeMouse;
    }

    public Rectangle getRubberBandSelection() {
        return this.mouseManager.getRubberBand();
    }

    public void popupMenu(int x, int y) {
        if (this.jmolStatusListener != null) {
            this.jmolStatusListener.handlePopupMenu(x, y);
        }
    }

    public int getCursorX() {
        return this.mouseManager.xCurrent;
    }

    public int getCursorY() {
        return this.mouseManager.yCurrent;
    }

    public void setAppletContext(URL documentBase, URL codeBase, String appletProxy) {
        this.fileManager.setAppletContext(documentBase, codeBase, appletProxy);
    }

    public Object getInputStreamOrErrorMessageFromName(String name) {
        return this.fileManager.getInputStreamOrErrorMessageFromName(name);
    }

    public void openFile(String name) {
        this.clear();
        this.forceRefresh();
        long timeBegin = System.currentTimeMillis();
        this.fileManager.openFile(name);
        long ms = System.currentTimeMillis() - timeBegin;
        System.out.println("openFile(" + name + ") " + ms + " ms");
    }

    public void openStringInline(String strModel) {
        this.clear();
        this.fileManager.openStringInline(strModel);
        this.getOpenFileError();
    }

    public void openReader(String fullPathName, String name, Reader reader) {
        this.clear();
        this.fileManager.openReader(fullPathName, name, reader);
        this.getOpenFileError();
    }

    public String getOpenFileError() {
        String errorMsg = this.getOpenFileError1();
        return errorMsg;
    }

    public String getOpenFileError1() {
        String fullPathName = this.fileManager.getFullPathName();
        String fileName = this.fileManager.getFileName();
        Object clientFile = this.fileManager.waitForClientFileOrErrorMessage();
        if (clientFile instanceof String || clientFile == null) {
            String errorMsg = (String)clientFile;
            this.notifyFileNotLoaded(fullPathName, errorMsg);
            return errorMsg;
        }
        this.openClientFile(fullPathName, fileName, clientFile);
        this.notifyFileLoaded(fullPathName, fileName, this.modelManager.getModelSetName(), clientFile);
        return null;
    }

    public void openClientFile(String fullPathName, String fileName, Object clientFile) {
        this.pushHoldRepaint();
        this.modelManager.setClientFile(fullPathName, fileName, clientFile);
        this.homePosition();
        if (this.eval != null) {
            this.eval.clearDefinitionsAndLoadPredefined();
        }
        if (this.modelManager.hasVibrationVectors()) {
            this.setShapeSize(5, 1);
        }
        this.popHoldRepaint();
    }

    public void clear() {
        this.repaintManager.clearAnimation();
        this.transformManager.clearVibration();
        this.modelManager.setClientFile(null, null, null);
        this.selectionManager.clearSelection();
        this.clearMeasurements();
        this.refresh();
    }

    public String getModelSetName() {
        return this.modelManager.getModelSetName();
    }

    public String getModelFileHeader() {
        return this.modelManager.getModelFileHeader();
    }

    public int getModelIndex(String modelTag) {
        return this.modelManager.getModelIndex(modelTag);
    }

    public boolean haveFrame() {
        return this.modelManager.frame != null;
    }

    public Object getClientFile() {
        return null;
    }

    public String getClientAtomStringProperty(Object clientAtomReference, String propertyName) {
        return this.modelManager.getClientAtomStringProperty(clientAtomReference, propertyName);
    }

    public ModelAdapter getExportModelAdapter() {
        return this.modelManager.getExportModelAdapter();
    }

    public Frame getFrame() {
        return this.modelManager.getFrame();
    }

    public float getRotationRadius() {
        return this.modelManager.getRotationRadius();
    }

    public Point3f getRotationCenter() {
        return this.modelManager.getRotationCenter();
    }

    public Point3f getBoundingBoxCenter() {
        return this.modelManager.getBoundingBoxCenter();
    }

    public Vector3f getBoundingBoxCornerVector() {
        return this.modelManager.getBoundingBoxCornerVector();
    }

    public int getBoundingBoxCenterX() {
        return this.dimScreen.width / 2;
    }

    public int getBoundingBoxCenterY() {
        return this.dimScreen.height / 2;
    }

    public int getNumberOfFrames() {
        return 1;
    }

    public int getModelCount() {
        return this.modelManager.getModelCount();
    }

    public int getChainCount() {
        return this.modelManager.getChainCount();
    }

    public int getGroupCount() {
        return this.modelManager.getGroupCount();
    }

    public int getAtomCount() {
        return this.modelManager.getAtomCount();
    }

    public int getBondCount() {
        return this.modelManager.getBondCount();
    }

    public boolean frankClicked(int x, int y) {
        return this.modelManager.frankClicked(x, y);
    }

    public int findNearestAtomIndex(int x, int y) {
        return this.modelManager.findNearestAtomIndex(x, y);
    }

    public BitSet findAtomsInRectangle(Rectangle rectRubberBand) {
        return this.modelManager.findAtomsInRectangle(rectRubberBand);
    }

    public void setCenter(Point3f center) {
        this.modelManager.setRotationCenter(center);
    }

    public Point3f getCenter() {
        return this.modelManager.getRotationCenter();
    }

    public void setCenterBitSet(BitSet bsCenter) {
        this.modelManager.setCenterBitSet(bsCenter);
        this.scaleFitToScreen();
        this.refresh();
    }

    public void rebond() {
        this.modelManager.rebond();
        this.refresh();
    }

    public void setBondTolerance(float bondTolerance) {
        this.modelManager.setBondTolerance(bondTolerance);
        this.refresh();
    }

    public float getBondTolerance() {
        return this.modelManager.bondTolerance;
    }

    public void setMinBondDistance(float minBondDistance) {
        this.modelManager.setMinBondDistance(minBondDistance);
        this.refresh();
    }

    public float getMinBondDistance() {
        return this.modelManager.minBondDistance;
    }

    public void setAutoBond(boolean ab) {
        this.modelManager.setAutoBond(ab);
        this.refresh();
    }

    public boolean getAutoBond() {
        return this.modelManager.autoBond;
    }

    public void setSolventProbeRadius(float radius) {
        this.modelManager.setSolventProbeRadius(radius);
    }

    public float getSolventProbeRadius() {
        return this.modelManager.solventProbeRadius;
    }

    public float getCurrentSolventProbeRadius() {
        return this.modelManager.solventOn ? this.modelManager.solventProbeRadius : 0.0f;
    }

    public void setSolventOn(boolean solventOn) {
        this.modelManager.setSolventOn(solventOn);
    }

    public boolean getSolventOn() {
        return this.modelManager.solventOn;
    }

    public int getAtomIndexFromAtomNumber(int atomNumber) {
        return this.modelManager.getAtomIndexFromAtomNumber(atomNumber);
    }

    public BitSet getElementsPresentBitSet() {
        return this.modelManager.getElementsPresentBitSet();
    }

    public BitSet getGroupsPresentBitSet() {
        return this.modelManager.getGroupsPresentBitSet();
    }

    public void clearMeasurements() {
        this.setShapeProperty(6, "clear", null);
        this.refresh();
    }

    public int getMeasurementCount() {
        int count = this.getShapePropertyAsInt(6, "count");
        return count <= 0 ? 0 : count;
    }

    public String getMeasurementStringValue(int i) {
        return "" + this.getShapeProperty(6, "stringValue", i);
    }

    public int[] getMeasurementCountPlusIndices(int i) {
        return (int[])this.getShapeProperty(6, "countPlusIndices", i);
    }

    public void setPendingMeasurement(int[] atomCountPlusIndices) {
        this.setShapeProperty(6, "pending", atomCountPlusIndices);
    }

    public void defineMeasurement(int[] atomCountPlusIndices) {
        this.setShapeProperty(6, "define", atomCountPlusIndices);
    }

    public void deleteMeasurement(int i) {
        this.setShapeProperty(6, "delete", new Integer(i));
    }

    public void deleteMeasurement(int[] atomCountPlusIndices) {
        this.setShapeProperty(6, "delete", atomCountPlusIndices);
    }

    public void toggleMeasurement(int[] atomCountPlusIndices) {
        this.setShapeProperty(6, "toggle", atomCountPlusIndices);
    }

    public void clearAllMeasurements() {
        this.setShapeProperty(6, "clear", null);
    }

    public void setAnimationDirection(int direction) {
        this.repaintManager.setAnimationDirection(direction);
    }

    public int getAnimationDirection() {
        return this.repaintManager.animationDirection;
    }

    public void setAnimationFps(int fps) {
        this.repaintManager.setAnimationFps(fps);
    }

    public int getAnimationFps() {
        return this.repaintManager.animationFps;
    }

    public void setAnimationReplayMode(int replay, float firstFrameDelay, float lastFrameDelay) {
        this.repaintManager.setAnimationReplayMode(replay, firstFrameDelay, lastFrameDelay);
    }

    public int getAnimationReplayMode() {
        return this.repaintManager.animationReplayMode;
    }

    public void setAnimationOn(boolean animationOn) {
        boolean wasAnimating = this.repaintManager.animationOn;
        this.repaintManager.setAnimationOn(animationOn);
        if (animationOn != wasAnimating) {
            this.refresh();
        }
    }

    public boolean isAnimationOn() {
        return this.repaintManager.animationOn;
    }

    public void setAnimationNext() {
        if (this.repaintManager.setAnimationNext()) {
            this.refresh();
        }
    }

    public void setAnimationPrevious() {
        if (this.repaintManager.setAnimationPrevious()) {
            this.refresh();
        }
    }

    public boolean setDisplayModelIndex(int modelIndex) {
        return this.repaintManager.setDisplayModelIndex(modelIndex);
    }

    public int getDisplayModelIndex() {
        return this.repaintManager.displayModelIndex;
    }

    public FrameRenderer getFrameRenderer() {
        return this.repaintManager.frameRenderer;
    }

    public void setWireframeRotating(boolean wireframeRotating) {
        this.repaintManager.setWireframeRotating(wireframeRotating);
    }

    public boolean getWireframeRotating() {
        return this.repaintManager.wireframeRotating;
    }

    public void setInMotion(boolean inMotion) {
        if (this.wasInMotion ^ inMotion) {
            if (inMotion) {
                ++this.motionEventNumber;
            }
            this.repaintManager.setInMotion(inMotion);
            this.checkOversample();
            this.wasInMotion = inMotion;
        }
    }

    public boolean getInMotion() {
        return this.repaintManager.inMotion;
    }

    public Image takeSnapshot() {
        return this.repaintManager.takeSnapshot();
    }

    public void pushHoldRepaint() {
        this.repaintManager.pushHoldRepaint();
    }

    public void popHoldRepaint() {
        this.repaintManager.popHoldRepaint();
    }

    public void forceRefresh() {
        this.repaintManager.forceRefresh();
    }

    public void refresh() {
        this.repaintManager.refresh();
    }

    public void requestRepaintAndWait() {
        this.repaintManager.requestRepaintAndWait();
    }

    public void notifyRepainted() {
        this.repaintManager.notifyRepainted();
    }

    public void renderScreenImage(Graphics g, Dimension size, Rectangle clip) {
        this.manageScriptTermination();
        if (size != null) {
            this.setScreenDimension(size);
        }
        this.setRectClip(clip);
        this.g3d.setRectClip(this.rectClip);
        this.g3d.beginRendering(false);
        this.repaintManager.render(this.g3d, this.rectClip, this.modelManager.getFrame(), this.repaintManager.displayModelIndex);
        this.g3d.endRendering();
        Image img = this.g3d.getScreenImage();
        try {
            g.drawImage(img, 0, 0, null);
        }
        catch (NullPointerException npe) {
            System.out.println("Sun!! ... fix graphics your bugs!");
        }
        this.g3d.releaseScreenImage();
        this.notifyRepainted();
    }

    public Image getScreenImage() {
        this.setRectClip(null);
        this.g3d.setRectClip(this.rectClip);
        this.g3d.beginRendering(false);
        this.repaintManager.render(this.g3d, this.rectClip, this.modelManager.getFrame(), this.repaintManager.displayModelIndex);
        this.g3d.endRendering();
        return this.g3d.getScreenImage();
    }

    public void releaseScreenImage() {
        this.g3d.releaseScreenImage();
    }

    public void checkOversample() {
        boolean tOversample = this.tOversampleAlways | !this.repaintManager.inMotion & this.tOversampleStopped;
        this.repaintManager.setOversample(tOversample);
        this.transformManager.setOversample(tOversample);
    }

    public void setOversample(boolean tOversample) {
        this.transformManager.setOversample(tOversample);
        this.repaintManager.setOversample(tOversample);
    }

    public Eval getEval() {
        if (this.eval == null) {
            this.eval = new Eval(this);
        }
        return this.eval;
    }

    public String evalFile(String strFilename) {
        if (strFilename != null) {
            if (!this.getEval().loadScriptFile(strFilename)) {
                return this.eval.getErrorMessage();
            }
            this.eval.start();
        }
        return null;
    }

    public String evalString(String strScript) {
        if (strScript != null) {
            if (!this.getEval().loadScriptString(strScript)) {
                return this.eval.getErrorMessage();
            }
            this.eval.start();
        }
        return null;
    }

    public void haltScriptExecution() {
        if (this.eval != null) {
            this.eval.haltExecution();
        }
    }

    public void setColorAtomScript(byte palette, Color color) {
        this.setShapeColor(0, palette, color);
    }

    public void setColorBond(Color color) {
        this.colorManager.setColorBond(color);
        this.setShapeColorProperty(1, color);
    }

    public Color getColorBond() {
        return this.colorManager.colorBond;
    }

    public short getColixBond(int order) {
        if ((order & 0x3C0) != 0) {
            return this.colorManager.colixHbond;
        }
        if ((order & 0x20) != 0) {
            return this.colorManager.colixSsbond;
        }
        return this.colorManager.colixBond;
    }

    public void setSsbondsBackbone(boolean ssbondsBackbone) {
        this.styleManager.setSsbondsBackbone(ssbondsBackbone);
    }

    public boolean getSsbondsBackbone() {
        return this.styleManager.ssbondsBackbone;
    }

    public void setHbondsBackbone(boolean hbondsBackbone) {
        this.styleManager.setHbondsBackbone(hbondsBackbone);
    }

    public boolean getHbondsBackbone() {
        return this.styleManager.hbondsBackbone;
    }

    public void setMarBond(short marBond) {
        this.styleManager.setMarBond(marBond);
        this.setShapeSize(1, marBond * 2);
    }

    public void hoverOn(int atomIndex) {
        if (!(this.eval != null && this.eval.isActive() || atomIndex == this.hoverAtomIndex)) {
            this.setShapeSize(20, 1);
            this.setShapeProperty(20, "target", new Integer(atomIndex));
            this.hoverAtomIndex = atomIndex;
        }
    }

    public void hoverOff() {
        if (this.hoverAtomIndex >= 0) {
            this.setShapeProperty(20, "target", null);
            this.hoverAtomIndex = -1;
        }
    }

    public void setLabel(String strLabel) {
        if (strLabel != null) {
            this.setShapeSize(4, this.styleManager.pointsLabelFontSize);
        }
        this.setShapeProperty(4, "label", strLabel);
    }

    public BitSet getBitSetSelection() {
        return this.selectionManager.bsSelection;
    }

    public void setShapeShow(int shapeID, boolean show) {
        this.setShapeSize(shapeID, show ? -1 : 0);
    }

    public boolean getShapeShow(int shapeID) {
        return this.getShapeSize(shapeID) != 0;
    }

    public void setShapeSize(int shapeID, int size) {
        this.modelManager.setShapeSize(shapeID, size, this.selectionManager.bsSelection);
        this.refresh();
    }

    public int getShapeSize(int shapeID) {
        return this.modelManager.getShapeSize(shapeID);
    }

    public byte getPalette(String colorScheme) {
        byte palette;
        if (colorScheme == null) {
            return -1;
        }
        for (palette = 0; palette < 10 && !colorScheme.equals(JmolConstants.colorSchemes[palette]); palette = (byte)(palette + 1)) {
        }
        return palette;
    }

    public void setShapeColor(int shapeID, byte palette, Color color) {
        System.out.println("setShapeColor()");
        if (palette == -1) {
            System.out.println("PALETTE_COLOR");
            this.modelManager.setShapeProperty(shapeID, "colorScheme", null, this.selectionManager.bsSelection);
            this.modelManager.setShapeProperty(shapeID, "color", color, this.selectionManager.bsSelection);
        } else {
            System.out.println("other PALETTE");
            this.modelManager.setShapeProperty(shapeID, "colorScheme", JmolConstants.colorSchemes[palette], this.selectionManager.bsSelection);
        }
        this.refresh();
    }

    public void setShapeProperty(int shapeID, String propertyName, Object value) {
        this.modelManager.setShapeProperty(shapeID, propertyName, value, this.selectionManager.bsSelection);
        this.refresh();
    }

    public void setShapeColorProperty(int shapeType, Color color) {
        this.setShapeProperty(shapeType, "color", color);
    }

    public Object getShapeProperty(int shapeType, String propertyName) {
        return this.modelManager.getShapeProperty(shapeType, propertyName, Integer.MIN_VALUE);
    }

    public Object getShapeProperty(int shapeType, String propertyName, int index) {
        return this.modelManager.getShapeProperty(shapeType, propertyName, index);
    }

    public Color getShapePropertyAsColor(int shapeID, String propertyName) {
        return (Color)this.getShapeProperty(shapeID, propertyName);
    }

    public int getShapePropertyAsInt(int shapeID, String propertyName) {
        Object value = this.getShapeProperty(shapeID, propertyName);
        return value == null || !(value instanceof Integer) ? Integer.MIN_VALUE : (Integer)value;
    }

    public Color getColorShape(int shapeID) {
        return (Color)this.getShapeProperty(shapeID, "color");
    }

    public short getColixShape(int shapeID) {
        return this.g3d.getColix(this.getColorShape(shapeID));
    }

    public int getShapeID(String shapeName) {
        int i = 22;
        while (--i >= 0) {
            if (!JmolConstants.shapeClassBases[i].equals(shapeName)) continue;
            return i;
        }
        String msg = "Unrecognized shape name:" + shapeName;
        System.out.println(msg);
        throw new NullPointerException(msg);
    }

    public short getColix(Color color) {
        return this.g3d.getColix(color);
    }

    public short getColix(Object object) {
        return this.g3d.getColix(object);
    }

    public void setStrandsCount(int strandsCount) {
        if (strandsCount < 0) {
            strandsCount = 0;
        }
        if (strandsCount > 20) {
            strandsCount = 20;
        }
        this.strandsCount = strandsCount;
    }

    public int getStrandsCount() {
        return this.strandsCount;
    }

    public void setRasmolHydrogenSetting(boolean b) {
        this.rasmolHydrogenSetting = b;
    }

    public boolean getRasmolHydrogenSetting() {
        return this.rasmolHydrogenSetting;
    }

    public void setRasmolHeteroSetting(boolean b) {
        this.rasmolHeteroSetting = b;
    }

    public boolean getRasmolHeteroSetting() {
        return this.rasmolHeteroSetting;
    }

    public void setJmolStatusListener(JmolStatusListener jmolStatusListener) {
        this.jmolStatusListener = jmolStatusListener;
    }

    public void notifyFrameChanged(int frameNo) {
        if (this.jmolStatusListener != null) {
            this.jmolStatusListener.notifyFrameChanged(frameNo);
        }
    }

    public void notifyFileLoaded(String fullPathName, String fileName, String modelName, Object clientFile) {
        if (this.jmolStatusListener != null) {
            this.jmolStatusListener.notifyFileLoaded(fullPathName, fileName, modelName, clientFile);
        }
    }

    public void notifyFileNotLoaded(String fullPathName, String errorMsg) {
        if (this.jmolStatusListener != null) {
            this.jmolStatusListener.notifyFileNotLoaded(fullPathName, errorMsg);
        }
    }

    private void manageScriptTermination() {
        if (this.eval != null && this.eval.hasTerminationNotification()) {
            String strErrorMessage = this.eval.getErrorMessage();
            int msWalltime = this.eval.getExecutionWalltime();
            this.eval.resetTerminationNotification();
            if (this.jmolStatusListener != null) {
                this.jmolStatusListener.notifyScriptTermination(strErrorMessage, msWalltime);
            }
        }
    }

    public void scriptEcho(String strEcho) {
        if (this.jmolStatusListener != null) {
            this.jmolStatusListener.scriptEcho(strEcho);
        }
    }

    public boolean getDebugScript() {
        return this.debugScript;
    }

    public void setDebugScript(boolean debugScript) {
        this.debugScript = debugScript;
    }

    public void scriptStatus(String strStatus) {
        if (this.jmolStatusListener != null) {
            this.jmolStatusListener.scriptStatus(strStatus);
        }
    }

    public void notifyMeasurementsChanged() {
        if (this.jmolStatusListener != null) {
            this.jmolStatusListener.notifyMeasurementsChanged();
        }
    }

    public void notifyPicked(int atomIndex) {
        if (atomIndex != -1 && this.jmolStatusListener != null) {
            this.jmolStatusListener.notifyAtomPicked(atomIndex, this.modelManager.getAtomInfo(atomIndex));
        }
    }

    public boolean getBooleanProperty(String key) {
        if (key.equalsIgnoreCase("wireframeRotation")) {
            return this.getWireframeRotation();
        }
        if (key.equalsIgnoreCase("perspectiveDepth")) {
            return this.getPerspectiveDepth();
        }
        if (key.equalsIgnoreCase("showAxes")) {
            return this.getShapeShow(15);
        }
        if (key.equalsIgnoreCase("showBoundingBox")) {
            return this.getShapeShow(16);
        }
        if (key.equalsIgnoreCase("showUnitcell")) {
            return this.getShapeShow(17);
        }
        if (key.equalsIgnoreCase("showHydrogens")) {
            return this.getShowHydrogens();
        }
        if (key.equalsIgnoreCase("showMeasurements")) {
            return this.getShowMeasurements();
        }
        if (key.equalsIgnoreCase("showSelections")) {
            return this.getSelectionHaloEnabled();
        }
        if (key.equalsIgnoreCase("oversampleAlways")) {
            return this.getOversampleAlwaysEnabled();
        }
        if (key.equalsIgnoreCase("oversampleStopped")) {
            return this.getOversampleStoppedEnabled();
        }
        if (key.equalsIgnoreCase("axesOrientationRasmol")) {
            return this.getAxesOrientationRasmol();
        }
        if (key.equalsIgnoreCase("zeroBasedXyzRasmol")) {
            return this.getZeroBasedXyzRasmol();
        }
        if (key.equalsIgnoreCase("testFlag1")) {
            return this.getTestFlag1();
        }
        if (key.equalsIgnoreCase("testFlag2")) {
            return this.getTestFlag2();
        }
        if (key.equalsIgnoreCase("testFlag3")) {
            return this.getTestFlag3();
        }
        System.out.println("viewer.getBooleanProperty(" + key + ") - unrecognized");
        return false;
    }

    public void setBooleanProperty(String key, boolean value) {
        this.refresh();
        if (key.equalsIgnoreCase("wireframeRotation")) {
            this.setWireframeRotation(value);
            return;
        }
        if (key.equalsIgnoreCase("perspectiveDepth")) {
            this.setPerspectiveDepth(value);
            return;
        }
        if (key.equalsIgnoreCase("showAxes")) {
            this.setShapeShow(15, value);
            return;
        }
        if (key.equalsIgnoreCase("showBoundingBox")) {
            this.setShapeShow(16, value);
            return;
        }
        if (key.equalsIgnoreCase("showUnitcell")) {
            this.setShapeShow(17, value);
            return;
        }
        if (key.equalsIgnoreCase("showHydrogens")) {
            this.setShowHydrogens(value);
            return;
        }
        if (key.equalsIgnoreCase("showHydrogens")) {
            this.setShowHydrogens(value);
            return;
        }
        if (key.equalsIgnoreCase("showMeasurements")) {
            this.setShowMeasurements(value);
            return;
        }
        if (key.equalsIgnoreCase("showSelections")) {
            this.setSelectionHaloEnabled(value);
            return;
        }
        if (key.equalsIgnoreCase("oversampleAlways")) {
            this.setOversampleAlwaysEnabled(value);
            return;
        }
        if (key.equalsIgnoreCase("oversampleStopped")) {
            this.setOversampleStoppedEnabled(value);
            return;
        }
        if (key.equalsIgnoreCase("axesOrientationRasmol")) {
            this.setAxesOrientationRasmol(value);
            return;
        }
        if (key.equalsIgnoreCase("zeroBasedXyzRasmol")) {
            this.setZeroBasedXyzRasmol(value);
            return;
        }
        if (key.equalsIgnoreCase("testFlag1")) {
            this.setTestFlag1(value);
            return;
        }
        if (key.equalsIgnoreCase("testFlag2")) {
            this.setTestFlag2(value);
            return;
        }
        if (key.equalsIgnoreCase("testFlag3")) {
            this.setTestFlag3(value);
            return;
        }
        System.out.println("viewer.setBooleanProperty(" + key + "," + value + ") - unrecognized");
    }

    void setTestFlag1(boolean value) {
        this.testFlag1 = value;
    }

    public boolean getTestFlag1() {
        return this.testFlag1;
    }

    void setTestFlag2(boolean value) {
        this.testFlag2 = value;
    }

    public boolean getTestFlag2() {
        return this.testFlag2;
    }

    void setTestFlag3(boolean value) {
        this.testFlag3 = value;
    }

    public boolean getTestFlag3() {
        return this.testFlag3;
    }

    public boolean getOversampleStoppedEnabled() {
        return this.tOversampleStopped;
    }

    public boolean getOversampleAlwaysEnabled() {
        return this.tOversampleAlways;
    }

    public void setOversampleAlwaysEnabled(boolean value) {
        this.tOversampleAlways = value;
        this.checkOversample();
        this.refresh();
    }

    public void setOversampleStoppedEnabled(boolean value) {
        this.tOversampleStopped = value;
        this.checkOversample();
        this.refresh();
    }

    private BondIterator bondIteratorSelected(byte bondType) {
        return this.getFrame().getBondIterator(bondType, this.selectionManager.bsSelection);
    }

    public void setPercentVdwAtom(int percentVdwAtom) {
        this.styleManager.setPercentVdwAtom(percentVdwAtom);
        this.setShapeSize(0, -percentVdwAtom);
    }

    public int getPercentVdwAtom() {
        return this.styleManager.percentVdwAtom;
    }

    public short getMadAtom() {
        return (short)(-this.styleManager.percentVdwAtom);
    }

    public short getMadBond() {
        return (short)(this.styleManager.marBond * 2);
    }

    public void setModeMultipleBond(byte modeMultipleBond) {
        this.styleManager.setModeMultipleBond(modeMultipleBond);
        this.refresh();
    }

    public byte getModeMultipleBond() {
        return this.styleManager.modeMultipleBond;
    }

    public void setShowMultipleBonds(boolean showMultipleBonds) {
        this.styleManager.setShowMultipleBonds(showMultipleBonds);
        this.refresh();
    }

    public boolean getShowMultipleBonds() {
        return this.styleManager.showMultipleBonds;
    }

    public void setShowHydrogens(boolean showHydrogens) {
        this.styleManager.setShowHydrogens(showHydrogens);
        this.refresh();
    }

    public boolean getShowHydrogens() {
        return this.styleManager.showHydrogens;
    }

    public void setShowMeasurements(boolean showMeasurements) {
        this.styleManager.setShowMeasurements(showMeasurements);
        this.refresh();
    }

    public boolean getShowMeasurements() {
        return this.styleManager.showMeasurements;
    }

    public void setShowMeasurementLabels(boolean showMeasurementLabels) {
        this.styleManager.setShowMeasurementLabels(showMeasurementLabels);
        this.refresh();
    }

    public boolean getShowMeasurementLabels() {
        return this.styleManager.showMeasurementLabels;
    }

    public boolean setMeasureDistanceUnits(String units) {
        return this.styleManager.setMeasureDistanceUnits(units);
    }

    public String getMeasureDistanceUnits() {
        return this.styleManager.measureDistanceUnits;
    }

    public void setWireframeRotation(boolean wireframeRotation) {
        this.styleManager.setWireframeRotation(wireframeRotation);
    }

    public boolean getWireframeRotation() {
        return this.styleManager.wireframeRotation;
    }

    public void setJmolDefaults() {
        this.styleManager.setJmolDefaults();
    }

    public void setRasmolDefaults() {
        this.styleManager.setRasmolDefaults();
    }

    public void setShowFrank(boolean showFrank) {
        this.styleManager.setShowFrank(showFrank);
    }

    public boolean getShowFrank() {
        return this.styleManager.showFrank;
    }

    public void setZeroBasedXyzRasmol(boolean zeroBasedXyzRasmol) {
        this.styleManager.setZeroBasedXyzRasmol(zeroBasedXyzRasmol);
    }

    public boolean getZeroBasedXyzRasmol() {
        return this.styleManager.zeroBasedXyzRasmol;
    }

    public void setLabelFontSize(int points) {
        this.styleManager.setLabelFontSize(points);
        this.refresh();
    }

    public void setLabelOffset(int xOffset, int yOffset) {
        this.styleManager.setLabelOffset(xOffset, yOffset);
        this.refresh();
    }

    public int getLabelOffsetX() {
        return this.styleManager.labelOffsetX;
    }

    public int getLabelOffsetY() {
        return this.styleManager.labelOffsetY;
    }

    public Point3f[] allocTempPoints(int size) {
        return this.tempManager.allocTempPoints(size);
    }

    public void freeTempPoints(Point3f[] tempPoints) {
        this.tempManager.freeTempPoints(tempPoints);
    }

    public Point3i[] allocTempScreens(int size) {
        return this.tempManager.allocTempScreens(size);
    }

    public void freeTempScreens(Point3i[] tempScreens) {
        this.tempManager.freeTempScreens(tempScreens);
    }

    public boolean[] allocTempBooleans(int size) {
        return this.tempManager.allocTempBooleans(size);
    }

    public void freeTempBooleans(boolean[] tempBooleans) {
        this.tempManager.freeTempBooleans(tempBooleans);
    }

    public Font3D getFont3D(int fontSize) {
        return this.g3d.getFont3D("SansSerif", "Plain", fontSize);
    }

    public Font3D getFont3D(String fontFace, String fontStyle, int fontSize) {
        return this.g3d.getFont3D(fontFace, fontStyle, fontSize);
    }

    public String getElementSymbol(int i) {
        return this.modelManager.getElementSymbol(i);
    }

    public int getElementNumber(int i) {
        return this.modelManager.getElementNumber(i);
    }

    public String getAtomName(int i) {
        return this.modelManager.getAtomName(i);
    }

    public int getAtomNumber(int i) {
        return this.modelManager.getAtomNumber(i);
    }

    public float getAtomX(int i) {
        return this.modelManager.getAtomX(i);
    }

    public float getAtomY(int i) {
        return this.modelManager.getAtomY(i);
    }

    public float getAtomZ(int i) {
        return this.modelManager.getAtomZ(i);
    }

    public Point3f getAtomPoint3f(int i) {
        return this.modelManager.getAtomPoint3f(i);
    }

    public float getAtomRadius(int i) {
        return this.modelManager.getAtomRadius(i);
    }

    public Color getAtomColor(int i) {
        return this.g3d.getColor(this.modelManager.getAtomColix(i));
    }

    public Point3f getBondPoint3f1(int i) {
        return this.modelManager.getBondPoint3f1(i);
    }

    public Point3f getBondPoint3f2(int i) {
        return this.modelManager.getBondPoint3f2(i);
    }

    public float getBondRadius(int i) {
        return this.modelManager.getBondRadius(i);
    }

    public short getBondOrder(int i) {
        return this.modelManager.getBondOrder(i);
    }

    public Color getBondColor1(int i) {
        return this.g3d.getColor(this.modelManager.getBondColix1(i));
    }

    public Color getBondColor2(int i) {
        return this.g3d.getColor(this.modelManager.getBondColix2(i));
    }

    static class NullBondIterator
    implements BondIterator {
        NullBondIterator() {
        }

        public boolean hasNext() {
            return false;
        }

        public Bond next() {
            return null;
        }
    }

    static class NullAtomIterator
    implements AtomIterator {
        NullAtomIterator() {
        }

        public boolean hasNext() {
            return false;
        }

        public Atom next() {
            return null;
        }

        public void release() {
        }
    }
}

