/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.jmol.viewer.datamodel;

import java.util.BitSet;
import org.jmol.g3d.Font3D;
import org.openscience.jmol.viewer.datamodel.Shape;

public class Hover
extends Shape {
    private static final int LEFT = 0;
    private static final int CENTER = 1;
    private static final int RIGHT = 2;
    private static final int TOP = 0;
    private static final int BOTTOM = 1;
    private static final int MIDDLE = 2;
    private static final String FONTFACE = "Serif";
    private static final String FONTSTYLE = "Plain";
    private static final int FONTSIZE = 16;
    int atomIndex;
    Font3D font3d;
    String labelFormat = "%U";
    short colixBackground;
    short colixForeground;

    void initShape() {
        this.font3d = this.g3d.getFont3D(FONTFACE, FONTSTYLE, 16);
        this.colixBackground = this.g3d.getColix("lightskyblue");
        this.colixForeground = 1;
    }

    void setProperty(String propertyName, Object value, BitSet bsSelected) {
        if ("target" == propertyName) {
            this.atomIndex = value == null ? -1 : (Integer)value;
            return;
        }
        if ("color" == propertyName) {
            this.colixForeground = this.g3d.getColix(value);
            return;
        }
        if ("bgcolor" == propertyName) {
            this.colixBackground = this.g3d.getColix(value);
            return;
        }
        if ("font" == propertyName) {
            this.font3d = (Font3D)value;
            return;
        }
        if ("label" == propertyName) {
            this.labelFormat = (String)value;
            if (this.labelFormat != null && this.labelFormat.length() == 0) {
                this.labelFormat = null;
            }
            return;
        }
    }
}

