/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.sanger.jcon.job;

import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import uk.ac.sanger.jcon.job.Executable;
import uk.ac.sanger.jcon.job.Job;
import uk.ac.sanger.jcon.job.Status;
import uk.ac.sanger.jcon.util.PostorderEnumeration;
import uk.ac.sanger.jcon.util.PreorderEnumeration;
import uk.ac.sanger.util.AbstractPropertyChangeable;

public class JobDefaultImpl
extends AbstractPropertyChangeable
implements Job {
    private int id;
    protected int low;
    protected int high;
    protected MutableTreeNode parent;
    protected Vector children;
    protected String operator;
    protected Executable executable;
    protected Status status;
    protected Timestamp startTime;
    protected Timestamp completionTime;
    protected String inputName;
    protected String outputName;
    protected String errorName;
    protected String workDirectoryName;
    protected String commandTemplate;
    protected String environment;
    protected int maxRetryCount;
    protected int retryCount;
    protected int exitValue;
    protected transient Object userObject;
    protected PropertyChangeSupport changeSupport;

    public JobDefaultImpl() {
        this.operator = "AND";
        this.maxRetryCount = 1;
        this.exitValue = -1;
    }

    public JobDefaultImpl(Executable executable) {
        if (executable == null) {
            throw new IllegalArgumentException("Failed to set Executable as it was null");
        }
        this.operator = "AND";
        this.maxRetryCount = 1;
        this.exitValue = -1;
        this.executable = executable;
    }

    public JobDefaultImpl(String operator, Executable executable, Status status, Timestamp startTime, Timestamp completionTime, String inputName, String outputName, String errorName, String commandTemplate, String workDirectoryName, String environment, int maxRetryCount, int retryCount, int exitValue) {
        if (maxRetryCount < 0 || maxRetryCount > 4) {
            throw new IllegalArgumentException("Invalid maxRetryCount '" + maxRetryCount + "' passed to constructor. Valid range is " + "0 >= id <= " + 4);
        }
        if (!operator.equals("AND") && !operator.equals("OR")) {
            throw new IllegalArgumentException("Invalid operator '" + operator + "' passed to constructor. Valid options are: '" + "AND" + "', '" + "OR" + "'");
        }
        if (executable == null) {
            throw new IllegalArgumentException("Failed to set Executable as it was null");
        }
        if (status == null) {
            throw new IllegalArgumentException("Failed to set Status as it was null");
        }
        if (commandTemplate == null) {
            throw new IllegalArgumentException("Failed to set commandTemplate as it was null");
        }
        this.checkFieldLength(inputName, 64);
        this.checkFieldLength(outputName, 64);
        this.checkFieldLength(errorName, 64);
        this.checkFieldLength(commandTemplate, 255);
        this.checkFieldLength(workDirectoryName, 255);
        this.operator = operator;
        this.executable = executable;
        this.status = status;
        this.startTime = startTime;
        this.completionTime = completionTime;
        this.inputName = inputName;
        this.outputName = outputName;
        this.errorName = errorName;
        this.commandTemplate = commandTemplate;
        this.workDirectoryName = workDirectoryName;
        this.environment = environment;
        this.maxRetryCount = maxRetryCount;
        this.retryCount = retryCount;
        this.exitValue = exitValue;
    }

    public int getId() {
        return this.id;
    }

    public String getOperator() {
        return this.operator;
    }

    public void setOperator(String operator) {
        if (!operator.equals("AND") && !operator.equals("OR")) {
            throw new IllegalArgumentException("Invalid operator '" + operator + "' passed to method. Valid options are: '" + "AND" + "', '" + "OR" + "'");
        }
        this.operator = operator;
    }

    public Executable getExecutable() {
        return this.executable;
    }

    public void setExecutable(Executable executable) {
        if (executable == null) {
            throw new IllegalArgumentException("Failed to set Executable as it was null");
        }
        this.executable = executable;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        if (status == null) {
            throw new IllegalArgumentException("Failed to set Status as it was null");
        }
        if (this.hasListeners()) {
            PropertyChangeSupport pcs = this.getPropertyChangeSupport();
            pcs.firePropertyChange("status", this.status, status);
        }
        this.status = status;
    }

    public Timestamp getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Timestamp startTime) {
        this.startTime = startTime;
    }

    public Timestamp getCompletionTime() {
        return this.completionTime;
    }

    public void setCompletionTime(Timestamp completionTime) {
        this.completionTime = completionTime;
    }

    public String getInputName() {
        return this.inputName;
    }

    public void setInputName(String inputName) {
        this.checkFieldLength(inputName, 64);
        this.inputName = inputName;
    }

    public String getOutputName() {
        return this.outputName;
    }

    public void setOutputName(String outputName) {
        this.checkFieldLength(outputName, 64);
        this.outputName = outputName;
    }

    public String getErrorName() {
        return this.errorName;
    }

    public void setErrorName(String errorName) {
        this.checkFieldLength(errorName, 64);
        this.errorName = errorName;
    }

    public String getCommandTemplate() {
        return this.commandTemplate;
    }

    public void setCommandTemplate(String commandTemplate) {
        if (commandTemplate == null) {
            throw new IllegalArgumentException("Failed to set commandTemplate as it was null");
        }
        this.checkFieldLength(commandTemplate, 255);
        this.commandTemplate = commandTemplate;
    }

    public String getWorkDirectoryName() {
        return this.workDirectoryName;
    }

    public void setWorkDirectoryName(String workDirectoryName) {
        this.checkFieldLength(workDirectoryName, 255);
        this.workDirectoryName = workDirectoryName;
    }

    public String getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(String environment) {
        this.checkFieldLength(environment, 255);
        this.environment = environment;
    }

    public int getMaxRetryCount() {
        return this.maxRetryCount;
    }

    public void setMaxRetryCount(int maxRetryCount) throws IllegalArgumentException {
        if (maxRetryCount < 0 || maxRetryCount > 4) {
            throw new IllegalArgumentException("Invalid maxRetryCount '" + maxRetryCount + "' passed to method. Valid range is " + "0 >= priority <= " + 4);
        }
        this.maxRetryCount = maxRetryCount;
    }

    public int getRetryCount() {
        return this.retryCount;
    }

    public void setRetryCount(int retryCount) {
        if (this.hasListeners()) {
            PropertyChangeSupport pcs = this.getPropertyChangeSupport();
            pcs.firePropertyChange("retryCount", this.retryCount, retryCount);
        }
        this.retryCount = retryCount;
    }

    public int getExitValue() {
        return this.exitValue;
    }

    public void setExitValue(int exitValue) {
        if (this.hasListeners()) {
            PropertyChangeSupport pcs = this.getPropertyChangeSupport();
            pcs.firePropertyChange("exitValue", this.exitValue, exitValue);
        }
        this.exitValue = exitValue;
    }

    public Enumeration children() {
        if (this.children == null) {
            return DefaultMutableTreeNode.EMPTY_ENUMERATION;
        }
        return this.children.elements();
    }

    public boolean getAllowsChildren() {
        return true;
    }

    public TreeNode getChildAt(int childIndex) {
        if (this.children == null) {
            throw new ArrayIndexOutOfBoundsException("Job has no children");
        }
        return (MutableTreeNode)this.children.get(childIndex);
    }

    public int getChildCount() {
        if (this.children == null) {
            return 0;
        }
        return this.children.size();
    }

    public int getIndex(TreeNode job) {
        if (job == null) {
            throw new IllegalArgumentException("Job argument was null");
        }
        if (!this.isOurChild((Job)job)) {
            return -1;
        }
        return this.children.indexOf(job);
    }

    public TreeNode getParent() {
        return this.parent;
    }

    public void setParent(MutableTreeNode parent) {
        this.parent = parent;
    }

    public boolean isLeaf() {
        return this.getChildCount() == 0;
    }

    public void add(Job newChild) {
        if (newChild.getParent() == this) {
            throw new IllegalArgumentException("Failed to added child Job as it is already a child of this Job");
        }
        this.insert(newChild, this.getChildCount());
    }

    public void insert(MutableTreeNode newChild, int childIndex) {
        if (!(newChild instanceof Job)) {
            throw new IllegalArgumentException("Failed to add child Job as it was not an instance of uk.ac.sanger.jcon.job.Job");
        }
        if (newChild == null) {
            throw new IllegalArgumentException("Failed to add child Job as it was null");
        }
        if (this.isOurAncestor(newChild)) {
            throw new IllegalArgumentException("Failed to add child Job as it is an ancestor");
        }
        MutableTreeNode oldParent = (MutableTreeNode)newChild.getParent();
        if (oldParent != null) {
            oldParent.remove(newChild);
        }
        newChild.setParent(this);
        if (this.children == null) {
            this.children = new Vector();
        }
        this.children.insertElementAt(newChild, childIndex);
    }

    public void remove(int childIndex) {
        MutableTreeNode child = (MutableTreeNode)this.getChildAt(childIndex);
        this.children.remove(childIndex);
        child.setParent(null);
    }

    public void remove(MutableTreeNode child) {
        if (child == null) {
            throw new IllegalArgumentException("Failed to remove child Job as it was null");
        }
        if (!this.isOurChild(child)) {
            throw new IllegalArgumentException("Failed to remove child as it the Job is not its parent");
        }
        this.remove(this.getIndex(child));
    }

    public void removeFromParent() {
        MutableTreeNode parent = (MutableTreeNode)this.getParent();
        if (parent != null) {
            parent.remove(this);
        }
    }

    public Object getUserObject() {
        return this.userObject;
    }

    public void setUserObject(Object userObject) {
        this.userObject = userObject;
    }

    public Enumeration preorderEnumeration() {
        return new PreorderEnumeration(this);
    }

    public Enumeration postorderEnumeration() {
        return new PostorderEnumeration(this);
    }

    public int getLow() {
        return this.low;
    }

    public void setLow(int low) {
        this.low = low;
    }

    public int getHigh() {
        return this.high;
    }

    public void setHigh(int high) {
        this.high = high;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("Job [");
        sb.append(this.id);
        sb.append("] '");
        sb.append(this.executable);
        sb.append("', ");
        sb.append(this.status);
        return sb.substring(0);
    }

    protected void checkFieldLength(String field, int maxLength) {
        if (field != null && field.length() > maxLength) {
            throw new IllegalArgumentException("Field " + field + " is longer than the permitted maximum of " + maxLength + " characters");
        }
    }

    protected boolean isOurChild(TreeNode child) {
        if (child == null) {
            return false;
        }
        if (this.getChildCount() == 0) {
            return false;
        }
        return child.getParent() == this;
    }

    protected boolean isOurAncestor(TreeNode job) {
        if (job == null) {
            return false;
        }
        TreeNode ancestor = this;
        while (ancestor != null) {
            if ((ancestor = ancestor.getParent()) != job) continue;
            return true;
        }
        return false;
    }

    protected void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        Object[] objects = this.userObject != null && this.userObject instanceof Serializable ? new Object[]{"userObject", this.userObject} : new Object[]{};
        stream.writeObject(objects);
    }

    protected void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        Object[] objects = (Object[])stream.readObject();
        if (objects.length > 0 && objects[0].equals("userObject")) {
            this.userObject = objects[1];
        }
    }
}

