/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.sanger.jcon.protocol;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Map;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.io.EmblLikeFormat;
import org.biojava.bio.seq.io.FastaFormat;
import uk.ac.sanger.jcon.JobControl;
import uk.ac.sanger.jcon.job.BatchJob;
import uk.ac.sanger.jcon.job.JobBatchImpl;
import uk.ac.sanger.jcon.manager.Administrator;
import uk.ac.sanger.jcon.manager.TaskManager;
import uk.ac.sanger.jcon.protocol.Protocol;

abstract class AbstractProtocol
implements Protocol {
    protected JobControl jobControl = new JobControl();
    protected Administrator admin = this.jobControl.createAdministrator();
    protected TaskManager manager = this.jobControl.createTaskManager();

    protected BatchJob createEmptyBatchJob(String queue) throws Exception {
        JobBatchImpl job = new JobBatchImpl(this.admin.getExecutableById(1));
        job.setStatus(this.admin.getStatusById(1));
        job.setOutputName("/dev/null");
        job.setCommandTemplate("$executable");
        job.setQueue(queue);
        return job;
    }

    protected void writeFasta(Sequence seq, File file) throws IOException {
        PrintStream ps = new PrintStream(new FileOutputStream(file));
        FastaFormat format = new FastaFormat();
        format.writeSequence(seq, ps);
    }

    protected void writeEMBL(Sequence seq, File file) throws IOException {
        PrintStream ps = new PrintStream(new FileOutputStream(file));
        EmblLikeFormat format = new EmblLikeFormat();
        format.writeSequence(seq, ps);
    }

    protected File createAbsoluteFile(String dir, String fileName) {
        return new File(dir, fileName).getAbsoluteFile();
    }

    public abstract void apply(String var1, Map var2, String[] var3) throws Exception;
}

