/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.sanger.jcon.servlets;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.log4j.Category;
import org.apache.velocity.Template;
import org.apache.velocity.context.Context;
import org.apache.velocity.exception.ParseErrorException;
import org.apache.velocity.exception.ResourceNotFoundException;
import uk.ac.sanger.jcon.dao.StatusSQLDAO;
import uk.ac.sanger.jcon.dao.TaskSQLDAO;
import uk.ac.sanger.jcon.dao.TaskStatisticSQLDAO;
import uk.ac.sanger.jcon.job.Status;
import uk.ac.sanger.jcon.job.Task;
import uk.ac.sanger.jcon.job.TaskState;
import uk.ac.sanger.jcon.servlets.JobControlServlet;
import uk.ac.sanger.jcon.servlets.Table;
import uk.ac.sanger.jcon.servlets.TemplateFactory;

class TemplateFactoryTaskStateImpl
implements TemplateFactory {
    static Category cat = Category.getInstance((String)(class$uk$ac$sanger$jcon$servlets$TemplateFactoryTaskStateImpl == null ? (class$uk$ac$sanger$jcon$servlets$TemplateFactoryTaskStateImpl = TemplateFactoryTaskStateImpl.class$("uk.ac.sanger.jcon.servlets.TemplateFactoryTaskStateImpl")) : class$uk$ac$sanger$jcon$servlets$TemplateFactoryTaskStateImpl).getName());
    private JobControlServlet servlet;
    static /* synthetic */ Class class$uk$ac$sanger$jcon$servlets$TemplateFactoryTaskStateImpl;

    TemplateFactoryTaskStateImpl(JobControlServlet servlet) {
        this.servlet = servlet;
    }

    public Template createTemplate(Context context) throws Exception {
        Template template = null;
        try {
            DataSource datasource = this.servlet.getDataSource();
            TaskSQLDAO taskDAO = new TaskSQLDAO(datasource);
            StatusSQLDAO statusDAO = new StatusSQLDAO(datasource);
            TaskStatisticSQLDAO taskStatDAO = new TaskStatisticSQLDAO(datasource);
            Status waiting = statusDAO.readStatusById(1);
            Status ready = statusDAO.readStatusById(2);
            Status started = statusDAO.readStatusById(3);
            Status completed = statusDAO.readStatusById(4);
            Status failed = statusDAO.readStatusById(5);
            Collection tasks = taskDAO.readSubmittedTasks(1);
            Collection tStats = taskStatDAO.readSubmittedTaskState();
            Map statMap = this.createTaskStatMap(tStats);
            Table taskTable = new Table();
            Iterator ti = tasks.iterator();
            while (ti.hasNext()) {
                Task t = (Task)ti.next();
                Integer id = new Integer(t.getId());
                TaskState tStat = (TaskState)statMap.get(id);
                if (tStat == null) {
                    cat.warn((Object)("Task [" + id + "] completed before stats could be read"));
                    continue;
                }
                int waitCount = tStat.getJobCount(waiting);
                int readyCount = tStat.getJobCount(ready);
                int startCount = tStat.getJobCount(started);
                int compCount = tStat.getJobCount(completed);
                int failCount = tStat.getJobCount(failed);
                int totalCount = tStat.getTotalJobCount();
                Table table = taskTable;
                table.getClass();
                Table.Row row = table.new Table.Row(5);
                Table table2 = taskTable;
                table2.getClass();
                Table.Cell cell = table2.new Table.Cell(id.toString());
                cell.setMetaData("right");
                row.addCell(cell);
                Table table3 = taskTable;
                table3.getClass();
                row.addCell(table3.new Table.Cell(t.getName()));
                Table table4 = taskTable;
                table4.getClass();
                row.addCell(table4.new Table.Cell(t.getOwner().getUserName()));
                Table table5 = taskTable;
                table5.getClass();
                row.addCell(table5.new Table.Cell(t.getDescription()));
                String[] vals = new String[]{Integer.toString(t.getPriority()), Integer.toString(waitCount), Integer.toString(readyCount), Integer.toString(startCount), Integer.toString(compCount), Integer.toString(failCount), Integer.toString(totalCount)};
                int i = 0;
                while (i < vals.length) {
                    Table table6 = taskTable;
                    table6.getClass();
                    cell = table6.new Table.Cell(vals[i]);
                    cell.setMetaData("right");
                    row.addCell(cell);
                    ++i;
                }
                if (id % 2 == 0) {
                    row.setMetaData("dark_bg");
                } else {
                    row.setMetaData("pale_bg");
                }
                taskTable.addRow(row);
            }
            cat.debug((Object)("Result table is:\n" + taskTable));
            context.put("taskTable", (Object)taskTable);
            template = this.servlet.getTemplate("taskstate.vm");
        }
        catch (ResourceNotFoundException rnfe) {
            System.err.println("JobControlServlet: template not found");
            throw rnfe;
        }
        catch (ParseErrorException pee) {
            System.err.println("JobControlServlet: parse error for template");
            throw pee;
        }
        return template;
    }

    private Map createTaskStatMap(Collection tStats) {
        HashMap<Integer, TaskState> statMap = new HashMap<Integer, TaskState>();
        Iterator i = tStats.iterator();
        while (i.hasNext()) {
            TaskState tStat = (TaskState)i.next();
            statMap.put(new Integer(tStat.getTaskId()), tStat);
        }
        return statMap;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

