/*
 * Decompiled with CFR 0.152.
 */
package Freeze;

import Freeze.DatabaseException;
import Freeze.Evictor;
import Freeze.EvictorDeactivatedException;
import Freeze.EvictorElement;
import Freeze.EvictorIterator;
import Freeze.EvictorIteratorI;
import Freeze.Index;
import Freeze.LinkedList;
import Freeze.ObjectRecord;
import Freeze.ObjectStore;
import Freeze.ServantInitializer;
import Freeze.SharedDbEnv;
import Freeze.Statistics;
import Freeze.Util;
import Ice.AlreadyRegisteredException;
import Ice.Communicator;
import Ice.Current;
import Ice.FacetNotExistException;
import Ice.Identity;
import Ice.IllegalIdentityException;
import Ice.LocalObject;
import Ice.LocalObjectHolder;
import Ice.LocalObjectImpl;
import Ice.NotRegisteredException;
import Ice.ObjectAdapter;
import Ice.ObjectPrx;
import Ice.OperationMode;
import IceUtil.StringUtil;
import com.sleepycat.db.Db;
import com.sleepycat.db.DbDeadlockException;
import com.sleepycat.db.DbEnv;
import com.sleepycat.db.DbException;
import com.sleepycat.db.DbTxn;
import com.sleepycat.db.Dbc;
import com.sleepycat.db.Dbt;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

class EvictorI
extends LocalObjectImpl
implements Evictor,
Runnable {
    static final String defaultDb = "$default";
    static final String indexPrefix = "$index:";
    private final Map _storeMap = new HashMap();
    private final LinkedList _evictorList = new LinkedList();
    private int _evictorSize = 10;
    private int _currentEvictorSize = 0;
    private List _modifiedQueue = new ArrayList();
    private boolean _savingThreadDone = false;
    private WatchDogThread _watchDogThread = null;
    private DeactivateController _deactivateController = new DeactivateController();
    private final ObjectAdapter _adapter;
    private final Communicator _communicator;
    private final ServantInitializer _initializer;
    private SharedDbEnv _dbEnvHolder;
    private DbEnv _dbEnv;
    private final String _filename;
    private final boolean _createDb;
    private int _trace = 0;
    private final List _saveNowThreads = new ArrayList();
    private int _saveSizeTrigger;
    private int _maxTxSize;
    private long _savePeriod;
    private Thread _thread;
    private String _errorPrefix;
    private boolean _deadlockWarning;
    static final /* synthetic */ boolean $assertionsDisabled;

    public EvictorI(ObjectAdapter adapter, String envName, String filename, ServantInitializer initializer, Index[] indices, boolean createDb) {
        this._adapter = adapter;
        this._communicator = adapter.getCommunicator();
        this._initializer = initializer;
        this._dbEnvHolder = SharedDbEnv.get(this._communicator, envName);
        this._dbEnv = this._dbEnvHolder;
        this._filename = filename;
        this._createDb = createDb;
        this.init(envName, indices);
    }

    public EvictorI(ObjectAdapter adapter, String envName, DbEnv dbEnv, String filename, ServantInitializer initializer, Index[] indices, boolean createDb) {
        this._adapter = adapter;
        this._communicator = adapter.getCommunicator();
        this._initializer = initializer;
        this._dbEnv = dbEnv;
        this._filename = filename;
        this._createDb = createDb;
        this.init(envName, indices);
    }

    private void init(String envName, Index[] indices) {
        String facet;
        this._trace = this._communicator.getProperties().getPropertyAsInt("Freeze.Trace.Evictor");
        this._deadlockWarning = this._communicator.getProperties().getPropertyAsInt("Freeze.Warn.Deadlocks") != 0;
        this._errorPrefix = "Freeze Evictor DbEnv(\"" + envName + "\") Db(\"" + this._filename + "\"): ";
        String propertyPrefix = "Freeze.Evictor." + envName + '.' + this._filename;
        this._saveSizeTrigger = this._communicator.getProperties().getPropertyAsIntWithDefault(propertyPrefix + ".SaveSizeTrigger", 10);
        this._savePeriod = this._communicator.getProperties().getPropertyAsIntWithDefault(propertyPrefix + ".SavePeriod", 60000);
        this._maxTxSize = this._communicator.getProperties().getPropertyAsIntWithDefault(propertyPrefix + ".MaxTxSize", 10 * this._saveSizeTrigger);
        if (this._maxTxSize <= 0) {
            this._maxTxSize = 100;
        }
        boolean populateEmptyIndices = this._communicator.getProperties().getPropertyAsIntWithDefault(propertyPrefix + ".PopulateEmptyIndices", 0) != 0;
        List dbs = this.allDbs();
        dbs.add(defaultDb);
        if (indices != null) {
            for (int i = 0; i < indices.length; ++i) {
                facet = indices[i].facet();
                if (this._storeMap.get(facet) != null) continue;
                java.util.LinkedList<Index> storeIndices = new java.util.LinkedList<Index>();
                for (int j = i; j < indices.length; ++j) {
                    if (!indices[j].facet().equals(facet)) continue;
                    storeIndices.add(indices[j]);
                }
                ObjectStore store = new ObjectStore(facet, this._createDb, this, storeIndices, populateEmptyIndices);
                this._storeMap.put(facet, store);
            }
        }
        Iterator p = dbs.iterator();
        while (p.hasNext()) {
            facet = (String)p.next();
            if (facet.equals(defaultDb)) {
                facet = "";
            }
            if (this._storeMap.get(facet) != null) continue;
            ObjectStore store = new ObjectStore(facet, this._createDb, this, new java.util.LinkedList(), populateEmptyIndices);
            this._storeMap.put(facet, store);
        }
        String programName = this._communicator.getProperties().getProperty("Ice.ProgramName");
        String savingThreadName = programName.length() > 0 ? programName + "-" : "";
        String watchDogThreadName = savingThreadName + "FreezeEvictorWatchDogThread(" + envName + '.' + this._filename + ")";
        savingThreadName = savingThreadName + "FreezeEvictorThread(" + envName + '.' + this._filename + ")";
        long streamTimeout = this._communicator.getProperties().getPropertyAsIntWithDefault(propertyPrefix + ".StreamTimeout", 0) * 1000;
        if (streamTimeout > 0L) {
            this._watchDogThread = new WatchDogThread(streamTimeout, watchDogThreadName);
            this._watchDogThread.start();
        }
        this._thread = new Thread((Runnable)this, savingThreadName);
        this._thread.start();
    }

    protected void finalize() {
        if (!this._deactivateController.deactivated()) {
            this._communicator.getLogger().warning("evictor has not been deactivated");
            this.deactivate("");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setSize(int evictorSize) {
        this._deactivateController.lock();
        try {
            if (evictorSize < 0) {
                return;
            }
            this._evictorSize = evictorSize;
            this.evict();
        }
        finally {
            this._deactivateController.unlock();
        }
    }

    public synchronized int getSize() {
        return this._evictorSize;
    }

    public ObjectPrx add(Ice.Object servant, Identity ident) {
        return this.addFacet(servant, ident, "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public ObjectPrx addFacet(Ice.Object servant, Identity ident, String facet) {
        block31: {
            EvictorI.checkIdentity(ident);
            if (facet == null) {
                facet = "";
            }
            try {
                ident = (Identity)ident.clone();
            }
            catch (CloneNotSupportedException ex) {
                if ($assertionsDisabled) break block31;
                throw new AssertionError();
            }
        }
        this._deactivateController.lock();
        try {
            EvictorElement element;
            ObjectStore store = null;
            while (true) {
                EvictorI evictorI = this;
                // MONITORENTER : evictorI
                Object o = this._storeMap.get(facet);
                if (o == null) {
                    if (store != null) {
                        this._storeMap.put(facet, store);
                    }
                } else {
                    if (store != null) {
                        store.close();
                    }
                    store = (ObjectStore)o;
                }
                // MONITOREXIT : evictorI
                if (store != null) break;
                if (!$assertionsDisabled && facet.length() <= 0) {
                    throw new AssertionError();
                }
                store = new ObjectStore(facet, this._createDb, this, new java.util.LinkedList(), false);
            }
            if (!$assertionsDisabled && store == null) {
                throw new AssertionError();
            }
            boolean alreadyThere = false;
            while (true) {
                element = new EvictorElement(ident, store);
                element.status = (byte)4;
                element.rec = new ObjectRecord();
                element.rec.stats = new Statistics();
                Object o = store.cache().putIfAbsent(ident, element);
                if (o != null) {
                    element = (EvictorElement)o;
                }
                EvictorI evictorI = this;
                // MONITORENTER : evictorI
                if (!element.stale) break;
                // MONITOREXIT : evictorI
            }
            this.fixEvictPosition(element);
            EvictorElement evictorElement = element;
            // MONITORENTER : evictorElement
            switch (element.status) {
                case 0: 
                case 1: 
                case 2: {
                    alreadyThere = true;
                    break;
                }
                case 3: {
                    element.status = (byte)2;
                    element.rec.servant = servant;
                    break;
                }
                case 4: {
                    element.status = 1;
                    ObjectRecord rec = element.rec;
                    rec.servant = servant;
                    rec.stats.creationTime = System.currentTimeMillis();
                    rec.stats.lastSaveTime = 0L;
                    rec.stats.avgSaveTime = 0L;
                    this.addToModifiedQueue(element);
                    break;
                }
                default: {
                    if (!$assertionsDisabled) {
                        throw new AssertionError();
                    }
                    break;
                }
            }
            // MONITOREXIT : evictorElement
            // MONITOREXIT : evictorI
            if (alreadyThere) {
                AlreadyRegisteredException ex = new AlreadyRegisteredException();
                ex.kindOfObject = "servant";
                ex.id = Ice.Util.identityToString(ident);
                if (facet.length() <= 0) throw ex;
                ex.id = ex.id + " -f " + StringUtil.escapeString(facet, "");
                throw ex;
            }
            if (this._trace >= 1) {
                String objString = "object \"" + Ice.Util.identityToString(ident) + "\"";
                if (!facet.equals("")) {
                    objString = objString + " with facet \"" + facet + "\"";
                }
                this._communicator.getLogger().trace("Freeze.Evictor", "added " + objString + " in the database");
            }
            ObjectPrx obj = this._adapter.createProxy(ident);
            if (facet.length() > 0) {
                obj = obj.ice_newFacet(facet);
            }
            ObjectPrx objectPrx = obj;
            return objectPrx;
        }
        finally {
            this._deactivateController.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void createObject(Identity ident, Ice.Object servant) {
        block19: {
            EvictorI.checkIdentity(ident);
            try {
                ident = (Identity)ident.clone();
            }
            catch (CloneNotSupportedException ex) {
                if ($assertionsDisabled) break block19;
                throw new AssertionError();
            }
        }
        this._deactivateController.lock();
        try {
            EvictorElement element;
            ObjectStore store = this.findStore("");
            if (!$assertionsDisabled && store == null) {
                throw new AssertionError();
            }
            while (true) {
                element = new EvictorElement(ident, store);
                element.status = (byte)4;
                element.rec = new ObjectRecord();
                element.rec.stats = new Statistics();
                Object o = store.cache().putIfAbsent(ident, element);
                if (o != null) {
                    element = (EvictorElement)o;
                }
                EvictorI evictorI = this;
                synchronized (evictorI) {
                    if (!element.stale) break;
                }
            }
            {
                this.fixEvictPosition(element);
                EvictorElement evictorElement = element;
                synchronized (evictorElement) {
                    switch (element.status) {
                        case 0: {
                            element.status = (byte)2;
                            element.rec.servant = servant;
                            this.addToModifiedQueue(element);
                            break;
                        }
                        case 1: 
                        case 2: {
                            element.rec.servant = servant;
                            break;
                        }
                        case 3: {
                            element.status = (byte)2;
                            element.rec.servant = servant;
                            break;
                        }
                        case 4: {
                            element.status = 1;
                            ObjectRecord rec = element.rec;
                            rec.servant = servant;
                            rec.stats.creationTime = System.currentTimeMillis();
                            rec.stats.lastSaveTime = 0L;
                            rec.stats.avgSaveTime = 0L;
                            this.addToModifiedQueue(element);
                            break;
                        }
                        default: {
                            if (!$assertionsDisabled) {
                                throw new AssertionError();
                            }
                            break;
                        }
                    }
                }
            }
            if (this._trace < 1) return;
            String objString = "object \"" + Ice.Util.identityToString(ident) + "\"";
            this._communicator.getLogger().trace("Freeze.Evictor", "added or updated " + objString + " in the database");
            return;
        }
        finally {
            this._deactivateController.unlock();
        }
    }

    public Ice.Object remove(Identity ident) {
        return this.removeFacet(ident, "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Ice.Object removeFacet(Identity ident, String facet) {
        block28: {
            EvictorI.checkIdentity(ident);
            if (facet == null) {
                facet = "";
            }
            try {
                ident = (Identity)ident.clone();
            }
            catch (CloneNotSupportedException ex) {
                if ($assertionsDisabled) break block28;
                throw new AssertionError();
            }
        }
        this._deactivateController.lock();
        try {
            ObjectStore store = this.findStore(facet);
            Ice.Object servant = null;
            if (store != null) {
                EvictorElement element;
                while ((element = (EvictorElement)store.cache().pin(ident)) != null) {
                    EvictorI evictorI = this;
                    synchronized (evictorI) {
                        if (element.stale) {
                            continue;
                        }
                        this.fixEvictPosition(element);
                        EvictorElement evictorElement = element;
                        synchronized (evictorElement) {
                            switch (element.status) {
                                case 0: {
                                    servant = element.rec.servant;
                                    element.status = (byte)3;
                                    element.rec.servant = null;
                                    this.addToModifiedQueue(element);
                                    break;
                                }
                                case 1: {
                                    servant = element.rec.servant;
                                    element.status = (byte)4;
                                    element.rec.servant = null;
                                    break;
                                }
                                case 2: {
                                    servant = element.rec.servant;
                                    element.status = (byte)3;
                                    element.rec.servant = null;
                                    break;
                                }
                                case 3: 
                                case 4: {
                                    break;
                                }
                                default: {
                                    if (!$assertionsDisabled) {
                                        throw new AssertionError();
                                    }
                                    break;
                                }
                            }
                        }
                        if (element.keepCount > 0) {
                            if (!$assertionsDisabled && servant == null) {
                                throw new AssertionError();
                            }
                            element.keepCount = 0;
                            this._evictorList.addFirst(element);
                            element.evictPosition = this._evictorList.iterator();
                            element.evictPosition.next();
                            ++this._currentEvictorSize;
                        }
                        break;
                    }
                }
            }
            if (servant == null) {
                NotRegisteredException ex = new NotRegisteredException();
                ex.kindOfObject = "servant";
                ex.id = Ice.Util.identityToString(ident);
                if (facet.length() > 0) {
                    ex.id = ex.id + " -f " + StringUtil.escapeString(facet, "");
                }
                throw ex;
            }
            if (this._trace >= 1) {
                String objString = "object \"" + Ice.Util.identityToString(ident) + "\"";
                if (!facet.equals("")) {
                    objString = objString + " with facet \"" + facet + "\"";
                }
                this._communicator.getLogger().trace("Freeze.Evictor", "removed " + objString);
            }
            Ice.Object object = servant;
            return object;
        }
        finally {
            this._deactivateController.unlock();
        }
    }

    public void destroyObject(Identity ident) {
        EvictorI.checkIdentity(ident);
        try {
            this.remove(ident);
        }
        catch (NotRegisteredException notRegisteredException) {
            // empty catch block
        }
    }

    public void keep(Identity ident) {
        this.keepFacet(ident, "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void keepFacet(Identity ident, String facet) {
        EvictorI.checkIdentity(ident);
        if (facet == null) {
            facet = "";
        }
        this._deactivateController.lock();
        try {
            boolean notThere;
            block19: {
                notThere = false;
                ObjectStore store = this.findStore(facet);
                if (store == null) {
                    notThere = true;
                } else {
                    EvictorElement element;
                    while (true) {
                        if ((element = (EvictorElement)store.cache().pin(ident)) == null) {
                            notThere = true;
                            break block19;
                        }
                        EvictorI evictorI = this;
                        synchronized (evictorI) {
                            if (!element.stale) break;
                        }
                    }
                    {
                        EvictorElement evictorElement = element;
                        synchronized (evictorElement) {
                            if (element.status == 3 || element.status == 4) {
                                notThere = true;
                            } else if (element.keepCount == 0) {
                                if (element.usageCount < 0) {
                                    element.usageCount = 0;
                                } else {
                                    if (!$assertionsDisabled && element.evictPosition == null) {
                                        throw new AssertionError();
                                    }
                                    element.evictPosition.remove();
                                    element.evictPosition = null;
                                    --this._currentEvictorSize;
                                }
                                element.keepCount = 1;
                            } else {
                                ++element.keepCount;
                            }
                        }
                    }
                }
            }
            if (!notThere) return;
            NotRegisteredException ex = new NotRegisteredException();
            ex.kindOfObject = "servant";
            ex.id = Ice.Util.identityToString(ident);
            if (facet.length() <= 0) throw ex;
            ex.id = ex.id + " -f " + StringUtil.escapeString(facet, "");
            throw ex;
        }
        finally {
            this._deactivateController.unlock();
        }
    }

    public void release(Identity ident) {
        this.releaseFacet(ident, "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void releaseFacet(Identity ident, String facet) {
        EvictorI.checkIdentity(ident);
        if (facet == null) {
            facet = "";
        }
        this._deactivateController.lock();
        try {
            EvictorI evictorI = this;
            synchronized (evictorI) {
                EvictorElement element;
                ObjectStore store = (ObjectStore)this._storeMap.get(facet);
                if (store != null && (element = (EvictorElement)store.cache().getIfPinned(ident)) != null) {
                    if (!$assertionsDisabled && element.stale) {
                        throw new AssertionError();
                    }
                    if (element.keepCount > 0) {
                        if (--element.keepCount != 0) return;
                        if (!$assertionsDisabled && element.evictPosition != null) {
                            throw new AssertionError();
                        }
                        this._evictorList.addFirst(element);
                        element.evictPosition = this._evictorList.iterator();
                        element.evictPosition.next();
                        ++this._currentEvictorSize;
                        return;
                    }
                }
            }
            NotRegisteredException ex = new NotRegisteredException();
            ex.kindOfObject = "servant";
            ex.id = Ice.Util.identityToString(ident);
            if (facet.length() <= 0) throw ex;
            ex.id = ex.id + " -f " + StringUtil.escapeString(facet, "");
            throw ex;
        }
        finally {
            this._deactivateController.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EvictorIterator getIterator(String facet, int batchSize) {
        if (facet == null) {
            facet = "";
        }
        this._deactivateController.lock();
        try {
            ObjectStore store = null;
            LocalObjectImpl localObjectImpl = this;
            synchronized (localObjectImpl) {
                store = (ObjectStore)this._storeMap.get(facet);
                if (store != null) {
                    this.saveNowNoSync();
                }
            }
            localObjectImpl = new EvictorIteratorI(store, batchSize);
            return localObjectImpl;
        }
        finally {
            this._deactivateController.unlock();
        }
    }

    public boolean hasObject(Identity ident) {
        return this.hasFacet(ident, "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean hasFacet(Identity ident, String facet) {
        ObjectStore store;
        EvictorI.checkIdentity(ident);
        if (facet == null) {
            facet = "";
        }
        this._deactivateController.lock();
        try {
            store = null;
            EvictorI evictorI = this;
            synchronized (evictorI) {
                store = (ObjectStore)this._storeMap.get(facet);
                if (store == null) {
                    boolean bl = false;
                    // MONITOREXIT @DISABLED, blocks:[0, 6, 12] lbl12 : MonitorExitStatement: MONITOREXIT : var4_4
                    this._deactivateController.unlock();
                    return bl;
                }
            }
        }
        catch (Throwable throwable) {
            this._deactivateController.unlock();
            throw throwable;
        }
        {
            EvictorElement element = (EvictorElement)store.cache().getIfPinned(ident);
            if (element != null) {
                boolean bl;
                if (!$assertionsDisabled && element.stale) {
                    throw new AssertionError();
                }
                EvictorElement evictorElement = element;
                synchronized (evictorElement) {
                    bl = element.status != 4 && element.status != 3;
                }
                // MONITOREXIT @DISABLED, blocks:[6, 10] lbl27 : MonitorExitStatement: MONITOREXIT : var4_4
                this._deactivateController.unlock();
                return bl;
            }
        }
        boolean bl = store.dbHasObject(ident);
        this._deactivateController.unlock();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Ice.Object locate(Current current, LocalObjectHolder cookie) {
        this._deactivateController.lock();
        try {
            Ice.Object result = this.locateImpl(current, cookie);
            if (result == null) {
                HashMap storeMapCopy;
                EvictorI evictorI = this;
                synchronized (evictorI) {
                    storeMapCopy = new HashMap(this._storeMap);
                }
                Iterator p = storeMapCopy.entrySet().iterator();
                while (p.hasNext()) {
                    Map.Entry entry = p.next();
                    if (current.facet.equals(entry.getKey())) continue;
                    ObjectStore store = (ObjectStore)entry.getValue();
                    boolean inCache = false;
                    EvictorI evictorI2 = this;
                    synchronized (evictorI2) {
                        EvictorElement element = (EvictorElement)store.cache().getIfPinned(current.id);
                        if (element != null) {
                            inCache = true;
                            if (!$assertionsDisabled && element.stale) {
                                throw new AssertionError();
                            }
                            EvictorElement evictorElement = element;
                            synchronized (evictorElement) {
                                if (element.status != 4 && element.status != 3) {
                                    throw new FacetNotExistException();
                                }
                            }
                        }
                    }
                    if (inCache || !store.dbHasObject(current.id)) continue;
                    throw new FacetNotExistException();
                }
            }
            Ice.Object object = result;
            return object;
        }
        finally {
            this._deactivateController.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    Ice.Object locateImpl(Current current, LocalObjectHolder cookie) {
        EvictorElement element;
        Identity ident;
        block16: {
            cookie.value = null;
            ident = null;
            try {
                ident = (Identity)current.id.clone();
            }
            catch (CloneNotSupportedException ex) {
                if ($assertionsDisabled) break block16;
                throw new AssertionError();
            }
        }
        ObjectStore store = this.findStore(current.facet);
        if (store == null) {
            if (this._trace >= 2) {
                this._communicator.getLogger().trace("Freeze.Evictor", "locate could not find a database for facet \"" + current.facet + "\"");
            }
            return null;
        }
        while (true) {
            if ((element = (EvictorElement)store.cache().pin(ident)) == null) {
                if (this._trace >= 2) {
                    this._communicator.getLogger().trace("Freeze.Evictor", "locate could not find \"" + Ice.Util.identityToString(ident) + "\" in database \"" + current.facet + "\"");
                }
                return null;
            }
            EvictorI evictorI = this;
            synchronized (evictorI) {
                if (!element.stale) break;
            }
        }
        {
            EvictorElement evictorElement = element;
            synchronized (evictorElement) {
                if (element.status == 3 || element.status == 4) {
                    if (this._trace >= 2) {
                        this._communicator.getLogger().trace("Freeze.Evictor", "locate found \"" + Ice.Util.identityToString(ident) + "\" in the cache for database \"" + current.facet + "\" but it was dead or destroyed");
                    }
                    return null;
                }
                if (this._trace >= 2) {
                    this._communicator.getLogger().trace("Freeze.Evictor", "locate found \"" + Ice.Util.identityToString(ident) + "\" in database \"" + current.facet + "\"");
                }
                this.fixEvictPosition(element);
                ++element.usageCount;
                cookie.value = element;
                if (!$assertionsDisabled && element.rec.servant == null) {
                    throw new AssertionError();
                }
                return element.rec.servant;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finished(Current current, Ice.Object servant, LocalObject cookie) {
        block17: {
            if (!$assertionsDisabled && servant == null) {
                throw new AssertionError();
            }
            this._deactivateController.lock();
            try {
                LocalObjectImpl localObjectImpl;
                if (cookie == null) break block17;
                EvictorElement element = (EvictorElement)cookie;
                boolean enqueue = false;
                if (current.mode != OperationMode.Nonmutating) {
                    localObjectImpl = element;
                    synchronized (localObjectImpl) {
                        if (element.status == 0) {
                            element.status = (byte)2;
                            enqueue = true;
                        }
                    }
                }
                localObjectImpl = this;
                synchronized (localObjectImpl) {
                    if (!$assertionsDisabled && element.stale) {
                        throw new AssertionError();
                    }
                    if (!$assertionsDisabled && element.usageCount < 1) {
                        throw new AssertionError();
                    }
                    --element.usageCount;
                    if (enqueue) {
                        this.addToModifiedQueue(element);
                    } else if (element.usageCount == 0 && element.keepCount == 0) {
                        this.evict();
                    }
                }
            }
            finally {
                this._deactivateController.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deactivate(String category) {
        if (this._deactivateController.deactivate()) {
            try {
                EvictorI evictorI = this;
                synchronized (evictorI) {
                    this.saveNowNoSync();
                    this._evictorSize = 0;
                    this.evict();
                    this._savingThreadDone = true;
                    this.notifyAll();
                }
                while (true) {
                    try {
                        this._thread.join();
                    }
                    catch (InterruptedException ex) {
                        continue;
                    }
                    break;
                }
                if (this._watchDogThread != null) {
                    this._watchDogThread.terminate();
                    while (true) {
                        try {
                            this._watchDogThread.join();
                        }
                        catch (InterruptedException ex) {
                            continue;
                        }
                        break;
                    }
                }
                Iterator p = this._storeMap.values().iterator();
                while (p.hasNext()) {
                    ObjectStore store = (ObjectStore)p.next();
                    store.close();
                }
                if (this._dbEnvHolder != null) {
                    this._dbEnvHolder.close();
                    this._dbEnvHolder = null;
                }
                this._dbEnv = null;
            }
            finally {
                this._deactivateController.deactivationComplete();
            }
        }
    }

    void initialize(Identity ident, String facet, Ice.Object servant) {
        if (this._initializer != null) {
            this._initializer.initialize(this._adapter, ident, facet, servant);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        try {
            while (true) {
                boolean tryAgain;
                int txSize;
                List allObjects;
                java.util.LinkedList<EvictorElement> deadObjects = new java.util.LinkedList<EvictorElement>();
                int saveNowThreadsSize = 0;
                EvictorI evictorI = this;
                synchronized (evictorI) {
                    while (!(this._savingThreadDone || this._saveNowThreads.size() != 0 || this._saveSizeTrigger >= 0 && this._modifiedQueue.size() >= this._saveSizeTrigger)) {
                        try {
                            if (this._savePeriod == 0L) {
                                this.wait();
                                continue;
                            }
                            long preSave = System.currentTimeMillis();
                            this.wait(this._savePeriod);
                            if (System.currentTimeMillis() <= preSave + this._savePeriod) continue;
                            break;
                        }
                        catch (InterruptedException ex) {
                        }
                    }
                    saveNowThreadsSize = this._saveNowThreads.size();
                    if (this._savingThreadDone) {
                        if (!$assertionsDisabled && this._modifiedQueue.size() != 0) {
                            throw new AssertionError();
                        }
                        if ($assertionsDisabled) return;
                        if (saveNowThreadsSize == 0) return;
                        throw new AssertionError();
                    }
                    if (this._modifiedQueue.size() == 0) {
                        if (saveNowThreadsSize > 0) {
                            this._saveNowThreads.clear();
                            this.notifyAll();
                        }
                        continue;
                    }
                    allObjects = this._modifiedQueue;
                    this._modifiedQueue = new ArrayList();
                }
                int size = allObjects.size();
                ArrayList<StreamedObject> streamedObjectQueue = new ArrayList<StreamedObject>();
                long streamStart = System.currentTimeMillis();
                int i = 0;
                while (true) {
                    boolean tryAgain2;
                    if (i >= size) {
                        if (this._trace >= 1) {
                            long now = System.currentTimeMillis();
                            this._communicator.getLogger().trace("Freeze.Evictor", "streamed " + streamedObjectQueue.size() + " objects in " + (now - streamStart) + " ms");
                        }
                        if ((txSize = streamedObjectQueue.size()) <= this._maxTxSize) break;
                        txSize = this._maxTxSize;
                        break;
                    }
                    EvictorElement element = (EvictorElement)allObjects.get(i);
                    do {
                        tryAgain2 = false;
                        Ice.Object servant = null;
                        Object object = element;
                        synchronized (object) {
                            byte status = element.status;
                            switch (status) {
                                case 1: 
                                case 2: {
                                    servant = element.rec.servant;
                                    break;
                                }
                                case 3: {
                                    streamedObjectQueue.add(this.stream(element, streamStart));
                                    element.status = (byte)4;
                                    deadObjects.add(element);
                                    break;
                                }
                                case 4: {
                                    deadObjects.add(element);
                                    break;
                                }
                            }
                            if (servant == null) continue;
                        }
                        if (this._watchDogThread != null) {
                            this._watchDogThread.activate();
                        }
                        object = servant;
                        synchronized (object) {
                            if (this._watchDogThread != null) {
                                this._watchDogThread.deactivate();
                            }
                            EvictorElement status = element;
                            synchronized (status) {
                                byte status2 = element.status;
                                switch (status2) {
                                    case 1: 
                                    case 2: {
                                        if (servant == element.rec.servant) {
                                            streamedObjectQueue.add(this.stream(element, streamStart));
                                            element.status = 0;
                                            break;
                                        }
                                        tryAgain2 = true;
                                        break;
                                    }
                                    case 3: {
                                        streamedObjectQueue.add(this.stream(element, streamStart));
                                        element.status = (byte)4;
                                        deadObjects.add(element);
                                        break;
                                    }
                                    case 4: {
                                        deadObjects.add(element);
                                        break;
                                    }
                                }
                            }
                        }
                    } while (tryAgain2);
                    ++i;
                }
                do {
                    tryAgain = false;
                    while (streamedObjectQueue.size() > 0) {
                        if (txSize > streamedObjectQueue.size()) {
                            txSize = streamedObjectQueue.size();
                        }
                        long saveStart = System.currentTimeMillis();
                        try {
                            DbTxn tx = this._dbEnv.txn_begin(null, 0);
                            try {
                                for (int i2 = 0; i2 < txSize; ++i2) {
                                    StreamedObject obj = (StreamedObject)streamedObjectQueue.get(i2);
                                    obj.store.save(obj.key, obj.value, obj.status, tx);
                                }
                                DbTxn toCommit = tx;
                                tx = null;
                                toCommit.commit(0);
                            }
                            finally {
                                if (tx != null) {
                                    tx.abort();
                                }
                            }
                            for (int i3 = 0; i3 < txSize; ++i3) {
                                streamedObjectQueue.remove(0);
                            }
                            if (this._trace < 1) continue;
                            long now = System.currentTimeMillis();
                            this._communicator.getLogger().trace("Freeze.Evictor", "saved " + txSize + " objects in " + (now - saveStart) + " ms");
                        }
                        catch (DbDeadlockException deadlock) {
                            if (this._deadlockWarning) {
                                this._communicator.getLogger().warning("Deadlock in Freeze.EvictorI.run while writing into Db \"" + this._filename + "\"; retrying ...");
                            }
                            tryAgain = true;
                            txSize = (txSize + 1) / 2;
                        }
                        catch (DbException dx) {
                            DatabaseException ex = new DatabaseException();
                            ex.initCause(dx);
                            ex.message = this._errorPrefix + "saving: " + dx.getMessage();
                            throw ex;
                        }
                    }
                } while (tryAgain);
                EvictorI evictorI2 = this;
                synchronized (evictorI2) {
                    EvictorElement element;
                    for (int i4 = 0; i4 < allObjects.size(); --element.usageCount, ++i4) {
                        element = (EvictorElement)allObjects.get(i4);
                        if (!$assertionsDisabled && element.usageCount <= 0) {
                            throw new AssertionError();
                        }
                    }
                    allObjects.clear();
                    Iterator p = deadObjects.iterator();
                    while (p.hasNext()) {
                        element = (EvictorElement)p.next();
                        if (element.stale || element.usageCount != 0 || element.keepCount != 0) continue;
                        EvictorElement evictorElement = element;
                        synchronized (evictorElement) {
                            if (element.status == 4) {
                                this.evict(element);
                            }
                        }
                    }
                    deadObjects.clear();
                    this.evict();
                    if (saveNowThreadsSize > 0) {
                        for (int i5 = 0; i5 < saveNowThreadsSize; ++i5) {
                            this._saveNowThreads.remove(0);
                        }
                        this.notifyAll();
                    }
                }
            }
        }
        catch (RuntimeException ex) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            ex.printStackTrace(pw);
            pw.flush();
            this._communicator.getLogger().error(this._errorPrefix + "Fatal error in saving thread:\n" + sw.toString());
            Util.handleFatalError(this, this._communicator, ex);
        }
    }

    final DeactivateController deactivateController() {
        return this._deactivateController;
    }

    final Communicator communicator() {
        return this._communicator;
    }

    final DbEnv dbEnv() {
        return this._dbEnv;
    }

    final String filename() {
        return this._filename;
    }

    final String errorPrefix() {
        return this._errorPrefix;
    }

    final boolean deadlockWarning() {
        return this._deadlockWarning;
    }

    synchronized void saveNow() {
        this.saveNowNoSync();
    }

    private void saveNowNoSync() {
        Thread myself = Thread.currentThread();
        this._saveNowThreads.add(myself);
        this.notifyAll();
        do {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } while (this._saveNowThreads.contains(myself));
    }

    private void evict() {
        if (!$assertionsDisabled && !Thread.holdsLock(this)) {
            throw new AssertionError();
        }
        Iterator p = this._evictorList.riterator();
        while (p.hasNext() && this._currentEvictorSize > this._evictorSize) {
            EvictorElement element = (EvictorElement)p.next();
            if (element.usageCount != 0) continue;
            if (!$assertionsDisabled && element.stale) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && element.keepCount != 0) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && element.evictPosition == null) {
                throw new AssertionError();
            }
            if (this._trace >= 2 || this._trace >= 1 && this._evictorList.size() % 50 == 0) {
                String objString = "object \"" + Ice.Util.identityToString(element.identity) + "\"";
                String facet = element.store.facet();
                if (facet.length() > 0) {
                    objString = objString + " with facet \"" + facet + "\"";
                }
                this._communicator.getLogger().trace("Freeze.Evictor", "evicting " + objString + " from the queue; " + "number of elements in the queue: " + this._currentEvictorSize);
            }
            element.stale = true;
            element.store.cache().unpin(element.identity);
            p.remove();
            element.evictPosition = null;
            --this._currentEvictorSize;
        }
    }

    private void fixEvictPosition(EvictorElement element) {
        if (!$assertionsDisabled && !Thread.holdsLock(this)) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && element.stale) {
            throw new AssertionError();
        }
        if (element.keepCount == 0) {
            if (element.usageCount < 0) {
                if (!$assertionsDisabled && element.evictPosition != null) {
                    throw new AssertionError();
                }
                element.usageCount = 0;
                ++this._currentEvictorSize;
            } else {
                if (!$assertionsDisabled && element.evictPosition == null) {
                    throw new AssertionError();
                }
                element.evictPosition.remove();
            }
            this._evictorList.addFirst(element);
            element.evictPosition = this._evictorList.iterator();
            element.evictPosition.next();
        }
    }

    private void evict(EvictorElement element) {
        if (!$assertionsDisabled && !Thread.holdsLock(this)) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && element.stale) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && element.keepCount != 0) {
            throw new AssertionError();
        }
        element.evictPosition.remove();
        --this._currentEvictorSize;
        element.stale = true;
        element.store.cache().unpin(element.identity);
    }

    private void addToModifiedQueue(EvictorElement element) {
        if (!$assertionsDisabled && !Thread.holdsLock(this)) {
            throw new AssertionError();
        }
        ++element.usageCount;
        this._modifiedQueue.add(element);
        if (this._saveSizeTrigger >= 0 && this._modifiedQueue.size() >= this._saveSizeTrigger) {
            this.notifyAll();
        }
    }

    private StreamedObject stream(EvictorElement element, long streamStart) {
        if (!$assertionsDisabled && !Thread.holdsLock(element)) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && element.status == 4) {
            throw new AssertionError();
        }
        StreamedObject obj = new StreamedObject();
        obj.status = element.status;
        obj.store = element.store;
        obj.key = ObjectStore.marshalKey(element.identity, this._communicator);
        if (element.status != 3) {
            Statistics stats = element.rec.stats;
            long diff = streamStart - (stats.creationTime + stats.lastSaveTime);
            if (stats.lastSaveTime == 0L) {
                stats.lastSaveTime = diff;
                stats.avgSaveTime = diff;
            } else {
                stats.lastSaveTime = streamStart - stats.creationTime;
                stats.avgSaveTime = (long)((double)stats.avgSaveTime * 0.95 + (double)diff * 0.05);
            }
            obj.value = ObjectStore.marshalValue(element.rec, this._communicator);
        }
        return obj;
    }

    private synchronized ObjectStore findStore(String facet) {
        return (ObjectStore)this._storeMap.get(facet);
    }

    /*
     * Loose catch block
     */
    private List allDbs() {
        java.util.LinkedList<String> result;
        block22: {
            DbException dx222;
            Dbc dbc;
            Db db;
            block20: {
                result = new java.util.LinkedList<String>();
                db = null;
                dbc = null;
                db = new Db(this._dbEnv, 0);
                db.open(null, this._filename, null, 5, Db.DB_RDONLY, 0);
                dbc = db.cursor(null, 0);
                Dbt key = new Dbt();
                key.set_flags(Db.DB_DBT_MALLOC);
                Dbt value = new Dbt();
                value.set_flags(Db.DB_DBT_MALLOC);
                boolean more = true;
                while (more) {
                    String dbName;
                    more = dbc.get(key, value, Db.DB_NEXT) == 0;
                    if (!more || (dbName = new String(key.get_data(), 0, key.get_size(), "UTF8")).startsWith(indexPrefix)) continue;
                    result.add(dbName);
                }
                dbc.close();
                dbc = null;
                db.close(0);
                db = null;
                Object var9_13 = null;
                if (dbc == null) break block20;
                try {
                    dbc.close();
                }
                catch (DbException dx222) {
                    // empty catch block
                }
            }
            if (db != null) {
                try {
                    db.close(0);
                }
                catch (DbException dx222) {}
            }
            break block22;
            {
                catch (UnsupportedEncodingException ix) {
                    DatabaseException ex = new DatabaseException();
                    ex.initCause(ix);
                    ex.message = this._errorPrefix + "cannot decode database names";
                    throw ex;
                }
                catch (FileNotFoundException ix) {
                    DbException dx222;
                    Object var9_14 = null;
                    if (dbc != null) {
                        try {
                            dbc.close();
                        }
                        catch (DbException dx222) {
                            // empty catch block
                        }
                    }
                    if (db != null) {
                        try {
                            db.close(0);
                        }
                        catch (DbException dx222) {}
                    }
                    break block22;
                }
                catch (DbException dx3) {
                    DatabaseException ex = new DatabaseException();
                    ex.initCause(dx3);
                    ex.message = this._errorPrefix + "Db.open: " + dx3.getMessage();
                    throw ex;
                }
            }
            catch (Throwable throwable) {
                DbException dx222;
                Object var9_15 = null;
                if (dbc != null) {
                    try {
                        dbc.close();
                    }
                    catch (DbException dx222) {
                        // empty catch block
                    }
                }
                if (db != null) {
                    try {
                        db.close(0);
                    }
                    catch (DbException dx222) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
        return result;
    }

    private static void checkIdentity(Identity ident) {
        if (ident.name == null || ident.name.length() == 0) {
            IllegalIdentityException e;
            block3: {
                e = new IllegalIdentityException();
                try {
                    e.id = (Identity)ident.clone();
                }
                catch (CloneNotSupportedException ex) {
                    if ($assertionsDisabled) break block3;
                    throw new AssertionError();
                }
            }
            throw e;
        }
    }

    static {
        $assertionsDisabled = !EvictorI.class.desiredAssertionStatus();
    }

    static class StreamedObject {
        byte[] key = null;
        byte[] value = null;
        byte status = (byte)4;
        ObjectStore store = null;

        StreamedObject() {
        }
    }

    class DeactivateController {
        private boolean _deactivating = false;
        private boolean _deactivated = false;
        private int _guardCount = 0;

        DeactivateController() {
        }

        synchronized void lock() {
            if (this._deactivated || this._deactivating) {
                throw new EvictorDeactivatedException();
            }
            ++this._guardCount;
        }

        synchronized void unlock() {
            --this._guardCount;
            if (this._deactivating && this._guardCount == 0) {
                this.notifyAll();
            }
        }

        synchronized boolean deactivated() {
            return this._deactivated || this._deactivating;
        }

        synchronized boolean deactivate() {
            if (this._deactivated) {
                return false;
            }
            if (this._deactivating) {
                while (!this._deactivated) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {}
                }
                return false;
            }
            this._deactivating = true;
            while (this._guardCount > 0) {
                if (EvictorI.this._trace >= 1) {
                    EvictorI.this._communicator.getLogger().trace("Freeze.Evictor", "*** Waiting for " + this._guardCount + " threads to complete before starting deactivation.");
                }
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            if (EvictorI.this._trace >= 1) {
                EvictorI.this._communicator.getLogger().trace("Freeze.Evictor", "Starting deactivation.");
            }
            return true;
        }

        synchronized void deactivationComplete() {
            if (EvictorI.this._trace >= 1) {
                EvictorI.this._communicator.getLogger().trace("Freeze.Evictor", "Deactivation complete.");
            }
            this._deactivated = true;
            this._deactivating = false;
            this.notifyAll();
        }
    }

    class WatchDogThread
    extends Thread {
        private final long _timeout;
        private boolean _done;
        private boolean _active;
        static final /* synthetic */ boolean $assertionsDisabled;

        WatchDogThread(long timeout, String name) {
            super(name);
            this._done = false;
            this._active = false;
            this._timeout = timeout;
            if (!$assertionsDisabled && timeout <= 0L) {
                throw new AssertionError();
            }
        }

        public synchronized void run() {
            while (!this._done) {
                long startTime = 0L;
                try {
                    if (this._active) {
                        startTime = System.currentTimeMillis();
                        this.wait(this._timeout);
                    } else {
                        this.wait();
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (this._done || !this._active || startTime <= 0L || System.currentTimeMillis() - startTime < this._timeout) continue;
                EvictorI.this._communicator.getLogger().error(EvictorI.this._errorPrefix + "Fatal error: streaming watch dog thread timed out.");
                Util.handleFatalError(EvictorI.this, EvictorI.this._communicator, null);
            }
        }

        synchronized void activate() {
            this._active = true;
            this.notify();
        }

        synchronized void deactivate() {
            this._active = false;
            this.notify();
        }

        synchronized void terminate() {
            this._done = true;
            this.notify();
        }

        static {
            $assertionsDisabled = !(class$Freeze$EvictorI == null ? (class$Freeze$EvictorI = EvictorI.class$("Freeze.EvictorI")) : class$Freeze$EvictorI).desiredAssertionStatus();
        }
    }
}

