/*
 * Decompiled with CFR 0.152.
 */
package Freeze;

import Freeze.ConnectionI;
import Freeze.DatabaseException;
import Freeze.NotFoundException;
import Ice.Communicator;
import com.sleepycat.db.Db;
import com.sleepycat.db.DbException;
import java.io.FileNotFoundException;
import java.util.HashMap;
import java.util.Map;

class SharedDb
extends Db {
    private MapKey _key;
    private int _refCount = 0;
    private int _trace;
    private static Map _map;
    static final /* synthetic */ boolean $assertionsDisabled;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SharedDb get(ConnectionI connection, String dbName, boolean createDb) {
        MapKey key = new MapKey(connection.envName(), connection.communicator(), dbName);
        Map map = _map;
        synchronized (map) {
            SharedDb result = (SharedDb)((Object)_map.get(key));
            if (result == null) {
                try {
                    result = new SharedDb(key, connection, createDb);
                }
                catch (DbException dx) {
                    DatabaseException ex = new DatabaseException();
                    ex.initCause(dx);
                    ex.message = SharedDb.errorPrefix(key) + "creation: " + dx.getMessage();
                    throw ex;
                }
                SharedDb previousValue = _map.put(key, result);
                if (!$assertionsDisabled && previousValue != null) {
                    throw new AssertionError();
                }
            } else {
                ++result._refCount;
            }
            return result;
        }
    }

    public String dbName() {
        return this._key.dbName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Map map = _map;
        synchronized (map) {
            if (--this._refCount == 0) {
                Object value = _map.remove(this._key);
                if (!$assertionsDisabled && value != this) {
                    throw new AssertionError();
                }
                if (this._trace >= 1) {
                    this._key.communicator.getLogger().trace("Freeze.Map", "closing Db \"" + this._key.dbName + "\"");
                }
                try {
                    super.close(0);
                }
                catch (DbException dx) {
                    DatabaseException ex = new DatabaseException();
                    ex.initCause(dx);
                    ex.message = SharedDb.errorPrefix(this._key) + "close: " + dx.getMessage();
                    throw ex;
                }
            }
        }
    }

    protected void finalize() {
        if (!$assertionsDisabled && this._refCount != 0) {
            throw new AssertionError();
        }
    }

    private SharedDb(MapKey key, ConnectionI connection, boolean createDb) throws DbException {
        super(connection.dbEnv(), 0);
        this._key = key;
        this._trace = connection.trace();
        try {
            int flags = Db.DB_AUTO_COMMIT;
            if (createDb) {
                flags |= Db.DB_CREATE;
            }
            this.open(null, key.dbName, null, 1, flags, 0);
        }
        catch (FileNotFoundException dx) {
            NotFoundException ex = new NotFoundException();
            ex.initCause(dx);
            ex.message = SharedDb.errorPrefix(this._key) + "Db.open: " + dx.getMessage();
            throw ex;
        }
        catch (DbException dx) {
            DatabaseException ex = new DatabaseException();
            ex.initCause(dx);
            ex.message = SharedDb.errorPrefix(this._key) + "Db.open: " + dx.getMessage();
            throw ex;
        }
        this._refCount = 1;
    }

    private static String errorPrefix(MapKey k) {
        return "Freeze DB DbEnv(\"" + k.envName + "\") Db(\"" + k.dbName + "\") :";
    }

    static {
        $assertionsDisabled = !SharedDb.class.desiredAssertionStatus();
        _map = new HashMap();
    }

    private static class MapKey {
        final String envName;
        final Communicator communicator;
        final String dbName;

        MapKey(String envName, Communicator communicator, String dbName) {
            this.envName = envName;
            this.communicator = communicator;
            this.dbName = dbName;
        }

        public boolean equals(Object o) {
            try {
                MapKey k = (MapKey)o;
                return this.dbName.equals(k.dbName) && this.communicator == k.communicator && this.envName.equals(k.envName);
            }
            catch (ClassCastException ex) {
                this.communicator.getLogger().trace("Freeze.Map", "equals cast failed");
                return false;
            }
        }

        public int hashCode() {
            return this.dbName.hashCode() ^ this.envName.hashCode() ^ this.communicator.hashCode();
        }
    }
}

