/*
 * Decompiled with CFR 0.152.
 */
package Ice;

import Ice.AdapterAlreadyActiveException;
import Ice.AdapterNotFoundException;
import Ice.Communicator;
import Ice.Current;
import Ice.Identity;
import Ice.IllegalIdentityException;
import Ice.LocalException;
import Ice.LocalObjectImpl;
import Ice.LocatorPrx;
import Ice.LocatorPrxHelper;
import Ice.LocatorRegistryPrx;
import Ice.Logger;
import Ice.NotRegisteredException;
import Ice.Object;
import Ice.ObjectAdapter;
import Ice.ObjectAdapterDeactivatedException;
import Ice.ObjectAdapterIdInUseException;
import Ice.ObjectPrx;
import Ice.ObjectPrxHelperBase;
import Ice.ProcessPrx;
import Ice.ProcessPrxHelper;
import Ice.RouterPrx;
import Ice.RouterPrxHelper;
import Ice.ServantLocator;
import Ice.ServerNotFoundException;
import Ice.Util;
import Ice._ProcessDisp;
import IceInternal.Connection;
import IceInternal.Endpoint;
import IceInternal.IncomingConnectionFactory;
import IceInternal.Instance;
import IceInternal.LocatorInfo;
import IceInternal.Reference;
import IceInternal.RouterInfo;
import IceInternal.ServantManager;
import IceInternal.ThreadPool;
import IceUtil.StringUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public final class ObjectAdapterI
extends LocalObjectImpl
implements ObjectAdapter {
    private boolean _deactivated = false;
    private Instance _instance;
    private Communicator _communicator;
    private ThreadPool _threadPool;
    private ServantManager _servantManager;
    private boolean _printAdapterReadyDone;
    private final String _name;
    private final String _id;
    private Logger _logger;
    private ArrayList _incomingConnectionFactories = new ArrayList();
    private ArrayList _routerEndpoints = new ArrayList();
    private LocatorInfo _locatorInfo;
    private int _directCount;
    private boolean _waitForDeactivate;
    static final /* synthetic */ boolean $assertionsDisabled;

    public String getName() {
        return this._name;
    }

    public synchronized Communicator getCommunicator() {
        this.checkForDeactivation();
        return this._communicator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void activate() {
        LocatorRegistryPrx locatorRegistry = null;
        boolean registerProcess = false;
        String serverId = "";
        Communicator communicator = null;
        boolean printAdapterReady = false;
        ObjectAdapterI objectAdapterI = this;
        synchronized (objectAdapterI) {
            this.checkForDeactivation();
            if (!this._printAdapterReadyDone) {
                if (this._locatorInfo != null && this._id.length() > 0) {
                    locatorRegistry = this._locatorInfo.getLocatorRegistry();
                }
                registerProcess = this._instance.properties().getPropertyAsInt(this._name + ".RegisterProcess") > 0;
                serverId = this._instance.properties().getProperty("Ice.ServerId");
                boolean bl = printAdapterReady = this._instance.properties().getPropertyAsInt("Ice.PrintAdapterReady") > 0;
                if (registerProcess && locatorRegistry == null) {
                    this._instance.logger().warning("object adapter `" + this._name + "' cannot register the process " + "without a locator registry");
                    registerProcess = false;
                } else if (registerProcess && serverId.length() == 0) {
                    this._instance.logger().warning("object adapter `" + this._name + "' cannot register the process " + "without a value for Ice.ServerId");
                    registerProcess = false;
                }
                communicator = this._communicator;
                this._printAdapterReadyDone = true;
            }
            int sz = this._incomingConnectionFactories.size();
            for (int i = 0; i < sz; ++i) {
                IncomingConnectionFactory factory = (IncomingConnectionFactory)this._incomingConnectionFactories.get(i);
                factory.activate();
            }
        }
        if (locatorRegistry != null) {
            try {
                Identity ident = new Identity();
                ident.category = "";
                ident.name = "dummy";
                locatorRegistry.setAdapterDirectProxy(this._id, this.newDirectProxy(ident));
            }
            catch (AdapterNotFoundException ex) {
                NotRegisteredException ex1 = new NotRegisteredException();
                ex1.id = this._id;
                ex1.kindOfObject = "object adapter";
                throw ex1;
            }
            catch (AdapterAlreadyActiveException ex) {
                ObjectAdapterIdInUseException ex1 = new ObjectAdapterIdInUseException();
                ex1.id = this._id;
                throw ex1;
            }
            if (registerProcess) {
                ProcessI servant = new ProcessI(communicator);
                ProcessPrx proxy = ProcessPrxHelper.uncheckedCast(this.addWithUUID(servant));
                try {
                    locatorRegistry.setServerProcessProxy(serverId, proxy);
                }
                catch (ServerNotFoundException ex) {
                    NotRegisteredException ex1 = new NotRegisteredException();
                    ex1.id = serverId;
                    ex1.kindOfObject = "server";
                    throw ex1;
                }
            }
        }
        if (printAdapterReady) {
            System.out.println(this._name + " ready");
        }
    }

    public synchronized void hold() {
        this.checkForDeactivation();
        int sz = this._incomingConnectionFactories.size();
        for (int i = 0; i < sz; ++i) {
            IncomingConnectionFactory factory = (IncomingConnectionFactory)this._incomingConnectionFactories.get(i);
            factory.hold();
        }
    }

    public synchronized void waitForHold() {
        this.checkForDeactivation();
        int sz = this._incomingConnectionFactories.size();
        for (int i = 0; i < sz; ++i) {
            IncomingConnectionFactory factory = (IncomingConnectionFactory)this._incomingConnectionFactories.get(i);
            factory.waitUntilHolding();
        }
    }

    public synchronized void deactivate() {
        if (this._deactivated) {
            return;
        }
        int sz = this._incomingConnectionFactories.size();
        for (int i = 0; i < sz; ++i) {
            IncomingConnectionFactory factory = (IncomingConnectionFactory)this._incomingConnectionFactories.get(i);
            factory.destroy();
        }
        this._instance.outgoingConnectionFactory().removeAdapter(this);
        this._deactivated = true;
        this.notifyAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForDeactivate() {
        ObjectAdapterI objectAdapterI = this;
        synchronized (objectAdapterI) {
            while (!this._deactivated || this._directCount > 0) {
                try {
                    this.wait();
                }
                catch (InterruptedException ex) {}
            }
            while (this._waitForDeactivate) {
                try {
                    this.wait();
                }
                catch (InterruptedException ex) {}
            }
            this._waitForDeactivate = true;
        }
        int sz = this._incomingConnectionFactories.size();
        for (int i = 0; i < sz; ++i) {
            IncomingConnectionFactory factory = (IncomingConnectionFactory)this._incomingConnectionFactories.get(i);
            factory.waitUntilFinished();
        }
        if (this._servantManager != null) {
            this._servantManager.destroy();
        }
        if (this._threadPool != null) {
            this._threadPool.destroy();
            this._threadPool.joinWithAllThreads();
        }
        ObjectAdapterI objectAdapterI2 = this;
        synchronized (objectAdapterI2) {
            this._waitForDeactivate = false;
            this.notifyAll();
            this._incomingConnectionFactories.clear();
            this._instance = null;
            this._threadPool = null;
            this._servantManager = null;
            this._communicator = null;
        }
    }

    public ObjectPrx add(Object object, Identity ident) {
        return this.addFacet(object, ident, "");
    }

    public synchronized ObjectPrx addFacet(Object object, Identity ident, String facet) {
        this.checkForDeactivation();
        ObjectAdapterI.checkIdentity(ident);
        Identity id = new Identity();
        id.category = ident.category;
        id.name = ident.name;
        this._servantManager.addServant(object, id, facet);
        return this.newProxy(id);
    }

    public ObjectPrx addWithUUID(Object object) {
        return this.addFacetWithUUID(object, "");
    }

    public ObjectPrx addFacetWithUUID(Object object, String facet) {
        Identity ident = new Identity();
        ident.category = "";
        ident.name = Util.generateUUID();
        return this.addFacet(object, ident, facet);
    }

    public Object remove(Identity ident) {
        return this.removeFacet(ident, "");
    }

    public synchronized Object removeFacet(Identity ident, String facet) {
        this.checkForDeactivation();
        ObjectAdapterI.checkIdentity(ident);
        return this._servantManager.removeServant(ident, facet);
    }

    public synchronized Map removeAllFacets(Identity ident) {
        this.checkForDeactivation();
        ObjectAdapterI.checkIdentity(ident);
        return this._servantManager.removeAllFacets(ident);
    }

    public Object find(Identity ident) {
        return this.findFacet(ident, "");
    }

    public synchronized Object findFacet(Identity ident, String facet) {
        this.checkForDeactivation();
        ObjectAdapterI.checkIdentity(ident);
        return this._servantManager.findServant(ident, facet);
    }

    public synchronized Map findAllFacets(Identity ident) {
        this.checkForDeactivation();
        ObjectAdapterI.checkIdentity(ident);
        return this._servantManager.findAllFacets(ident);
    }

    public synchronized Object findByProxy(ObjectPrx proxy) {
        this.checkForDeactivation();
        Reference ref = ((ObjectPrxHelperBase)proxy).__reference();
        return this.findFacet(ref.identity, ref.facet);
    }

    public synchronized void addServantLocator(ServantLocator locator, String prefix) {
        this.checkForDeactivation();
        this._servantManager.addServantLocator(locator, prefix);
    }

    public synchronized ServantLocator findServantLocator(String prefix) {
        this.checkForDeactivation();
        return this._servantManager.findServantLocator(prefix);
    }

    public synchronized ObjectPrx createProxy(Identity ident) {
        this.checkForDeactivation();
        ObjectAdapterI.checkIdentity(ident);
        return this.newProxy(ident);
    }

    public synchronized ObjectPrx createDirectProxy(Identity ident) {
        this.checkForDeactivation();
        ObjectAdapterI.checkIdentity(ident);
        return this.newDirectProxy(ident);
    }

    public synchronized ObjectPrx createReverseProxy(Identity ident) {
        this.checkForDeactivation();
        ObjectAdapterI.checkIdentity(ident);
        Endpoint[] endpoints = new Endpoint[]{};
        Reference ref = this._instance.referenceFactory().create(ident, new HashMap(), "", 0, false, "", endpoints, null, null, this, true);
        return this._instance.proxyFactory().referenceToProxy(ref);
    }

    public synchronized void addRouter(RouterPrx router) {
        this.checkForDeactivation();
        RouterInfo routerInfo = this._instance.routerManager().get(router);
        if (routerInfo != null) {
            int i;
            ObjectPrxHelperBase proxy = (ObjectPrxHelperBase)routerInfo.getServerProxy();
            Endpoint[] endpoints = proxy.__reference().endpoints;
            for (i = 0; i < endpoints.length; ++i) {
                this._routerEndpoints.add(endpoints[i]);
            }
            Collections.sort(this._routerEndpoints);
            for (i = 0; i < this._routerEndpoints.size() - 1; ++i) {
                java.lang.Object o2;
                java.lang.Object o1 = this._routerEndpoints.get(i);
                if (!o1.equals(o2 = this._routerEndpoints.get(i + 1))) continue;
                this._routerEndpoints.remove(i);
            }
            routerInfo.setAdapter(this);
            this._instance.outgoingConnectionFactory().setRouter(routerInfo.getRouter());
        }
    }

    public synchronized void setLocator(LocatorPrx locator) {
        this.checkForDeactivation();
        this._locatorInfo = this._instance.locatorManager().get(locator);
    }

    public synchronized LocatorPrx getLocator() {
        this.checkForDeactivation();
        LocatorPrx locator = null;
        if (this._locatorInfo != null) {
            locator = this._locatorInfo.getLocator();
        }
        return locator;
    }

    public synchronized boolean isLocal(ObjectPrx proxy) {
        int i;
        this.checkForDeactivation();
        Reference ref = ((ObjectPrxHelperBase)proxy).__reference();
        Endpoint[] endpoints = ref.endpoints;
        if (!ref.adapterId.equals("")) {
            return ref.adapterId.equals(this._id);
        }
        for (i = 0; i < endpoints.length; ++i) {
            int sz = this._incomingConnectionFactories.size();
            for (int j = 0; j < sz; ++j) {
                IncomingConnectionFactory factory = (IncomingConnectionFactory)this._incomingConnectionFactories.get(j);
                if (!factory.equivalent(endpoints[i])) continue;
                return true;
            }
        }
        for (i = 0; i < endpoints.length; ++i) {
            if (Collections.binarySearch(this._routerEndpoints, endpoints[i]) < 0) continue;
            return true;
        }
        return false;
    }

    public synchronized Connection[] getIncomingConnections() {
        this.checkForDeactivation();
        ArrayList<Connection> connections = new ArrayList<Connection>();
        int sz = this._incomingConnectionFactories.size();
        for (int i = 0; i < sz; ++i) {
            IncomingConnectionFactory factory = (IncomingConnectionFactory)this._incomingConnectionFactories.get(i);
            Connection[] cons = factory.connections();
            for (int j = 0; j < cons.length; ++j) {
                connections.add(cons[j]);
            }
        }
        Connection[] arr = new Connection[connections.size()];
        connections.toArray(arr);
        return arr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushBatchRequests() {
        ArrayList f;
        ObjectAdapterI objectAdapterI = this;
        synchronized (objectAdapterI) {
            f = new ArrayList(this._incomingConnectionFactories);
        }
        Iterator i = f.iterator();
        while (i.hasNext()) {
            ((IncomingConnectionFactory)i.next()).flushBatchRequests();
        }
    }

    public synchronized void incDirectCount() {
        this.checkForDeactivation();
        if (!$assertionsDisabled && this._directCount < 0) {
            throw new AssertionError();
        }
        ++this._directCount;
    }

    public synchronized void decDirectCount() {
        if (!$assertionsDisabled && this._instance == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this._directCount <= 0) {
            throw new AssertionError();
        }
        if (--this._directCount == 0) {
            this.notifyAll();
        }
    }

    public ThreadPool getThreadPool() {
        if (!$assertionsDisabled && this._instance == null) {
            throw new AssertionError();
        }
        if (this._threadPool != null) {
            return this._threadPool;
        }
        return this._instance.serverThreadPool();
    }

    public ServantManager getServantManager() {
        if (!$assertionsDisabled && this._instance == null) {
            throw new AssertionError();
        }
        return this._servantManager;
    }

    public ObjectAdapterI(Instance instance, Communicator communicator, String name) {
        this._instance = instance;
        this._communicator = communicator;
        this._servantManager = new ServantManager(instance, name);
        this._printAdapterReadyDone = false;
        this._name = name;
        this._id = instance.properties().getProperty(name + ".AdapterId");
        this._logger = instance.logger();
        this._directCount = 0;
        this._waitForDeactivate = false;
        try {
            String locator;
            int beg;
            String endpts = this._instance.properties().getProperty(name + ".Endpoints").toLowerCase();
            int end = 0;
            String delim = " \t\n\r";
            while (end < endpts.length() && (beg = StringUtil.findFirstNotOf(endpts, " \t\n\r", end)) != -1) {
                end = endpts.indexOf(58, beg);
                if (end == -1) {
                    end = endpts.length();
                }
                if (end == beg) {
                    ++end;
                    continue;
                }
                String s = endpts.substring(beg, end);
                Endpoint endp = instance.endpointFactoryManager().create(s);
                this._incomingConnectionFactories.add(new IncomingConnectionFactory(instance, endp, this));
                ++end;
            }
            String router = this._instance.properties().getProperty(name + ".Router");
            if (router.length() > 0) {
                this.addRouter(RouterPrxHelper.uncheckedCast(this._instance.proxyFactory().stringToProxy(router)));
            }
            if ((locator = this._instance.properties().getProperty(name + ".Locator")).length() > 0) {
                this.setLocator(LocatorPrxHelper.uncheckedCast(this._instance.proxyFactory().stringToProxy(locator)));
            } else {
                this.setLocator(this._instance.referenceFactory().getDefaultLocator());
            }
            int size = this._instance.properties().getPropertyAsInt(this._name + ".ThreadPool.Size");
            int sizeMax = this._instance.properties().getPropertyAsInt(this._name + ".ThreadPool.SizeMax");
            if (size > 0 || sizeMax > 0) {
                this._threadPool = new ThreadPool(this._instance, this._name + ".ThreadPool", 0);
            }
        }
        catch (LocalException ex) {
            this.deactivate();
            this.waitForDeactivate();
            throw ex;
        }
    }

    protected void finalize() throws Throwable {
        if (!this._deactivated) {
            this._instance.logger().warning("object adapter `" + this._name + "' has not been deactivated");
        } else if (this._instance != null) {
            this._instance.logger().warning("object adapter `" + this._name + "' deactivation had not been waited for");
        } else {
            if (!$assertionsDisabled && this._threadPool != null) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && this._servantManager != null) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && this._communicator != null) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && !this._incomingConnectionFactories.isEmpty()) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && this._directCount != 0) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && this._waitForDeactivate) {
                throw new AssertionError();
            }
        }
        super.finalize();
    }

    private ObjectPrx newProxy(Identity ident) {
        if (this._id.length() == 0) {
            return this.newDirectProxy(ident);
        }
        Endpoint[] endpoints = new Endpoint[]{};
        Reference reference = this._instance.referenceFactory().create(ident, new HashMap(), "", 0, false, this._id, endpoints, null, this._locatorInfo, null, true);
        return this._instance.proxyFactory().referenceToProxy(reference);
    }

    private ObjectPrx newDirectProxy(Identity ident) {
        int i;
        Endpoint[] endpoints = new Endpoint[this._incomingConnectionFactories.size() + this._routerEndpoints.size()];
        int sz = this._incomingConnectionFactories.size();
        for (i = 0; i < sz; ++i) {
            IncomingConnectionFactory factory = (IncomingConnectionFactory)this._incomingConnectionFactories.get(i);
            endpoints[i] = factory.endpoint();
        }
        sz = this._routerEndpoints.size();
        for (i = 0; i < sz; ++i) {
            endpoints[this._incomingConnectionFactories.size() + i] = (Endpoint)this._routerEndpoints.get(i);
        }
        Reference reference = this._instance.referenceFactory().create(ident, new HashMap(), "", 0, false, "", endpoints, null, this._locatorInfo, null, true);
        return this._instance.proxyFactory().referenceToProxy(reference);
    }

    private void checkForDeactivation() {
        if (this._deactivated) {
            ObjectAdapterDeactivatedException ex = new ObjectAdapterDeactivatedException();
            ex.name = this._name;
            throw ex;
        }
    }

    private static void checkIdentity(Identity ident) {
        if (ident.name == null || ident.name.length() == 0) {
            IllegalIdentityException e;
            block4: {
                e = new IllegalIdentityException();
                try {
                    e.id = (Identity)ident.clone();
                }
                catch (CloneNotSupportedException ex) {
                    if ($assertionsDisabled) break block4;
                    throw new AssertionError();
                }
            }
            throw e;
        }
        if (ident.category == null) {
            ident.category = "";
        }
    }

    static {
        $assertionsDisabled = !ObjectAdapterI.class.desiredAssertionStatus();
    }

    private static class ProcessI
    extends _ProcessDisp {
        private Communicator _communicator;

        ProcessI(Communicator communicator) {
            this._communicator = communicator;
        }

        public void shutdown(Current current) {
            this._communicator.shutdown();
        }
    }
}

