/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.BadMagicException;
import Ice.CloseConnectionException;
import Ice.CloseTimeoutException;
import Ice.CommunicatorDestroyedException;
import Ice.CompressionNotSupportedException;
import Ice.ConnectionLostException;
import Ice.ConnectionNotValidatedException;
import Ice.ConnectionTimeoutException;
import Ice.IllegalMessageSizeException;
import Ice.LocalException;
import Ice.Logger;
import Ice.NegativeSizeException;
import Ice.ObjectAdapter;
import Ice.ObjectAdapterDeactivatedException;
import Ice.ObjectAdapterI;
import Ice.TimeoutException;
import Ice.UnknownException;
import Ice.UnknownMessageException;
import Ice.UnknownRequestIdException;
import Ice.UnsupportedEncodingException;
import Ice.UnsupportedProtocolException;
import IceInternal.BasicStream;
import IceInternal.ConnectionMonitor;
import IceInternal.Endpoint;
import IceInternal.EventHandler;
import IceInternal.Incoming;
import IceInternal.Instance;
import IceInternal.IntMap;
import IceInternal.Outgoing;
import IceInternal.OutgoingAsync;
import IceInternal.Protocol;
import IceInternal.ServantManager;
import IceInternal.ThreadPool;
import IceInternal.TraceLevels;
import IceInternal.TraceUtil;
import IceInternal.Transceiver;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Iterator;

public final class Connection
extends EventHandler {
    public static final int ObjectAdapterDeactivated = 0;
    public static final int CommunicatorDestroyed = 1;
    private static final byte[] _requestHdr;
    private static final byte[] _requestBatchHdr;
    private static final byte[] _replyHdr;
    private static final int StateNotValidated = 0;
    private static final int StateActive = 1;
    private static final int StateHolding = 2;
    private static final int StateClosing = 3;
    private static final int StateClosed = 4;
    private Transceiver _transceiver;
    private final String _desc;
    private final Endpoint _endpoint;
    private ObjectAdapter _adapter;
    private ServantManager _servantManager;
    private final Logger _logger;
    private final TraceLevels _traceLevels;
    private boolean _registeredWithPool;
    private final ThreadPool _threadPool;
    private final boolean _warn;
    private final int _acmTimeout;
    private long _acmAbsoluteTimeoutMillis;
    private int _nextRequestId;
    private IntMap _requests = new IntMap();
    private IntMap _asyncRequests = new IntMap();
    private LocalException _exception;
    private BasicStream _batchStream;
    private boolean _batchStreamInUse;
    private int _batchRequestNum;
    private int _dispatchCount;
    private int _state;
    private long _stateTime;
    private Object _sendMutex = new Object();
    private Incoming _incomingCache;
    private Object _incomingCacheMutex = new Object();
    static final /* synthetic */ boolean $assertionsDisabled;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void validate() {
        block16: {
            if (!$assertionsDisabled && this._state != 0) {
                throw new AssertionError();
            }
            if (!this._endpoint.datagram()) {
                try {
                    if (this._adapter != null) {
                        Object object = this._sendMutex;
                        synchronized (object) {
                            BasicStream os = new BasicStream(this._instance);
                            os.writeByte(Protocol.magic[0]);
                            os.writeByte(Protocol.magic[1]);
                            os.writeByte(Protocol.magic[2]);
                            os.writeByte(Protocol.magic[3]);
                            os.writeByte((byte)1);
                            os.writeByte((byte)0);
                            os.writeByte((byte)1);
                            os.writeByte((byte)0);
                            os.writeByte((byte)3);
                            os.writeByte((byte)0);
                            os.writeInt(14);
                            TraceUtil.traceHeader("sending validate connection", os, this._logger, this._traceLevels);
                            this._transceiver.write(os, this._endpoint.timeout());
                            break block16;
                        }
                    }
                    BasicStream is = new BasicStream(this._instance);
                    is.resize(14, true);
                    is.pos(0);
                    this._transceiver.read(is, this._endpoint.timeout());
                    int pos = is.pos();
                    if (!$assertionsDisabled && pos < 14) {
                        throw new AssertionError();
                    }
                    is.pos(0);
                    byte[] m = new byte[]{is.readByte(), is.readByte(), is.readByte(), is.readByte()};
                    if (m[0] != Protocol.magic[0] || m[1] != Protocol.magic[1] || m[2] != Protocol.magic[2] || m[3] != Protocol.magic[3]) {
                        BadMagicException ex = new BadMagicException();
                        ex.badMagic = m;
                        throw ex;
                    }
                    int pMajor = is.readByte();
                    int pMinor = is.readByte();
                    if (pMajor != 1) {
                        UnsupportedProtocolException e = new UnsupportedProtocolException();
                        e.badMajor = pMajor < 0 ? pMajor + 255 : pMajor;
                        e.badMinor = pMinor < 0 ? pMinor + 255 : pMinor;
                        e.major = 1;
                        e.minor = 0;
                        throw e;
                    }
                    int eMajor = is.readByte();
                    int eMinor = is.readByte();
                    if (eMajor != 1) {
                        UnsupportedEncodingException e = new UnsupportedEncodingException();
                        e.badMajor = eMajor < 0 ? eMajor + 255 : eMajor;
                        e.badMinor = eMinor < 0 ? eMinor + 255 : eMinor;
                        e.major = 1;
                        e.minor = 0;
                        throw e;
                    }
                    byte messageType = is.readByte();
                    if (messageType != 3) {
                        throw new ConnectionNotValidatedException();
                    }
                    byte compress = is.readByte();
                    int size = is.readInt();
                    if (size != 14) {
                        throw new IllegalMessageSizeException();
                    }
                    TraceUtil.traceHeader("received validate connection", is, this._logger, this._traceLevels);
                }
                catch (LocalException ex) {
                    this.setState(4, ex);
                    if (!$assertionsDisabled && this._exception == null) {
                        throw new AssertionError();
                    }
                    throw this._exception;
                }
            }
        }
        if (this._acmTimeout > 0) {
            this._acmAbsoluteTimeoutMillis = System.currentTimeMillis() + (long)(this._acmTimeout * 1000);
        }
        this.setState(2);
    }

    public synchronized void activate() {
        this.setState(1);
    }

    public synchronized void hold() {
        this.setState(2);
    }

    public synchronized void destroy(int reason) {
        switch (reason) {
            case 0: {
                this.setState(3, new ObjectAdapterDeactivatedException());
                break;
            }
            case 1: {
                this.setState(3, new CommunicatorDestroyedException());
            }
        }
    }

    public synchronized boolean isValidated() {
        return this._state > 0;
    }

    public synchronized boolean isDestroyed() {
        return this._state >= 3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean isFinished() {
        if (this._transceiver == null && this._dispatchCount == 0) {
            Object object = this._incomingCacheMutex;
            synchronized (object) {
                while (this._incomingCache != null) {
                    this._incomingCache.__destroy();
                    this._incomingCache = this._incomingCache.next;
                }
            }
            return true;
        }
        return false;
    }

    public synchronized void waitUntilHolding() {
        while (this._state < 2 || this._dispatchCount > 0) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void waitUntilFinished() {
        while (this._state < 3 || this._dispatchCount > 0) {
            try {
                this.wait();
            }
            catch (InterruptedException ex) {}
        }
        while (this._transceiver != null) {
            try {
                if (this._state != 4 && this._endpoint.timeout() >= 0) {
                    long absoluteWaitTime = this._stateTime + (long)this._endpoint.timeout();
                    long waitTime = absoluteWaitTime - System.currentTimeMillis();
                    if (waitTime > 0L) {
                        this.wait(waitTime);
                        if (System.currentTimeMillis() < absoluteWaitTime) continue;
                        this.setState(4, new CloseTimeoutException());
                        continue;
                    }
                    this.setState(4, new CloseTimeoutException());
                    continue;
                }
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        if (!$assertionsDisabled && this._state != 4) {
            throw new AssertionError();
        }
        Object object = this._incomingCacheMutex;
        synchronized (object) {
            while (this._incomingCache != null) {
                this._incomingCache.__destroy();
                this._incomingCache = this._incomingCache.next;
            }
        }
    }

    public synchronized void monitor() {
        if (this._state != 1) {
            return;
        }
        Iterator i = this._asyncRequests.entryIterator();
        while (i.hasNext()) {
            IntMap.Entry e = (IntMap.Entry)i.next();
            OutgoingAsync out = (OutgoingAsync)e.getValue();
            if (!out.__timedOut()) continue;
            this.setState(4, new TimeoutException());
            return;
        }
        if (this._acmTimeout > 0 && this._requests.isEmpty() && this._asyncRequests.isEmpty() && !this._batchStreamInUse && this._batchStream.isEmpty() && this._dispatchCount == 0 && System.currentTimeMillis() >= this._acmAbsoluteTimeoutMillis) {
            this.setState(3, new ConnectionTimeoutException());
            return;
        }
    }

    public void prepareRequest(BasicStream os) {
        os.writeBlob(_requestHdr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendRequest(BasicStream os, Outgoing out) {
        int requestId = 0;
        Object object = this;
        synchronized (object) {
            if (!$assertionsDisabled && out != null && this._endpoint.datagram()) {
                throw new AssertionError();
            }
            if (this._exception != null) {
                throw this._exception;
            }
            if (!$assertionsDisabled && this._state <= 0) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && this._state >= 3) {
                throw new AssertionError();
            }
            os.pos(10);
            os.writeInt(os.size());
            if (out != null) {
                if ((requestId = this._nextRequestId++) <= 0) {
                    this._nextRequestId = 1;
                    requestId = this._nextRequestId++;
                }
                os.pos(14);
                os.writeInt(requestId);
                this._requests.put(requestId, out);
            }
            if (this._acmTimeout > 0) {
                this._acmAbsoluteTimeoutMillis = System.currentTimeMillis() + (long)(this._acmTimeout * 1000);
            }
        }
        try {
            object = this._sendMutex;
            synchronized (object) {
                if (this._transceiver == null) {
                    if (!$assertionsDisabled && this._exception == null) {
                        throw new AssertionError();
                    }
                    throw this._exception;
                }
                TraceUtil.traceRequest("sending request", os, this._logger, this._traceLevels);
                this._transceiver.write(os, this._endpoint.timeout());
            }
        }
        catch (LocalException ex) {
            Connection connection = this;
            synchronized (connection) {
                this.setState(4, ex);
                if (!$assertionsDisabled && this._exception == null) {
                    throw new AssertionError();
                }
                if (out != null) {
                    Outgoing o = (Outgoing)this._requests.remove(requestId);
                    if (o != null) {
                        if (!$assertionsDisabled && o != out) {
                            throw new AssertionError();
                        }
                        throw this._exception;
                    }
                } else {
                    throw this._exception;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendAsyncRequest(BasicStream os, OutgoingAsync out) {
        int requestId = 0;
        Object object = this;
        synchronized (object) {
            if (!$assertionsDisabled && this._endpoint.datagram()) {
                throw new AssertionError();
            }
            if (this._exception != null) {
                throw this._exception;
            }
            if (!$assertionsDisabled && this._state <= 0) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && this._state >= 3) {
                throw new AssertionError();
            }
            os.pos(10);
            os.writeInt(os.size());
            requestId = this._nextRequestId++;
            if (requestId <= 0) {
                this._nextRequestId = 1;
                requestId = this._nextRequestId++;
            }
            os.pos(14);
            os.writeInt(requestId);
            this._asyncRequests.put(requestId, out);
            if (this._acmTimeout > 0) {
                this._acmAbsoluteTimeoutMillis = System.currentTimeMillis() + (long)(this._acmTimeout * 1000);
            }
        }
        try {
            object = this._sendMutex;
            synchronized (object) {
                if (this._transceiver == null) {
                    if (!$assertionsDisabled && this._exception == null) {
                        throw new AssertionError();
                    }
                    throw this._exception;
                }
                TraceUtil.traceRequest("sending asynchronous request", os, this._logger, this._traceLevels);
                this._transceiver.write(os, this._endpoint.timeout());
            }
        }
        catch (LocalException ex) {
            Connection connection = this;
            synchronized (connection) {
                this.setState(4, ex);
                if (!$assertionsDisabled && this._exception == null) {
                    throw new AssertionError();
                }
                OutgoingAsync o = (OutgoingAsync)this._asyncRequests.remove(requestId);
                if (o != null) {
                    if (!$assertionsDisabled && o != out) {
                        throw new AssertionError();
                    }
                    throw this._exception;
                }
            }
        }
    }

    public synchronized void prepareBatchRequest(BasicStream os) {
        while (this._batchStreamInUse && this._exception == null) {
            try {
                this.wait();
            }
            catch (InterruptedException ex) {}
        }
        if (this._exception != null) {
            throw this._exception;
        }
        if (!$assertionsDisabled && this._state <= 0) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this._state >= 3) {
            throw new AssertionError();
        }
        if (this._batchStream.isEmpty()) {
            try {
                this._batchStream.writeBlob(_requestBatchHdr);
            }
            catch (LocalException ex) {
                this.setState(4, ex);
                throw ex;
            }
        }
        this._batchStreamInUse = true;
        this._batchStream.swap(os);
    }

    public synchronized void finishBatchRequest(BasicStream os) {
        if (this._exception != null) {
            throw this._exception;
        }
        if (!$assertionsDisabled && this._state <= 0) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this._state >= 3) {
            throw new AssertionError();
        }
        this._batchStream.swap(os);
        ++this._batchRequestNum;
        if (!$assertionsDisabled && !this._batchStreamInUse) {
            throw new AssertionError();
        }
        this._batchStreamInUse = false;
        this.notifyAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushBatchRequest() {
        Object object = this;
        synchronized (object) {
            while (this._batchStreamInUse && this._exception == null) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            if (this._exception != null) {
                throw this._exception;
            }
            if (!$assertionsDisabled && this._state <= 0) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && this._state >= 3) {
                throw new AssertionError();
            }
            if (this._batchStream.isEmpty()) {
                return;
            }
            this._batchStream.pos(10);
            this._batchStream.writeInt(this._batchStream.size());
            this._batchStream.writeInt(this._batchRequestNum);
            if (this._acmTimeout > 0) {
                this._acmAbsoluteTimeoutMillis = System.currentTimeMillis() + (long)(this._acmTimeout * 1000);
            }
            this._batchStreamInUse = true;
        }
        try {
            object = this._sendMutex;
            synchronized (object) {
                if (this._transceiver == null) {
                    if (!$assertionsDisabled && this._exception == null) {
                        throw new AssertionError();
                    }
                    throw this._exception;
                }
                TraceUtil.traceBatchRequest("sending batch request", this._batchStream, this._logger, this._traceLevels);
                this._transceiver.write(this._batchStream, this._endpoint.timeout());
            }
        }
        catch (LocalException ex) {
            Connection connection = this;
            synchronized (connection) {
                this.setState(4, ex);
                if (!$assertionsDisabled && this._exception == null) {
                    throw new AssertionError();
                }
                throw this._exception;
            }
        }
        object = this;
        synchronized (object) {
            this._batchStream.destroy();
            this._batchStream = new BasicStream(this._instance);
            this._batchRequestNum = 0;
            this._batchStreamInUse = false;
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendResponse(BasicStream os, byte compress) {
        Object object;
        try {
            object = this._sendMutex;
            synchronized (object) {
                if (this._transceiver == null) {
                    if (!$assertionsDisabled && this._exception == null) {
                        throw new AssertionError();
                    }
                    throw this._exception;
                }
                os.pos(10);
                os.writeInt(os.size());
                TraceUtil.traceReply("sending reply", os, this._logger, this._traceLevels);
                this._transceiver.write(os, this._endpoint.timeout());
            }
        }
        catch (LocalException ex) {
            Connection connection = this;
            synchronized (connection) {
                this.setState(4, ex);
            }
        }
        object = this;
        synchronized (object) {
            if (!$assertionsDisabled && this._state <= 0) {
                throw new AssertionError();
            }
            try {
                if (--this._dispatchCount == 0) {
                    this.notifyAll();
                }
                if (this._state == 3 && this._dispatchCount == 0) {
                    this.initiateShutdown();
                }
                if (this._acmTimeout > 0) {
                    this._acmAbsoluteTimeoutMillis = System.currentTimeMillis() + (long)(this._acmTimeout * 1000);
                }
            }
            catch (LocalException ex) {
                this.setState(4, ex);
            }
        }
    }

    public synchronized void sendNoResponse() {
        if (!$assertionsDisabled && this._state <= 0) {
            throw new AssertionError();
        }
        try {
            if (--this._dispatchCount == 0) {
                this.notifyAll();
            }
            if (this._state == 3 && this._dispatchCount == 0) {
                this.initiateShutdown();
            }
        }
        catch (LocalException ex) {
            this.setState(4, ex);
        }
    }

    public int timeout() {
        return this._endpoint.timeout();
    }

    public Endpoint endpoint() {
        return this._endpoint;
    }

    public synchronized void setAdapter(ObjectAdapter adapter) {
        if (this._adapter != adapter) {
            while (this._dispatchCount > 0) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            this._adapter = adapter;
            this._servantManager = this._adapter != null ? ((ObjectAdapterI)this._adapter).getServantManager() : null;
        }
    }

    public synchronized ObjectAdapter getAdapter() {
        return this._adapter;
    }

    public boolean datagram() {
        return this._endpoint.datagram();
    }

    public boolean readable() {
        return true;
    }

    public void read(BasicStream stream) {
        this._transceiver.read(stream, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void message(BasicStream stream, ThreadPool threadPool) {
        block71: {
            Connection connection;
            OutgoingAsync outAsync = null;
            int invoke = 0;
            int requestId = 0;
            byte compress = 0;
            Connection connection2 = this;
            synchronized (connection2) {
                threadPool.promoteFollower();
                if (!$assertionsDisabled && this._state <= 0) {
                    throw new AssertionError();
                }
                if (this._state == 4) {
                    return;
                }
                if (this._acmTimeout > 0) {
                    this._acmAbsoluteTimeoutMillis = System.currentTimeMillis() + (long)(this._acmTimeout * 1000);
                }
                try {
                    if (!$assertionsDisabled && stream.pos() != stream.size()) {
                        throw new AssertionError();
                    }
                    stream.pos(8);
                    byte messageType = stream.readByte();
                    compress = stream.readByte();
                    if (compress == 2) {
                        throw new CompressionNotSupportedException();
                    }
                    stream.pos(14);
                    switch (messageType) {
                        case 4: {
                            TraceUtil.traceHeader("received close connection", stream, this._logger, this._traceLevels);
                            if (this._endpoint.datagram() && this._warn) {
                                this._logger.warning("ignoring close connection message for datagram connection:\n" + this._desc);
                                break;
                            }
                            this.setState(4, new CloseConnectionException());
                            break;
                        }
                        case 0: {
                            if (this._state == 3) {
                                TraceUtil.traceRequest("received request during closing\n(ignored by server, client will retry)", stream, this._logger, this._traceLevels);
                                break;
                            }
                            TraceUtil.traceRequest("received request", stream, this._logger, this._traceLevels);
                            requestId = stream.readInt();
                            invoke = 1;
                            ++this._dispatchCount;
                            break;
                        }
                        case 1: {
                            if (this._state == 3) {
                                TraceUtil.traceBatchRequest("received batch request during closing\n(ignored by server, client will retry)", stream, this._logger, this._traceLevels);
                                break;
                            }
                            TraceUtil.traceBatchRequest("received batch request", stream, this._logger, this._traceLevels);
                            invoke = stream.readInt();
                            if (invoke < 0) {
                                throw new NegativeSizeException();
                            }
                            this._dispatchCount += invoke;
                            break;
                        }
                        case 2: {
                            TraceUtil.traceReply("received reply", stream, this._logger, this._traceLevels);
                            requestId = stream.readInt();
                            Outgoing out = (Outgoing)this._requests.remove(requestId);
                            if (out != null) {
                                out.finished(stream);
                                break;
                            }
                            outAsync = (OutgoingAsync)this._asyncRequests.remove(requestId);
                            if (outAsync == null) {
                                throw new UnknownRequestIdException();
                            }
                            break;
                        }
                        case 3: {
                            TraceUtil.traceHeader("received validate connection", stream, this._logger, this._traceLevels);
                            if (this._warn) {
                                this._logger.warning("ignoring unexpected validate connection message:\n" + this._desc);
                            }
                            break;
                        }
                        default: {
                            TraceUtil.traceHeader("received unknown message\n(invalid, closing connection)", stream, this._logger, this._traceLevels);
                            throw new UnknownMessageException();
                        }
                    }
                }
                catch (LocalException ex) {
                    this.setState(4, ex);
                    return;
                }
            }
            if (outAsync != null) {
                outAsync.__finished(stream);
            }
            Incoming in = null;
            try {
                block70: {
                    while (invoke > 0) {
                        boolean response = !this._endpoint.datagram() && requestId != 0;
                        in = this.getIncoming(response, compress);
                        BasicStream is = in.is();
                        stream.swap(is);
                        BasicStream os = in.os();
                        if (response) {
                            if (!$assertionsDisabled && invoke != 1) {
                                throw new AssertionError();
                            }
                            os.writeBlob(_replyHdr);
                            os.writeInt(requestId);
                        }
                        in.invoke(this._servantManager);
                        if (--invoke > 0) {
                            stream.swap(is);
                        }
                        this.reclaimIncoming(in);
                        in = null;
                    }
                    Object var15_16 = null;
                    if (in == null) break block70;
                    this.reclaimIncoming(in);
                }
                if (invoke <= 0) break block71;
                connection = this;
            }
            catch (Throwable throwable) {
                Object var15_19 = null;
                if (in != null) {
                    this.reclaimIncoming(in);
                }
                if (invoke > 0) {
                    Connection connection3 = this;
                    synchronized (connection3) {
                        if (!$assertionsDisabled && this._dispatchCount <= 0) {
                            throw new AssertionError();
                        }
                        this._dispatchCount -= invoke;
                        if (!$assertionsDisabled && this._dispatchCount < 0) {
                            throw new AssertionError();
                        }
                        if (this._dispatchCount == 0) {
                            this.notifyAll();
                        }
                    }
                }
                throw throwable;
            }
            synchronized (connection) {
                if (!$assertionsDisabled && this._dispatchCount <= 0) {
                    throw new AssertionError();
                }
                this._dispatchCount -= invoke;
                if (!$assertionsDisabled && this._dispatchCount < 0) {
                    throw new AssertionError();
                }
                if (this._dispatchCount == 0) {
                    this.notifyAll();
                }
            }
            {
                Connection connection4;
                catch (LocalException ex) {
                    if (!$assertionsDisabled && invoke <= 0) {
                        throw new AssertionError();
                    }
                    connection4 = this;
                    synchronized (connection4) {
                        this.setState(4, ex);
                    }
                    Object var15_17 = null;
                    if (in != null) {
                        this.reclaimIncoming(in);
                    }
                    if (invoke > 0) {
                        Connection connection5 = this;
                        synchronized (connection5) {
                            if (!$assertionsDisabled && this._dispatchCount <= 0) {
                                throw new AssertionError();
                            }
                            this._dispatchCount -= invoke;
                            if (!$assertionsDisabled && this._dispatchCount < 0) {
                                throw new AssertionError();
                            }
                            if (this._dispatchCount == 0) {
                                this.notifyAll();
                            }
                        }
                    }
                    break block71;
                }
                catch (AssertionError ex) {
                    if (!$assertionsDisabled && invoke <= 0) {
                        throw new AssertionError();
                    }
                    connection4 = this;
                    synchronized (connection4) {
                        StringWriter sw = new StringWriter();
                        PrintWriter pw = new PrintWriter(sw);
                        ((Throwable)((Object)ex)).printStackTrace(pw);
                        pw.flush();
                        UnknownException exc = new UnknownException();
                        exc.unknown = sw.toString();
                        this._logger.error(exc.unknown);
                        this.setState(4, exc);
                    }
                    Object var15_18 = null;
                    if (in != null) {
                        this.reclaimIncoming(in);
                    }
                    if (invoke > 0) {
                        Connection connection6 = this;
                        synchronized (connection6) {
                            if (!$assertionsDisabled && this._dispatchCount <= 0) {
                                throw new AssertionError();
                            }
                            this._dispatchCount -= invoke;
                            if (!$assertionsDisabled && this._dispatchCount < 0) {
                                throw new AssertionError();
                            }
                            if (this._dispatchCount == 0) {
                                this.notifyAll();
                            }
                        }
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finished(ThreadPool threadPool) {
        Object out;
        IntMap.Entry e;
        Iterator i;
        threadPool.promoteFollower();
        LocalException exception = null;
        IntMap requests = null;
        IntMap asyncRequests = null;
        Incoming in = null;
        Connection connection = this;
        synchronized (connection) {
            if (this._state == 1 || this._state == 3) {
                this.registerWithPool();
            } else if (this._state == 4) {
                Object object = this._sendMutex;
                synchronized (object) {
                    try {
                        this._transceiver.close();
                    }
                    catch (LocalException ex) {
                        exception = ex;
                    }
                    this._transceiver = null;
                    this.notifyAll();
                }
            }
            if (this._state == 4 || this._state == 3) {
                requests = this._requests;
                this._requests = new IntMap();
                asyncRequests = this._asyncRequests;
                this._asyncRequests = new IntMap();
            }
        }
        while (in != null) {
            in.__destroy();
            in = in.next;
        }
        if (requests != null) {
            i = requests.entryIterator();
            while (i.hasNext()) {
                e = (IntMap.Entry)i.next();
                out = (Outgoing)e.getValue();
                ((Outgoing)out).finished(this._exception);
            }
        }
        if (asyncRequests != null) {
            i = asyncRequests.entryIterator();
            while (i.hasNext()) {
                e = (IntMap.Entry)i.next();
                out = (OutgoingAsync)e.getValue();
                ((OutgoingAsync)out).__finished(this._exception);
            }
        }
        if (exception != null) {
            throw exception;
        }
    }

    public synchronized void exception(LocalException ex) {
        this.setState(4, ex);
    }

    public String toString() {
        return this._desc;
    }

    Connection(Instance instance, Transceiver transceiver, Endpoint endpoint, ObjectAdapter adapter) {
        super(instance);
        this._transceiver = transceiver;
        this._desc = ((Object)transceiver).toString();
        this._endpoint = endpoint;
        this._adapter = adapter;
        this._logger = instance.logger();
        this._traceLevels = instance.traceLevels();
        this._registeredWithPool = false;
        this._warn = this._instance.properties().getPropertyAsInt("Ice.Warn.Connections") > 0;
        this._acmTimeout = this._endpoint.datagram() ? 0 : this._instance.connectionIdleTime();
        this._acmAbsoluteTimeoutMillis = 0L;
        this._nextRequestId = 1;
        this._batchStream = new BasicStream(instance);
        this._batchStreamInUse = false;
        this._batchRequestNum = 0;
        this._dispatchCount = 0;
        this._state = 0;
        this._stateTime = System.currentTimeMillis();
        if (this._adapter != null) {
            this._threadPool = ((ObjectAdapterI)this._adapter).getThreadPool();
            this._servantManager = ((ObjectAdapterI)this._adapter).getServantManager();
        } else {
            this._threadPool = this._instance.clientThreadPool();
            this._servantManager = null;
        }
    }

    protected void finalize() throws Throwable {
        if (!$assertionsDisabled && this._state != 4) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this._transceiver != null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this._dispatchCount != 0) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this._incomingCache != null) {
            throw new AssertionError();
        }
        this._batchStream.destroy();
        super.finalize();
    }

    private void setState(int state, LocalException ex) {
        if (!$assertionsDisabled && state != 3 && state != 4) {
            throw new AssertionError();
        }
        if (this._state == state) {
            return;
        }
        if (this._exception == null) {
            this._exception = ex;
            if (!(!this._warn || this._state <= 0 || this._exception instanceof CloseConnectionException || this._exception instanceof ConnectionTimeoutException || this._exception instanceof CommunicatorDestroyedException || this._exception instanceof ObjectAdapterDeactivatedException || this._exception instanceof ConnectionLostException && this._state == 3)) {
                this.warning("connection exception", this._exception);
            }
        }
        this.setState(state);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setState(int state) {
        if (this._endpoint.datagram() && state == 3) {
            state = 4;
        }
        if (this._state == state) {
            return;
        }
        switch (state) {
            case 0: {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
                break;
            }
            case 1: {
                if (this._state != 2 && this._state != 0) {
                    return;
                }
                this.registerWithPool();
                break;
            }
            case 2: {
                if (this._state != 1 && this._state != 0) {
                    return;
                }
                this.unregisterWithPool();
                break;
            }
            case 3: {
                if (this._state == 4) {
                    return;
                }
                this.registerWithPool();
                break;
            }
            case 4: {
                if (this._state == 0) {
                    if (!$assertionsDisabled && this._registeredWithPool) {
                        throw new AssertionError();
                    }
                    Object object = this._sendMutex;
                    synchronized (object) {
                        try {
                            this._transceiver.close();
                        }
                        catch (LocalException localException) {
                            // empty catch block
                        }
                        this._transceiver = null;
                        break;
                    }
                }
                this.registerWithPool();
                this.unregisterWithPool();
            }
        }
        this._state = state;
        this._stateTime = System.currentTimeMillis();
        this.notifyAll();
        if (this._state == 3 && this._dispatchCount == 0) {
            try {
                this.initiateShutdown();
            }
            catch (LocalException ex) {
                this.setState(4, ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initiateShutdown() {
        if (!$assertionsDisabled && this._state != 3) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this._dispatchCount != 0) {
            throw new AssertionError();
        }
        if (!this._endpoint.datagram()) {
            Object object = this._sendMutex;
            synchronized (object) {
                BasicStream os = new BasicStream(this._instance);
                os.writeByte(Protocol.magic[0]);
                os.writeByte(Protocol.magic[1]);
                os.writeByte(Protocol.magic[2]);
                os.writeByte(Protocol.magic[3]);
                os.writeByte((byte)1);
                os.writeByte((byte)0);
                os.writeByte((byte)1);
                os.writeByte((byte)0);
                os.writeByte((byte)4);
                os.writeByte((byte)0);
                os.writeInt(14);
                TraceUtil.traceHeader("sending close connection", os, this._logger, this._traceLevels);
                this._transceiver.write(os, this._endpoint.timeout());
                this._transceiver.shutdown();
            }
        }
    }

    private void registerWithPool() {
        if (!this._registeredWithPool) {
            this._threadPool._register(this._transceiver.fd(), this);
            this._registeredWithPool = true;
            ConnectionMonitor connectionMonitor = this._instance.connectionMonitor();
            if (connectionMonitor != null) {
                connectionMonitor.add(this);
            }
        }
    }

    private void unregisterWithPool() {
        if (this._registeredWithPool) {
            this._threadPool.unregister(this._transceiver.fd());
            this._registeredWithPool = false;
            ConnectionMonitor connectionMonitor = this._instance.connectionMonitor();
            if (connectionMonitor != null) {
                connectionMonitor.remove(this);
            }
        }
    }

    private void warning(String msg, Exception ex) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        Throwable t = ex;
        do {
            t.printStackTrace(pw);
            t = t.getCause();
            if (t == null) continue;
            pw.println("Caused by:\n");
        } while (t != null);
        pw.flush();
        String s = msg + ":\n" + sw.toString() + this._desc;
        this._logger.warning(s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Incoming getIncoming(boolean response, byte compress) {
        Incoming in = null;
        Object object = this._incomingCacheMutex;
        synchronized (object) {
            if (this._incomingCache == null) {
                in = new Incoming(this._instance, this, this._adapter, response, compress);
            } else {
                in = this._incomingCache;
                this._incomingCache = this._incomingCache.next;
                in.next = null;
                in.reset(this._instance, this, this._adapter, response, compress);
            }
        }
        return in;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reclaimIncoming(Incoming in) {
        Object object = this._incomingCacheMutex;
        synchronized (object) {
            in.next = this._incomingCache;
            this._incomingCache = in;
        }
    }

    static {
        $assertionsDisabled = !Connection.class.desiredAssertionStatus();
        _requestHdr = new byte[]{Protocol.magic[0], Protocol.magic[1], Protocol.magic[2], Protocol.magic[3], 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        _requestBatchHdr = new byte[]{Protocol.magic[0], Protocol.magic[1], Protocol.magic[2], Protocol.magic[3], 1, 0, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        _replyHdr = new byte[]{Protocol.magic[0], Protocol.magic[1], Protocol.magic[2], Protocol.magic[3], 1, 0, 1, 0, 2, 0, 0, 0, 0, 0};
    }
}

