/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.Properties;
import IceInternal.Network;

public final class DefaultsAndOverrides {
    public final String defaultHost;
    public final String defaultProtocol;
    public final String defaultRouter;
    public final String defaultLocator;
    public final boolean overrideTimeout;
    public final int overrideTimeoutValue;
    public final boolean overrideConnectTimeout;
    public final int overrideConnectTimeoutValue;
    public final boolean overrideCompress;
    public final boolean overrideCompressValue;

    DefaultsAndOverrides(Properties properties) {
        this.defaultProtocol = properties.getPropertyWithDefault("Ice.Default.Protocol", "tcp");
        String value = properties.getProperty("Ice.Default.Host");
        this.defaultHost = value.length() != 0 ? value : Network.getLocalHost(true);
        this.defaultRouter = properties.getProperty("Ice.Default.Router");
        value = properties.getProperty("Ice.Override.Timeout");
        if (value.length() > 0) {
            this.overrideTimeout = true;
            this.overrideTimeoutValue = properties.getPropertyAsInt("Ice.Override.Timeout");
        } else {
            this.overrideTimeout = false;
            this.overrideTimeoutValue = -1;
        }
        value = properties.getProperty("Ice.Override.ConnectTimeout");
        if (value.length() > 0) {
            this.overrideConnectTimeout = true;
            this.overrideConnectTimeoutValue = properties.getPropertyAsInt("Ice.Override.ConnectTimeout");
        } else {
            this.overrideConnectTimeout = false;
            this.overrideConnectTimeoutValue = -1;
        }
        value = properties.getProperty("Ice.Override.Compress");
        if (value.length() > 0) {
            this.overrideCompress = true;
            if (properties.getPropertyAsInt("Ice.Override.Compress") != 0) {
                System.err.println("warning: compression not supported, Ice.Override.Compress ignored");
            }
            this.overrideCompressValue = false;
        } else {
            this.overrideCompress = false;
            this.overrideCompressValue = false;
        }
        this.defaultLocator = properties.getProperty("Ice.Default.Locator");
    }
}

