/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.EndpointParseException;
import IceInternal.BasicStream;
import IceInternal.Endpoint;
import IceInternal.EndpointFactory;
import IceInternal.Instance;
import IceInternal.UnknownEndpoint;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class EndpointFactoryManager {
    private Instance _instance;
    private ArrayList _factories = new ArrayList();
    static final /* synthetic */ boolean $assertionsDisabled;

    EndpointFactoryManager(Instance instance) {
        this._instance = instance;
    }

    public synchronized void add(EndpointFactory factory) {
        for (int i = 0; i < this._factories.size(); ++i) {
            EndpointFactory f = (EndpointFactory)this._factories.get(i);
            if (f.type() == factory.type() && !$assertionsDisabled) {
                throw new AssertionError();
            }
        }
        this._factories.add(factory);
    }

    public synchronized EndpointFactory get(short type) {
        for (int i = 0; i < this._factories.size(); ++i) {
            EndpointFactory f = (EndpointFactory)this._factories.get(i);
            if (f.type() != type) continue;
            return f;
        }
        return null;
    }

    public synchronized Endpoint create(String str) {
        String s = str.trim();
        if (s.length() == 0) {
            EndpointParseException e = new EndpointParseException();
            e.str = str;
            throw e;
        }
        Pattern p = Pattern.compile("([ \t\n\r]+)|$");
        Matcher m = p.matcher(s);
        boolean b = m.find();
        if (!$assertionsDisabled && !b) {
            throw new AssertionError();
        }
        String protocol = s.substring(0, m.start());
        if (protocol.equals("default")) {
            protocol = this._instance.defaultsAndOverrides().defaultProtocol;
        }
        for (int i = 0; i < this._factories.size(); ++i) {
            EndpointFactory f = (EndpointFactory)this._factories.get(i);
            if (!f.protocol().equals(protocol)) continue;
            return f.create(s.substring(m.end()));
        }
        EndpointParseException e = new EndpointParseException();
        e.str = str;
        throw e;
    }

    public synchronized Endpoint read(BasicStream s) {
        short type = s.readShort();
        for (int i = 0; i < this._factories.size(); ++i) {
            EndpointFactory f = (EndpointFactory)this._factories.get(i);
            if (f.type() != type) continue;
            return f.read(s);
        }
        return new UnknownEndpoint(type, s);
    }

    void destroy() {
        for (int i = 0; i < this._factories.size(); ++i) {
            EndpointFactory f = (EndpointFactory)this._factories.get(i);
            f.destroy();
        }
        this._factories.clear();
    }

    static {
        $assertionsDisabled = !EndpointFactoryManager.class.desiredAssertionStatus();
    }
}

