/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.Current;
import Ice.Identity;
import Ice.LocalObjectHolder;
import Ice.Object;
import Ice.ObjectAdapter;
import Ice.ServantLocator;
import Ice.Util;
import IceInternal.BasicStream;
import IceInternal.Connection;
import IceInternal.Instance;
import IceUtil.OutputBase;
import IceUtil.StringUtil;
import java.io.PrintWriter;
import java.io.StringWriter;

public class IncomingBase {
    protected Current _current;
    protected Object _servant;
    protected ServantLocator _locator;
    protected LocalObjectHolder _cookie;
    protected boolean _response;
    protected byte _compress;
    protected BasicStream _os;
    private Connection _connection;
    static final /* synthetic */ boolean $assertionsDisabled;

    protected IncomingBase(Instance instance, Connection connection, ObjectAdapter adapter, boolean response, byte compress) {
        this._current = new Current();
        this._current.id = new Identity();
        this._current.adapter = adapter;
        this._cookie = new LocalObjectHolder();
        this._response = response;
        this._compress = compress;
        this._os = new BasicStream(instance);
        this._connection = connection;
    }

    protected IncomingBase(IncomingBase in) {
        this._current = in._current;
        in._current = null;
        this._servant = in._servant;
        in._servant = null;
        this._locator = in._locator;
        in._locator = null;
        this._cookie = in._cookie;
        in._cookie = null;
        this._response = in._response;
        in._response = false;
        this._compress = in._compress;
        in._compress = 0;
        this._os = in._os;
        in._os = null;
        this._connection = in._connection;
        in._connection = null;
    }

    public void __destroy() {
        if (this._os != null) {
            this._os.destroy();
            this._os = null;
        }
    }

    public void reset(Instance instance, Connection connection, ObjectAdapter adapter, boolean response, byte compress) {
        if (this._current == null) {
            this._current = new Current();
            this._current.id = new Identity();
            this._current.adapter = adapter;
        } else {
            if (!$assertionsDisabled && this._current.id == null) {
                throw new AssertionError();
            }
            this._current.adapter = adapter;
            this._current.facet = null;
            if (this._current.ctx != null) {
                this._current.ctx.clear();
            }
        }
        this._servant = null;
        this._locator = null;
        if (this._cookie == null) {
            this._cookie = new LocalObjectHolder();
        } else {
            this._cookie.value = null;
        }
        this._response = response;
        this._compress = compress;
        if (this._os == null) {
            this._os = new BasicStream(instance);
        } else {
            this._os.reset();
        }
        this._connection = connection;
    }

    protected final void __finishInvoke() {
        if (this._locator != null && this._servant != null) {
            this._locator.finished(this._current, this._servant, this._cookie.value);
        }
        if (this._response) {
            this._connection.sendResponse(this._os, this._compress);
        } else {
            this._connection.sendNoResponse();
        }
    }

    protected final void __warning(Exception ex) {
        if (!$assertionsDisabled && this._os == null) {
            throw new AssertionError();
        }
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        OutputBase out = new OutputBase(pw);
        out.setUseTab(false);
        out.print("dispatch exception:");
        out.print("\nidentity: " + Util.identityToString(this._current.id));
        out.print("\nfacet: " + StringUtil.escapeString(this._current.facet, ""));
        out.print("\noperation: " + this._current.operation);
        out.print("\n");
        ex.printStackTrace(pw);
        pw.flush();
        this._os.instance().logger().warning(sw.toString());
    }

    static {
        $assertionsDisabled = !IncomingBase.class.desiredAssertionStatus();
    }
}

