/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.ConnectFailedException;
import Ice.ConnectTimeoutException;
import Ice.ConnectionRefusedException;
import Ice.DNSException;
import Ice.LocalException;
import Ice.SocketException;
import Ice.TimeoutException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.ConnectException;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.channels.spi.AbstractSelectableChannel;
import java.util.Enumeration;

public final class Network {
    static final /* synthetic */ boolean $assertionsDisabled;

    public static boolean connectionLost(IOException ex) {
        String msg = ex.getMessage().toLowerCase();
        if (msg != null) {
            String[] msgs = new String[]{"connection reset by peer", "cannot send after socket shutdown", "cannot send after transport endpoint shutdown", "software caused connection abort", "an existing connection was forcibly closed"};
            for (int i = 0; i < msgs.length; ++i) {
                if (msg.indexOf(msgs[i]) == -1) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean connectionRefused(ConnectException ex) {
        String msg = ex.getMessage().toLowerCase();
        if (msg != null) {
            String[] msgs = new String[]{"connection refused"};
            for (int i = 0; i < msgs.length; ++i) {
                if (msg.indexOf(msgs[i]) == -1) continue;
                return true;
            }
        }
        return false;
    }

    public static SocketChannel createTcpSocket() {
        try {
            SocketChannel fd = SocketChannel.open();
            Socket socket = fd.socket();
            socket.setTcpNoDelay(true);
            socket.setKeepAlive(true);
            return fd;
        }
        catch (IOException ex) {
            SocketException se = new SocketException();
            se.initCause(ex);
            throw se;
        }
    }

    public static ServerSocketChannel createTcpServerSocket() {
        try {
            ServerSocketChannel fd = ServerSocketChannel.open();
            return fd;
        }
        catch (IOException ex) {
            SocketException se = new SocketException();
            se.initCause(ex);
            throw se;
        }
    }

    public static DatagramChannel createUdpSocket() {
        try {
            return DatagramChannel.open();
        }
        catch (IOException ex) {
            SocketException se = new SocketException();
            se.initCause(ex);
            throw se;
        }
    }

    public static void setBlock(SelectableChannel fd, boolean block) {
        try {
            fd.configureBlocking(block);
        }
        catch (IOException ex) {
            SocketException se = new SocketException();
            se.initCause(ex);
            throw se;
        }
    }

    public static InetSocketAddress doBind(ServerSocketChannel fd, InetSocketAddress addr) {
        try {
            ServerSocket sock = fd.socket();
            sock.bind(addr);
            return (InetSocketAddress)sock.getLocalSocketAddress();
        }
        catch (IOException ex) {
            SocketException se = new SocketException();
            se.initCause(ex);
            throw se;
        }
    }

    public static InetSocketAddress doBind(DatagramChannel fd, InetSocketAddress addr) {
        try {
            DatagramSocket sock = fd.socket();
            sock.bind(addr);
            return (InetSocketAddress)sock.getLocalSocketAddress();
        }
        catch (IOException ex) {
            SocketException se = new SocketException();
            se.initCause(ex);
            throw se;
        }
    }

    public static void doConnect(SocketChannel fd, InetSocketAddress addr, int timeout) {
        try {
            if (!fd.connect(addr)) {
                int delay = timeout > 0 && timeout < 100 ? timeout : 100;
                int timer = 0;
                while (!fd.finishConnect()) {
                    if (timeout > 0 && timer >= timeout) {
                        fd.close();
                        throw new ConnectTimeoutException();
                    }
                    try {
                        Thread.sleep(delay);
                        timer += delay;
                    }
                    catch (InterruptedException ex) {}
                }
            }
        }
        catch (ConnectException ex) {
            try {
                fd.close();
            }
            catch (IOException e) {
                // empty catch block
            }
            ConnectFailedException se = Network.connectionRefused(ex) ? new ConnectionRefusedException() : new ConnectFailedException();
            se.initCause(ex);
            throw se;
        }
        catch (IOException ex) {
            try {
                fd.close();
            }
            catch (IOException e) {
                // empty catch block
            }
            SocketException se = new SocketException();
            se.initCause(ex);
            throw se;
        }
    }

    public static void doConnect(DatagramChannel fd, InetSocketAddress addr, int timeout) {
        try {
            fd.connect(addr);
        }
        catch (ConnectException ex) {
            try {
                fd.close();
            }
            catch (IOException e) {
                // empty catch block
            }
            ConnectFailedException se = Network.connectionRefused(ex) ? new ConnectionRefusedException() : new ConnectFailedException();
            se.initCause(ex);
            throw se;
        }
        catch (IOException ex) {
            try {
                fd.close();
            }
            catch (IOException e) {
                // empty catch block
            }
            SocketException se = new SocketException();
            se.initCause(ex);
            throw se;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SocketChannel doAccept(ServerSocketChannel fd, int timeout) {
        SocketException se;
        SocketChannel result = null;
        block15: while (result == null) {
            try {
                result = fd.accept();
                if (result != null) continue;
                Selector selector = Selector.open();
                try {
                    while (true) {
                        try {
                            SelectionKey key = fd.register(selector, 16);
                            int n = timeout > 0 ? selector.select(timeout) : (timeout == 0 ? selector.selectNow() : selector.select());
                            if (n != 0) continue block15;
                            throw new TimeoutException();
                        }
                        catch (InterruptedIOException ex) {
                            continue;
                        }
                        catch (IOException ex) {
                            SocketException se2 = new SocketException();
                            se2.initCause(ex);
                            throw se2;
                        }
                        break;
                    }
                }
                finally {
                    try {
                        selector.close();
                    }
                    catch (IOException ex) {}
                }
            }
            catch (InterruptedIOException ex) {
            }
            catch (IOException ex) {
                se = new SocketException();
                se.initCause(ex);
                throw se;
            }
        }
        try {
            Socket socket = result.socket();
            socket.setTcpNoDelay(true);
            socket.setKeepAlive(true);
        }
        catch (IOException ex) {
            se = new SocketException();
            se.initCause(ex);
            throw se;
        }
        return result;
    }

    public static void setSendBufferSize(DatagramChannel fd, int size) {
        try {
            DatagramSocket socket = fd.socket();
            socket.setSendBufferSize(size);
        }
        catch (IOException ex) {
            SocketException se = new SocketException();
            se.initCause(ex);
            throw se;
        }
    }

    public static int getSendBufferSize(DatagramChannel fd) {
        int size;
        try {
            DatagramSocket socket = fd.socket();
            size = socket.getSendBufferSize();
        }
        catch (IOException ex) {
            SocketException se = new SocketException();
            se.initCause(ex);
            throw se;
        }
        return size;
    }

    public static void setRecvBufferSize(ServerSocketChannel fd, int size) {
        try {
            ServerSocket socket = fd.socket();
            socket.setReceiveBufferSize(size);
        }
        catch (IOException ex) {
            SocketException se = new SocketException();
            se.initCause(ex);
            throw se;
        }
    }

    public static void setRecvBufferSize(DatagramChannel fd, int size) {
        try {
            DatagramSocket socket = fd.socket();
            socket.setReceiveBufferSize(size);
        }
        catch (IOException ex) {
            SocketException se = new SocketException();
            se.initCause(ex);
            throw se;
        }
    }

    public static int getRecvBufferSize(ServerSocketChannel fd) {
        int size;
        try {
            ServerSocket socket = fd.socket();
            size = socket.getReceiveBufferSize();
        }
        catch (IOException ex) {
            SocketException se = new SocketException();
            se.initCause(ex);
            throw se;
        }
        return size;
    }

    public static int getRecvBufferSize(DatagramChannel fd) {
        int size;
        try {
            DatagramSocket socket = fd.socket();
            size = socket.getReceiveBufferSize();
        }
        catch (IOException ex) {
            SocketException se = new SocketException();
            se.initCause(ex);
            throw se;
        }
        return size;
    }

    public static InetSocketAddress getAddress(String host, int port) {
        try {
            InetAddress addr = InetAddress.getByName(host);
            return new InetSocketAddress(addr, port);
        }
        catch (UnknownHostException ex) {
            DNSException e = new DNSException();
            e.host = host;
            throw e;
        }
    }

    public static String getLocalHost(boolean numeric) {
        InetAddress addr = Network.getLocalAddress();
        return numeric ? addr.getHostAddress() : addr.getHostName();
    }

    public static InetAddress getLocalAddress() {
        InetAddress addr = null;
        try {
            addr = InetAddress.getLocalHost();
        }
        catch (UnknownHostException ex) {
        }
        catch (NullPointerException ex) {
            // empty catch block
        }
        if (addr == null) {
            InetAddress loopback = null;
            try {
                Enumeration<NetworkInterface> ni = NetworkInterface.getNetworkInterfaces();
                while (addr == null && ni.hasMoreElements()) {
                    NetworkInterface i = ni.nextElement();
                    Enumeration<InetAddress> addrs = i.getInetAddresses();
                    while (addr == null && addrs.hasMoreElements()) {
                        InetAddress a = addrs.nextElement();
                        if (!a.isLoopbackAddress()) {
                            addr = a;
                            continue;
                        }
                        loopback = a;
                    }
                }
            }
            catch (java.net.SocketException e) {
                SocketException se = new SocketException();
                se.initCause(e);
                throw se;
            }
            if (addr == null) {
                addr = loopback;
            }
        }
        if (!$assertionsDisabled && addr == null) {
            throw new AssertionError();
        }
        return addr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SocketPair createPipe() {
        SocketPair fds = new SocketPair();
        ServerSocketChannel fd = Network.createTcpServerSocket();
        InetSocketAddress addr = new InetSocketAddress("127.0.0.1", 0);
        addr = Network.doBind(fd, addr);
        try {
            SocketChannel sink = Network.createTcpSocket();
            fds.sink = sink;
            try {
                Network.doConnect(sink, addr, -1);
                fds.source = Network.doAccept(fd, -1);
            }
            catch (LocalException ex) {
                try {
                    fds.sink.close();
                }
                catch (IOException e) {
                    // empty catch block
                }
                throw ex;
            }
        }
        finally {
            try {
                fd.close();
            }
            catch (IOException iOException) {}
        }
        return fds;
    }

    public static String fdToString(SelectableChannel fd) {
        if (fd == null) {
            return "<closed>";
        }
        InetAddress localAddr = null;
        InetAddress remoteAddr = null;
        int localPort = -1;
        int remotePort = -1;
        if (fd instanceof SocketChannel) {
            SocketChannel socketChannel = (SocketChannel)fd;
            Socket socket = socketChannel.socket();
            localAddr = socket.getLocalAddress();
            localPort = socket.getLocalPort();
            remoteAddr = socket.getInetAddress();
            remotePort = socket.getPort();
        } else if (fd instanceof DatagramChannel) {
            DatagramChannel datagramChannel = (DatagramChannel)fd;
            DatagramSocket socket = datagramChannel.socket();
            localAddr = socket.getLocalAddress();
            localPort = socket.getLocalPort();
            remoteAddr = socket.getInetAddress();
            remotePort = socket.getPort();
        } else if (!$assertionsDisabled) {
            throw new AssertionError();
        }
        StringBuffer s = new StringBuffer();
        s.append("local address = ");
        s.append(localAddr.getHostAddress());
        s.append(':');
        s.append(localPort);
        if (remoteAddr == null) {
            s.append("\nremote address = <not connected>");
        } else {
            s.append("\nremote address = ");
            s.append(remoteAddr.getHostAddress());
            s.append(':');
            s.append(remotePort);
        }
        return s.toString();
    }

    public static String addrToString(InetSocketAddress addr) {
        StringBuffer s = new StringBuffer();
        s.append(addr.getAddress().getHostAddress());
        s.append(':');
        s.append(addr.getPort());
        return s.toString();
    }

    static {
        $assertionsDisabled = !Network.class.desiredAssertionStatus();
    }

    public static final class SocketPair {
        public AbstractSelectableChannel source;
        public WritableByteChannel sink;
    }
}

