/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.CloseConnectionException;
import Ice.FacetNotExistException;
import Ice.Identity;
import Ice.LocalException;
import Ice.MarshalException;
import Ice.ObjectNotExistException;
import Ice.ObjectPrx;
import Ice.ObjectPrxHelperBase;
import Ice.OperationMode;
import Ice.OperationNotExistException;
import Ice.RequestFailedException;
import Ice.UnknownException;
import Ice.UnknownLocalException;
import Ice.UnknownReplyStatusException;
import Ice.UnknownUserException;
import IceInternal.BasicStream;
import IceInternal.Connection;
import IceInternal.ProxyFactory;
import IceInternal.Reference;
import IceUtil.OutputBase;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Iterator;
import java.util.Map;

public abstract class OutgoingAsync {
    protected BasicStream __is;
    protected BasicStream __os;
    private Reference _reference;
    private Connection _connection;
    private int _cnt;
    private OperationMode _mode;
    private volatile long _absoluteTimeoutMillis;
    private final Object _monitor = new Object();
    static final /* synthetic */ boolean $assertionsDisabled;

    public abstract void ice_exception(LocalException var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void __finished(BasicStream is) {
        Object object = this._monitor;
        synchronized (object) {
            byte status;
            try {
                this.__is.swap(is);
                status = this.__is.readByte();
                switch (status) {
                    case 0: 
                    case 1: {
                        this.__is.startReadEncaps();
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: {
                        String facet;
                        Identity id = new Identity();
                        id.__read(this.__is);
                        String[] facetPath = this.__is.readStringSeq();
                        if (facetPath.length > 0) {
                            if (facetPath.length > 1) {
                                throw new MarshalException();
                            }
                            facet = facetPath[0];
                        } else {
                            facet = "";
                        }
                        String operation = this.__is.readString();
                        RequestFailedException ex = null;
                        switch (status) {
                            case 2: {
                                ex = new ObjectNotExistException();
                                break;
                            }
                            case 3: {
                                ex = new FacetNotExistException();
                                break;
                            }
                            case 4: {
                                ex = new OperationNotExistException();
                                break;
                            }
                            default: {
                                if (!$assertionsDisabled) {
                                    throw new AssertionError();
                                }
                                break;
                            }
                        }
                        ex.id = id;
                        ex.facet = facet;
                        ex.operation = operation;
                        throw ex;
                    }
                    case 5: 
                    case 6: 
                    case 7: {
                        String unknown = this.__is.readString();
                        UnknownException ex = null;
                        switch (status) {
                            case 7: {
                                ex = new UnknownException();
                                break;
                            }
                            case 5: {
                                ex = new UnknownLocalException();
                                break;
                            }
                            case 6: {
                                ex = new UnknownUserException();
                                break;
                            }
                            default: {
                                if (!$assertionsDisabled) {
                                    throw new AssertionError();
                                }
                                break;
                            }
                        }
                        ex.unknown = unknown;
                        throw ex;
                    }
                    default: {
                        throw new UnknownReplyStatusException();
                    }
                }
            }
            catch (LocalException ex) {
                this.__finished(ex);
                return;
            }
            if (!$assertionsDisabled && status != 0 && status != 1) {
                throw new AssertionError();
            }
            try {
                this.__response(status == 0);
            }
            catch (Exception ex) {
                this.warning(ex);
            }
            finally {
                this.cleanup();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void __finished(LocalException exc) {
        Object object = this._monitor;
        synchronized (object) {
            if (this._reference != null) {
                if (this._reference.locatorInfo != null) {
                    this._reference.locatorInfo.clearObjectCache(this._reference);
                }
                boolean doRetry = false;
                if (this._mode == OperationMode.Nonmutating || this._mode == OperationMode.Idempotent || exc instanceof CloseConnectionException) {
                    try {
                        ProxyFactory proxyFactory = this._reference.instance.proxyFactory();
                        if (proxyFactory == null) {
                            throw exc;
                        }
                        this._cnt = proxyFactory.checkRetryAfterException(exc, this._cnt);
                        doRetry = true;
                    }
                    catch (LocalException ex) {
                        // empty catch block
                    }
                }
                if (doRetry) {
                    this._connection = null;
                    this.__send();
                    return;
                }
            }
            try {
                this.ice_exception(exc);
            }
            catch (Exception ex) {
                this.warning(ex);
            }
            finally {
                this.cleanup();
            }
        }
    }

    public final boolean __timedOut() {
        if (this._absoluteTimeoutMillis > 0L) {
            return System.currentTimeMillis() >= this._absoluteTimeoutMillis;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void __prepare(ObjectPrx prx, String operation, OperationMode mode, Map context) {
        Object object = this._monitor;
        synchronized (object) {
            try {
                while (this._reference != null) {
                    try {
                        this._monitor.wait();
                    }
                    catch (InterruptedException ex) {}
                }
                this._reference = ((ObjectPrxHelperBase)prx).__reference();
                if (!$assertionsDisabled && this._connection != null) {
                    throw new AssertionError();
                }
                this._connection = this._reference.getConnection();
                this._cnt = 0;
                this._mode = mode;
                if (!$assertionsDisabled && this.__is != null) {
                    throw new AssertionError();
                }
                this.__is = new BasicStream(this._reference.instance);
                if (!$assertionsDisabled && this.__os != null) {
                    throw new AssertionError();
                }
                this.__os = new BasicStream(this._reference.instance);
                if (this._reference.routerInfo != null) {
                    this._reference.routerInfo.addProxy(prx);
                }
                this._connection.prepareRequest(this.__os);
                this._reference.identity.__write(this.__os);
                if (this._reference.facet == null || this._reference.facet.length() == 0) {
                    this.__os.writeStringSeq(null);
                } else {
                    String[] facetPath = new String[]{this._reference.facet};
                    this.__os.writeStringSeq(facetPath);
                }
                this.__os.writeString(operation);
                this.__os.writeByte((byte)mode.value());
                if (context == null) {
                    this.__os.writeSize(0);
                } else {
                    int sz = context.size();
                    this.__os.writeSize(sz);
                    if (sz > 0) {
                        Iterator i = context.entrySet().iterator();
                        while (i.hasNext()) {
                            Map.Entry entry = i.next();
                            this.__os.writeString((String)entry.getKey());
                            this.__os.writeString((String)entry.getValue());
                        }
                    }
                }
                this.__os.startWriteEncaps();
            }
            catch (LocalException ex) {
                this.cleanup();
                throw ex;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void __send() {
        Object object = this._monitor;
        synchronized (object) {
            try {
                while (true) {
                    if (this._connection == null) {
                        this._connection = this._reference.getConnection();
                    }
                    this._absoluteTimeoutMillis = this._connection.timeout() >= 0 ? System.currentTimeMillis() + (long)this._connection.timeout() : 0L;
                    try {
                        this._connection.sendAsyncRequest(this.__os, this);
                        return;
                    }
                    catch (LocalException ex) {
                        ProxyFactory proxyFactory;
                        if (this._reference.locatorInfo != null) {
                            this._reference.locatorInfo.clearObjectCache(this._reference);
                        }
                        if ((proxyFactory = this._reference.instance.proxyFactory()) == null) {
                            throw ex;
                        }
                        this._cnt = proxyFactory.checkRetryAfterException(ex, this._cnt);
                        this._connection = null;
                        continue;
                    }
                    break;
                }
            }
            catch (LocalException ex) {
                this.__finished(ex);
            }
        }
    }

    protected abstract void __response(boolean var1);

    private final void warning(Exception ex) {
        if (this._reference != null && this._reference.instance.properties().getPropertyAsIntWithDefault("Ice.Warn.AMICallback", 1) > 0) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            OutputBase out = new OutputBase(pw);
            out.setUseTab(false);
            out.print("exception raised by AMI callback:\n");
            ex.printStackTrace(pw);
            pw.flush();
            this._reference.instance.logger().warning(sw.toString());
        }
    }

    private final void cleanup() {
        this._reference = null;
        this._connection = null;
        if (this.__is != null) {
            this.__is.destroy();
            this.__is = null;
        }
        if (this.__os != null) {
            this.__os.destroy();
            this.__os = null;
        }
        this._monitor.notify();
    }

    static {
        $assertionsDisabled = !OutgoingAsync.class.desiredAssertionStatus();
    }
}

