/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.CommunicatorDestroyedException;
import Ice.LocalException;
import Ice.ObjectAdapter;
import Ice.ObjectPrx;
import Ice.ObjectPrxHelperBase;
import Ice.RouterPrx;
import IceInternal.Connection;
import IceInternal.Connector;
import IceInternal.DefaultsAndOverrides;
import IceInternal.Endpoint;
import IceInternal.Instance;
import IceInternal.RouterInfo;
import IceInternal.TraceLevels;
import IceInternal.Transceiver;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;

public class OutgoingConnectionFactory {
    private final Instance _instance;
    private boolean _destroyed;
    private HashMap _connections = new HashMap();
    private HashSet _pending = new HashSet();
    static final /* synthetic */ boolean $assertionsDisabled;

    public synchronized void destroy() {
        if (this._destroyed) {
            return;
        }
        Iterator p = this._connections.values().iterator();
        while (p.hasNext()) {
            LinkedList connectionList = (LinkedList)p.next();
            Iterator q = connectionList.iterator();
            while (q.hasNext()) {
                Connection connection = (Connection)q.next();
                connection.destroy(1);
            }
        }
        this._destroyed = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitUntilFinished() {
        HashMap connections;
        OutgoingConnectionFactory outgoingConnectionFactory = this;
        synchronized (outgoingConnectionFactory) {
            while (!this._destroyed || !this._pending.isEmpty()) {
                try {
                    this.wait();
                }
                catch (InterruptedException ex) {}
            }
            connections = this._connections;
            this._connections = new HashMap();
        }
        Iterator p = connections.values().iterator();
        while (p.hasNext()) {
            LinkedList connectionList = (LinkedList)p.next();
            Iterator q = connectionList.iterator();
            while (q.hasNext()) {
                Connection connection = (Connection)q.next();
                connection.waitUntilFinished();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection create(Endpoint[] endpoints) {
        if (!$assertionsDisabled && endpoints.length <= 0) {
            throw new AssertionError();
        }
        OutgoingConnectionFactory outgoingConnectionFactory = this;
        synchronized (outgoingConnectionFactory) {
            int i;
            if (this._destroyed) {
                throw new CommunicatorDestroyedException();
            }
            Iterator p = this._connections.values().iterator();
            while (p.hasNext()) {
                LinkedList connectionList = (LinkedList)p.next();
                Iterator q = connectionList.iterator();
                while (q.hasNext()) {
                    Connection con = (Connection)q.next();
                    if (!con.isFinished()) continue;
                    q.remove();
                }
                if (!connectionList.isEmpty()) continue;
                p.remove();
            }
            DefaultsAndOverrides defaultsAndOverrides = this._instance.defaultsAndOverrides();
            for (i = 0; i < endpoints.length; ++i) {
                if (!defaultsAndOverrides.overrideTimeout) continue;
                endpoints[i] = endpoints[i].timeout(defaultsAndOverrides.overrideTimeoutValue);
            }
            for (i = 0; i < endpoints.length; ++i) {
                LinkedList connectionList = (LinkedList)this._connections.get(endpoints[i]);
                if (connectionList == null) continue;
                Iterator q = connectionList.iterator();
                while (q.hasNext()) {
                    Connection connection = (Connection)q.next();
                    if (connection.isDestroyed()) continue;
                    return connection;
                }
            }
            boolean searchAgain = false;
            while (!this._destroyed) {
                int i2;
                for (i2 = 0; i2 < endpoints.length && !this._pending.contains(endpoints[i2]); ++i2) {
                }
                if (i2 == endpoints.length) break;
                searchAgain = true;
                try {
                    this.wait();
                }
                catch (InterruptedException ex) {}
            }
            if (this._destroyed) {
                throw new CommunicatorDestroyedException();
            }
            if (searchAgain) {
                for (int i3 = 0; i3 < endpoints.length; ++i3) {
                    LinkedList connectionList = (LinkedList)this._connections.get(endpoints[i3]);
                    if (connectionList == null) continue;
                    Iterator q = connectionList.iterator();
                    while (q.hasNext()) {
                        Connection connection = (Connection)q.next();
                        if (connection.isDestroyed()) continue;
                        return connection;
                    }
                }
            }
            for (int i4 = 0; i4 < endpoints.length; ++i4) {
                this._pending.add(endpoints[i4]);
            }
        }
        Connection connection = null;
        LocalException exception = null;
        for (int i = 0; i < endpoints.length; ++i) {
            Endpoint endpoint = endpoints[i];
            try {
                Transceiver transceiver = endpoint.clientTransceiver();
                if (transceiver == null) {
                    Connector connector = endpoint.connector();
                    if (!$assertionsDisabled && connector == null) {
                        throw new AssertionError();
                    }
                    DefaultsAndOverrides defaultsAndOverrides = this._instance.defaultsAndOverrides();
                    int timeout = defaultsAndOverrides.overrideConnectTimeout ? defaultsAndOverrides.overrideConnectTimeoutValue : endpoint.timeout();
                    transceiver = connector.connect(timeout);
                    if (!$assertionsDisabled && transceiver == null) {
                        throw new AssertionError();
                    }
                }
                connection = new Connection(this._instance, transceiver, endpoint, null);
                connection.validate();
                break;
            }
            catch (LocalException ex) {
                exception = ex;
                TraceLevels traceLevels = this._instance.traceLevels();
                if (traceLevels.retry < 2) continue;
                StringBuffer s = new StringBuffer();
                s.append("connection to endpoint failed");
                if (i < endpoints.length - 1) {
                    s.append(", trying next endpoint\n");
                } else {
                    s.append(" and no more endpoints to try\n");
                }
                s.append(exception.toString());
                this._instance.logger().trace(traceLevels.retryCat, s.toString());
                continue;
            }
        }
        OutgoingConnectionFactory outgoingConnectionFactory2 = this;
        synchronized (outgoingConnectionFactory2) {
            for (int i = 0; i < endpoints.length; ++i) {
                this._pending.remove(endpoints[i]);
            }
            this.notifyAll();
            if (connection == null) {
                if (!$assertionsDisabled && exception == null) {
                    throw new AssertionError();
                }
                throw exception;
            }
            LinkedList<Connection> connectionList = (LinkedList<Connection>)this._connections.get(connection.endpoint());
            if (connectionList == null) {
                connectionList = new LinkedList<Connection>();
                this._connections.put(connection.endpoint(), connectionList);
            }
            connectionList.add(connection);
            if (this._destroyed) {
                connection.destroy(1);
                throw new CommunicatorDestroyedException();
            }
            connection.activate();
        }
        if (!$assertionsDisabled && connection == null) {
            throw new AssertionError();
        }
        return connection;
    }

    public synchronized void setRouter(RouterPrx router) {
        if (this._destroyed) {
            throw new CommunicatorDestroyedException();
        }
        RouterInfo routerInfo = this._instance.routerManager().get(router);
        if (routerInfo != null) {
            ObjectPrx proxy = routerInfo.getClientProxy();
            ObjectAdapter adapter = routerInfo.getAdapter();
            DefaultsAndOverrides defaultsAndOverrides = this._instance.defaultsAndOverrides();
            Endpoint[] endpoints = ((ObjectPrxHelperBase)proxy).__reference().endpoints;
            for (int i = 0; i < endpoints.length; ++i) {
                LinkedList connectionList;
                Endpoint endpoint = endpoints[i];
                if (defaultsAndOverrides.overrideTimeout) {
                    endpoint = endpoint.timeout(defaultsAndOverrides.overrideTimeoutValue);
                }
                if ((connectionList = (LinkedList)this._connections.get(endpoints[i])) == null) continue;
                Iterator p = connectionList.iterator();
                while (p.hasNext()) {
                    Connection connection = (Connection)p.next();
                    connection.setAdapter(adapter);
                }
            }
        }
    }

    public synchronized void removeAdapter(ObjectAdapter adapter) {
        if (this._destroyed) {
            throw new CommunicatorDestroyedException();
        }
        Iterator p = this._connections.values().iterator();
        while (p.hasNext()) {
            LinkedList connectionList = (LinkedList)p.next();
            Iterator q = connectionList.iterator();
            while (q.hasNext()) {
                Connection connection = (Connection)q.next();
                if (connection.getAdapter() != adapter) continue;
                connection.setAdapter(null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushBatchRequests() {
        LinkedList c = new LinkedList();
        OutgoingConnectionFactory outgoingConnectionFactory = this;
        synchronized (outgoingConnectionFactory) {
            Iterator p = this._connections.values().iterator();
            while (p.hasNext()) {
                LinkedList connectionList = (LinkedList)p.next();
                Iterator q = connectionList.iterator();
                while (q.hasNext()) {
                    c.add(q.next());
                }
            }
        }
        Iterator p = c.iterator();
        while (p.hasNext()) {
            Connection conn = (Connection)p.next();
            if (!conn.isValidated()) continue;
            try {
                conn.flushBatchRequest();
            }
            catch (LocalException ex) {}
        }
    }

    OutgoingConnectionFactory(Instance instance) {
        this._instance = instance;
        this._destroyed = false;
    }

    protected void finalize() throws Throwable {
        if (!$assertionsDisabled && !this._destroyed) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !this._connections.isEmpty()) {
            throw new AssertionError();
        }
        super.finalize();
    }

    static {
        $assertionsDisabled = !OutgoingConnectionFactory.class.desiredAssertionStatus();
    }
}

