/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.program.gff;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashSet;
import java.util.Iterator;
import org.biojava.bio.BioError;
import org.biojava.bio.BioException;
import org.biojava.bio.program.gff.GFFEntrySet;
import org.biojava.bio.program.gff.GFFFilterer;
import org.biojava.bio.program.gff.GFFParser;
import org.biojava.bio.program.gff.GFFRecord;
import org.biojava.bio.program.gff.GFFRecordFilter;
import org.biojava.bio.program.gff.GFFWriter;
import org.biojava.bio.program.gff.SequencesAsGFF;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.SequenceIterator;
import org.biojava.bio.seq.db.IllegalIDException;
import org.biojava.bio.seq.db.SequenceDB;
import org.biojava.utils.ChangeVetoException;
import org.biojava.utils.ParserException;

public class GFFTools {
    public static double NO_SCORE = Double.NEGATIVE_INFINITY;
    public static int NO_FRAME = -1;

    public static GFFEntrySet readGFF(String fileName) throws FileNotFoundException, ParserException, BioException, IOException {
        return GFFTools.readGFF(fileName, GFFRecordFilter.ACCEPT_ALL);
    }

    public static GFFEntrySet readGFF(String fileName, GFFRecordFilter recFilt) throws FileNotFoundException, ParserException, BioException, IOException {
        GFFEntrySet gffEntries = new GFFEntrySet();
        GFFFilterer filterer = new GFFFilterer(gffEntries.getAddHandler(), recFilt);
        GFFParser parser = new GFFParser();
        parser.parse(new BufferedReader(new FileReader(fileName)), filterer);
        return gffEntries;
    }

    public static GFFEntrySet readGFF(File inFile) throws FileNotFoundException, ParserException, BioException, IOException {
        return GFFTools.readGFF(inFile, GFFRecordFilter.ACCEPT_ALL);
    }

    public static GFFEntrySet readGFF(File inFile, GFFRecordFilter recFilt) throws FileNotFoundException, ParserException, BioException, IOException {
        GFFEntrySet gffEntries = new GFFEntrySet();
        GFFFilterer filterer = new GFFFilterer(gffEntries.getAddHandler(), recFilt);
        GFFParser parser = new GFFParser();
        parser.parse(new BufferedReader(new FileReader(inFile)), filterer);
        return gffEntries;
    }

    public static GFFEntrySet readGFF(BufferedReader gffIn) throws ParserException, BioException, IOException {
        return GFFTools.readGFF(gffIn, GFFRecordFilter.ACCEPT_ALL);
    }

    public static GFFEntrySet readGFF(BufferedReader gffIn, GFFRecordFilter recFilt) throws ParserException, BioException, IOException {
        GFFEntrySet gffEntries = new GFFEntrySet();
        GFFFilterer filterer = new GFFFilterer(gffEntries.getAddHandler(), recFilt);
        GFFParser parser = new GFFParser();
        parser.parse(gffIn, filterer);
        return gffEntries;
    }

    public static void writeGFF(String fileName, GFFEntrySet ents) throws IOException {
        PrintWriter pw = new PrintWriter(new FileWriter(fileName));
        GFFTools.writeGFF(pw, ents);
        pw.close();
    }

    public static void writeGFF(File outFile, GFFEntrySet ents) throws IOException {
        PrintWriter pw = new PrintWriter(new FileWriter(outFile));
        GFFTools.writeGFF(pw, ents);
        pw.close();
    }

    public static void writeGFF(PrintWriter pw, GFFEntrySet ents) throws IOException {
        GFFWriter writer = new GFFWriter(pw);
        ents.streamRecords(writer);
    }

    public static Sequence annotateSequence(Sequence seq, GFFEntrySet ents) {
        Sequence annotated;
        try {
            annotated = ents.getAnnotator().annotate(seq);
        }
        catch (ChangeVetoException ex) {
            throw new BioError("Assertion Error: Unable to annotate sequence", ex);
        }
        catch (BioException ex) {
            throw new BioError("Assertion Error: Unable to annotate sequence", ex);
        }
        return annotated;
    }

    public static Sequence annotateSequence(Sequence seq, GFFEntrySet ents, boolean checkSeqName) {
        Sequence annotated;
        try {
            annotated = ents.getAnnotator(checkSeqName).annotate(seq);
        }
        catch (ChangeVetoException ex) {
            throw new BioError("Assertion Error: Unable to annotate sequence", ex);
        }
        catch (BioException ex) {
            throw new BioError("Assertion Error: Unable to annotate sequence", ex);
        }
        return annotated;
    }

    public static SequenceDB annotateSequences(SequenceDB seqs, GFFEntrySet ents) throws IllegalIDException, BioException {
        HashSet<String> names = new HashSet<String>();
        Iterator i = ents.lineIterator();
        while (i.hasNext()) {
            GFFRecord record = (GFFRecord)i.next();
            if (names.contains(record.getSeqName())) continue;
            names.add(record.getSeqName());
        }
        i = names.iterator();
        while (i.hasNext()) {
            final String name = (String)i.next();
            GFFRecordFilter filt = new GFFRecordFilter(){

                public boolean accept(GFFRecord rec) {
                    return rec.getSeqName().equals(name);
                }
            };
            GFFEntrySet filtered = ents.filter(filt);
            Sequence seq = seqs.getSequence(name);
            seq = GFFTools.annotateSequence(seq, filtered);
        }
        return seqs;
    }

    public static GFFEntrySet gffFromSequence(Sequence seq) throws BioException {
        SequencesAsGFF sagff = new SequencesAsGFF();
        GFFEntrySet gffES = new GFFEntrySet();
        sagff.processSequence(seq, gffES.getAddHandler());
        return gffES;
    }

    public static GFFEntrySet gffFromSeqDB(SequenceDB seqDB) throws BioException {
        GFFEntrySet gffES = new GFFEntrySet();
        SequenceIterator si = seqDB.sequenceIterator();
        while (si.hasNext()) {
            Sequence seq = si.nextSequence();
            SequencesAsGFF sagff = new SequencesAsGFF();
            sagff.processSequence(seq, gffES.getAddHandler());
        }
        return gffES;
    }
}

