/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.ontology;

import java.io.Serializable;
import org.biojava.bio.Annotation;
import org.biojava.ontology.AbstractTerm;
import org.biojava.ontology.Ontology;
import org.biojava.ontology.Term;

public interface RemoteTerm
extends Term {
    public Term getRemoteTerm();

    public static final class Impl
    extends AbstractTerm
    implements RemoteTerm,
    Serializable {
        private final Ontology ontology;
        private final Term remoteTerm;
        private final String name;

        public Impl(Ontology ontology, Term remoteTerm, String name) {
            if (ontology == null) {
                throw new NullPointerException("Ontology must not be null");
            }
            if (remoteTerm == null) {
                throw new NullPointerException("RemoteTerm must not be null");
            }
            if (name == null) {
                name = remoteTerm.getOntology().getName() + "." + remoteTerm.getName();
            }
            this.ontology = ontology;
            this.remoteTerm = remoteTerm;
            this.name = name;
        }

        public String getName() {
            return this.getOntology().getName() + ":" + this.remoteTerm.getName();
        }

        public String getDescription() {
            return this.remoteTerm.getDescription();
        }

        public Ontology getOntology() {
            return this.ontology;
        }

        public Term getRemoteTerm() {
            return this.remoteTerm;
        }

        public String toString() {
            return this.name;
        }

        public Annotation getAnnotation() {
            return this.remoteTerm.getAnnotation();
        }
    }
}

