/*
 * Decompiled with CFR 0.152.
 */
package MCview;

import MCview.Bond;
import MCview.Residue;
import MCview.myAtom;
import jalview.DrawableSequence;
import jalview.ResidueProperties;
import jalview.Sequence;
import java.awt.Color;
import java.util.Vector;

public class PDBChain {
    public String id;
    public Vector bonds = new Vector();
    public Vector atoms = new Vector();
    public Vector residues = new Vector();
    public int offset;
    public Sequence sequence;
    public boolean isVisible = false;
    public DrawableSequence ds;

    public PDBChain(String id) {
        this.id = id;
    }

    public String print() {
        String tmp = "";
        int i = 0;
        while (i < this.bonds.size()) {
            tmp = String.valueOf(tmp) + ((Bond)this.bonds.elementAt((int)i)).at1.resName + " " + ((Bond)this.bonds.elementAt((int)i)).at1.resNumber + " " + this.offset + "\n";
            ++i;
        }
        return tmp;
    }

    public void makeCaBondList() {
        int i = 0;
        while (i < this.residues.size() - 1) {
            Residue tmpres = (Residue)this.residues.elementAt(i);
            Residue tmpres2 = (Residue)this.residues.elementAt(i + 1);
            myAtom at1 = tmpres.findAtom("CA");
            myAtom at2 = tmpres2.findAtom("CA");
            if (at1 != null && at2 != null && at1.chain.equals(at2.chain)) {
                this.makeBond(at1, at2);
            }
            ++i;
        }
    }

    public void makeBond(myAtom at1, myAtom at2) {
        float[] start = new float[3];
        float[] end = new float[3];
        start[0] = at1.x;
        start[1] = at1.y;
        start[2] = at1.z;
        end[0] = at2.x;
        end[1] = at2.y;
        end[2] = at2.z;
        this.bonds.addElement(new Bond(start, end, at1, at2));
    }

    public void makeResidueList() {
        int count = 0;
        String seq2 = "";
        int i = 0;
        while (i < this.atoms.size()) {
            int resNumber;
            myAtom tmp = (myAtom)this.atoms.elementAt(i);
            String cfr_ignored_0 = tmp.resName;
            int res = resNumber = tmp.resNumber;
            if (i == 0) {
                this.offset = resNumber;
            }
            Vector<myAtom> resAtoms = new Vector<myAtom>();
            resAtoms.addElement((myAtom)this.atoms.elementAt(i));
            resNumber = ((myAtom)this.atoms.elementAt((int)(++i))).resNumber;
            while (resNumber == res && i < this.atoms.size()) {
                resAtoms.addElement((myAtom)this.atoms.elementAt(i));
                if (++i < this.atoms.size()) {
                    resNumber = ((myAtom)this.atoms.elementAt((int)i)).resNumber;
                    continue;
                }
                ++resNumber;
            }
            --i;
            this.residues.addElement(new Residue(resAtoms, resNumber - 1, count));
            ++count;
            Residue tmpres = (Residue)this.residues.lastElement();
            myAtom tmpat = (myAtom)tmpres.atoms.elementAt(0);
            String tmpres2 = ResidueProperties.aa[(Integer)ResidueProperties.aa3Hash.get(tmpat.resName)];
            seq2 = String.valueOf(seq2) + tmpres2;
            ++i;
        }
        this.sequence = new Sequence("PDB_seq", seq2, 1, seq2.length());
        System.out.println("Sequence = " + seq2);
        System.out.println("No of residues = " + this.residues.size());
    }

    public void setChargeColours() {
        int i = 0;
        while (i < this.bonds.size()) {
            Bond b;
            try {
                b = (Bond)this.bonds.elementAt(i);
                if (b.at1.resName.toUpperCase().equals("ASP") || b.at1.resName.toUpperCase().equals("GLU")) {
                    b.startCol = Color.red;
                } else if (b.at1.resName.toUpperCase().equals("LYS") || b.at1.resName.toUpperCase().equals("ARG")) {
                    b.startCol = Color.blue;
                } else if (b.at1.resName.toUpperCase().equals("CYS")) {
                    b.startCol = Color.yellow;
                } else {
                    ((Integer)ResidueProperties.aa3Hash.get(b.at1.resName.toUpperCase())).intValue();
                    b.startCol = Color.lightGray;
                }
                if (b.at2.resName.toUpperCase().equals("ASP") || b.at2.resName.toUpperCase().equals("GLU")) {
                    b.endCol = Color.red;
                } else if (b.at2.resName.toUpperCase().equals("LYS") || b.at2.resName.toUpperCase().equals("ARG")) {
                    b.endCol = Color.blue;
                } else if (b.at2.resName.toUpperCase().equals("CYS")) {
                    b.endCol = Color.yellow;
                } else {
                    ((Integer)ResidueProperties.aa3Hash.get(b.at2.resName.toUpperCase())).intValue();
                    b.endCol = Color.lightGray;
                }
            }
            catch (Exception exception) {
                b = (Bond)this.bonds.elementAt(i);
                b.startCol = Color.gray;
                b.endCol = Color.gray;
            }
            ++i;
        }
    }

    public void setHydrophobicityColours() {
        int i = 0;
        while (i < this.bonds.size()) {
            Bond b;
            try {
                b = (Bond)this.bonds.elementAt(i);
                int atno = (Integer)ResidueProperties.aa3Hash.get(b.at1.resName.toUpperCase());
                float red = ((float)ResidueProperties.hyd[atno] - -3.9f) / 8.4f;
                if (red > 1.0f) {
                    red = 1.0f;
                }
                if (red < 0.0f) {
                    red = 0.0f;
                }
                b.startCol = new Color(red, 0.0f, 1.0f - red);
                atno = (Integer)ResidueProperties.aa3Hash.get(b.at2.resName.toUpperCase());
                red = ((float)ResidueProperties.hyd[atno] - -3.9f) / 8.4f;
                if (red > 1.0f) {
                    red = 1.0f;
                }
                if (red < 0.0f) {
                    red = 0.0f;
                }
                b.endCol = new Color(red, 0.2f, 1.0f - red);
            }
            catch (Exception exception) {
                b = (Bond)this.bonds.elementAt(i);
                b.startCol = Color.gray;
                b.endCol = Color.gray;
            }
            ++i;
        }
    }

    public void colourBySequence() {
        this.colourBySequence(this.ds);
    }

    public void colourBySequence(DrawableSequence seq2) {
        int i = 0;
        while (i < this.bonds.size()) {
            Bond tmp = (Bond)this.bonds.elementAt(i);
            try {
                int index;
                int pos;
                if (tmp.at1.resNumber >= this.offset + seq2.pdbstart - 1 && tmp.at1.resNumber <= this.offset + seq2.pdbend - 1) {
                    pos = seq2.seqstart + (tmp.at1.resNumber - seq2.pdbstart - this.offset);
                    index = seq2.findIndex(pos);
                    tmp.startCol = (Color)seq2.boxColour.elementAt(index);
                } else {
                    tmp.startCol = Color.gray;
                }
                if (tmp.at2.resNumber >= this.offset + seq2.pdbstart - 1 && tmp.at2.resNumber <= seq2.pdbend + this.offset - 1) {
                    pos = seq2.seqstart + (tmp.at2.resNumber - seq2.pdbstart - this.offset);
                    index = seq2.findIndex(pos);
                    tmp.endCol = (Color)seq2.boxColour.elementAt(index);
                } else {
                    tmp.endCol = Color.gray;
                }
            }
            catch (Exception exception) {
                tmp.startCol = Color.lightGray;
                tmp.endCol = Color.lightGray;
            }
            ++i;
        }
    }

    public void setChainColours() {
        int i = 0;
        while (i < this.bonds.size()) {
            Bond tmp = (Bond)this.bonds.elementAt(i);
            try {
                tmp.startCol = (Color)ResidueProperties.chainColours.get(this.id);
                tmp.endCol = (Color)ResidueProperties.chainColours.get(this.id);
            }
            catch (Exception exception) {
                tmp.startCol = Color.lightGray;
                tmp.endCol = Color.lightGray;
            }
            ++i;
        }
    }
}

