/*
 * Decompiled with CFR 0.152.
 */
package bilab;

import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class SizedComposite
extends Composite {
    int minWidth;
    int minHeight;
    int maxWidth;
    int maxHeight;
    int prefWidth;
    int prefHeight;

    public SizedComposite(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new FillLayout());
        this.prefWidth = 200;
        this.maxWidth = 200;
        this.minWidth = 200;
        this.prefHeight = 200;
        this.maxHeight = 200;
        this.minHeight = 200;
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        return this.computeSize(wHint, hHint);
    }

    public Point computeSize(int wHint, int hHint) {
        int width = this.prefWidth;
        int height = this.prefHeight;
        if (wHint != -1) {
            width = wHint;
            if (width < this.minWidth) {
                width = this.minWidth;
            }
            if (width > this.maxWidth) {
                width = this.maxWidth;
            }
        }
        if (hHint != -1) {
            height = hHint;
            if (height < this.minHeight) {
                height = this.minHeight;
            }
            if (height > this.maxHeight) {
                height = this.maxHeight;
            }
        }
        return new Point(width, height);
    }

    public void setMinimumSize(int width, int height) {
        this.minWidth = width;
        if (this.minWidth > this.maxWidth) {
            this.maxWidth = this.minWidth;
        }
        if (this.minWidth > this.prefWidth) {
            this.prefWidth = this.minWidth;
        }
        this.minHeight = height;
        if (this.minHeight > this.maxHeight) {
            this.maxHeight = this.minHeight;
        }
        if (this.minHeight > this.prefHeight) {
            this.prefHeight = this.minHeight;
        }
    }

    public void setMinimumSize(Point p) {
        this.setMinimumSize(p.x, p.y);
    }

    public void setMaximumSize(int width, int height) {
        this.maxWidth = width;
        if (this.maxWidth < this.prefWidth) {
            this.prefWidth = this.maxWidth;
        }
        if (this.maxWidth < this.minWidth) {
            this.minWidth = this.maxWidth;
        }
        this.maxHeight = height;
        if (this.maxHeight < this.prefHeight) {
            this.prefHeight = this.maxHeight;
        }
        if (this.maxHeight < this.minHeight) {
            this.minHeight = this.maxHeight;
        }
    }

    public void setMaximumSize(Point p) {
        this.setMaximumSize(p.x, p.y);
    }

    public void setPreferedSize(int width, int height) {
        this.prefWidth = width;
        if (this.prefWidth > this.maxWidth) {
            this.maxWidth = this.prefWidth;
        }
        if (this.prefWidth < this.minWidth) {
            this.minWidth = this.prefWidth;
        }
        this.prefHeight = height;
        if (this.prefHeight > this.maxHeight) {
            this.maxHeight = this.prefHeight;
        }
        if (this.prefHeight < this.minHeight) {
            this.minHeight = this.prefHeight;
        }
    }

    public void setPreferedSize(Point p) {
        this.setPreferedSize(p.x, p.y);
    }
}

