/*
 * Decompiled with CFR 0.152.
 */
package bilab.notebook;

import bilab.BilabException;
import bilab.Notify;
import bilab.Util;
import bilab.io.IFileSystem;
import bilab.io.LocalFileSystem;
import bilab.notebook.INotebookStore;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.TimeZone;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileSystemNotebookStore
implements INotebookStore {
    protected static FileSystemNotebookStore instance = null;
    protected HashMap<String, IFileSystem> fsCache = new HashMap();
    protected static final String formatVersion = "Bilab 1.1";
    protected static final String versionIndexFile = "versions.xml";
    protected static final String sectionIndexFile = "sections.xml";
    protected static final String annotationsFile = "annotations.xml";
    protected DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
    protected TransformerFactory transFactory = TransformerFactory.newInstance();
    protected static final Calendar calendar = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
    protected static DateFormat dateTimeFormatter = DateFormat.getDateTimeInstance(1, 1);

    static {
        dateTimeFormatter.setTimeZone(TimeZone.getTimeZone("UTC"));
    }

    protected FileSystemNotebookStore() {
    }

    public static FileSystemNotebookStore getInstance() {
        if (instance == null) {
            instance = new FileSystemNotebookStore();
        }
        return instance;
    }

    public static boolean isAbsolutePath(String path) {
        if (path.length() < 1) {
            return false;
        }
        if (path.startsWith("/") || path.startsWith("\\")) {
            return true;
        }
        if (path.length() < 3) {
            return false;
        }
        return path.substring(1, 3).equals(":/") || path.substring(1, 3).equals(":\\");
    }

    @Override
    public String createNotebook(String locationURI, String name) throws URISyntaxException, IOException {
        URI locURI = null;
        locURI = FileSystemNotebookStore.isAbsolutePath(locationURI) ? new URI("file", null, locationURI, null, null) : new URI(locationURI);
        if (!locURI.getScheme().equals("file")) {
            throw new BilabException("only file: URIs are valid for the location of a local notebook");
        }
        String notebookURI = null;
        IFileSystem fs = null;
        try {
            String locPath = locURI.getPath();
            notebookURI = new File(String.valueOf(locPath) + "/" + name).toURI().toString();
            if (notebookURI.endsWith(".xml")) {
                Notify.unimplemented(this);
            } else {
                LocalFileSystem localRootFS = new LocalFileSystem("/");
                if (!localRootFS.changeDir(locURI.getPath())) {
                    throw new BilabException("location '" + locURI + "' doesn't exist");
                }
                localRootFS.makeDirectory(name);
                NotebookItemInfo info = this.getNotebookItemInfo(notebookURI);
                fs = this.getNotebookFilesystem(info);
            }
            Versions versions = new Versions();
            Date now = new Date();
            String nowDateTime = dateTimeFormatter.format(now);
            versions.globalAnnotations.put("CreationDate", nowDateTime);
            versions.versions.add("current");
            this.writeVersionIndex(fs, versions);
            fs.changeDir("/");
            fs.makeDirectory("current");
            fs.changeDir("current");
            Sections sections = new Sections();
            sections.annotations.put("CreationDate", nowDateTime);
            sections.sections.add("main");
            this.writeSectionIndex(fs, "current", sections);
            fs.makeDirectory("main");
            HashMap<String, String> sectionAnnotations = new HashMap<String, String>();
            sectionAnnotations.put("CreationDate", nowDateTime);
            this.writeAnnotationFile(fs, "current", "main", sectionAnnotations);
        }
        catch (Exception e) {
            String msg = e.getMessage() == null ? "" : " - " + e.getMessage();
            throw new BilabException("unable to create notebook '" + name + "' at location '" + locationURI + "' - " + msg, e);
        }
        return notebookURI;
    }

    @Override
    public boolean existsNotebook(String notebookURI) {
        try {
            NotebookItemInfo info = this.getNotebookItemInfo(notebookURI);
            if (this.getNotebookFilesystem(info) == null) {
                return false;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    @Override
    public String snapshotNotebookAsVersion(String notebookURI, String versionName) {
        return null;
    }

    @Override
    public String[] listNotebookVersionURIs(String notebookURI) throws URISyntaxException, IOException {
        String[] names = this.listNotebookVersionNames(notebookURI);
        String[] URIs = new String[names.length];
        NotebookItemInfo notebookInfo = this.getNotebookItemInfo(notebookURI);
        int nameIndex = 0;
        while (nameIndex < names.length) {
            notebookInfo.versionName = names[nameIndex];
            URIs[nameIndex] = notebookInfo.toURI();
            ++nameIndex;
        }
        return URIs;
    }

    @Override
    public String[] listNotebookVersionNames(String notebookURI) throws URISyntaxException, IOException {
        if (!this.existsNotebook(notebookURI)) {
            throw new IOException("notebook not found:" + notebookURI);
        }
        NotebookItemInfo info = this.getNotebookItemInfo(notebookURI);
        IFileSystem fs = this.getNotebookFilesystem(info);
        Versions versions = this.readVersionIndex(fs);
        return versions.versions.toArray(new String[0]);
    }

    @Override
    public String getCurrentNotebookVersion(String anyNotebookVersionURI) throws URISyntaxException {
        NotebookItemInfo info = this.getNotebookItemInfo(anyNotebookVersionURI);
        info.versionName = "current";
        return info.toURI();
    }

    @Override
    public void deleteNotebookAll(String notebookURI) throws URISyntaxException, IOException {
        String[] contents;
        if (!this.existsNotebook(notebookURI)) {
            throw new IOException("notebook not found:" + notebookURI);
        }
        NotebookItemInfo info = this.getNotebookItemInfo(notebookURI);
        IFileSystem fs = this.getNotebookFilesystem(info);
        String[] stringArray = contents = fs.listDirectoryContents("/");
        int n = 0;
        int n2 = stringArray.length;
        while (n < n2) {
            String item = stringArray[n];
            fs.delete(item, true);
            ++n;
        }
        LocalFileSystem localRootFS = new LocalFileSystem("/");
        localRootFS.changeDir("/" + info.notebookPath);
        localRootFS.delete(info.notebookName, true);
        this.removeNotebookFilesystem(info);
    }

    @Override
    public String[] listNotebookSectionURIs(String notebookURI) throws URISyntaxException, IOException {
        return null;
    }

    @Override
    public String[] listNotebookSectionNames(String notebookURI) throws URISyntaxException, IOException {
        return null;
    }

    protected NotebookItemInfo locateSection(NotebookItemInfo secInfo) throws URISyntaxException, IOException {
        IFileSystem fs = this.getNotebookFilesystem(secInfo);
        Versions versions = this.readVersionIndex(fs);
        if (secInfo.versionName.equals("current") && secInfo.sectionName.equals("last")) {
            NotebookItemInfo lastInfo = new NotebookItemInfo(secInfo);
            Sections sections = this.readSectionIndex(fs, "current");
            try {
                lastInfo.sectionName = sections.sections.getLast();
                return lastInfo;
            }
            catch (NoSuchElementException noSuchElementException) {
                return null;
            }
        }
        if (!versions.versions.contains(secInfo.versionName)) {
            throw new BilabException("Unknown version '" + secInfo.versionName + "' in notebook: " + secInfo.toURI());
        }
        boolean found = false;
        boolean foundDeleted = false;
        int versionIndex = versions.versions.indexOf(secInfo.versionName) + 1;
        while (!found && !foundDeleted && versionIndex >= 1) {
            Sections sections = this.readSectionIndex(fs, versions.versions.get(versionIndex - 1));
            if (sections.sections.contains(secInfo.sectionName)) {
                String sectionDir = "/" + versions.versions.get(versionIndex - 1) + "/" + secInfo.sectionName;
                if (fs.exists(sectionDir) && fs.isDirectory(sectionDir)) {
                    found = true;
                    continue;
                }
                --versionIndex;
                continue;
            }
            foundDeleted = true;
        }
        if (found) {
            NotebookItemInfo foundInfo = new NotebookItemInfo(secInfo);
            foundInfo.versionName = versions.versions.get(versionIndex - 1);
            return foundInfo;
        }
        return null;
    }

    @Override
    public String createSection(String notebookURI, String newSectionName, String insertAfterSectionURI) throws URISyntaxException, IOException {
        if (!this.existsNotebook(notebookURI)) {
            throw new IOException("notebook not found:" + notebookURI);
        }
        if (newSectionName.equals("last")) {
            throw new BilabException("'last' is not a valid notebook section name (it is reserved)");
        }
        notebookURI = this.getCurrentNotebookVersion(notebookURI);
        NotebookItemInfo info = this.getNotebookItemInfo(notebookURI);
        IFileSystem fs = this.getNotebookFilesystem(info);
        NotebookItemInfo physicalSecInfo = this.locateSection(info);
        if (physicalSecInfo != null) {
            throw new BilabException("a notebook section named '" + newSectionName + "' already exists in the current version");
        }
        NotebookItemInfo afterSectionInfo = null;
        if (insertAfterSectionURI != null) {
            afterSectionInfo = this.locateSection(this.getNotebookItemInfo(insertAfterSectionURI));
            if (afterSectionInfo == null) {
                throw new BilabException("unable to create new section after non-existant section:" + insertAfterSectionURI);
            }
        } else {
            insertAfterSectionURI = notebookURI;
            afterSectionInfo = this.getNotebookItemInfo(insertAfterSectionURI);
            afterSectionInfo.sectionName = "last";
            afterSectionInfo = this.locateSection(afterSectionInfo);
        }
        fs.changeDir("/current");
        fs.makeDirectory(newSectionName);
        HashMap<String, String> sectionAnnotations = new HashMap<String, String>();
        Date now = new Date();
        String nowDateTime = dateTimeFormatter.format(now);
        sectionAnnotations.put("CreationDate", nowDateTime);
        this.writeAnnotationFile(fs, "current", newSectionName, sectionAnnotations);
        Sections sections = this.readSectionIndex(fs, "current");
        if (afterSectionInfo == null) {
            sections.sections.addLast(newSectionName);
        } else {
            int afterSectionIndex = sections.sections.indexOf(afterSectionInfo.sectionName);
            sections.sections.add(afterSectionIndex + 1, newSectionName);
        }
        this.writeSectionIndex(fs, "current", sections);
        NotebookItemInfo newSectionInfo = this.getNotebookItemInfo(notebookURI);
        newSectionInfo.sectionName = newSectionName;
        newSectionInfo.page = -1;
        return newSectionInfo.toURI();
    }

    @Override
    public int getSectionCount(String notebookURI) throws URISyntaxException, IOException {
        if (!this.existsNotebook(notebookURI)) {
            throw new IOException("notebook not found:" + notebookURI);
        }
        NotebookItemInfo info = this.getNotebookItemInfo(notebookURI);
        IFileSystem fs = this.getNotebookFilesystem(info);
        Sections sections = this.readSectionIndex(fs, info.versionName);
        return sections.sections.size();
    }

    @Override
    public String getSectionURI(String notebookURI, int sectionIndex) throws URISyntaxException, IOException {
        if (!this.existsNotebook(notebookURI)) {
            throw new IOException("notebook not found:" + notebookURI);
        }
        NotebookItemInfo info = this.getNotebookItemInfo(notebookURI);
        IFileSystem fs = this.getNotebookFilesystem(info);
        Sections sections = this.readSectionIndex(fs, info.versionName);
        if (sectionIndex < 1 || sectionIndex > sections.sections.size()) {
            throw new BilabException("section index " + sectionIndex + " out of range [1.." + sections.sections.size() + "]");
        }
        info.page = -1;
        info.sectionName = sections.sections.get(sectionIndex - 1);
        return info.toURI();
    }

    @Override
    public int repositionSection(String notebookURI, String sectionURI, String afterSectionURI) throws URISyntaxException, IOException {
        if (!this.existsNotebook(notebookURI)) {
            throw new IOException("notebook not found:" + notebookURI);
        }
        Notify.unimplemented(this);
        return 0;
    }

    @Override
    public void deleteSection(String sectionURI) throws URISyntaxException, IOException {
        if (!this.existsNotebook(sectionURI)) {
            throw new IOException("notebook not found:" + sectionURI);
        }
    }

    @Override
    public String renameSection(String sectionURI, String newSectionName) throws URISyntaxException, IOException {
        if (!this.existsNotebook(sectionURI)) {
            throw new IOException("notebook not found:" + sectionURI);
        }
        return null;
    }

    @Override
    public String createPage(String sectionURI, String insertAfterPageURI) throws URISyntaxException, IOException {
        if (!this.existsNotebook(sectionURI)) {
            throw new IOException("notebook not found:" + sectionURI);
        }
        return null;
    }

    @Override
    public int getPageCount(String sectionURI) throws IOException {
        if (!this.existsNotebook(sectionURI)) {
            throw new IOException("notebook not found:" + sectionURI);
        }
        return 0;
    }

    @Override
    public String getPageURI(String sectionURI, int pageIndex) throws IOException {
        if (!this.existsNotebook(sectionURI)) {
            throw new IOException("notebook not found:" + sectionURI);
        }
        return null;
    }

    @Override
    public String getContainingSection(String pageURI) throws IOException {
        if (!this.existsNotebook(pageURI)) {
            throw new IOException("notebook not found:" + pageURI);
        }
        return null;
    }

    @Override
    public String repositionPage(String sectionURI, String pageURI, String afterPageURI) {
        return null;
    }

    @Override
    public void deletePage(String pageURI) {
    }

    @Override
    public void setPageContent(String pageURI, byte[] content) {
    }

    @Override
    public byte[] getPageContent(String pageURI) {
        return null;
    }

    @Override
    public void addPageResource(String pageURI, String resourceName, byte[] content) {
    }

    @Override
    public byte[] getPageResource(String pageURI, String resourceName) {
        return null;
    }

    @Override
    public void setProperty(String componentURI, String propertyName, String value) {
    }

    @Override
    public String getProperty(String componentURI, String propertyName) {
        return null;
    }

    @Override
    public String[] getProperties(String componentURI) {
        return null;
    }

    protected NotebookItemInfo getNotebookItemInfo(String notebookURI) throws URISyntaxException {
        URI uri = null;
        uri = FileSystemNotebookStore.isAbsolutePath(notebookURI) ? new URI("file", null, notebookURI, null, null) : new URI(notebookURI);
        NotebookItemInfo itemInfo = new NotebookItemInfo();
        String fullPath = uri.getPath();
        File path = new File(Util.toNativePathSeparator(fullPath));
        itemInfo.notebookPath = Util.toForwardPathSeparator(path.getParent());
        itemInfo.notebookName = path.getName();
        String query = uri.getQuery();
        if (query != null) {
            String[] args;
            String[] stringArray = args = query.split("&");
            int n = 0;
            int n2 = stringArray.length;
            while (n < n2) {
                String arg = stringArray[n];
                String[] parts = arg.split("=");
                if (parts.length != 2) {
                    throw new IllegalArgumentException("syntax error in notebook URI parameters: " + notebookURI);
                }
                if (parts[0].equals("version")) {
                    itemInfo.versionName = parts[1];
                } else if (parts[0].equals("section")) {
                    itemInfo.sectionName = parts[1];
                } else if (parts[0].equals("page")) {
                    itemInfo.page = Integer.parseInt(parts[1]);
                } else {
                    throw new IllegalArgumentException("unrecognized parameter in notebook URI: " + notebookURI);
                }
                ++n;
            }
        }
        return itemInfo;
    }

    protected IFileSystem getNotebookFilesystem(NotebookItemInfo itemInfo) throws IOException {
        String fullPath = String.valueOf(itemInfo.notebookPath) + "/" + itemInfo.notebookName;
        if (this.fsCache.containsKey(fullPath)) {
            return this.fsCache.get(fullPath);
        }
        LocalFileSystem fs = null;
        if (itemInfo.notebookName.endsWith(".xml")) {
            fs = null;
            Notify.unimplemented(this);
        } else {
            fs = new LocalFileSystem(fullPath);
        }
        if (fs != null) {
            if (this.fsCache.size() > 10) {
                this.fsCache.remove(this.fsCache.keySet().toArray()[0]);
            }
        } else {
            throw new BilabException("unsuported notebook format");
        }
        this.fsCache.put(fullPath, fs);
        return fs;
    }

    protected void removeNotebookFilesystem(NotebookItemInfo itemInfo) {
        String fullPath = String.valueOf(itemInfo.notebookPath) + "/" + itemInfo.notebookName;
        this.fsCache.remove(fullPath);
    }

    protected void outputAnnotations(Document xmlDoc, Element e, HashMap<String, String> annotations) {
        Element annotElement = xmlDoc.createElement("annotations");
        if (e != null) {
            e.appendChild(annotElement);
        } else {
            xmlDoc.appendChild(annotElement);
        }
        for (String propName : annotations.keySet()) {
            Element propElement = xmlDoc.createElement("property");
            propElement.setAttribute("name", propName);
            propElement.setTextContent(annotations.get(propName));
            annotElement.appendChild(propElement);
        }
    }

    /*
     * Unable to fully structure code
     */
    protected HashMap<String, String> inputAnnotations(Document xmlDoc, Element e) {
        if (e == null) {
            e = xmlDoc.getDocumentElement();
        }
        props = new HashMap<String, String>();
        annotElement = FileSystemNotebookStore.findNextElement(e, "annotations", true);
        if (annotElement == null || !annotElement.hasChildNodes()) {
            return props;
        }
        propElement = FileSystemNotebookStore.findNextElement(annotElement.getFirstChild(), "property", false);
        if (propElement != null) ** GOTO lbl16
        return props;
lbl-1000:
        // 1 sources

        {
            propName = propElement.getAttribute("name");
            if (propName.length() > 0) {
                propValue = propElement.getTextContent();
                props.put(propName, propValue);
            }
            propElement = FileSystemNotebookStore.findNextElement(propElement.getNextSibling(), "property", false);
lbl16:
            // 2 sources

            ** while (propElement != null)
        }
lbl17:
        // 1 sources

        return props;
    }

    protected void writeAnnotationFile(IFileSystem fs, String version, String section, HashMap<String, String> annotations) throws IOException {
        try {
            DocumentBuilder builder = this.builderFactory.newDocumentBuilder();
            Document xmlDoc = builder.newDocument();
            xmlDoc.setXmlStandalone(true);
            this.outputAnnotations(xmlDoc, null, annotations);
            fs.changeDir("/" + version + "/" + section);
            OutputStream out = fs.writeFile(annotationsFile, false);
            this.outputXMLToStream(xmlDoc, out);
            out.flush();
            out.close();
        }
        catch (Exception e) {
            IOException ioe = new IOException("error writing notebook annotation information - " + e.getMessage());
            ioe.initCause(e);
            throw ioe;
        }
    }

    protected HashMap<String, String> readAnnotationFile(IFileSystem fs, String version, String section) throws IOException {
        try {
            fs.changeDir("/" + version + "/" + section);
            InputStream in = fs.readFile(annotationsFile);
            DocumentBuilder builder = this.builderFactory.newDocumentBuilder();
            Document xmlDoc = builder.parse(in);
            in.close();
            return this.inputAnnotations(xmlDoc, null);
        }
        catch (Exception e) {
            IOException ioe = new IOException("error reading notebook annotation information - " + e.getMessage());
            ioe.initCause(e);
            throw ioe;
        }
    }

    protected void writeVersionIndex(IFileSystem fs, Versions versions) throws IOException {
        try {
            DocumentBuilder builder = this.builderFactory.newDocumentBuilder();
            Document xmlDoc = builder.newDocument();
            xmlDoc.setXmlStandalone(true);
            Element nbElement = xmlDoc.createElement("notebook");
            nbElement.setAttribute("format", formatVersion);
            xmlDoc.appendChild(nbElement);
            this.outputAnnotations(xmlDoc, nbElement, versions.globalAnnotations);
            Element versElement = xmlDoc.createElement("versions");
            for (String versionName : versions.versions) {
                Element verElement = xmlDoc.createElement("version");
                verElement.setTextContent(versionName);
                versElement.appendChild(verElement);
            }
            nbElement.appendChild(versElement);
            fs.changeDir("/");
            OutputStream out = fs.writeFile(versionIndexFile, false);
            this.outputXMLToStream(xmlDoc, out);
            out.flush();
            out.close();
        }
        catch (Exception e) {
            IOException ioe = new IOException("error writing notebook version information - " + e.getMessage());
            ioe.initCause(e);
            throw ioe;
        }
    }

    protected Versions readVersionIndex(IFileSystem fs) throws IOException {
        try {
            fs.changeDir("/");
            InputStream in = fs.readFile(versionIndexFile);
            DocumentBuilder builder = this.builderFactory.newDocumentBuilder();
            Document xmlDoc = builder.parse(in);
            in.close();
            Element nbElement = FileSystemNotebookStore.findNextElement(xmlDoc, "notebook", true);
            if (nbElement == null) {
                throw new IOException("required element 'notebook' not found");
            }
            String inFormatVersion = nbElement.getAttribute("format");
            if (inFormatVersion.length() > 0 && !inFormatVersion.equals(formatVersion)) {
                throw new BilabException("unsupported notebook format '" + inFormatVersion + "'");
            }
            Versions versions = new Versions();
            versions.globalAnnotations = this.inputAnnotations(xmlDoc, nbElement);
            Element versElement = FileSystemNotebookStore.findNextElement(nbElement, "versions", true);
            Element verElement = FileSystemNotebookStore.findNextElement(versElement.getFirstChild(), "version", false);
            while (verElement != null) {
                String version = verElement.getTextContent();
                versions.versions.add(version);
                verElement = FileSystemNotebookStore.findNextElement(verElement.getNextSibling(), "version", false);
            }
            return versions;
        }
        catch (Exception e) {
            IOException ioe = new IOException("error reading notebook version information - " + e.getMessage());
            ioe.initCause(e);
            throw ioe;
        }
    }

    protected void writeSectionIndex(IFileSystem fs, String version, Sections sections) throws IOException {
        try {
            DocumentBuilder builder = this.builderFactory.newDocumentBuilder();
            Document xmlDoc = builder.newDocument();
            xmlDoc.setXmlStandalone(true);
            Element secsElement = xmlDoc.createElement("sections");
            xmlDoc.appendChild(secsElement);
            for (String sectionName : sections.sections) {
                Element secElement = xmlDoc.createElement("section");
                secElement.setTextContent(sectionName);
                secsElement.appendChild(secElement);
            }
            fs.changeDir("/" + version);
            OutputStream out = fs.writeFile(sectionIndexFile, false);
            this.outputXMLToStream(xmlDoc, out);
            out.flush();
            out.close();
        }
        catch (Exception e) {
            IOException ioe = new IOException("error writing notebook section information - " + e.getMessage());
            ioe.initCause(e);
            throw ioe;
        }
    }

    protected Sections readSectionIndex(IFileSystem fs, String version) throws IOException {
        try {
            fs.changeDir("/" + version);
            InputStream in = fs.readFile(sectionIndexFile);
            DocumentBuilder builder = this.builderFactory.newDocumentBuilder();
            Document xmlDoc = builder.parse(in);
            in.close();
            Sections sections = new Sections();
            Element secsElement = FileSystemNotebookStore.findNextElement(xmlDoc, "sections", true);
            if (secsElement == null) {
                throw new IOException("required element 'sections' not present");
            }
            Element secElement = FileSystemNotebookStore.findNextElement(secsElement.getFirstChild(), "section", false);
            while (secElement != null) {
                String section = secElement.getTextContent();
                sections.sections.add(section);
                secElement = FileSystemNotebookStore.findNextElement(secElement.getNextSibling(), "section", false);
            }
            return sections;
        }
        catch (Exception e) {
            IOException ioe = new IOException("error reading notebook section information - " + e.getMessage());
            ioe.initCause(e);
            throw ioe;
        }
    }

    protected void outputXMLToStream(Document xmlDoc, OutputStream out) throws IOException {
        try {
            Transformer transformer = this.transFactory.newTransformer();
            DOMSource source = new DOMSource(xmlDoc);
            StreamResult result = new StreamResult(out);
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("standalone", "yes");
            transformer.setOutputProperty("method", "xml");
            transformer.transform(source, result);
        }
        catch (Exception e) {
            throw new IOException("error writing XML content to notebook - " + e.getMessage());
        }
    }

    protected Document inputXMLFromStream(InputStream in) throws IOException {
        try {
            DocumentBuilder builder = this.builderFactory.newDocumentBuilder();
            return builder.parse(in);
        }
        catch (Exception e) {
            throw new IOException("error reading XML content from notebook - " + e.getMessage());
        }
    }

    protected static Element findNextElement(Node n, String tagName, boolean searchChildren) {
        if (n == null) {
            return null;
        }
        do {
            if (n instanceof Element && n.getNodeName().equals(tagName)) {
                return (Element)n;
            }
            if (searchChildren && n.hasChildNodes()) {
                Element c;
                Node cn = n.getFirstChild();
                while (cn != null && !(cn instanceof Element)) {
                    cn = cn.getNextSibling();
                }
                if (cn != null && (c = FileSystemNotebookStore.findNextElement(cn, tagName, searchChildren)) != null) {
                    return c;
                }
            }
            n = n.getNextSibling();
            while (n != null && !(n instanceof Element)) {
                n = n.getNextSibling();
            }
        } while (n != null);
        return null;
    }

    protected static class NotebookItemInfo {
        String notebookName;
        String notebookPath;
        String versionName;
        String sectionName;
        int page;

        public NotebookItemInfo() {
            this.versionName = "current";
            this.sectionName = "";
            this.page = -1;
        }

        public NotebookItemInfo(NotebookItemInfo copy) {
            this.notebookName = copy.notebookName;
            this.notebookPath = copy.notebookPath;
            this.versionName = copy.versionName;
            this.sectionName = copy.sectionName;
            this.page = copy.page;
        }

        public String toURI() {
            try {
                String absPath = new File(String.valueOf(this.notebookPath) + "/" + this.notebookName).toURI().getPath();
                String query = "";
                if (!this.versionName.equals("current")) {
                    query = String.valueOf(query) + "version=" + this.versionName;
                }
                if (this.sectionName.length() > 0) {
                    if (query.length() > 0) {
                        query = String.valueOf(query) + "&";
                    }
                    query = String.valueOf(query) + "section=" + this.sectionName;
                }
                if (this.page != -1) {
                    if (query.length() > 0) {
                        query = String.valueOf(query) + "&";
                    }
                    query = String.valueOf(query) + "page=" + this.page;
                }
                return new URI("file", null, absPath, query.length() > 0 ? query : null, null).toString();
            }
            catch (URISyntaxException e) {
                throw new RuntimeException("interal error: can't form URI string - " + e.getMessage());
            }
        }
    }

    protected static class Versions {
        LinkedList<String> versions = new LinkedList();
        HashMap<String, String> globalAnnotations = new HashMap();

        protected Versions() {
        }
    }

    protected static class Sections {
        public LinkedList<String> sections = new LinkedList();
        public HashMap<String, String> annotations = new HashMap();

        protected Sections() {
        }
    }
}

