/*
 * Decompiled with CFR 0.152.
 */
package bilab.notebook;

import bilab.Notify;
import bilab.notebook.NotebookPageEditorContextMenuProvider;
import bilab.notebook.NotebookPageEditorPaletteFactory;
import bilab.notebook.model.GraphicsDiagram;
import bilab.notebook.parts.GraphicsEditPartFactory;
import bilab.notebook.parts.GraphicsTreeEditPartFactory;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.EventObject;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.gef.DefaultEditDomain;
import org.eclipse.gef.EditDomain;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.KeyHandler;
import org.eclipse.gef.KeyStroke;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.dnd.TemplateTransferDragSourceListener;
import org.eclipse.gef.dnd.TemplateTransferDropTargetListener;
import org.eclipse.gef.dnd.TransferDragSourceListener;
import org.eclipse.gef.editparts.ScalableRootEditPart;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.requests.CreationFactory;
import org.eclipse.gef.requests.SimpleFactory;
import org.eclipse.gef.ui.palette.FlyoutPaletteComposite;
import org.eclipse.gef.ui.palette.PaletteViewer;
import org.eclipse.gef.ui.palette.PaletteViewerProvider;
import org.eclipse.gef.ui.parts.ContentOutlinePage;
import org.eclipse.gef.ui.parts.GraphicalEditorWithFlyoutPalette;
import org.eclipse.gef.ui.parts.GraphicalViewerKeyHandler;
import org.eclipse.gef.ui.parts.TreeViewer;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.util.TransferDropTargetListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.SaveAsDialog;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.PageBook;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

public class NotebookPageEditor
extends GraphicalEditorWithFlyoutPalette {
    private GraphicsDiagram diagram = new GraphicsDiagram();
    private IContentOutlinePage outlinePage;
    private PaletteRoot palette;
    private boolean saveAlreadyRequested;
    private KeyHandler sharedKeyHandler;
    static /* synthetic */ Class class$0;

    public NotebookPageEditor() {
        this.setEditDomain(new DefaultEditDomain((IEditorPart)this));
    }

    protected void configureGraphicalViewer() {
        super.configureGraphicalViewer();
        GraphicalViewer viewer = this.getGraphicalViewer();
        viewer.setRootEditPart((RootEditPart)new ScalableRootEditPart());
        viewer.setEditPartFactory((EditPartFactory)new GraphicsEditPartFactory());
        viewer.setKeyHandler(new GraphicalViewerKeyHandler(viewer).setParent(this.getCommonKeyHandler()));
        NotebookPageEditorContextMenuProvider cmProvider = new NotebookPageEditorContextMenuProvider((EditPartViewer)viewer, this.getActionRegistry());
        viewer.setContextMenu((MenuManager)cmProvider);
        this.getSite().registerContextMenu((MenuManager)cmProvider, (ISelectionProvider)viewer);
    }

    public void commandStackChanged(EventObject event) {
        super.commandStackChanged(event);
        if (this.isDirty() && !this.saveAlreadyRequested) {
            this.saveAlreadyRequested = true;
            this.firePropertyChange(257);
        } else {
            this.saveAlreadyRequested = false;
            this.firePropertyChange(257);
        }
    }

    private void createOutputStream(OutputStream os) throws IOException {
        ObjectOutputStream oos = new ObjectOutputStream(os);
        oos.writeObject(this.getModel());
        oos.close();
    }

    protected PaletteViewerProvider createPaletteViewerProvider() {
        return new PaletteViewerProvider((EditDomain)this.getEditDomain()){

            protected void configurePaletteViewer(PaletteViewer viewer) {
                super.configurePaletteViewer(viewer);
                viewer.addDragSourceListener((TransferDragSourceListener)new TemplateTransferDragSourceListener((EditPartViewer)viewer));
            }
        };
    }

    private TransferDropTargetListener createTransferDropTargetListener() {
        return new TemplateTransferDropTargetListener((EditPartViewer)this.getGraphicalViewer()){

            protected CreationFactory getFactory(Object template) {
                return new SimpleFactory((Class)template);
            }
        };
    }

    private void disposeOutlinePage() {
        this.outlinePage = null;
    }

    public void doSave(IProgressMonitor monitor) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            this.createOutputStream(out);
            IFile file = ((IFileEditorInput)this.getEditorInput()).getFile();
            file.setContents((InputStream)new ByteArrayInputStream(out.toByteArray()), true, false, monitor);
            this.getCommandStack().markSaveLocation();
        }
        catch (CoreException ce) {
            ce.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public void doSaveAs() {
        Shell shell = this.getSite().getWorkbenchWindow().getShell();
        SaveAsDialog dialog = new SaveAsDialog(shell);
        dialog.setOriginalFile(((IFileEditorInput)this.getEditorInput()).getFile());
        dialog.open();
        IPath path = dialog.getResult();
        if (path != null) {
            final IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(path);
            try {
                new ProgressMonitorDialog(shell).run(false, false, (IRunnableWithProgress)new WorkspaceModifyOperation(){

                    public void execute(IProgressMonitor monitor) {
                        try {
                            ByteArrayOutputStream out = new ByteArrayOutputStream();
                            NotebookPageEditor.this.createOutputStream(out);
                            file.create((InputStream)new ByteArrayInputStream(out.toByteArray()), true, monitor);
                        }
                        catch (CoreException ce) {
                            ce.printStackTrace();
                        }
                        catch (IOException ioe) {
                            ioe.printStackTrace();
                        }
                    }
                });
                this.setInput((IEditorInput)new FileEditorInput(file));
                this.getCommandStack().markSaveLocation();
            }
            catch (InterruptedException ie) {
                ie.printStackTrace();
            }
            catch (InvocationTargetException ite) {
                ite.printStackTrace();
            }
        }
    }

    public Object getAdapter(Class type) {
        if (type == IContentOutlinePage.class) {
            if (this.outlinePage == null) {
                this.outlinePage = new NotebookEditorOutlinePage(this, (EditPartViewer)new TreeViewer());
            }
            return this.outlinePage;
        }
        return super.getAdapter(type);
    }

    KeyHandler getCommonKeyHandler() {
        if (this.sharedKeyHandler == null) {
            this.sharedKeyHandler = new KeyHandler();
            this.sharedKeyHandler.put(KeyStroke.getPressed((char)'\u007f', (int)127, (int)0), this.getActionRegistry().getAction((Object)ActionFactory.DELETE.getId()));
        }
        return this.sharedKeyHandler;
    }

    private GraphicsDiagram getModel() {
        return this.diagram;
    }

    protected FlyoutPaletteComposite.FlyoutPreferences getPalettePreferences() {
        return NotebookPageEditorPaletteFactory.createPalettePreferences();
    }

    protected PaletteRoot getPaletteRoot() {
        if (this.palette == null) {
            this.palette = NotebookPageEditorPaletteFactory.createPalette();
        }
        return this.palette;
    }

    private void handleLoadException(Exception e) {
        Notify.userError((Object)this, "Unable to load the specified file as a Notebook.  Creating empty document instead.");
        this.diagram = new GraphicsDiagram();
    }

    protected void initializeGraphicalViewer() {
        super.initializeGraphicalViewer();
        GraphicalViewer graphicalViewer = this.getGraphicalViewer();
        graphicalViewer.setContents((Object)this.getModel());
        graphicalViewer.addDropTargetListener(this.createTransferDropTargetListener());
    }

    public boolean isDirty() {
        return this.getCommandStack().isDirty();
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    protected void setInput(IEditorInput input) {
        super.setInput(input);
        try {
            IFile file = ((IFileEditorInput)input).getFile();
            ObjectInputStream in = new ObjectInputStream(file.getContents());
            this.diagram = (GraphicsDiagram)in.readObject();
            in.close();
            this.setPartName(file.getName());
        }
        catch (IOException e) {
            this.handleLoadException(e);
        }
        catch (CoreException e) {
            this.handleLoadException((Exception)((Object)e));
        }
        catch (ClassNotFoundException e) {
            this.handleLoadException(e);
        }
        catch (Exception e) {
            this.handleLoadException(e);
        }
    }

    public class NotebookEditorOutlinePage
    extends ContentOutlinePage {
        private final NotebookPageEditor editor;
        private PageBook pagebook;

        public NotebookEditorOutlinePage(NotebookPageEditor editor, EditPartViewer viewer) {
            super(viewer);
            if (editor == null) {
                throw new IllegalArgumentException();
            }
            this.editor = editor;
        }

        public void createControl(Composite parent) {
            this.pagebook = new PageBook(parent, 0);
            Control outline = this.getViewer().createControl((Composite)this.pagebook);
            this.getViewer().setEditDomain((EditDomain)this.editor.getEditDomain());
            this.getViewer().setEditPartFactory((EditPartFactory)new GraphicsTreeEditPartFactory());
            this.getViewer().setKeyHandler(this.editor.getCommonKeyHandler());
            NotebookPageEditorContextMenuProvider cmProvider = new NotebookPageEditorContextMenuProvider(this.getViewer(), this.editor.getActionRegistry());
            this.getViewer().setContextMenu((MenuManager)cmProvider);
            this.getSite().registerContextMenu("org.eclipse.gef.examples.shapes.outline.contextmenu", (MenuManager)cmProvider, this.getSite().getSelectionProvider());
            this.editor.getSelectionSynchronizer().addViewer(this.getViewer());
            this.getViewer().setContents((Object)this.editor.getModel());
            this.pagebook.showPage(outline);
        }

        public void dispose() {
            this.editor.getSelectionSynchronizer().removeViewer(this.getViewer());
            super.dispose();
            this.editor.disposeOutlinePage();
        }

        public Control getControl() {
            return this.pagebook;
        }
    }
}

