/*
 * Decompiled with CFR 0.152.
 */
package bilab.notebook.model;

import bilab.BilabPlugin;
import bilab.Notify;
import bilab.notebook.model.Connection;
import bilab.notebook.model.ModelElement;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.jface.viewers.ICellEditorValidator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.PropertyDescriptor;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;

public abstract class Graphic
extends ModelElement {
    private static IPropertyDescriptor[] descriptors = new IPropertyDescriptor[]{new TextPropertyDescriptor((Object)"Shape.xPos", "X"), new TextPropertyDescriptor((Object)"Shape.yPos", "Y"), new TextPropertyDescriptor((Object)"Shape.Width", "Width"), new TextPropertyDescriptor((Object)"Shape.Height", "Height")};
    private static final String HEIGHT_PROP = "Shape.Height";
    public static final String LOCATION_PROP = "Shape.Location";
    private static final long serialVersionUID = 1L;
    public static final String SIZE_PROP = "Shape.Size";
    public static final String SOURCE_CONNECTIONS_PROP = "Shape.SourceConn";
    public static final String TARGET_CONNECTIONS_PROP = "Shape.TargetConn";
    private static final String WIDTH_PROP = "Shape.Width";
    private static final String XPOS_PROP = "Shape.xPos";
    private static final String YPOS_PROP = "Shape.yPos";
    private Point location = new Point(0, 0);
    private Dimension size = new Dimension(50, 50);
    private List sourceConnections = new ArrayList();
    private List targetConnections = new ArrayList();
    static /* synthetic */ Class class$0;

    static {
        int i = 0;
        while (i < descriptors.length) {
            ((PropertyDescriptor)descriptors[i]).setValidator(new ICellEditorValidator(){

                public String isValid(Object value) {
                    int intValue = -1;
                    try {
                        intValue = Integer.parseInt((String)value);
                    }
                    catch (NumberFormatException numberFormatException) {
                        return "Not a number";
                    }
                    return intValue >= 0 ? null : "Value must be >=  0";
                }
            });
            ++i;
        }
    }

    protected static Image createImage(String name) {
        try {
            InputStream stream = BilabPlugin.getResourceManager().findResourceStream(name);
            Image image = new Image(null, stream);
            try {
                stream.close();
            }
            catch (IOException iOException) {}
            return image;
        }
        catch (IOException iOException) {
            Notify.devWarning(Graphic.class, "resource not found:" + name);
            return null;
        }
    }

    void addConnection(Connection conn) {
        if (conn == null || conn.getSource() == conn.getTarget()) {
            throw new IllegalArgumentException();
        }
        if (conn.getSource() == this) {
            this.sourceConnections.add(conn);
            this.firePropertyChange(SOURCE_CONNECTIONS_PROP, null, conn);
        } else if (conn.getTarget() == this) {
            this.targetConnections.add(conn);
            this.firePropertyChange(TARGET_CONNECTIONS_PROP, null, conn);
        }
    }

    public abstract Image getIcon();

    public Point getLocation() {
        return this.location.getCopy();
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        return descriptors;
    }

    public Object getPropertyValue(Object propertyId) {
        if (XPOS_PROP.equals(propertyId)) {
            return Integer.toString(this.location.x);
        }
        if (YPOS_PROP.equals(propertyId)) {
            return Integer.toString(this.location.y);
        }
        if (HEIGHT_PROP.equals(propertyId)) {
            return Integer.toString(this.size.height);
        }
        if (WIDTH_PROP.equals(propertyId)) {
            return Integer.toString(this.size.width);
        }
        return super.getPropertyValue(propertyId);
    }

    public Dimension getSize() {
        return this.size.getCopy();
    }

    public List getSourceConnections() {
        return new ArrayList(this.sourceConnections);
    }

    public List getTargetConnections() {
        return new ArrayList(this.targetConnections);
    }

    void removeConnection(Connection conn) {
        if (conn == null) {
            throw new IllegalArgumentException();
        }
        if (conn.getSource() == this) {
            this.sourceConnections.remove(conn);
            this.firePropertyChange(SOURCE_CONNECTIONS_PROP, null, conn);
        } else if (conn.getTarget() == this) {
            this.targetConnections.remove(conn);
            this.firePropertyChange(TARGET_CONNECTIONS_PROP, null, conn);
        }
    }

    public void setLocation(Point newLocation) {
        if (newLocation == null) {
            throw new IllegalArgumentException();
        }
        this.location.setLocation(newLocation);
        this.firePropertyChange(LOCATION_PROP, null, this.location);
    }

    public void setPropertyValue(Object propertyId, Object value) {
        if (XPOS_PROP.equals(propertyId)) {
            int x = Integer.parseInt((String)value);
            this.setLocation(new Point(x, this.location.y));
        } else if (YPOS_PROP.equals(propertyId)) {
            int y = Integer.parseInt((String)value);
            this.setLocation(new Point(this.location.x, y));
        } else if (HEIGHT_PROP.equals(propertyId)) {
            int height = Integer.parseInt((String)value);
            this.setSize(new Dimension(this.size.width, height));
        } else if (WIDTH_PROP.equals(propertyId)) {
            int width = Integer.parseInt((String)value);
            this.setSize(new Dimension(width, this.size.height));
        } else {
            super.setPropertyValue(propertyId, value);
        }
    }

    public void setSize(Dimension newSize) {
        if (newSize != null) {
            this.size.setSize(newSize);
            this.firePropertyChange(SIZE_PROP, null, this.size);
        }
    }
}

