/*
 * Decompiled with CFR 0.152.
 */
package bilab.notebook.model.commands;

import bilab.notebook.model.Graphic;
import bilab.notebook.model.GraphicsDiagram;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.CreateRequest;

public class GraphicCreateCommand
extends Command {
    private Graphic newShape;
    private final GraphicsDiagram parent;
    private final CreateRequest request;
    private boolean shapeAdded;

    public GraphicCreateCommand(GraphicsDiagram parent, CreateRequest req) {
        if (parent == null || req == null) {
            throw new IllegalArgumentException("neither parent nor req may be null");
        }
        Object newObj = null;
        try {
            newObj = req.getNewObject();
        }
        catch (ExceptionInInitializerError e) {
            Throwable t = e;
            if (t.getCause() != null) {
                t = t.getCause();
            }
            throw new IllegalArgumentException("unable to instantiate requested class:" + req.getNewObjectType(), t);
        }
        catch (Throwable t) {
            throw new IllegalArgumentException("unable to instantiate requested class:" + req.getNewObjectType(), t);
        }
        if (!(newObj instanceof Graphic)) {
            throw new IllegalArgumentException("object must be a Graphic (not " + newObj.getClass() + ")");
        }
        this.parent = parent;
        this.request = req;
        this.setLabel("shape creation");
    }

    public boolean canUndo() {
        return this.shapeAdded;
    }

    public void execute() {
        this.newShape = (Graphic)this.request.getNewObject();
        this.newShape.setSize(this.request.getSize());
        this.newShape.setLocation(this.request.getLocation());
        this.redo();
    }

    public void redo() {
        this.shapeAdded = this.parent.addChild(this.newShape);
    }

    public void undo() {
        this.parent.removeChild(this.newShape);
    }
}

