/*
 * Decompiled with CFR 0.152.
 */
package bilab;

import bilab.BilabException;
import bilab.DNA;
import bilab.IResourceIOProvider;
import bilab.Notify;
import bilab.RNA;
import bilab.ResourceManager;
import bilab.Sophistication;
import bilab.Summary;
import bilab.molecule;
import bilab.protein;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.StringReader;
import java.util.LinkedList;
import java.util.List;
import org.biojava.bio.program.gff.GFFEntrySet;
import org.biojava.bio.program.gff.GFFTools;
import org.biojava.bio.seq.DNATools;
import org.biojava.bio.seq.ProteinTools;
import org.biojava.bio.seq.RNATools;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.SequenceIterator;
import org.biojava.bio.seq.io.SeqIOTools;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.utils.ChangeVetoException;
import scigol.Any;
import scigol.Debug;
import scigol.Map;
import scigol.accessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class seq
extends scigol.List
implements molecule,
IResourceIOProvider {
    static final int maxStringLen = 40;
    private static final List<String> supportedImportResourceTypes = new LinkedList<String>();
    private static final List<String> supportedExportResourceTypes;
    protected String _name;
    protected String associatedResourceName = null;
    static /* synthetic */ Class class$0;

    static {
        supportedImportResourceTypes.add("EMBL");
        supportedImportResourceTypes.add("SwissProt");
        supportedImportResourceTypes.add("GenBank");
        supportedImportResourceTypes.add("GenPept");
        supportedImportResourceTypes.add("FASTA");
        supportedExportResourceTypes = supportedImportResourceTypes;
    }

    public seq() {
        this._name = "untitled";
    }

    public seq(String name) {
        this._name = name;
    }

    @Override
    public boolean get_StructureKnown() {
        return false;
    }

    @Override
    @accessor
    public String get_name() {
        return this._name;
    }

    @Override
    @accessor
    public String get_AssociatedResource() {
        return this.associatedResourceName;
    }

    @Sophistication(value=2)
    @accessor
    public void set_AssociatedResource(String resourceName) {
        this.associatedResourceName = resourceName;
    }

    public String ToMDL() {
        Debug.Unimplemented();
        return null;
    }

    @Override
    public abstract String get_ShortText();

    @Override
    public abstract String get_DetailText();

    public abstract String get_sequence();

    public abstract String get_rawsequence();

    @Override
    public abstract Map get_annotations();

    public Any get_annotation(String key) {
        return this.get_annotations().get_Item(key);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Object importResource(ResourceManager rm, String resourceName, String resourceType) {
        try {
            InputStreamReader streamReader = new InputStreamReader(rm.findResourceStream(resourceName));
            if (streamReader == null) {
                throw new BilabException("unable to open resource:" + resourceName);
            }
            scigol.List seqList = new scigol.List();
            SequenceIterator sequences = null;
            BufferedReader br = new BufferedReader(streamReader);
            if (resourceType.equals("EMBL")) {
                sequences = SeqIOTools.readEmbl((BufferedReader)br);
            } else if (resourceType.equals("SwissProt")) {
                sequences = SeqIOTools.readSwissprot((BufferedReader)br);
            } else if (resourceType.equals("GenBank")) {
                sequences = SeqIOTools.readGenbank((BufferedReader)br);
            } else if (resourceType.equals("GenPept")) {
                sequences = SeqIOTools.readGenpept((BufferedReader)br);
            } else {
                if (!resourceType.equals("FASTA")) {
                    throw new BilabException("unsupported resource type:" + resourceType);
                }
                sequences = SeqIOTools.readFastaDNA((BufferedReader)br);
                Notify.logInfo(seq.class, "Assuming FASTA DNA");
            }
            while (true) {
                if (!sequences.hasNext()) {
                    if (seqList.get_size() <= 1) break;
                    return seqList;
                }
                Sequence seq2 = sequences.nextSequence();
                seqList.add(seq.seqFromSequence(seq2));
            }
            seq s = (seq)seqList.get_head().value;
            s.set_AssociatedResource(resourceName);
            return seqList.get_head();
        }
        catch (Exception exception) {
            throw new BilabException("unable to locate/import resource as sequence(s): " + resourceName);
        }
    }

    @Summary(value="create a resource containing data in a supported format from a seq")
    public static void exportResource(ResourceManager rm, seq s, String resourceName, String resourceType) {
        try {
            OutputStream outStream = rm.createResourceStream(resourceName);
            seq.exportResource(rm, s, outStream, resourceType);
            outStream.flush();
            outStream.close();
        }
        catch (Exception exception) {
            throw new BilabException("unable to export sequence as resource: " + resourceName);
        }
    }

    @Summary(value="write the resource to the stream in a supported format")
    @Sophistication(value=2)
    protected static void exportResource(ResourceManager rm, seq s, OutputStream outStream, String resourceType) {
        block7: {
            try {
                if (resourceType.equals("EMBL")) {
                    SeqIOTools.writeEmbl((OutputStream)outStream, (Sequence)seq.sequenceFromSeq(s));
                    break block7;
                }
                if (resourceType.equals("SwissProt")) {
                    SeqIOTools.writeSwissprot((OutputStream)outStream, (Sequence)seq.sequenceFromSeq(s));
                    break block7;
                }
                if (resourceType.equals("GenBank")) {
                    SeqIOTools.writeGenbank((OutputStream)outStream, (Sequence)seq.sequenceFromSeq(s));
                    break block7;
                }
                if (resourceType.equals("GenPept")) {
                    SeqIOTools.writeGenpept((OutputStream)outStream, (Sequence)seq.sequenceFromSeq(s));
                    break block7;
                }
                if (resourceType.equals("FASTA")) {
                    SeqIOTools.writeFasta((OutputStream)outStream, (Sequence)seq.sequenceFromSeq(s));
                    break block7;
                }
                throw new BilabException("unsupported resource type:" + resourceType);
            }
            catch (Exception exception) {
                throw new BilabException("unable to export sequence as resource type: " + resourceType);
            }
        }
    }

    @Summary(value="add the features expressed in GFF format to this sequence")
    @Sophistication(value=2)
    public void addGFFFeatures(String GFFString) {
        try {
            StringReader stringReader = new StringReader(GFFString);
            BufferedReader bufferedReader = new BufferedReader(stringReader);
            GFFEntrySet gffEntrySet = GFFTools.readGFF((BufferedReader)bufferedReader);
            Sequence thisSequence = seq.sequenceFromSeq(this);
            Sequence thisGFFAnnotatedSequence = GFFTools.annotateSequence((Sequence)thisSequence, (GFFEntrySet)gffEntrySet);
            this.updateSequence(thisGFFAnnotatedSequence);
        }
        catch (Exception e) {
            throw new BilabException("unable to parse GFF feature string:" + e);
        }
    }

    @Sophistication(value=2)
    public static seq seqFromSequence(Sequence seq2) {
        if (seq2 == null) {
            return null;
        }
        Alphabet alpha = seq2.getAlphabet();
        if (alpha.equals(DNATools.getDNA())) {
            return new DNA(seq2);
        }
        if (alpha.equals(RNATools.getRNA())) {
            return new RNA(seq2);
        }
        if (alpha.equals(ProteinTools.getAlphabet()) || alpha.equals(ProteinTools.getTAlphabet())) {
            return new protein(seq2);
        }
        throw new BilabException("unsupported sequence alphabet:" + alpha);
    }

    @Sophistication(value=2)
    public void updateSequence(Sequence seq2) {
        if (seq2 == null) {
            return;
        }
        seq2.getAlphabet();
        if (this instanceof DNA) {
            ((DNA)this).seq = seq2;
        } else if (this instanceof RNA) {
            ((RNA)this).seq = seq2;
        } else if (this instanceof protein) {
            ((protein)this).seq = seq2;
        } else {
            throw new BilabException("unsupported seq subclass:" + this.getClass());
        }
    }

    @Sophistication(value=2)
    public static Sequence sequenceFromSeq(seq s) {
        if (s == null) {
            return null;
        }
        if (s instanceof DNA) {
            return ((DNA)s).seq;
        }
        if (s instanceof RNA) {
            return ((RNA)s).seq;
        }
        if (s instanceof protein) {
            return ((protein)s).seq;
        }
        Debug.Assert(false, "unknown/unhandled seq subclass");
        return null;
    }

    @Sophistication(value=2)
    protected static void addAnnotationsToSequence(Sequence s, Map annots) {
        try {
            for (Object key : annots.keySet()) {
                s.getAnnotation().setProperty(key, annots.get(key));
            }
        }
        catch (ChangeVetoException changeVetoException) {}
    }

    public static List<String> getSupportedImportResourceTypes() {
        return supportedImportResourceTypes;
    }

    public static List<String> getSupportedExportResourceTypes() {
        return supportedExportResourceTypes;
    }

    @Summary(value="split into lines of 6 cols of 10 chars each")
    @Sophistication(value=3)
    public static String formatSeqString(String seqString) {
        StringBuilder fs = new StringBuilder();
        int c = 0;
        while (c < seqString.length()) {
            fs.append(seqString.charAt(c));
            if ((c + 1) % 10 == 0) {
                if ((c + 1) % 60 == 0) {
                    fs.append("\n");
                } else {
                    fs.append(' ');
                }
            }
            ++c;
        }
        return fs.toString();
    }

    @Override
    public String toString() {
        String s = this.get_rawsequence();
        if (s.length() <= 40) {
            return s;
        }
        int half = 17;
        String start = s.substring(0, half);
        String end = s.substring(s.length() - half - 1);
        return String.valueOf(start) + " ... " + end;
    }
}

