/*
 * Decompiled with CFR 0.152.
 */
package jalview;

import jalview.PIDColourScheme;
import jalview.QuickSort;
import jalview.ResidueProperties;
import jalview.Sequence;
import jalview.SequenceGroup;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class Alignment {
    public Sequence[] sequences;
    public int[][] scores;
    public int maxLength;
    public int size;
    public Vector groups = new Vector();
    public Hashtable[] cons;
    public int[][] cons2;
    String gapCharacter = "-";
    public Vector quality;

    public Alignment(Sequence[] sequences) {
        this.sequences = sequences;
        this.maxLength = this.maxLength();
        this.size = this.size();
        this.groups.addElement(new SequenceGroup());
        ((SequenceGroup)this.groups.elementAt((int)0)).colourScheme = new PIDColourScheme();
        int i = 0;
        while (i < sequences.length && sequences[i] != null) {
            this.addToGroup((SequenceGroup)this.groups.elementAt(0), sequences[i]);
            ++i;
        }
    }

    public void addSequence(Sequence snew) {
        Sequence[] s = new Sequence[this.sequences.length + 1];
        int i = 0;
        while (i < this.sequences.length && this.sequences[i] != null) {
            s[i] = this.sequences[i];
            ++i;
        }
        s[i] = snew;
        this.size = this.size();
        this.maxLength = this.maxLength();
    }

    public void sortGroups() {
        float[] arr = new float[this.groups.size()];
        Object[] s = new Object[this.groups.size()];
        int i = 0;
        while (i < this.groups.size()) {
            arr[i] = ((SequenceGroup)this.groups.elementAt((int)i)).sequences.size();
            s[i] = this.groups.elementAt(i);
            ++i;
        }
        QuickSort.sort(arr, s);
        Vector<Object> newg = new Vector<Object>(this.groups.size());
        int i2 = this.groups.size() - 1;
        while (i2 >= 0) {
            newg.addElement(s[i2]);
            --i2;
        }
        this.groups = newg;
    }

    public void removeGaps() {
        int i = 0;
        while (i < this.maxLength()) {
            boolean flag = true;
            int j = 0;
            while (j < this.size()) {
                if (!(this.sequences[j].sequence.length() <= i || this.sequences[j].sequence.substring(i, i + 1).equals("-") || this.sequences[j].sequence.substring(i, i + 1).equals(".") || this.sequences[j].sequence.substring(i, i + 1).equals(" "))) {
                    flag = false;
                }
                ++j;
            }
            if (flag) {
                System.out.println("Deleting column " + i);
                this.deleteColumns(i + 1, i + 1);
            }
            ++i;
        }
    }

    public Sequence[] getColumns(int start, int end) {
        return this.getColumns(0, this.size() - 1, start, end);
    }

    public void deleteColumns(int start, int end) {
        if (end > this.quality.size()) {
            end = this.quality.size();
        }
        int i = start;
        while (i <= end) {
            this.quality.removeElementAt(start);
            ++i;
        }
        this.deleteColumns(0, this.size() - 1, start, end);
    }

    public Hashtable[] removeArrayElement(Hashtable[] cons, int i) {
        if (cons != null && cons.length > i) {
            Hashtable[] newhash = new Hashtable[cons.length - 1];
            int j = 0;
            while (j < i) {
                newhash[j] = cons[j];
                ++j;
            }
            j = i + 1;
            while (j < newhash.length) {
                newhash[j] = cons[j + 1];
                ++j;
            }
            return newhash;
        }
        return null;
    }

    public void removeIntArrayColumn(int[][] cons2, int start) {
        int length = this.maxLength();
        int cons2leng = cons2.length;
        System.out.println("cons2 length " + cons2leng + " " + length);
        int k = start;
        while (k < cons2leng - 1) {
            cons2[k] = cons2[k + 1];
            ++k;
        }
    }

    public void deleteColumns(int seq1, int seq2, int start, int end) {
        System.out.println("Deleting cols : " + start + " " + end);
        int i = 0;
        while (i <= end - start) {
            System.out.println("Removing cons for element " + (start + i));
            this.cons = this.removeArrayElement(this.cons, start);
            this.removeIntArrayColumn(this.cons2, start);
            int j = seq1;
            while (j <= seq2) {
                this.sequences[j].deleteCharAt(start);
                ++j;
            }
            ++i;
        }
        this.maxLength = this.maxLength();
    }

    public void insertColumns(Sequence[] seqs, int pos) {
        if (seqs.length == this.size()) {
            int i = 0;
            while (i < this.size()) {
                String tmp = new String(this.sequences[i].getSequence());
                this.sequences[i].sequence = String.valueOf(tmp.substring(0, pos)) + seqs[i].getSequence() + tmp.substring(pos);
                ++i;
            }
        }
        this.maxLength = this.maxLength();
    }

    public Sequence[] getColumns(int seq1, int seq2, int start, int end) {
        Sequence[] seqs = new Sequence[seq2 - seq1 + 1];
        int i = seq1;
        while (i <= seq2) {
            seqs[i] = new Sequence(this.sequences[i].name, this.sequences[i].getSequence().substring(start, end), this.sequences[i].findPosition(start), this.sequences[i].findPosition(end));
            ++i;
        }
        return seqs;
    }

    public void trimLeft(int i) {
        int length;
        int j = 0;
        while (j < this.size) {
            int newstart;
            Sequence s = this.sequences[j];
            s.start = newstart = s.findPosition(i);
            s.sequence = s.sequence.substring(i);
            s.num = Sequence.setNums(s.sequence);
            ++j;
        }
        if (this.cons != null) {
            length = this.cons.length;
            int k = 0;
            while (k < length - i) {
                this.cons[k] = this.cons[i + k];
                ++k;
            }
        }
        if (this.cons2 != null) {
            length = this.maxLength();
            int k = 0;
            while (k < length - i) {
                this.cons2[k] = this.cons2[i + k];
                ++k;
            }
        }
        this.maxLength = this.maxLength();
        this.size = this.size();
    }

    public void trimRight(int i) {
        int j = 0;
        while (j < this.size) {
            int newend;
            Sequence s = this.sequences[j];
            s.end = newend = s.findPosition(i);
            s.sequence = s.sequence.substring(0, i + 1);
            ++j;
        }
        if (this.cons != null) {
            int cfr_ignored_0 = this.cons.length;
            Hashtable[] tmp = new Hashtable[i + 1];
            int k = 0;
            while (k <= i) {
                tmp[k] = this.cons[i];
                ++k;
            }
        }
        this.maxLength = this.maxLength();
        this.size = this.size();
    }

    public void deleteSequence(Sequence s) {
        int i = 0;
        while (i < this.size) {
            if (this.sequences[i] == s) {
                this.deleteSequence(i);
            }
            ++i;
        }
    }

    public void deleteSequence(int i) {
        Sequence[] tmp = new Sequence[this.size - 1];
        int j = 0;
        while (j < i) {
            tmp[j] = this.sequences[j];
            ++j;
        }
        j = i + 1;
        while (j < this.size) {
            tmp[j - 1] = this.sequences[j];
            ++j;
        }
        this.sequences = tmp;
        this.size = this.size();
    }

    public Vector removeRedundancy(float threshold, Vector sel) {
        Vector del = new Vector();
        int i = 1;
        while (i < sel.size()) {
            int j = 0;
            while (j < i) {
                float pid;
                if (!(del.contains((Sequence)sel.elementAt(i)) && del.contains((Sequence)sel.elementAt(j)) || !((pid = Alignment.compare((Sequence)sel.elementAt(j), (Sequence)sel.elementAt(i))) >= threshold))) {
                    if (((Sequence)sel.elementAt(j)).getSequence().length() > ((Sequence)sel.elementAt(i)).getSequence().length()) {
                        del.addElement(sel.elementAt(i));
                        System.out.println("Deleting sequence " + ((Sequence)sel.elementAt(i)).getName());
                    } else {
                        del.addElement(sel.elementAt(i));
                        System.out.println("Deleting sequence " + ((Sequence)sel.elementAt(i)).getName());
                    }
                }
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < del.size()) {
            System.out.println("Deleting sequence " + ((Sequence)del.elementAt(i)).getName());
            this.deleteSequence((Sequence)del.elementAt(i));
            ++i;
        }
        return del;
    }

    public static float compare(Sequence ii, Sequence jj) {
        String si = ii.getSequence();
        String sj = jj.getSequence();
        int ilen = si.length();
        int jlen = sj.length();
        if (si.substring(ilen).equals("-") || si.substring(ilen).equals(".") || si.substring(ilen).equals(" ")) {
            --ilen;
            while (si.substring(ilen, ilen + 1).equals("-") || si.substring(ilen, ilen + 1).equals(".") || si.substring(ilen, ilen + 1).equals(" ")) {
                --ilen;
            }
        }
        if (sj.substring(jlen).equals("-") || sj.substring(jlen).equals(".") || sj.substring(jlen).equals(" ")) {
            --jlen;
            while (sj.substring(jlen, jlen + 1).equals("-") || sj.substring(jlen, jlen + 1).equals(".") || sj.substring(jlen, jlen + 1).equals(" ")) {
                --jlen;
            }
        }
        int count = 0;
        int match = 0;
        float pid = -1.0f;
        if (ilen > jlen) {
            int j = 0;
            while (j < jlen) {
                if (si.substring(j, j + 1).equals(sj.substring(j, j + 1))) {
                    ++match;
                }
                ++count;
                ++j;
            }
            pid = (float)match / (float)ilen * 100.0f;
        } else {
            int j = 0;
            while (j < jlen) {
                if (si.substring(j, j + 1).equals(sj.substring(j, j + 1))) {
                    ++match;
                }
                ++count;
                ++j;
            }
            pid = (float)match / (float)jlen * 100.0f;
        }
        return pid;
    }

    public static float PID(Sequence s1, Sequence s2) {
        int len = s1.getSequence().length() > s2.getSequence().length() ? s1.getSequence().length() : s2.getSequence().length();
        int bad = 0;
        int i = 0;
        while (i < len) {
            String str1 = "";
            String str2 = "";
            str1 = i < s1.getSequence().length() ? s1.getSequence().substring(i, i + 1) : ".";
            str2 = i < s2.getSequence().length() ? s2.getSequence().substring(i, i + 1) : ".";
            if (!(str1.equals(".") || str1.equals("-") || str1.equals(" ") || str2.equals(".") || str2.equals("-") || str2.equals(" ") || str1.equals(str2))) {
                ++bad;
            }
            ++i;
        }
        return 100.0f * (float)(len - bad) / (float)len;
    }

    public void sortByPID(Sequence s) {
        float[] scores = new float[this.size()];
        int i = 0;
        while (i < this.size()) {
            scores[i] = Alignment.compare(this.sequences[i], s);
            ++i;
        }
        QuickSort.sort(scores, 0, scores.length - 1, this.sequences);
        int len = 0;
        len = this.size() % 2 == 0 ? this.size() / 2 : (this.size() + 1) / 2;
        int i2 = 0;
        while (i2 < len) {
            Sequence tmp = this.sequences[i2];
            this.sequences[i2] = this.sequences[this.size() - i2 - 1];
            this.sequences[this.size() - i2 - 1] = tmp;
            ++i2;
        }
    }

    public void sortByID() {
        String[] ids = new String[this.size()];
        int i = 0;
        while (i < this.size()) {
            ids[i] = this.sequences[i].name;
            ++i;
        }
        QuickSort.sort(ids, (Object[])this.sequences);
        int len = 0;
        len = this.size() % 2 == 0 ? this.size() / 2 : (this.size() + 1) / 2;
        int i2 = 0;
        while (i2 < len) {
            Sequence tmp = this.sequences[i2];
            this.sequences[i2] = this.sequences[this.size() - i2 - 1];
            this.sequences[this.size() - i2 - 1] = tmp;
            ++i2;
        }
    }

    public SequenceGroup findGroup(int i) {
        return this.findGroup(this.sequences[i]);
    }

    public SequenceGroup findGroup(Sequence s) {
        int i = 0;
        while (i < this.groups.size()) {
            SequenceGroup sg = (SequenceGroup)this.groups.elementAt(i);
            if (sg.sequences.contains(s)) {
                return sg;
            }
            ++i;
        }
        return null;
    }

    public void addToGroup(SequenceGroup g, Sequence s) {
        if (!g.sequences.contains(s)) {
            g.sequences.addElement(s);
        }
    }

    public void removeFromGroup(SequenceGroup g, Sequence s) {
        if (g != null && g.sequences != null && g.sequences.contains(s)) {
            g.sequences.removeElement(s);
            if (g.sequences.size() == 0) {
                this.groups.removeElement(g);
            }
        }
    }

    public void addGroup(SequenceGroup sg) {
        this.groups.addElement(sg);
    }

    public SequenceGroup addGroup() {
        SequenceGroup sg = new SequenceGroup();
        this.groups.addElement(sg);
        return sg;
    }

    public void deleteGroup(SequenceGroup g) {
        if (this.groups.contains(g)) {
            this.groups.removeElement(g);
        }
    }

    public Sequence findName(String name) {
        int i = 0;
        while (i < this.sequences.length && this.sequences[i] != null) {
            Sequence s = this.sequences[i];
            if (s.name.equals(name)) {
                return s;
            }
            ++i;
        }
        return null;
    }

    public int findIndex(Sequence s) {
        int i = 0;
        while (i < this.sequences.length && this.sequences[i] != null) {
            if (s == this.sequences[i]) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int size() {
        int i = 0;
        while (i < this.sequences.length && this.sequences[i] != null) {
            ++i;
        }
        return i;
    }

    public int maxLength() {
        this.maxLength = -1;
        int i = 0;
        while (i < this.sequences.length) {
            if (this.sequences[i] != null && this.sequences[i].length() > this.maxLength) {
                this.maxLength = this.sequences[i].sequence.length();
            }
            ++i;
        }
        i = 0;
        while (i < this.sequences.length) {
            if (this.sequences[i] != null) {
                int j = this.sequences[i].sequence.length();
                while (j < this.maxLength) {
                    this.sequences[i].insertCharAt(j, this.gapCharacter.charAt(0));
                    ++j;
                }
            }
            ++i;
        }
        return this.maxLength;
    }

    public int maxIdLength() {
        int max = 0;
        int i = 0;
        while (i < this.sequences.length && this.sequences[i] != null) {
            String tmp = String.valueOf(this.sequences[i].getName()) + "/" + this.sequences[i].start + "-" + this.sequences[i].end;
            if (tmp.length() > max) {
                max = tmp.length();
            }
            ++i;
        }
        return max;
    }

    public void percentIdentity(Vector sel) {
        this.cons = new Hashtable[this.maxLength()];
        this.cons2 = new int[this.maxLength()][24];
        System.out.println("Maxlength " + this.maxLength());
        System.out.println(System.currentTimeMillis());
        this.percentIdentity(0, this.maxLength, sel);
        System.out.println(System.currentTimeMillis());
        System.out.println(System.currentTimeMillis());
    }

    public void percentIdentity2(int start, int end, Vector sel) {
        int j = 0;
        while (j < 24) {
            int i = start;
            while (i < end) {
                this.cons2[i][j] = 0;
                ++i;
            }
            ++j;
        }
        int i = start;
        while (i < end) {
            int j2 = 0;
            while (j2 < this.sequences.length && this.sequences[j2] != null) {
                if (sel.contains(this.sequences[j2])) {
                    int[] nArray = this.cons2[i];
                    int n = this.sequences[j2].num[i];
                    nArray[n] = nArray[n] + 1;
                }
                ++j2;
            }
            ++i;
        }
        i = start;
        while (i < end) {
            int max = -1000;
            int j3 = 0;
            while (j3 < 24) {
                if (this.cons2[i][j3] > max) {
                    max = this.cons2[i][j3];
                }
                ++j3;
            }
            ++i;
        }
    }

    public void percentIdentity2() {
        this.percentIdentity2(0, this.maxLength() - 1);
    }

    public void percentIdentity2(int start, int end) {
        this.cons2 = new int[this.maxLength()][24];
        int j = 0;
        while (j < 24) {
            int i = 0;
            while (i < this.maxLength()) {
                this.cons2[i][j] = 0;
                ++i;
            }
            ++j;
        }
        int i = start;
        while (i <= end) {
            int j2 = 0;
            while (j2 < this.sequences.length && this.sequences[j2] != null) {
                int[] nArray = this.cons2[i];
                int n = this.sequences[j2].num[i];
                nArray[n] = nArray[n] + 1;
                ++j2;
            }
            ++i;
        }
        i = start;
        while (i <= end) {
            int max = -1000;
            int j3 = 0;
            while (j3 < 24) {
                if (this.cons2[i][j3] > max) {
                    max = this.cons2[i][j3];
                }
                ++j3;
            }
            ++i;
        }
    }

    public void percentIdentity(int start, int end, Vector sel) {
        int i = start;
        while (i < end) {
            int noRes = 0;
            if (i < this.cons.length) {
                this.cons[i] = new Hashtable();
                int j = 0;
                while (j < this.sequences.length && this.sequences[j] != null) {
                    if (sel.contains(this.sequences[j])) {
                        String s = this.sequences[j].getSequence();
                        String res = "";
                        ++noRes;
                        if (s.length() > i + 1) {
                            res = s.substring(i, i + 1);
                        } else if (s.length() == i + 1) {
                            res = s.substring(i);
                        }
                        if (this.cons[i].get(res) != null) {
                            int count = (Integer)this.cons[i].get(res) + 1;
                            this.cons[i].put(res, new Integer(count));
                        } else {
                            this.cons[i].put(res, new Integer(1));
                        }
                    }
                    ++j;
                }
                Enumeration e = this.cons[i].keys();
                String max = "";
                double maxno = 0.0;
                while (e.hasMoreElements()) {
                    String key = (String)e.nextElement();
                    double tmp = ((Integer)this.cons[i].get(key)).floatValue();
                    if (tmp > maxno) {
                        maxno = tmp;
                        max = key;
                    }
                    double percent = tmp * 100.0 / (double)noRes;
                    this.cons[i].put(key, new Double(percent));
                }
                this.cons[i].put("max", max);
            }
            ++i;
        }
    }

    public void percentIdentity() {
        this.percentIdentity2();
        this.findQuality();
        this.cons = new Hashtable[this.maxLength()];
        int i = 0;
        while (i < this.maxLength) {
            int noRes = 0;
            this.cons[i] = new Hashtable();
            int j = 0;
            while (j < this.sequences.length && this.sequences[j] != null) {
                String s = this.sequences[j].getSequence();
                String res = "";
                ++noRes;
                if (s.length() > i + 1) {
                    res = s.substring(i, i + 1);
                } else if (s.length() == i + 1) {
                    res = s.substring(i);
                }
                if (this.cons[i].get(res) != null) {
                    int count = (Integer)this.cons[i].get(res) + 1;
                    this.cons[i].put(res, new Integer(count));
                } else {
                    this.cons[i].put(res, new Integer(1));
                }
                ++j;
            }
            Enumeration e = this.cons[i].keys();
            String max = "";
            double maxno = 0.0;
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                double tmp = ((Integer)this.cons[i].get(key)).floatValue();
                if (tmp > maxno) {
                    maxno = tmp;
                    max = key;
                }
                double percent = tmp * 100.0 / (double)noRes;
                this.cons[i].put(key, new Double(percent));
            }
            this.cons[i].put("max", max);
            ++i;
        }
    }

    public void findQuality() {
        this.findQuality(0, this.maxLength - 1);
    }

    public void findQuality(int start, int end) {
        this.quality = new Vector();
        double max = -10000.0;
        String s = "";
        this.size = this.size();
        int j = start;
        while (j <= end) {
            double bigtot = 0.0;
            double[] x = new double[24];
            int ii = 0;
            while (ii < 24) {
                x[ii] = 0.0;
                try {
                    int i2 = 0;
                    while (i2 < 24) {
                        int n = ii;
                        x[n] = x[n] + ((double)this.cons2[j][i2] * (double)ResidueProperties.BLOSUM62[ii][i2] + 4.0);
                        ++i2;
                    }
                }
                catch (Exception e) {
                    System.out.println("Exception : " + e);
                }
                int n = ii++;
                x[n] = x[n] / (double)this.size;
            }
            int k = 0;
            while (k < this.size) {
                double tot = 0.0;
                double[] xx = new double[24];
                int i = 0;
                while (i < 23) {
                    double sr = 0.0;
                    try {
                        sr = (double)ResidueProperties.BLOSUM62[i][this.sequences[k].num[j]] + 4.0;
                    }
                    catch (Exception e) {
                        System.out.println("Exception in sr " + e);
                    }
                    xx[i] = x[i] - sr;
                    tot += xx[i] * xx[i];
                    ++i;
                }
                bigtot += Math.sqrt(tot);
                ++k;
            }
            if (max < bigtot) {
                max = bigtot;
            }
            this.quality.addElement(new Double(bigtot));
            s = String.valueOf(s) + "-";
            ++j;
        }
        j = start;
        while (j <= end) {
            double tmp = (Double)this.quality.elementAt(j);
            tmp = (max - tmp) * (double)(this.size - this.cons2[j][23]) / (double)this.size;
            this.quality.setElementAt(new Double(tmp), j);
            ++j;
        }
    }
}

