/*
 * Decompiled with CFR 0.152.
 */
package jalview;

import jalview.AlignFrame;
import jalview.AlignmentPanel;
import jalview.ConservationColourScheme;
import jalview.Popup;
import jalview.SequenceGroup;
import jalview.ThresholdPanel;
import java.awt.Event;
import java.awt.Frame;
import java.awt.Insets;

public class IncrementPopup
extends Popup {
    ThresholdPanel tp;

    public IncrementPopup(Frame parent, String title, String label, int low, int high) {
        super(parent, title);
        int value = this.findIncrement();
        this.tp = new ThresholdPanel(parent, label, low, high, value);
        this.status.setText("Enter the step by which to decrease colour intensity");
        this.gbc.fill = 0;
        this.gbc.insets = new Insets(20, 20, 20, 20);
        this.add(this.tp, this.gb, this.gbc, 0, 0, 2, 1);
        this.add(this.status, this.gb, this.gbc, 0, 1, 2, 1);
        this.add(this.apply, this.gb, this.gbc, 0, 2, 1, 1);
        this.add(this.close, this.gb, this.gbc, 1, 2, 1, 1);
        this.pack();
        this.show();
    }

    public boolean handleEvent(Event e) {
        if (e.target == this.apply && e.id == 1001) {
            int threshold = 0;
            try {
                threshold = Integer.valueOf(this.tp.tf.getText());
            }
            catch (Exception exception) {
                threshold = this.tp.sb.getValue();
                this.tp.tf.setText(new Integer(threshold).toString());
            }
            if (this.parent instanceof AlignFrame) {
                AlignFrame af = (AlignFrame)this.parent;
                af.increment = threshold;
                AlignmentPanel ap = af.ap;
                int j = 0;
                while (j < ap.seqPanel.align.groups.size()) {
                    SequenceGroup sg = (SequenceGroup)ap.seqPanel.align.groups.elementAt(j);
                    if (sg.colourScheme instanceof ConservationColourScheme) {
                        ((ConservationColourScheme)sg.colourScheme).inc = af.increment;
                        sg.colourScheme.setColours(sg);
                        this.status.setText("Changing group colour increment");
                        this.status.validate();
                    }
                    ++j;
                }
                af.updateFont();
            }
            return true;
        }
        if (e.target == this.close && e.id == 1001) {
            this.hide();
            this.dispose();
            return true;
        }
        return super.handleEvent(e);
    }

    public int findIncrement() {
        if (this.parent instanceof AlignFrame) {
            AlignFrame af = (AlignFrame)this.parent;
            AlignmentPanel ap = af.ap;
            int j = 0;
            while (j < ap.seqPanel.align.groups.size()) {
                SequenceGroup sg = (SequenceGroup)ap.seqPanel.align.groups.elementAt(j);
                if (sg.colourScheme instanceof ConservationColourScheme) {
                    af.increment = ((ConservationColourScheme)sg.colourScheme).inc;
                    return ((ConservationColourScheme)sg.colourScheme).inc;
                }
                ++j;
            }
        }
        return 30;
    }
}

