/*
 * Decompiled with CFR 0.152.
 */
package jalview;

import jalview.AlignFrame;
import jalview.ConsThread;
import jalview.DrawableSequence;
import jalview.FormatAdapter;
import jalview.FormatProperties;
import jalview.Popup;
import java.awt.Choice;
import java.awt.Event;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Label;
import java.awt.TextArea;

public class InputPopup
extends Popup {
    TextArea ta = new TextArea(25, 80);
    Label format;
    Choice f;

    public InputPopup(Frame parent, String title) {
        super(parent, title);
        this.ta.setFont(new Font("Courier", 0, 12));
        this.format = new Label("Alignment format");
        this.f = new Choice();
        int i = 0;
        while (i < FormatProperties.formats.size()) {
            this.f.addItem((String)FormatProperties.formats.elementAt(i));
            ++i;
        }
        this.gbc.fill = 0;
        this.gbc.insets = new Insets(20, 20, 20, 20);
        this.add(this.ta, this.gb, this.gbc, 0, 0, 4, 4);
        this.add(this.format, this.gb, this.gbc, 0, 4, 1, 1);
        this.add(this.f, this.gb, this.gbc, 1, 4, 1, 1);
        this.add(this.status, this.gb, this.gbc, 0, 5, 1, 1);
        this.add(this.apply, this.gb, this.gbc, 0, 6, 1, 1);
        this.add(this.close, this.gb, this.gbc, 1, 6, 1, 1);
        this.pack();
        this.show();
    }

    public boolean handleEvent(Event e) {
        if (e.target == this.apply && e.id == 1001) {
            DrawableSequence[] s = null;
            String inStr = this.ta.getText();
            if (FormatProperties.contains(this.f.getSelectedItem())) {
                s = FormatAdapter.toDrawableSequence(FormatAdapter.read(this.f.getSelectedItem(), inStr));
            } else {
                System.out.println("Format not supported");
            }
            if (s != null) {
                AlignFrame af = new AlignFrame(this.parent.getParent(), s);
                System.out.println("Size = " + af.ap.seqPanel.align.size());
                if (af.ap.seqPanel.align.size() > 0) {
                    af.resize(700, 500);
                    af.show();
                    ConsThread ct = new ConsThread(af);
                    ct.start();
                    this.hide();
                    this.dispose();
                } else {
                    af.dispose();
                    this.status.setText("Can't read input - check format");
                }
            } else {
                this.status.setText("No sequences found");
            }
            return true;
        }
        return super.handleEvent(e);
    }
}

