/*
 * Decompiled with CFR 0.152.
 */
package jalview;

import jalview.AlignFrame;
import jalview.DrawableSequence;
import jalview.Format;
import jalview.RotatableMatrix;
import jalview.Sequence;
import jalview.SequencePoint;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Graphics;
import java.awt.Image;
import java.util.Vector;

public class RotatableCanvas
extends Canvas {
    RotatableMatrix idmat = new RotatableMatrix(3, 3);
    RotatableMatrix objmat = new RotatableMatrix(3, 3);
    RotatableMatrix rotmat = new RotatableMatrix(3, 3);
    boolean redrawneeded = true;
    boolean drawAxes = true;
    int omx = 0;
    int mx = 0;
    int omy = 0;
    int my = 0;
    Image img;
    Graphics ig;
    Dimension prefsize;
    float[] centre = new float[3];
    float[] width = new float[3];
    float[] max = new float[3];
    float[] min = new float[3];
    float maxwidth;
    float scale;
    int npoint;
    Vector points;
    float[][] orig;
    float[][] axes;
    Vector selected;
    Object parent;
    int startx;
    int starty;
    int lastx;
    int lasty;
    int rectx1;
    int recty1;
    int rectx2;
    int recty2;
    float scalefactor = 1.0f;
    Sequence[] sequence;

    public RotatableCanvas(Object parent, Vector points, int npoint) {
        this.parent = parent;
        this.points = points;
        this.npoint = npoint;
        this.prefsize = this.getPreferredSize();
        this.orig = new float[npoint][3];
        int i = 0;
        while (i < npoint) {
            SequencePoint sp = (SequencePoint)points.elementAt(i);
            int j = 0;
            while (j < 3) {
                this.orig[i][j] = sp.coord[j];
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < 3) {
            int j = 0;
            while (j < 3) {
                if (i != j) {
                    this.idmat.addElement(i, j, 0.0f);
                    this.objmat.addElement(i, j, 0.0f);
                    this.rotmat.addElement(i, j, 0.0f);
                } else {
                    this.idmat.addElement(i, j, 0.0f);
                    this.objmat.addElement(i, j, 0.0f);
                    this.rotmat.addElement(i, j, 0.0f);
                }
                ++j;
            }
            ++i;
        }
        this.axes = new float[3][3];
        this.initAxes();
        this.findCentre();
        this.findWidth();
        this.scale = this.findScale();
        this.selected = new Vector();
        if (parent instanceof AlignFrame) {
            AlignFrame af = (AlignFrame)parent;
            this.selected = af.ap.sel;
        }
    }

    public void initAxes() {
        int i = 0;
        while (i < 3) {
            int j = 0;
            while (j < 3) {
                this.axes[i][j] = i != j ? 0.0f : 1.0f;
                ++j;
            }
            ++i;
        }
    }

    public void findWidth() {
        this.max = new float[3];
        this.min = new float[3];
        this.max[0] = -1.0E30f;
        this.max[1] = -1.0E30f;
        this.max[2] = -1.0E30f;
        this.min[0] = 1.0E30f;
        this.min[1] = 1.0E30f;
        this.min[2] = 1.0E30f;
        int i = 0;
        while (i < 3) {
            int j = 0;
            while (j < this.npoint) {
                SequencePoint sp = (SequencePoint)this.points.elementAt(j);
                if (sp.coord[i] >= this.max[i]) {
                    this.max[i] = sp.coord[i];
                }
                if (sp.coord[i] <= this.min[i]) {
                    this.min[i] = sp.coord[i];
                }
                ++j;
            }
            ++i;
        }
        this.width[0] = Math.abs(this.max[0] - this.min[0]);
        this.width[1] = Math.abs(this.max[1] - this.min[1]);
        this.width[2] = Math.abs(this.max[2] - this.min[2]);
        this.maxwidth = this.width[0];
        if (this.width[1] > this.width[0]) {
            this.maxwidth = this.width[1];
        }
        if (this.width[2] > this.width[1]) {
            this.maxwidth = this.width[2];
        }
    }

    public float findScale() {
        int height;
        int width;
        if (this.size().width != 0) {
            width = this.size().width;
            height = this.size().height;
        } else {
            width = this.prefsize.width;
            height = this.prefsize.height;
        }
        int dim = width < height ? width : height;
        return (float)dim * this.scalefactor / (2.0f * this.maxwidth);
    }

    public void findCentre() {
        this.findWidth();
        this.centre[0] = (this.max[0] + this.min[0]) / 2.0f;
        this.centre[1] = (this.max[1] + this.min[1]) / 2.0f;
        this.centre[2] = (this.max[2] + this.min[2]) / 2.0f;
    }

    public Dimension getPreferredSize() {
        if (this.prefsize != null) {
            return this.prefsize;
        }
        return new Dimension(400, 400);
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public void paint(Graphics g) {
        if (this.img == null || this.prefsize.width != this.size().width || this.prefsize.height != this.size().height) {
            this.prefsize.width = this.size().width;
            this.prefsize.height = this.size().height;
            this.scale = this.findScale();
            this.img = this.createImage(this.size().width, this.size().height);
            this.ig = this.img.getGraphics();
            this.redrawneeded = true;
        }
        if (this.redrawneeded) {
            this.drawBackground(this.ig, Color.black);
            this.drawScene(this.ig);
            if (this.drawAxes) {
                this.drawAxes(this.ig);
            }
            this.redrawneeded = false;
        } else {
            this.ig = this.img.getGraphics();
        }
        g.drawImage(this.img, 0, 0, this);
    }

    public void drawAxes(Graphics g) {
        g.setColor(Color.yellow);
        int i = 0;
        while (i < 3) {
            g.drawLine(this.size().width / 2, this.size().height / 2, (int)(this.axes[i][0] * this.scale * this.max[0] + (float)(this.size().width / 2)), (int)(this.axes[i][1] * this.scale * this.max[1] + (float)(this.size().height / 2)));
            ++i;
        }
    }

    public void drawBackground(Graphics g, Color col) {
        g.setColor(col);
        g.fillRect(0, 0, this.prefsize.width, this.prefsize.height);
    }

    public Sequence findPoint(int x, int y) {
        int halfwidth = this.size().width / 2;
        int halfheight = this.size().height / 2;
        int found = -1;
        int i = 0;
        while (i < this.npoint) {
            SequencePoint sp = (SequencePoint)this.points.elementAt(i);
            int px = (int)((sp.coord[0] - this.centre[0]) * this.scale) + halfwidth;
            int py = (int)((sp.coord[1] - this.centre[1]) * this.scale) + halfheight;
            if (Math.abs(px - x) < 3 && Math.abs(py - y) < 3) {
                found = i;
            }
            ++i;
        }
        if (found != -1) {
            return ((SequencePoint)this.points.elementAt((int)found)).sequence;
        }
        return null;
    }

    public void drawScene(Graphics g) {
        int halfwidth = this.size().width / 2;
        int halfheight = this.size().height / 2;
        int i = 0;
        while (i < this.npoint) {
            SequencePoint sp = (SequencePoint)this.points.elementAt(i);
            int x = (int)((sp.coord[0] - this.centre[0]) * this.scale) + halfwidth;
            int y = (int)((sp.coord[1] - this.centre[1]) * this.scale) + halfheight;
            float z = sp.coord[1] - this.centre[2];
            if (sp.sequence instanceof DrawableSequence) {
                if (((DrawableSequence)sp.sequence).color == Color.black) {
                    g.setColor(Color.white);
                } else {
                    g.setColor(((DrawableSequence)sp.sequence).color);
                }
            } else {
                g.setColor(Color.red);
            }
            if (this.parent instanceof AlignFrame && this.selected.contains(((SequencePoint)this.points.elementAt((int)i)).sequence)) {
                g.setColor(Color.gray);
            }
            if (z < 0.0f) {
                g.setColor(g.getColor().darker());
            }
            g.fillRect(x - 3, y - 3, 6, 6);
            g.setColor(Color.red);
            ++i;
        }
        if (this.rectx2 != -1 && this.recty2 != -1) {
            g.setColor(Color.white);
            g.drawRect(this.rectx1, this.recty1, this.rectx2 - this.rectx1, this.recty2 - this.recty1);
        }
    }

    public Dimension minimumsize() {
        return this.prefsize;
    }

    public Dimension preferredsize() {
        return this.prefsize;
    }

    public boolean keyDown(Event evt, int key) {
        this.requestFocus();
        if (key == 1004) {
            this.scalefactor = (float)((double)this.scalefactor * 1.1);
            this.scale = this.findScale();
            this.redrawneeded = true;
            this.repaint();
            return true;
        }
        if (key == 1005) {
            this.scalefactor = (float)((double)this.scalefactor * 0.9);
            this.scale = this.findScale();
            this.redrawneeded = true;
            this.repaint();
            return true;
        }
        if (key == 115) {
            if (this.rectx2 != -1 && this.recty2 != -1) {
                this.rectSelect(this.rectx1, this.recty1, this.rectx2, this.recty2);
                this.redrawneeded = true;
                this.repaint();
            }
            return true;
        }
        return true;
    }

    public void printPoints() {
        int i = 0;
        while (i < this.npoint) {
            SequencePoint sp = (SequencePoint)this.points.elementAt(i);
            Format.print(System.out, "%5d ", i);
            int j = 0;
            while (j < 3) {
                Format.print(System.out, "%13.3f  ", sp.coord[j]);
                ++j;
            }
            System.out.println();
            ++i;
        }
    }

    public boolean mouseDown(Event e, int x, int y) {
        this.mx = x;
        this.my = y;
        this.omx = this.mx;
        this.omy = this.my;
        this.startx = x;
        this.starty = y;
        this.rectx1 = x;
        this.recty1 = y;
        this.rectx2 = -1;
        this.recty2 = -1;
        Sequence found = this.findPoint(x, y);
        if (found != null) {
            if (this.parent instanceof AlignFrame) {
                AlignFrame af = (AlignFrame)this.parent;
                if (af.ap.sel.contains(found)) {
                    af.ap.sel.removeElement(found);
                } else {
                    af.ap.sel.addElement(found);
                }
                af.ap.idPanel.idCanvas.paintFlag = true;
                af.ap.idPanel.idCanvas.repaint();
                if (af.tt != null) {
                    af.tt.tf.p.mc.repaint();
                }
            }
            System.out.println("Sequence found = " + found.name);
        }
        this.redrawneeded = true;
        this.repaint();
        return true;
    }

    public boolean mouseDrag(Event e, int x, int y) {
        this.mx = x;
        this.my = y;
        if ((e.modifiers & 4) != 0) {
            this.rectx2 = x;
            this.recty2 = y;
        } else {
            this.rotmat.setIdentity();
            this.rotmat.rotate(this.my - this.omy, 'x');
            this.rotmat.rotate(this.mx - this.omx, 'y');
            int i = 0;
            while (i < this.npoint) {
                SequencePoint sp = (SequencePoint)this.points.elementAt(i);
                sp.coord[0] = sp.coord[0] - this.centre[0];
                sp.coord[1] = sp.coord[1] - this.centre[1];
                sp.coord[2] = sp.coord[2] - this.centre[2];
                sp.coord = this.rotmat.vectorMultiply(sp.coord);
                sp.coord[0] = sp.coord[0] + this.centre[0];
                sp.coord[1] = sp.coord[1] + this.centre[1];
                sp.coord[2] = sp.coord[2] + this.centre[2];
                ++i;
            }
            i = 0;
            while (i < 3) {
                this.axes[i] = this.rotmat.vectorMultiply(this.axes[i]);
                ++i;
            }
        }
        this.omx = this.mx;
        this.omy = this.my;
        this.redrawneeded = true;
        this.paint(this.getGraphics());
        return true;
    }

    public void rectSelect(int x1, int y1, int x2, int y2) {
        int i = 0;
        while (i < this.npoint) {
            SequencePoint sp = (SequencePoint)this.points.elementAt(i);
            int tmp1 = (int)((sp.coord[0] - this.centre[0]) * this.scale + (float)(this.size().width / 2));
            int tmp2 = (int)((sp.coord[1] - this.centre[1]) * this.scale + (float)(this.size().width / 2));
            if (tmp1 <= x1 || tmp1 >= x2 || tmp2 > y1) {
                // empty if block
            }
            ++i;
        }
    }

    public void update(Graphics g) {
        this.paint(g);
    }
}

