/*
 * Decompiled with CFR 0.152.
 */
package jalview;

import jalview.BrowserFrame;
import java.awt.Event;
import java.awt.Font;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.StringTokenizer;
import java.util.Vector;

public class SimpleBrowser {
    String server;
    int port;
    String out;
    BrowserFrame bf;
    Vector pages;
    int position = 0;

    public static void main(String[] args) {
        if (args.length == 2) {
            new SimpleBrowser("srs.ebi.ac.uk", 80, "srs5bin/cgi-bin/wgetz?-e+[" + args[0] + "-id:" + args[1] + "]");
        } else if (args.length == 1) {
            new SimpleBrowser(args[0]);
        } else {
            new SimpleBrowser("");
        }
    }

    public SimpleBrowser(String url) {
        this.pages = new Vector();
        this.pages.addElement(url);
        this.frameInit(url);
    }

    public SimpleBrowser(String server, int port, String page) {
        this.server = server;
        this.port = port;
        if (page.indexOf("/") != 0) {
            page = "/" + page;
        }
        String url = "http://" + server + ":" + port + page;
        this.pages = new Vector();
        this.pages.addElement(url);
        this.frameInit(url);
    }

    public void frameInit(String url) {
        this.bf = new BrowserFrame(this, "SimpleBrowser", 25, 72, "", url);
        this.bf.ta.setFont(new Font("Courier", 0, 12));
        this.bf.resize(700, 500);
        this.bf.show();
        this.bf.back.disable();
        this.bf.forward.disable();
        this.bf.status.setText("Connecting to server");
        this.connect(this.split(url));
    }

    public void connect(String page) {
        this.bf.status.setText("Connecting to server...");
        try {
            Socket socket = new Socket(this.server, this.port);
            socket.setSoTimeout(5000);
            BufferedReader inputStream = new BufferedReader(new InputStreamReader(socket.getInputStream()));
            PrintWriter outputStream = new PrintWriter((Writer)new OutputStreamWriter(socket.getOutputStream()), true);
            this.bf.status.setText("Reading URL...");
            outputStream.println("GET " + page + " HTTP/1.0");
            outputStream.println("Host: " + this.server);
            outputStream.println();
            String line = "";
            String text = "";
            int count = 0;
            boolean headers = true;
            while ((line = inputStream.readLine()) != null) {
                if (line.equals("")) {
                    headers = false;
                }
                if (!headers && !line.equals("")) {
                    text = String.valueOf(text) + SimpleBrowser.parse(line) + "\n";
                }
                if (count != 1) {
                    this.bf.status.setText("Read " + count + " lines");
                } else {
                    this.bf.status.setText("Read " + count + " line");
                }
                ++count;
            }
            this.bf.setText(text);
            this.bf.status.setText("done");
            socket.close();
        }
        catch (UnknownHostException e) {
            System.out.println(e);
            this.bf.setText("Not online");
            this.bf.status.setText("");
        }
        catch (SocketException e) {
            System.out.println("Socket Exception " + e);
            this.bf.setText("Socket exception");
            this.bf.status.setText("");
        }
        catch (InterruptedIOException e) {
            System.out.println("Read to server timed out " + e);
            this.bf.setText("Server connect timed out");
            this.bf.status.setText("");
        }
        catch (IOException e) {
            this.bf.setText("IO exception");
            this.bf.status.setText("");
            System.out.println("IOException " + e);
        }
    }

    public boolean action(Event e, Object arg) {
        System.out.println(e + " " + arg);
        if (e.target == this.bf.tf) {
            System.out.println("new page");
            String url = this.bf.tf.getText();
            this.pages.addElement(url);
            String page = this.split(url);
            System.out.println("Server = " + this.server);
            System.out.println("Port = " + this.port);
            System.out.println("Page = " + page);
            this.connect(page);
            ++this.position;
            this.bf.back.enable();
            return true;
        }
        if (e.target == this.bf.back) {
            System.out.println("pos " + this.position + " " + this.pages.size());
            if (this.position > 0) {
                --this.position;
                String page = this.split((String)this.pages.elementAt(this.position));
                this.bf.tf.setText((String)this.pages.elementAt(this.position));
                this.connect(page);
                if (this.position == 0) {
                    this.bf.back.disable();
                }
                this.bf.forward.enable();
            }
            return true;
        }
        if (e.target == this.bf.forward) {
            if (this.position != this.pages.size() - 1) {
                ++this.position;
                this.bf.tf.setText((String)this.pages.elementAt(this.position));
                String page = this.split((String)this.pages.elementAt(this.position));
                if (this.position == this.pages.size() - 1) {
                    this.bf.forward.disable();
                }
                this.bf.back.enable();
                this.connect(page);
            }
            return true;
        }
        if (e.target == this.bf.b) {
            System.out.println("Disposing of browser frame");
            this.bf.hide();
            this.bf.dispose();
            this.bf = null;
            return true;
        }
        return false;
    }

    public boolean handleEvent(Event e) {
        if (e.id == 201) {
            System.out.println("Disposing of browser frame");
            this.bf.hide();
            this.bf.dispose();
            this.bf = null;
            return true;
        }
        return false;
    }

    public static String removeString(String line, String off) {
        while (line.indexOf(off) >= 0) {
            String tmp;
            line = tmp = String.valueOf(line.substring(0, line.indexOf(off))) + line.substring(line.indexOf(off) + off.length());
        }
        return line;
    }

    public static String parse(String line) {
        String out = "";
        if ((line = SimpleBrowser.removeString(line, "&nbsp;")).indexOf("<") >= 0) {
            StringTokenizer st = new StringTokenizer(line, "<");
            while (st.hasMoreTokens()) {
                String tmp = st.nextToken();
                out = tmp.indexOf(">") >= 0 ? String.valueOf(out) + tmp.substring(tmp.indexOf(">") + 1) : String.valueOf(out) + tmp;
            }
        } else {
            out = line;
        }
        return out;
    }

    public String split(String url) {
        System.out.println(url);
        if (url.indexOf("http://") == 0) {
            url = url.substring(7);
        }
        System.out.println("URL = " + url);
        String page = "/";
        if (url.indexOf("/") != -1) {
            page = url.substring(url.indexOf("/"));
            url = url.substring(0, url.indexOf("/"));
        }
        System.out.println("PAge = " + page);
        System.out.println("Url = " + url);
        if (url.indexOf(":") >= 0) {
            this.port = Integer.parseInt(url.substring(url.indexOf(":") + 1));
            this.server = url.substring(0, url.indexOf(":"));
        } else {
            this.port = 80;
            this.server = url.indexOf("/") != -1 ? url.substring(0, url.indexOf("/")) : url;
        }
        System.out.println(this.server);
        System.out.println(this.port);
        return page;
    }
}

