/*
 * Decompiled with CFR 0.152.
 */
package scigol;

import antlr.RecognitionException;
import antlr.collections.AST;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import scigol.Class;
import scigol.ClassScope;
import scigol.Debug;
import scigol.Entry;
import scigol.Func;
import scigol.FuncInfo;
import scigol.Location;
import scigol.ScigolTreeParser;
import scigol.Scope;
import scigol.TypeManager;
import scigol.TypeSpec;
import scigol.Value;
import scigol.accessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassInfo {
    protected ArrayList comparisonPairStack = new ArrayList();
    protected static ArrayList toStringArray = new ArrayList();
    static HashMap<java.lang.Class, Entry[]> javaTypes = new HashMap();
    protected Scope _outerScope;
    protected ClassType _classType;
    protected boolean _isAbstract;
    protected boolean _isInterface;
    protected EnumSet<TypeSpec.Modifier> _modifiers;
    protected TypeSpec _superClass;
    protected ArrayList _interfaces;
    protected boolean complete;
    protected ArrayList _members;
    protected String identityHint = null;
    protected Location _location = new Location();
    Type _sysType;
    static /* synthetic */ java.lang.Class class$0;
    static /* synthetic */ java.lang.Class class$1;
    static /* synthetic */ java.lang.Class class$2;

    public ClassInfo(Scope outerScope, TypeSpec superClass) {
        if (superClass != null && superClass.isBuiltin() && !superClass.isBuiltinObject()) {
            ScigolTreeParser.semanticError("can only subclass builtin type 'object' (i.e. not '" + superClass + "')");
        }
        this._classType = ClassType.Local;
        this._outerScope = outerScope;
        this._modifiers = EnumSet.of(TypeSpec.Modifier.Public);
        this._superClass = superClass;
        boolean bl = this._isInterface = superClass == null;
        if (this._isInterface) {
            this._superClass = new TypeSpec(TypeSpec.objectType);
        }
        this._isAbstract = this._isInterface;
        this._interfaces = new ArrayList();
        this._members = new ArrayList();
        this.addMember("self", EnumSet.of(Entry.Flags.Field), TypeSpec.typeTypeSpec, EnumSet.of(TypeSpec.Modifier.Static, TypeSpec.Modifier.Public), new TypeSpec(this), null);
        this.complete = false;
    }

    public ClassInfo(java.lang.Class externalClassType) {
        java.lang.Class<?>[] interfaces;
        this._classType = ClassType.External;
        this._sysType = externalClassType;
        this._isAbstract = Modifier.isAbstract(externalClassType.getModifiers());
        this._isInterface = externalClassType.isInterface();
        if (!this._isInterface) {
            java.lang.Class baseType = externalClassType.getSuperclass();
            this._superClass = null;
            if (baseType != null && !baseType.equals(Void.TYPE)) {
                this._superClass = new TypeSpec(baseType);
            }
        } else {
            this._superClass = TypeSpec.objectTypeSpec;
        }
        this._interfaces = new ArrayList();
        java.lang.Class<?>[] classArray = interfaces = externalClassType.getInterfaces();
        int n = 0;
        int n2 = classArray.length;
        while (n < n2) {
            java.lang.Class<?> it = classArray[n];
            this._interfaces.add(new TypeSpec(it));
            ++n;
        }
        this._members = null;
        this.complete = true;
    }

    public EnumSet<TypeSpec.Modifier> getModifiers() {
        return this._modifiers;
    }

    public void setModifiers(EnumSet<TypeSpec.Modifier> modifiers) {
        this._modifiers = modifiers;
        if (this._modifiers.contains((Object)TypeSpec.Modifier.Abstract) && this._isInterface) {
            ScigolTreeParser.semanticError("an interface cannot have the 'abstract' modifier - it is abstract by definition");
        }
        if (this._modifiers.contains((Object)TypeSpec.Modifier.Static)) {
            ScigolTreeParser.semanticError("an interface or class cannot have the 'static' modifier (perhaps you meant the 'type' variable to be static?)");
        }
    }

    public TypeSpec getBaseClass() {
        return this._superClass;
    }

    public void addInterface(TypeSpec interfaceType) {
        Debug.Assert(interfaceType.isInterface());
        Debug.Assert(!this.complete);
        this._interfaces.add(interfaceType);
    }

    public void setIdentityHint(String hint) {
        this.identityHint = hint;
    }

    public Location getDefinitionLocation() {
        if (this._location == null) {
            return new Location();
        }
        return this._location;
    }

    public void setDefinitionLocation(Location value) {
        this._location = value;
    }

    public void completeDefinition() {
        Debug.Assert(this._classType == ClassType.Local, "can't call completeDefinition() on external class types");
        Debug.Assert(!this.complete, "class already complete");
        if (!this._isInterface && !this.declaresMember(".ctor")) {
            FuncInfo fi = new FuncInfo();
            fi.setReturnType(new TypeSpec(this));
            this.addMember(".ctor", EnumSet.of(Entry.Flags.Method), new TypeSpec(fi), EnumSet.of(TypeSpec.Modifier.Public, TypeSpec.Modifier.Static), null, null);
        }
        if (!this._isAbstract) {
            Entry[] declaredMembers;
            int instanceIndex = 0;
            if (this._superClass != null) {
                instanceIndex += this._superClass.getClassInfo().getAllInstanceEntries(null).length;
            }
            Entry[] entryArray = declaredMembers = this.getDeclaredEntries(null);
            int n = 0;
            int n2 = entryArray.length;
            while (n < n2) {
                Entry entry = entryArray[n];
                entry.index = !entry.isStatic() && !entry.isProperty() ? instanceIndex++ : 0;
                ++n;
            }
        }
        this.complete = true;
    }

    public Entry[] getDeclaredEntries(String name) {
        if (this._classType == ClassType.Local) {
            ArrayList<Entry> entries = new ArrayList<Entry>();
            for (Object o : this._members) {
                Entry entry = (Entry)o;
                if (name == null) {
                    entries.add(entry);
                    continue;
                }
                if (!entry.name.equals(name)) continue;
                entries.add(entry);
            }
            return Entry.toArray(entries);
        }
        return ClassInfo.externalGetDeclaredEntries(this, name);
    }

    public boolean declaresMember(String name) {
        Entry[] declaredMembers;
        Debug.Assert(name != null);
        Entry[] entryArray = declaredMembers = this.getDeclaredEntries(name);
        int n = 0;
        int n2 = entryArray.length;
        while (n < n2) {
            Entry e = entryArray[n];
            if (e.name.equals(name)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public boolean hasMember(String name) {
        Entry[] allMembers;
        Debug.Assert(name != null);
        Entry[] entryArray = allMembers = this.getAllEntries(name);
        int n = 0;
        int n2 = entryArray.length;
        while (n < n2) {
            Entry e = entryArray[n];
            if (e.name.equals(name)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public Entry[] getAllEntries(String name) {
        Entry[] declaredEntries;
        Entry e;
        Entry[] entryArray;
        ArrayList<Entry> entries = new ArrayList<Entry>();
        for (Object o : this._interfaces) {
            Entry[] interfaceEntries;
            TypeSpec interfaceType = (TypeSpec)o;
            Entry[] entryArray2 = interfaceEntries = interfaceType.getClassInfo().getAllEntries(name);
            int n = 0;
            int n2 = entryArray2.length;
            while (n < n2) {
                Entry e2 = entryArray2[n];
                entries.add(e2);
                ++n;
            }
        }
        if (this._superClass != null) {
            Entry[] superEntries = this._superClass.getClassInfo().getAllEntries(name);
            entryArray = superEntries;
            int n = 0;
            int n3 = entryArray.length;
            while (n < n3) {
                e = entryArray[n];
                entries.add(e);
                ++n;
            }
        }
        entryArray = declaredEntries = this.getDeclaredEntries(name);
        int n = 0;
        int n4 = entryArray.length;
        while (n < n4) {
            e = entryArray[n];
            entries.add(e);
            ++n;
        }
        return Entry.toArray(entries);
    }

    public Entry[] getAllInstanceEntries(String name) {
        Entry[] allEntries;
        ArrayList<Entry> instanceEntries = new ArrayList<Entry>();
        Entry[] entryArray = allEntries = this.getAllEntries(name);
        int n = 0;
        int n2 = entryArray.length;
        while (n < n2) {
            Entry e = entryArray[n];
            if (!e.isStatic() && !e.isAbstract()) {
                instanceEntries.add(e);
            }
            ++n;
        }
        return Entry.toArray(instanceEntries);
    }

    public Entry[] lookup(String name, FuncInfo callSig, Object[] args) {
        ArrayList candidates = new ArrayList();
        ClassInfo c = this;
        while (c != null) {
            ArrayList currEntries = Entry.toArrayList(c.getDeclaredEntries(name));
            if (currEntries.size() == 1 && !((Entry)currEntries.get((int)0)).type.isFunc()) {
                return Entry.toArray(currEntries);
            }
            ArrayList newCurrEntries = (ArrayList)currEntries.clone();
            for (Object o : currEntries) {
                Entry ce = (Entry)o;
                if (ce.isAbstract()) {
                    newCurrEntries.remove(ce);
                    continue;
                }
                boolean ceIsFunc = ce.type.isFunc();
                FuncInfo ceFuncInfo = ceIsFunc ? ce.type.getFuncInfo() : null;
                for (Object o2 : candidates) {
                    Entry ee = (Entry)o2;
                    if (!ce.name.equals(ee.name) || ceIsFunc && !ceFuncInfo.equalsParams(ee.type.getFuncInfo())) continue;
                    newCurrEntries.remove(ce);
                }
            }
            for (Object e : newCurrEntries) {
                candidates.add(e);
            }
            c = c._superClass != null ? c._superClass.getClassInfo() : null;
        }
        if (callSig == null) {
            return Entry.toArray(candidates);
        }
        return TypeManager.resolveOverload(Entry.toArray(candidates), callSig, args);
    }

    public ClassInfo[] directlyDependsOn() {
        Scope outer = this._outerScope;
        while (outer != null && !outer.isClassScope()) {
            outer = outer.getOuter();
        }
        if (outer != null && outer instanceof ClassScope) {
            ClassInfo[] infos = new ClassInfo[2];
            if (this._superClass != null) {
                infos[0] = ((ClassScope)outer).getClassType().getClassInfo();
                infos[1] = this._superClass.getClassInfo();
                return infos;
            }
            infos[0] = ((ClassScope)outer).getClassType().getClassInfo();
            infos[1] = new ClassInfo(TypeSpec.objectType);
            return infos;
        }
        ClassInfo[] info = new ClassInfo[]{this._superClass != null ? this._superClass.getClassInfo() : new ClassInfo(TypeSpec.objectType)};
        return info;
    }

    public ClassInfo[] dependsOn() {
        return this.directlyDependsOn();
    }

    public Class instantiateClass(FuncInfo ctorCallSig, ArrayList args, ScigolTreeParser treeParser) {
        Func ctor;
        Entry ctorEntry;
        int a;
        FuncInfo callSig;
        if (args == null) {
            args = new ArrayList();
        }
        if ((callSig = ctorCallSig) == null) {
            TypeSpec[] paramTypes = new TypeSpec[args.size()];
            a = 0;
            while (a < args.size()) {
                paramTypes[a] = TypeSpec.typeOf(args.get(a));
                ++a;
            }
            callSig = new FuncInfo(paramTypes, new TypeSpec(this));
        }
        if (this._isInterface || this._isAbstract) {
            ScigolTreeParser.semanticError(callSig.getDefinitionLocation(), "abstract class or interface '" + this.toString() + "' cannot be instantiated");
        }
        if (!this.complete) {
            ScigolTreeParser.semanticError(callSig.getDefinitionLocation(), "can't instantiate incomplete type '" + this.toString() + "'");
        }
        if (this._classType == ClassType.Local) {
            Func ctor2;
            Entry ctorEntry2;
            Entry[] instanceMembers = this.getAllInstanceEntries(null);
            ArrayList<Object> memberValues = new ArrayList<Object>();
            Entry[] entryArray = instanceMembers;
            int n = 0;
            int n2 = entryArray.length;
            while (n < n2) {
                Entry entry = entryArray[n];
                if (!entry.isProperty()) {
                    boolean staticOrConst;
                    boolean bl = staticOrConst = entry.isStatic() || entry.isConst();
                    if (staticOrConst) {
                        memberValues.add(entry.getStaticValue());
                    } else if (entry.initializer != null) {
                        AST initializerExprAST = entry.initializer;
                        Scope savedScope = treeParser.scope;
                        treeParser.scope = new ClassScope(new TypeSpec(this));
                        Value initializer = null;
                        try {
                            initializer = treeParser.expr(initializerExprAST);
                        }
                        catch (RecognitionException e) {
                            ScigolTreeParser.semanticError("error instantiating class '" + this + " - " + e.getMessage());
                        }
                        treeParser.scope = savedScope;
                        TypeSpec initializerType = TypeSpec.typeOf(initializer);
                        if (TypeManager.existsImplicitConversion(initializerType, entry.type, initializer)) {
                            initializer = TypeManager.performImplicitConversion(initializerType, entry.type, initializer);
                        } else {
                            ScigolTreeParser.semanticError("initializer value for member '" + entry.name + ":" + entry.type + "' of class '" + this + "' has incompatible type '" + initializerType + "'");
                        }
                        memberValues.add(initializer.getValue());
                    } else if (entry.getStaticValue() == null) {
                        memberValues.add(entry.type.constructValue(null, null, treeParser).getValue());
                    } else {
                        memberValues.add(entry.getStaticValue());
                    }
                }
                ++n;
            }
            Class newClass = new Class(this, memberValues);
            Object[] aargs = new Object[args.size()];
            int a2 = 0;
            while (a2 < args.size()) {
                aargs[a2] = args.get(a2);
                ++a2;
            }
            Entry[] ctors = this.lookup(".ctor", callSig, aargs);
            if (ctors.length == 0) {
                ScigolTreeParser.semanticError(callSig.getDefinitionLocation(), "no contructor for type '" + this + "' with compatible parameter types for call signature " + callSig + " found");
            }
            if (ctors.length != 1) {
                ScigolTreeParser.semanticError(callSig.getDefinitionLocation(), "contructor for type '" + this + "' is ambiguous for call signature " + callSig);
            }
            if ((ctorEntry2 = ctors[0]).getStaticValue() != null) {
                Debug.Assert(ctorEntry2.getStaticValue() instanceof Func, ".ctor isn't a Func!");
            }
            Func func = ctor2 = ctorEntry2.getStaticValue() != null ? (Func)ctorEntry2.getStaticValue() : null;
            if (ctor2 != null) {
                aargs = ctor2.getInfo().convertParameters(callSig, aargs, false);
            }
            if (ctor2 != null) {
                ctor2.call((Object)newClass, aargs);
            }
            return newClass;
        }
        Object[] aargs = new Object[args.size()];
        a = 0;
        while (a < args.size()) {
            aargs[a] = args.get(a);
            ++a;
        }
        Entry[] ctors = this.lookup(".ctor", callSig, aargs);
        if (ctors.length == 0) {
            ScigolTreeParser.semanticError(callSig.getDefinitionLocation(), "no contructor for type '" + ((java.lang.Class)this._sysType).getName() + "' with compatible parameter types for call signature " + callSig + " found");
        }
        if (ctors.length != 1) {
            ScigolTreeParser.semanticError(callSig.getDefinitionLocation(), "contructor for type '" + ((java.lang.Class)this._sysType).getName() + "' is ambiguous for call signature " + callSig);
        }
        if ((ctorEntry = ctors[0]).getStaticValue() != null) {
            Debug.Assert(ctorEntry.getStaticValue() instanceof Func, ".ctor isn't a Func!");
        }
        Func func = ctor = ctorEntry.getStaticValue() != null ? (Func)ctorEntry.getStaticValue() : null;
        if (ctor != null) {
            aargs = ctor.getInfo().convertParameters(callSig, aargs, true);
        }
        Object obj = null;
        if (ctor != null) {
            obj = ctor.call(null, aargs);
        }
        if (obj == null) {
            ScigolTreeParser.semanticError(callSig.getDefinitionLocation(), "construction failed");
        }
        return new Class(this, obj);
    }

    public void addMember(String name, EnumSet<Entry.Flags> flags, TypeSpec type, EnumSet<TypeSpec.Modifier> modifiers, Object value, AST initializer) {
        Debug.Assert(name != null);
        if (initializer == null && type.isClass() && !flags.contains((Object)Entry.Flags.Property) && type.getClassInfo() == this) {
            ScigolTreeParser.semanticError("instance members of type 'self' in class '" + this + "' must have an initializer supplied (as construction of default self() is recursive)");
        }
        String actualName = null;
        if (!type.isFunc()) {
            Debug.Assert(flags.contains((Object)Entry.Flags.Field));
            if (TypeSpec.isOperator(name)) {
                ScigolTreeParser.semanticError("the name '" + name + "' is a special func member (method) name for operator overloading and cannot be used for fields (in class '" + this + "')");
            }
            if (this._isInterface && name != "self") {
                ScigolTreeParser.semanticError("an interface '" + this + "' cannot contain a field ('" + name + "')");
            }
            this.hasMember(name);
        } else {
            Debug.Assert(flags.contains((Object)Entry.Flags.Method));
            if (TypeSpec.isOperator(name)) {
                if (!name.equals("operator->")) {
                    if (!modifiers.contains((Object)TypeSpec.Modifier.Static) || !modifiers.contains((Object)TypeSpec.Modifier.Public)) {
                        ScigolTreeParser.semanticError("operator '" + name + "' must be declared 'public static' in class '" + this + "'");
                    }
                    boolean binary = true;
                    if (type.getFuncInfo().numArgs() == 1) {
                        binary = false;
                    } else if (type.getFuncInfo().numArgs() != 2 || type.getFuncInfo().numArgs() != type.getFuncInfo().numRequiredArgs()) {
                        ScigolTreeParser.semanticError("operators must have one (unary) or two (binary) arguments (with no default values) in class '" + this + "'");
                    }
                    actualName = TypeSpec.operatorJavaName(name, binary);
                } else {
                    if (!modifiers.contains((Object)TypeSpec.Modifier.Public)) {
                        ScigolTreeParser.semanticError("operator '" + name + "' must be declared 'public' in class '" + this + "'");
                    }
                    actualName = !modifiers.contains((Object)TypeSpec.Modifier.Implicit) ? "op_Implicit" : "op_Explicit";
                    if (modifiers.contains((Object)TypeSpec.Modifier.Static)) {
                        if (type.getFuncInfo().numArgs() != 1 || type.getFuncInfo().numRequiredArgs() != 1) {
                            ScigolTreeParser.semanticError("static conversion operators must have one argument (with no default value) in class '" + this + "'");
                        }
                    } else {
                        if (type.getFuncInfo().numArgs() != 0) {
                            ScigolTreeParser.semanticError("instance conversion operators must have no arguments in class '" + this + "'");
                        }
                        if (type.getFuncInfo().getReturnType().isString()) {
                            actualName = "toString";
                        }
                    }
                }
            }
            if (this._isInterface) {
                modifiers.add(TypeSpec.Modifier.Abstract);
            }
        }
        Entry e = new Entry(name, actualName, type, value, initializer, modifiers, flags, -1, new ClassScope(new TypeSpec(this)));
        this._members.add(e);
    }

    public Scope getOuterScope() {
        return this._outerScope;
    }

    public boolean isTypeSpec() {
        if (this._classType == ClassType.External) {
            return this._sysType.equals(TypeSpec.class);
        }
        return false;
    }

    public boolean isInterface() {
        return this._isInterface;
    }

    public boolean isClass() {
        return !this._isInterface;
    }

    public boolean isAbstract() {
        return this._isInterface || this._isAbstract;
    }

    public boolean isA(ClassInfo superClass) {
        if (this == superClass) {
            return true;
        }
        if (superClass.isBuiltinObject()) {
            return true;
        }
        if (this.isExternal()) {
            if (superClass.isExternal()) {
                return ((java.lang.Class)superClass.getSysType()).isAssignableFrom((java.lang.Class)this._sysType);
            }
            return false;
        }
        if (superClass.isExternal()) {
            return false;
        }
        if (this.isInterface() && superClass.isClass()) {
            return false;
        }
        if (this.isClass()) {
            if (superClass.isClass()) {
                TypeSpec t = this._superClass;
                while (t != null) {
                    if (t.isBuiltinObject()) {
                        return false;
                    }
                    if (t.getClassInfo().equals(superClass)) {
                        return true;
                    }
                    t = t.getClassInfo()._superClass;
                }
                return false;
            }
            Debug.WriteLine("Warning: isA() unimplemented");
            return false;
        }
        if (superClass.isClass()) {
            return false;
        }
        Debug.WriteLine("Warning: interface.isA() unimplemented");
        return true;
    }

    public boolean isExternal() {
        return this._classType == ClassType.External;
    }

    public boolean isBuiltinObject() {
        return this._classType == ClassType.External && this._sysType.equals(TypeSpec.objectType);
    }

    public Type getSysType() {
        Debug.Assert(this._classType == ClassType.External);
        return this._sysType;
    }

    protected boolean comparisonStackContains(ClassInfoPair pair) {
        for (Object o : this.comparisonPairStack) {
            ClassInfoPair p = (ClassInfoPair)o;
            if (!p.equals(pair)) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object classInfo) {
        if (classInfo == null) {
            return false;
        }
        if (classInfo == this) {
            return true;
        }
        if (!(classInfo instanceof ClassInfo)) {
            return false;
        }
        ClassInfo info = (ClassInfo)classInfo;
        if (this._classType == ClassType.External && info._classType == ClassType.External) {
            return this._sysType.equals(info._sysType);
        }
        ClassInfoPair currentPair = new ClassInfoPair(this, info);
        if (this.comparisonStackContains(currentPair)) {
            return true;
        }
        this.comparisonPairStack.add(currentPair);
        if (this._isInterface && !info._isInterface || !this._isInterface && info._isInterface) {
            this.comparisonPairStack.remove(currentPair);
            return false;
        }
        if (this._isAbstract && !info._isAbstract || !this._isAbstract && info._isAbstract) {
            this.comparisonPairStack.remove(currentPair);
            return false;
        }
        if (this._superClass != null && info._superClass != null && !this._superClass.equals(info._superClass)) {
            this.comparisonPairStack.remove(currentPair);
            return false;
        }
        if (this._interfaces.size() != info._interfaces.size()) {
            this.comparisonPairStack.remove(currentPair);
            return false;
        }
        int i = 0;
        while (i < this._interfaces.size()) {
            if (!((TypeSpec)this._interfaces.get(i)).equals(info._interfaces.get(i))) {
                this.comparisonPairStack.remove(currentPair);
                return false;
            }
            ++i;
        }
        ClassInfo thisInfo = this;
        ClassInfo otherInfo = info;
        if (thisInfo._members.size() != otherInfo._members.size()) {
            this.comparisonPairStack.remove(currentPair);
            return false;
        }
        int i2 = 0;
        while (i2 < thisInfo._members.size()) {
            Entry thisMInfo = (Entry)thisInfo._members.get(i2);
            Entry otherMInfo = (Entry)otherInfo._members.get(i2);
            if (thisMInfo.name != "self") {
                if (thisMInfo.name != otherMInfo.name) {
                    this.comparisonPairStack.remove(currentPair);
                    return false;
                }
                if (thisMInfo.name != ".ctor") {
                    if (thisMInfo.type.isClass() && thisMInfo.type.getClassInfo() == thisInfo) {
                        if (!otherMInfo.type.isClass() || otherMInfo.type.isClass() && otherMInfo.type.getClassInfo() != otherInfo) {
                            this.comparisonPairStack.remove(currentPair);
                            return false;
                        }
                    } else if (!thisMInfo.type.equals(otherMInfo.type)) {
                        this.comparisonPairStack.remove(currentPair);
                        return false;
                    }
                } else {
                    if (!otherMInfo.type.isFunc()) {
                        this.comparisonPairStack.remove(currentPair);
                        return false;
                    }
                    if (!thisMInfo.type.getFuncInfo().equalsParams(otherMInfo.type.getFuncInfo())) {
                        this.comparisonPairStack.remove(currentPair);
                        return false;
                    }
                }
                if (thisMInfo.modifiers != otherMInfo.modifiers) {
                    this.comparisonPairStack.remove(currentPair);
                    return false;
                }
            }
            ++i2;
        }
        this.comparisonPairStack.remove(currentPair);
        return true;
    }

    public int hashCode() {
        Debug.Unimplemented();
        return 0;
    }

    public String toString() {
        if (this._classType == ClassType.Local) {
            String s = "";
            if (this._location.isKnown()) {
                s = "[" + this._location;
                if (this.identityHint != null) {
                    s = String.valueOf(s) + ";" + this.identityHint;
                }
                s = String.valueOf(s) + "]";
            } else if (this.identityHint != null) {
                s = String.valueOf(s) + "[" + this.identityHint + "]";
            }
            s = toStringArray.size() == 0 ? (this._isInterface ? "interface" + s : "class" + s) : (!toStringArray.contains(this) ? String.valueOf(s) + this.toStringFull() : "self");
            return s;
        }
        if (this._sysType instanceof java.lang.Class) {
            java.lang.Class sysClass = (java.lang.Class)this._sysType;
            if (!sysClass.isArray()) {
                String s = sysClass.toString();
                if (s.startsWith("class ")) {
                    s = s.substring(6, s.length());
                } else if (s.startsWith("interface ")) {
                    s = s.substring(10, s.length());
                }
                return s;
            }
            return String.valueOf(new TypeSpec(sysClass.getComponentType()).typeName()) + "[]";
        }
        return this._sysType.toString();
    }

    protected String externToStringFull() {
        Entry[] declEntries;
        java.lang.Class<?>[] interfaces;
        if (!(this._sysType instanceof java.lang.Class)) {
            return this._sysType.toString();
        }
        String s = "";
        java.lang.Class sysClass = (java.lang.Class)this._sysType;
        s = String.valueOf(s) + (sysClass.isInterface() ? "interface" : "class");
        s = String.valueOf(s) + " " + this.toString();
        boolean addedColon = false;
        java.lang.Class baseClass = sysClass.getSuperclass();
        if (baseClass != null && !baseClass.equals(Object.class)) {
            s = String.valueOf(s) + " : " + new ClassInfo(baseClass).toString();
            addedColon = true;
        }
        java.lang.Class<?>[] classArray = interfaces = sysClass.getInterfaces();
        int n = 0;
        int n2 = classArray.length;
        while (n < n2) {
            java.lang.Class<?> baseInterface = classArray[n];
            if (!addedColon) {
                s = String.valueOf(s) + " : ";
                addedColon = true;
            } else {
                s = String.valueOf(s) + ", ";
            }
            s = String.valueOf(s) + new ClassInfo(baseInterface).toString();
            ++n;
        }
        s = String.valueOf(s) + "\n{\n";
        Entry[] entryArray = declEntries = ClassInfo.externalGetDeclaredEntries(this, null);
        n2 = 0;
        int n3 = entryArray.length;
        while (n2 < n3) {
            Entry entry = entryArray[n2];
            if (!entry.isAccessor()) {
                s = String.valueOf(s) + ClassInfo.entryToString(entry);
            }
            ++n2;
        }
        s = String.valueOf(s) + "}";
        return s;
    }

    public String toStringFull() {
        if (toStringArray.contains(this)) {
            return "self";
        }
        toStringArray.add(this);
        String s = this._classType == ClassType.Local ? this.nonRecursiveToString() : this.externToStringFull();
        toStringArray.remove(this);
        return s;
    }

    public String nonRecursiveToString() {
        if (this._classType == ClassType.Local) {
            String s = this._isInterface ? "interface {\n" : "class {\n";
            for (Object o : this._members) {
                Entry entry = (Entry)o;
                if (entry.isAccessor()) continue;
                s = String.valueOf(s) + ClassInfo.entryToString(entry);
            }
            s = String.valueOf(s) + "}";
            return s;
        }
        return this._sysType.toString();
    }

    public static String entryToString(Entry entry) {
        if (entry == null) {
            return "null";
        }
        String s = "  ";
        s = String.valueOf(s) + TypeSpec.modifiersString(entry.modifiers) + " ";
        String name = entry.name;
        if (TypeSpec.isOperator(name)) {
            name = TypeSpec.operatorSourceName(name);
        }
        s = String.valueOf(s) + name;
        boolean staticNonNullFunc = entry.type.isFunc() && entry.getStaticValue() != null;
        s = !staticNonNullFunc ? String.valueOf(s) + " :" + entry.type : String.valueOf(s) + " = " + entry.getStaticValue();
        if (entry.isProperty()) {
            s = String.valueOf(s) + " property ";
            if (entry.hasSetter()) {
                s = String.valueOf(s) + "set";
                if (entry.hasGetter()) {
                    s = String.valueOf(s) + "; get";
                }
            } else if (entry.hasGetter()) {
                s = String.valueOf(s) + "get";
            }
        }
        s = String.valueOf(s) + "\n";
        return s;
    }

    public String instanceToString(Class instance) {
        Debug.Assert(this._classType == ClassType.Local);
        Debug.Assert(instance != null, "can't convert Class instance to string without an instance!");
        Debug.Assert(instance.getInfo().equals(this));
        String s = null;
        instance.getMemberValues();
        FuncInfo callSig = new FuncInfo();
        if (this.declaresMember("toString")) {
            Entry[] entries = this.lookup("toString", callSig, new Object[0]);
            if (entries.length != 1) {
                ScigolTreeParser.semanticError("call of toString() is ambiguous or incompatible");
            }
            Func f = (Func)Class.getMemberValue(entries[0], instance);
            s = (String)f.call((Object)instance, new Object[0]);
        } else {
            Entry[] instanceMembers = this.getAllInstanceEntries(null);
            s = "class {\n";
            Entry[] entryArray = instanceMembers;
            int n = 0;
            int n2 = entryArray.length;
            while (n < n2) {
                String value;
                Entry entry = entryArray[n];
                Debug.Assert(entry != null);
                String string = value = entry.index >= 0 ? Class.getMemberValue(entry, instance) : "?";
                if (!entry.type.isFunc() || !value.equals("?") && ((Func)((Object)value)).getValue() != null) {
                    s = String.valueOf(s) + "  ";
                    s = String.valueOf(s) + TypeSpec.operatorSourceName(entry.name);
                    s = String.valueOf(s) + ":" + entry.type;
                    if (value != null) {
                        if (value instanceof String) {
                            value = "\"" + value + "\"";
                        }
                        s = String.valueOf(s) + " = " + value;
                    } else {
                        s = String.valueOf(s) + " = null";
                    }
                    s = String.valueOf(s) + "\n";
                }
                ++n;
            }
            s = String.valueOf(s) + "}";
        }
        return s;
    }

    protected ClassInfo() {
        this._classType = ClassType.Local;
        this._outerScope = null;
        this._modifiers = EnumSet.of(TypeSpec.Modifier.Public);
        this._superClass = TypeSpec.objectTypeSpec;
        this._isInterface = false;
        this._isAbstract = false;
        this._interfaces = new ArrayList();
        this._members = new ArrayList();
        this.addMember("self", EnumSet.of(Entry.Flags.Field), TypeSpec.typeTypeSpec, EnumSet.of(TypeSpec.Modifier.Static, TypeSpec.Modifier.Public), new TypeSpec(this), null);
        this.complete = false;
    }

    protected static Entry[] externalGetAllDeclaredEntries(ClassInfo declaringClass) {
        Field[] fields;
        Method[] methods;
        Constructor<?>[] constructors;
        Debug.Assert(declaringClass.isExternal(), "isn't an external Java class");
        Debug.Assert(declaringClass.getSysType() instanceof java.lang.Class, "can only get members of a class or interface (not " + declaringClass + ")");
        java.lang.Class sysType = (java.lang.Class)declaringClass.getSysType();
        if (javaTypes.containsKey(sysType)) {
            return javaTypes.get(sysType);
        }
        ClassScope classScope = new ClassScope(new TypeSpec(declaringClass));
        ArrayList<Entry> entries = new ArrayList<Entry>();
        Constructor<?>[] constructorArray = constructors = sysType.getDeclaredConstructors();
        int n = 0;
        int n2 = constructorArray.length;
        while (n < n2) {
            Constructor<?> constructor = constructorArray[n];
            EnumSet<TypeSpec.Modifier> modifiers = TypeSpec.modifiersFromJavaModifiers(constructor.getModifiers());
            EnumSet<Entry.Flags> flags = EnumSet.of(Entry.Flags.Method);
            TypeSpec type = new TypeSpec(constructor);
            type.getFuncInfo().setReturnType(new TypeSpec(declaringClass));
            Func func = new Func(sysType, constructor);
            modifiers.add(TypeSpec.Modifier.Const);
            modifiers.add(TypeSpec.Modifier.Static);
            entries.add(new Entry(".ctor", ".ctor", type, func, null, modifiers, flags, -2, classScope));
            ++n;
        }
        Method[] methodArray = methods = sysType.getDeclaredMethods();
        n2 = 0;
        int n3 = methodArray.length;
        while (n2 < n3) {
            boolean isAccessor;
            Method method = methodArray[n2];
            String name = method.getName();
            String javaName = null;
            EnumSet<TypeSpec.Modifier> modifiers = TypeSpec.modifiersFromJavaModifiers(method.getModifiers());
            if (TypeSpec.isJavaOperator(name)) {
                if (name.equals("op_Implicit") || name.equals("toString")) {
                    modifiers.add(TypeSpec.Modifier.Implicit);
                }
                javaName = name;
                name = TypeSpec.operatorSourceName(javaName);
            }
            Debug.Assert(!(isAccessor = method.isAnnotationPresent(accessor.class)) || name.startsWith("get_") || name.startsWith("set_"), "methods annotated as accessors must start with set_ or get_");
            if (name.startsWith("get_") || name.startsWith("set_") && !isAccessor) {
                isAccessor = true;
            }
            if (!isAccessor) {
                EnumSet<Entry.Flags> flags = EnumSet.of(Entry.Flags.Method);
                TypeSpec type = new TypeSpec(method);
                Func func = new Func(sysType, method);
                if (isAccessor) {
                    flags.add(Entry.Flags.Accessor);
                }
                modifiers.add(TypeSpec.Modifier.Const);
                Entry methodEntry = new Entry(name, javaName, type, func, null, modifiers, flags, -2, classScope);
                methodEntry.addAnnotations(method.getAnnotations());
                entries.add(methodEntry);
            } else {
                Entry.EntryPair ep;
                String accessorName = name.substring(0, 3);
                String propertyName = FuncInfo.propertyName(name);
                FuncInfo accessorFuncInfo = new FuncInfo(method);
                TypeSpec propertyType = FuncInfo.propertyTypeFromAccessor(accessorName, accessorFuncInfo);
                Entry propEntry = null;
                FuncInfo propArgsInfo = null;
                for (Object e : entries) {
                    Entry entry = (Entry)e;
                    if (!entry.isProperty() || !entry.name.equals(propertyName) || !entry.type.equals(propertyType)) continue;
                    FuncInfo propertyArgsInfo = accessorFuncInfo.propertySig(accessorName);
                    ep = (Entry.EntryPair)entry.getStaticValue();
                    if (ep.getter != null) {
                        propArgsInfo = ep.getter.type.getFuncInfo().propertySig("get");
                    } else if (ep.setter != null) {
                        propArgsInfo = ep.setter.type.getFuncInfo().propertySig("set");
                    } else {
                        Debug.Assert(false, "encountered property entry with no accessor entries!");
                    }
                    if (!propArgsInfo.equalsParams(propertyArgsInfo)) continue;
                    propEntry = entry;
                    break;
                }
                EnumSet<Entry.Flags> enumSet = EnumSet.of(Entry.Flags.Method, Entry.Flags.Accessor);
                TypeSpec type = new TypeSpec(method);
                Func func = new Func(sysType, method);
                modifiers.add(TypeSpec.Modifier.Const);
                Entry accessorEntry = new Entry(name, javaName, type, func, null, modifiers, enumSet, -2, classScope);
                if (propEntry != null) {
                    TypeSpec[] setterArgTypes;
                    ep = (Entry.EntryPair)propEntry.getStaticValue();
                    if (accessorName.equals("get")) {
                        ep.getter = accessorEntry;
                    } else {
                        ep.setter = accessorEntry;
                    }
                    accessorEntry.propertyEntry = propEntry;
                    if (ep.setter != null && ep.getter != null && !(setterArgTypes = ep.setter.type.getFuncInfo().getParamTypes())[setterArgTypes.length - 1].equals(ep.getter.type.getFuncInfo().getReturnType())) {
                        Debug.Warning("external Java class '" + declaringClass + "' has property '" + propertyName + ":" + propertyType + "' with unmatched getter return type & setter value argument type.");
                    }
                } else {
                    EnumSet<Entry.Flags> pflags = EnumSet.of(Entry.Flags.Property);
                    EnumSet<TypeSpec.Modifier> pmodifiers = modifiers;
                    pmodifiers.remove((Object)TypeSpec.Modifier.Const);
                    accessorEntry.propertyEntry = propEntry = new Entry(propertyName, propertyType, null, null, pmodifiers, pflags, -2, classScope);
                    Entry.EntryPair ep2 = new Entry.EntryPair();
                    if (accessorName.equals("get")) {
                        ep2.getter = accessorEntry;
                    } else {
                        ep2.setter = accessorEntry;
                    }
                    propEntry.setStaticValue(ep2);
                    entries.add(propEntry);
                }
            }
            ++n2;
        }
        Field[] fieldArray = fields = sysType.getDeclaredFields();
        n3 = 0;
        int n4 = fieldArray.length;
        while (n3 < n4) {
            Field field = fieldArray[n3];
            String fname = field.getName();
            TypeSpec type = new TypeSpec(field.getType());
            EnumSet<TypeSpec.Modifier> modifiers = TypeSpec.modifiersFromJavaModifiers(field.getModifiers());
            entries.add(new Entry(fname, type, null, null, modifiers, EnumSet.of(Entry.Flags.Field), -2, classScope));
            ++n3;
        }
        Entry[] entryArray = Entry.toArray(entries);
        javaTypes.put(sysType, entryArray);
        return entryArray;
    }

    protected static Entry[] externalGetDeclaredEntries(ClassInfo declaringClass, String findName) {
        boolean getAll = findName == null;
        Entry[] allentries = ClassInfo.externalGetAllDeclaredEntries(declaringClass);
        if (getAll) {
            return allentries;
        }
        java.lang.Class cfr_ignored_0 = (java.lang.Class)declaringClass.getSysType();
        boolean findAccessor = findName.startsWith("get_") || findName.startsWith("set_");
        if (findAccessor) {
            FuncInfo.propertyName(findName);
        }
        ArrayList<Entry> entries = new ArrayList<Entry>();
        Entry[] entryArray = allentries;
        int n = 0;
        int n2 = entryArray.length;
        while (n < n2) {
            Entry entry = entryArray[n];
            if (!findAccessor) {
                if (entry.name.equals(findName)) {
                    entries.add(entry);
                }
            } else {
                String findAccessorName = findName.substring(0, 3);
                String propFindName = FuncInfo.propertyName(findName);
                if (entry.isProperty() && entry.name.equals(propFindName)) {
                    Entry.EntryPair ep = (Entry.EntryPair)entry.getStaticValue();
                    if (findAccessorName.equals("get")) {
                        if (ep.getter != null) {
                            entries.add(ep.getter);
                        }
                    } else if (ep.setter != null) {
                        entries.add(ep.setter);
                    }
                }
            }
            ++n;
        }
        return Entry.toArray(entries);
    }

    protected class ClassInfoPair {
        ClassInfo first;
        ClassInfo second;

        public ClassInfoPair(ClassInfo first, ClassInfo second) {
            this.first = first;
            this.second = second;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum ClassType {
        Local,
        External;

    }
}

