/*
 * Decompiled with CFR 0.152.
 */
package scigol;

import antlr.CommonToken;
import antlr.Token;
import scigol.Debug;
import scigol.Location;

public class CommonTokenWithLocation
extends CommonToken {
    public Location loc;

    public CommonTokenWithLocation() {
        this.loc = new Location();
    }

    public CommonTokenWithLocation(Token tok) {
        super(tok.getType(), tok.getText());
        this.setLine(tok.getLine());
        this.setColumn(tok.getColumn());
        if (tok.getFilename() != null) {
            this.setFilename(tok.getFilename());
        } else {
            this.setFilename("?");
        }
        this.loc = !(tok instanceof CommonTokenWithLocation) ? new Location() : ((CommonTokenWithLocation)tok).loc;
    }

    public CommonTokenWithLocation(int t, String txt) {
        super(t, txt);
        this.loc = new Location();
    }

    public CommonTokenWithLocation(String s) {
        super(s);
        this.loc = new Location();
    }

    public void setLine(int l) {
        if (this.loc == null) {
            this.loc = new Location();
        }
        this.loc.line = l;
        super.setLine(l);
    }

    public void setColumn(int c) {
        if (this.loc == null) {
            this.loc = new Location();
        }
        this.loc.column = c;
        super.setColumn(c);
    }

    public void setFilename(String name) {
        Debug.Assert(name != null);
        if (this.loc == null) {
            this.loc = new Location();
        }
        this.loc.filename = name;
    }

    public String getFilename() {
        if (this.loc != null && this.loc.filename != null) {
            return this.loc.filename;
        }
        return "?";
    }
}

