/*
 * Decompiled with CFR 0.152.
 */
package scigol;

import antlr.NoViableAltException;
import antlr.RecognitionException;
import antlr.TreeParser;
import antlr.collections.AST;
import antlr.collections.impl.BitSet;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.LinkedList;
import scigol.Any;
import scigol.ClassInfo;
import scigol.ClassScope;
import scigol.CommonASTWithLocation;
import scigol.Debug;
import scigol.Entry;
import scigol.Func;
import scigol.FuncInfo;
import scigol.LValue;
import scigol.List;
import scigol.LocalScope;
import scigol.Location;
import scigol.Map;
import scigol.Math;
import scigol.Matrix;
import scigol.NamespaceScope;
import scigol.Num;
import scigol.Range;
import scigol.ScigolAnnotation;
import scigol.ScigolException;
import scigol.ScigolTreeParserTokenTypes;
import scigol.Scope;
import scigol.Symbol;
import scigol.TypeManager;
import scigol.TypeSpec;
import scigol.Value;
import scigol.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScigolTreeParser
extends TreeParser
implements ScigolTreeParserTokenTypes {
    public Scope globalScope;
    public boolean interactive;
    public Scope scope;
    public static final String[] _tokenNames = new String[]{"<0>", "EOF", "<2>", "NULL_TREE_LOOKAHEAD", "DOT", "DOTDOT", "UNARY_MINUS", "UNARY_PLUS", "EXPRLIST", "INITLIST", "MATRIX", "LIST", "MAP", "FUNC", "POST_INC", "POST_DEC", "APPLICATION", "NAMED_ARG", "\"true\"", "\"false\"", "\"null\"", "LIT_FUNC", "MODIFIERS", "BUILTIN_TYPE", "CTOR", "PROP", "LCURLY", ";", "\"namespace\"", "}", "an identifier", "\"using\"", "\"as\"", "\"from\"", "a string literal", "\"pre\"", "\"post\"", "\"typeof\"", "LPAREN", "RPAREN", "\"assert\"", "COMMA", "\"debug\"", "\"logger\"", "ASSIGN", "\"or\"", "\"and\"", "NOT_EQUAL", "EQUAL", "\"is\"", "\"isnt\"", "LTHAN", "GTHAN", "LTE", "GTE", "PLUS", "MINUS", "STAR", "DIV", "MOD", "HAT", "INC", "DEC", "LNOT", "\"not\"", "HASH", "PRIME", "BAR", "SCOPE_ESCAPE", "'(", "\"try\"", "\"catch\"", "COLON", "a numeric literal", "NUM_DINT", "NUM_REAL", "NUM_SREAL", "a char literal", "LBRACK", "RBRACK", "->", "ANNOT_START", "\"let\"", "\"const\"", "\"static\"", "\"final\"", "\"class\"", "\"interface\"", "\"property\"", "\"override\"", "\"implicit\"", "\"public\"", "\"private\"", "\"protected\"", "\"func\"", "\"vector\"", "\"matrix\"", "\"range\"", "\"list\"", "\"map\"", "\"bool\"", "\"byte\"", "\"char\"", "\"int\"", "\"dint\"", "\"real\"", "\"sreal\"", "\"string\"", "\"type\"", "\"num\"", "\"any\"", "\"object\"", "\"if\"", "\"then\"", "\"else\"", "\"do\"", "\"while\"", "\"for\"", "\"foreach\"", "\"in\"", "\"by\"", "\"throw\"", "QUESTION", "SL", "BAND", "FROM", "LINE_BREAK", "NON_LINE_BREAK_WS", "WS", "SL_COMMENT", "ML_COMMENT", "STRING_OR_CHAR_LITERAL", "a string literal", "a multi-line string literal", "NON_BACKQUOTE_STRING", "CHAR_LIT_SUFFIX", "ESC", "HEX_DIGIT", "VOCAB", "DOT_FLOAT_EXP", "EXPONENT", "REAL_SUFFIX"};
    public static final BitSet _tokenSet_0 = new BitSet(ScigolTreeParser.mk_tokenSet_0());
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public ScigolTreeParser(Scope initialScope, boolean interactive) {
        this.interactive = interactive;
        this.globalScope = initialScope.getGlobalScope();
        this.scope = initialScope;
    }

    public static void semanticError(String msg) {
        throw new ScigolException(msg);
    }

    public static void semanticError(String msg, Exception inner) {
        throw new ScigolException(msg, inner);
    }

    public static void semanticError(Location l, String msg) {
        if (l != null && l.isKnown()) {
            throw new ScigolException("[" + l + "] " + msg);
        }
        throw new ScigolException(msg);
    }

    public static Location locationOf(AST near) {
        if (near instanceof CommonASTWithLocation) {
            return ((CommonASTWithLocation)near).loc;
        }
        return new Location();
    }

    public static void semanticError(AST near, String msg) {
        String loc = "";
        if (near instanceof CommonASTWithLocation) {
            CommonASTWithLocation locAST = (CommonASTWithLocation)near;
            if (locAST.loc.isKnown()) {
                loc = String.valueOf(loc) + "[" + locAST.loc.toString() + "] ";
            }
        }
        throw new ScigolException(String.valueOf(loc) + msg);
    }

    public ScigolTreeParser() {
        this.tokenNames = _tokenNames;
    }

    public final Value program(AST _t) throws RecognitionException {
        Value v = null;
        AST aST = _t == ASTNULL ? null : _t;
        if (_t == null) {
            _t = ASTNULL;
        }
        switch (_t.getType()) {
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 28: 
            case 30: 
            case 34: 
            case 37: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 70: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 82: 
            case 86: 
            case 87: 
            case 112: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 121: {
                v = this.expr(_t);
                _t = this._retTree;
                break;
            }
            case 26: {
                v = this.namespaceBody(_t);
                _t = this._retTree;
                break;
            }
            default: {
                throw new NoViableAltException(_t);
            }
        }
        this._retTree = _t;
        return v;
    }

    public final Value expr(AST _t) throws RecognitionException {
        Value v = null;
        AST aST = _t == ASTNULL ? null : _t;
        if (_t == null) {
            _t = ASTNULL;
        }
        switch (_t.getType()) {
            case 8: {
                v = this.expressionList(_t, true);
                _t = this._retTree;
                break;
            }
            case 11: {
                v = this.listLiteral(_t);
                _t = this._retTree;
                break;
            }
            case 12: {
                v = this.mapLiteral(_t);
                _t = this._retTree;
                break;
            }
            case 28: {
                v = this.namespaceScope(_t);
                _t = this._retTree;
                break;
            }
            case 10: 
            case 13: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 34: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 86: 
            case 87: {
                v = this.literal(_t);
                _t = this._retTree;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 14: 
            case 15: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: {
                v = this.arithmeticExpression(_t);
                _t = this._retTree;
                break;
            }
            case 43: {
                v = this.logCall(_t);
                _t = this._retTree;
                break;
            }
            case 82: {
                v = this.declaration(_t);
                _t = this._retTree;
                break;
            }
            case 44: {
                v = this.assignmentExpression(_t);
                _t = this._retTree;
                break;
            }
            case 37: {
                v = this.typeofExpression(_t);
                _t = this._retTree;
                break;
            }
            case 30: 
            case 68: {
                v = this.symbol(_t);
                _t = this._retTree;
                break;
            }
            case 16: {
                v = this.applicationExpression(_t);
                _t = this._retTree;
                break;
            }
            case 4: {
                v = this.selectionExpression(_t);
                _t = this._retTree;
                break;
            }
            case 112: {
                v = this.ifExpression(_t);
                _t = this._retTree;
                break;
            }
            case 115: 
            case 116: {
                v = this.whileExpression(_t);
                _t = this._retTree;
                break;
            }
            case 117: {
                v = this.forExpression(_t);
                _t = this._retTree;
                break;
            }
            case 118: {
                v = this.forEachExpression(_t);
                _t = this._retTree;
                break;
            }
            case 70: {
                v = this.exceptionBlock(_t);
                _t = this._retTree;
                break;
            }
            case 121: {
                v = this.throwExpression(_t);
                _t = this._retTree;
                break;
            }
            default: {
                throw new NoViableAltException(_t);
            }
        }
        this._retTree = _t;
        return v;
    }

    public final Value namespaceBody(AST _t) throws RecognitionException {
        Value v = null;
        AST aST = _t == ASTNULL ? null : _t;
        this.match(_t, 26);
        _t = _t.getNextSibling();
        while (true) {
            if (_t == null) {
                _t = ASTNULL;
            }
            if (_t.getType() != 31) break;
            this.usingDecl(_t);
            _t = this._retTree;
        }
        while (true) {
            if (_t == null) {
                _t = ASTNULL;
            }
            if (!_tokenSet_0.member(_t.getType())) break;
            v = this.expr(_t);
            _t = this._retTree;
        }
        this._retTree = _t;
        return v;
    }

    public final Value expressionList(AST _t, boolean inNewScope) throws RecognitionException {
        Value v = null;
        AST aST = _t == ASTNULL ? null : _t;
        AST el = null;
        Value a = null;
        AST __t35 = _t;
        el = _t == ASTNULL ? null : _t;
        this.match(_t, 8);
        _t = _t.getFirstChild();
        if (inNewScope) {
            this.scope = new LocalScope(this.scope);
            this.scope.setDefinitionLocation(ScigolTreeParser.locationOf(el));
        }
        while (true) {
            if (_t == null) {
                _t = ASTNULL;
            }
            if (!_tokenSet_0.member(_t.getType())) break;
            a = this.expr(_t);
            _t = this._retTree;
            if (a == null) continue;
            v = a;
        }
        if (inNewScope) {
            this.scope = this.scope.getOuter();
        }
        _t = __t35;
        this._retTree = _t = _t.getNextSibling();
        return v;
    }

    public final Value listLiteral(AST _t) throws RecognitionException {
        Value v = null;
        AST aST = _t == ASTNULL ? null : _t;
        List l = new List();
        AST __t4 = _t;
        this.match(_t, 11);
        _t = _t.getFirstChild();
        while (true) {
            if (_t == null) {
                _t = ASTNULL;
            }
            if (!_tokenSet_0.member(_t.getType())) break;
            v = this.expr(_t);
            _t = this._retTree;
            l.add(v.getValue());
        }
        _t = __t4;
        _t = _t.getNextSibling();
        v = new Value(l);
        this._retTree = _t;
        return v;
    }

    public final Value mapLiteral(AST _t) throws RecognitionException {
        Value v = null;
        AST aST = _t == ASTNULL ? null : _t;
        Map m = new Map();
        Value key = null;
        Value val = null;
        AST __t8 = _t;
        this.match(_t, 12);
        _t = _t.getFirstChild();
        while (true) {
            if (_t == null) {
                _t = ASTNULL;
            }
            if (!_tokenSet_0.member(_t.getType())) break;
            key = this.expr(_t);
            _t = this._retTree;
            this.match(_t, 80);
            _t = _t.getNextSibling();
            val = this.expr(_t);
            _t = this._retTree;
            m.set_Item(key.getValue(), new Any(val.getValue()));
        }
        _t = __t8;
        _t = _t.getNextSibling();
        v = new Value(m);
        this._retTree = _t;
        return v;
    }

    public final Value namespaceScope(AST _t) throws RecognitionException {
        Value v = null;
        AST aST = _t == ASTNULL ? null : _t;
        AST ns = null;
        AST __t42 = _t;
        ns = _t == ASTNULL ? null : _t;
        this.match(_t, 28);
        _t = _t.getFirstChild();
        String id = this.namespaceName(_t);
        _t = this._retTree;
        if (!this.scope.isNamespaceScope()) {
            ScigolTreeParser.semanticError(ScigolTreeParser.locationOf(ns), "can't define namespace '" + id + "' within current scope (namespaces can only be nested directly within other namespaces)");
        }
        Scope savedOuterScope = this.scope;
        this.scope = NamespaceScope.newOrExistingNamespaceScope(id, this.scope);
        this.scope.setDefinitionLocation(ScigolTreeParser.locationOf(ns));
        v = this.namespaceBody(_t);
        _t = this._retTree;
        this.scope = savedOuterScope;
        _t = __t42;
        this._retTree = _t = _t.getNextSibling();
        return v;
    }

    public final Value literal(AST _t) throws RecognitionException {
        Value v = null;
        AST aST = _t == ASTNULL ? null : _t;
        if (_t == null) {
            _t = ASTNULL;
        }
        switch (_t.getType()) {
            case 10: 
            case 18: 
            case 19: 
            case 20: 
            case 73: 
            case 74: 
            case 75: 
            case 76: {
                v = this.number(_t);
                _t = this._retTree;
                break;
            }
            case 34: {
                v = this.stringLit(_t);
                _t = this._retTree;
                break;
            }
            case 77: {
                v = this.charLit(_t);
                _t = this._retTree;
                break;
            }
            case 13: 
            case 23: 
            case 86: 
            case 87: {
                TypeSpec t = this.typeLiteral(_t);
                _t = this._retTree;
                v = new Value(t);
                break;
            }
            case 21: {
                Func f = this.functionLiteral(_t);
                _t = this._retTree;
                v = new Value(f);
                break;
            }
            default: {
                throw new NoViableAltException(_t);
            }
        }
        this._retTree = _t;
        return v;
    }

    public final Value arithmeticExpression(AST _t) throws RecognitionException {
        Value v = null;
        AST aST = _t == ASTNULL ? null : _t;
        Value lhs = null;
        if (_t == null) {
            _t = ASTNULL;
        }
        switch (_t.getType()) {
            case 55: {
                AST __t53 = _t;
                this.match(_t, 55);
                _t = _t.getFirstChild();
                lhs = this.expr(_t);
                _t = this._retTree;
                Value rhs = this.expr(_t);
                _t = this._retTree;
                _t = __t53;
                _t = _t.getNextSibling();
                v = Math.performOverloadedOperation("operator+", lhs, rhs);
                break;
            }
            case 56: {
                AST __t54 = _t;
                this.match(_t, 56);
                _t = _t.getFirstChild();
                lhs = this.expr(_t);
                _t = this._retTree;
                Value rhs = this.expr(_t);
                _t = this._retTree;
                _t = __t54;
                _t = _t.getNextSibling();
                v = Math.performOverloadedOperation("operator-", lhs, rhs);
                break;
            }
            case 7: {
                AST __t55 = _t;
                this.match(_t, 7);
                _t = _t.getFirstChild();
                Value rhs = this.expr(_t);
                _t = this._retTree;
                _t = __t55;
                _t = _t.getNextSibling();
                v = Math.performOverloadedOperation("operator+", null, rhs);
                break;
            }
            case 6: {
                AST __t56 = _t;
                this.match(_t, 6);
                _t = _t.getFirstChild();
                Value rhs = this.expr(_t);
                _t = this._retTree;
                _t = __t56;
                _t = _t.getNextSibling();
                v = Math.performOverloadedOperation("operator-", null, rhs);
                break;
            }
            case 57: {
                AST __t57 = _t;
                this.match(_t, 57);
                _t = _t.getFirstChild();
                lhs = this.expr(_t);
                _t = this._retTree;
                Value rhs = this.expr(_t);
                _t = this._retTree;
                _t = __t57;
                _t = _t.getNextSibling();
                v = Math.performOverloadedOperation("operator*", lhs, rhs);
                break;
            }
            case 58: {
                AST __t58 = _t;
                this.match(_t, 58);
                _t = _t.getFirstChild();
                lhs = this.expr(_t);
                _t = this._retTree;
                Value rhs = this.expr(_t);
                _t = this._retTree;
                _t = __t58;
                _t = _t.getNextSibling();
                v = Math.performOverloadedOperation("operator/", lhs, rhs);
                break;
            }
            case 59: {
                AST __t59 = _t;
                this.match(_t, 59);
                _t = _t.getFirstChild();
                lhs = this.expr(_t);
                _t = this._retTree;
                Value rhs = this.expr(_t);
                _t = this._retTree;
                _t = __t59;
                _t = _t.getNextSibling();
                v = Math.performOverloadedOperation("operator%", lhs, rhs);
                break;
            }
            case 60: {
                AST __t60 = _t;
                this.match(_t, 60);
                _t = _t.getFirstChild();
                lhs = this.expr(_t);
                _t = this._retTree;
                Value rhs = this.expr(_t);
                _t = this._retTree;
                _t = __t60;
                _t = _t.getNextSibling();
                v = Math.performOverloadedOperation("operator^", lhs, rhs);
                break;
            }
            case 48: {
                AST __t61 = _t;
                this.match(_t, 48);
                _t = _t.getFirstChild();
                lhs = this.expr(_t);
                _t = this._retTree;
                Value rhs = this.expr(_t);
                _t = this._retTree;
                _t = __t61;
                _t = _t.getNextSibling();
                v = Math.performOverloadedOperation("operator==", lhs, rhs);
                break;
            }
            case 47: {
                AST __t62 = _t;
                this.match(_t, 47);
                _t = _t.getFirstChild();
                lhs = this.expr(_t);
                _t = this._retTree;
                Value rhs = this.expr(_t);
                _t = this._retTree;
                _t = __t62;
                _t = _t.getNextSibling();
                v = Math.performOverloadedOperation("operator!=", lhs, rhs);
                break;
            }
            case 51: {
                AST __t63 = _t;
                this.match(_t, 51);
                _t = _t.getFirstChild();
                lhs = this.expr(_t);
                _t = this._retTree;
                Value rhs = this.expr(_t);
                _t = this._retTree;
                _t = __t63;
                _t = _t.getNextSibling();
                v = Math.performOverloadedOperation("operator<", lhs, rhs);
                break;
            }
            case 52: {
                AST __t64 = _t;
                this.match(_t, 52);
                _t = _t.getFirstChild();
                lhs = this.expr(_t);
                _t = this._retTree;
                Value rhs = this.expr(_t);
                _t = this._retTree;
                _t = __t64;
                _t = _t.getNextSibling();
                v = Math.performOverloadedOperation("operator>", lhs, rhs);
                break;
            }
            case 53: {
                AST __t65 = _t;
                this.match(_t, 53);
                _t = _t.getFirstChild();
                lhs = this.expr(_t);
                _t = this._retTree;
                Value rhs = this.expr(_t);
                _t = this._retTree;
                _t = __t65;
                _t = _t.getNextSibling();
                v = Math.performOverloadedOperation("operator<=", lhs, rhs);
                break;
            }
            case 54: {
                AST __t66 = _t;
                this.match(_t, 54);
                _t = _t.getFirstChild();
                lhs = this.expr(_t);
                _t = this._retTree;
                Value rhs = this.expr(_t);
                _t = this._retTree;
                _t = __t66;
                _t = _t.getNextSibling();
                v = Math.performOverloadedOperation("operator>=", lhs, rhs);
                break;
            }
            case 61: 
            case 62: {
                v = this.prefixExpression(_t);
                _t = this._retTree;
                break;
            }
            case 14: 
            case 15: 
            case 66: {
                v = this.postfixExpression(_t);
                _t = this._retTree;
                break;
            }
            case 46: {
                v = this.logicalAndExpression(_t);
                _t = this._retTree;
                break;
            }
            case 45: {
                v = this.logicalOrExpression(_t);
                _t = this._retTree;
                break;
            }
            case 63: 
            case 64: {
                v = this.logicalNotExpression(_t);
                _t = this._retTree;
                break;
            }
            case 49: 
            case 50: {
                v = this.isExpression(_t);
                _t = this._retTree;
                break;
            }
            case 5: {
                v = this.rangeExpression(_t);
                _t = this._retTree;
                break;
            }
            case 67: {
                v = this.normExpression(_t);
                _t = this._retTree;
                break;
            }
            case 65: {
                v = this.cardinalityExpression(_t);
                _t = this._retTree;
                Debug.Assert(v != null, "Value is null");
                break;
            }
            default: {
                throw new NoViableAltException(_t);
            }
        }
        this._retTree = _t;
        return v;
    }

    public final Value logCall(AST _t) throws RecognitionException {
        Value v = null;
        AST aST = _t == ASTNULL ? null : _t;
        AST i = null;
        AST __t183 = _t;
        this.match(_t, 43);
        _t = _t.getFirstChild();
        if (_t == null) {
            _t = ASTNULL;
        }
        switch (_t.getType()) {
            case 41: {
                AST __t185 = _t;
                this.match(_t, 41);
                i = _t = _t.getFirstChild();
                this.match(_t, 30);
                _t = _t.getNextSibling();
                _t = __t185;
                _t = _t.getNextSibling();
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 28: 
            case 30: 
            case 34: 
            case 37: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 70: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 82: 
            case 86: 
            case 87: 
            case 112: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 121: {
                break;
            }
            default: {
                throw new NoViableAltException(_t);
            }
        }
        v = this.expr(_t);
        _t = this._retTree;
        _t = __t183;
        _t = _t.getNextSibling();
        if (i != null) {
            System.out.print(String.valueOf(i.getText()) + ": ");
        }
        System.out.println(v.toString());
        this._retTree = _t;
        return v;
    }

    public final Value declaration(AST _t) throws RecognitionException {
        boolean initializerSupplied;
        Value v = null;
        AST aST = _t == ASTNULL ? null : _t;
        AST i = null;
        AST tt = null;
        AST at = null;
        TypeSpec t = null;
        Value e = null;
        ScigolAnnotation annot = null;
        LinkedList<Annotation> annotations = new LinkedList<Annotation>();
        EnumSet<TypeSpec.Modifier> modifiers = EnumSet.of(TypeSpec.Modifier.Public);
        AST __t124 = _t;
        this.match(_t, 82);
        _t = _t.getFirstChild();
        while (true) {
            if (_t == null) {
                _t = ASTNULL;
            }
            if (_t.getType() != 81) break;
            annot = this.annotation(_t);
            _t = this._retTree;
            annotations.add(annot);
        }
        if (_t == null) {
            _t = ASTNULL;
        }
        switch (_t.getType()) {
            case 22: {
                modifiers = this.classModifiers(_t);
                _t = this._retTree;
                break;
            }
            case 30: {
                break;
            }
            default: {
                throw new NoViableAltException(_t);
            }
        }
        i = _t;
        this.match(_t, 30);
        _t = _t.getNextSibling();
        this.scope.pushDeclarationIdent(i.getText());
        if (_t == null) {
            _t = ASTNULL;
        }
        switch (_t.getType()) {
            case 72: {
                tt = _t;
                this.match(_t, 72);
                _t = _t.getNextSibling();
                t = this.typeExpression(_t);
                _t = this._retTree;
                break;
            }
            case 3: 
            case 44: {
                break;
            }
            default: {
                throw new NoViableAltException(_t);
            }
        }
        if (_t == null) {
            _t = ASTNULL;
        }
        switch (_t.getType()) {
            case 44: {
                at = _t;
                this.match(_t, 44);
                _t = _t.getNextSibling();
                e = this.expr(_t);
                _t = this._retTree;
                break;
            }
            case 3: {
                break;
            }
            default: {
                throw new NoViableAltException(_t);
            }
        }
        _t = __t124;
        _t = _t.getNextSibling();
        this.scope.popDeclarationIdent();
        String id = i.getText();
        boolean typeSupplied = t != null;
        boolean bl = initializerSupplied = e != null;
        if (!typeSupplied) {
            if (!initializerSupplied) {
                ScigolTreeParser.semanticError("must supply either a type or an initializer in let declaration of identifier '" + id + "'");
            } else {
                t = e.getType();
            }
        } else if (!initializerSupplied) {
            FuncInfo callSig = new FuncInfo();
            callSig.setDefinitionLocation(ScigolTreeParser.locationOf(i));
            e = t.constructValue(callSig, null, this);
            if (e == null) {
                ScigolTreeParser.semanticError(tt, "type " + t.typeName() + " doesn't have an accessible no-argument constructor");
            }
        } else {
            TypeSpec etype = e.getType();
            if (!TypeManager.existsImplicitConversion(etype, t, e)) {
                ScigolTreeParser.semanticError(at, "cannot declare variable '" + id + "' of type '" + t + "' with an incompatible initializer of type '" + etype.typeName() + "'");
            }
            e = TypeManager.performImplicitConversion(etype, t, e);
        }
        if (!t.isFunc() && this.scope.contains(id)) {
            ScigolTreeParser.semanticError(i, "variable " + id + " already declared in this scope");
        }
        this.scope.addEntry(id, t, e.getValue(), null, modifiers).addAnnotations(annotations);
        v = new Value(new LValue(new Symbol(this.scope, id, null)));
        this._retTree = _t;
        return v;
    }

    public final Value assignmentExpression(AST _t) throws RecognitionException {
        Value v = null;
        AST aST = _t == ASTNULL ? null : _t;
        AST a = null;
        Value lhs = null;
        Value rhs = null;
        AST __t30 = _t;
        a = _t == ASTNULL ? null : _t;
        this.match(_t, 44);
        _t = _t.getFirstChild();
        lhs = this.expr(_t);
        _t = this._retTree;
        rhs = this.expr(_t);
        _t = this._retTree;
        _t = __t30;
        _t = _t.getNextSibling();
        if (lhs.isLValue()) {
            LValue l = lhs.getLValue();
            TypeSpec tlhs = l.getType();
            TypeSpec trhs = TypeSpec.typeOf(rhs);
            if (TypeManager.existsImplicitConversion(trhs, tlhs, rhs)) {
                lhs.setValue(TypeManager.performImplicitConversion(trhs, tlhs, rhs).getValue());
            } else {
                ScigolTreeParser.semanticError(a, "incompatible right-hand-side (RHS) in assignment, value of type '" + trhs + "' is incompatible with LHS type '" + tlhs + "'");
            }
            v = lhs;
        } else if (lhs.isNamespaceComponent()) {
            if (this.interactive) {
                String name = lhs.getNamespaceComponentString();
                int dotIndex = name.indexOf(46);
                if (dotIndex == -1) {
                    TypeSpec trhs = TypeSpec.typeOf(rhs.getValue());
                    TypeSpec tlhs = new TypeSpec(TypeSpec.anyType);
                    if (trhs.isANum()) {
                        tlhs = new TypeSpec(TypeSpec.numType);
                        if (!(rhs.getValue() instanceof Num)) {
                            rhs = new Value(new Num(rhs.getValue()));
                        }
                    } else {
                        rhs = new Value(new Any(rhs.getValue()));
                    }
                    this.scope.addEntry(name, tlhs, rhs.getValue(), null, EnumSet.of(TypeSpec.Modifier.Public));
                    v = new Value(new LValue(new Symbol(this.scope, name, null)));
                } else {
                    ScigolTreeParser.semanticError(a, "unknown name '" + lhs.getNamespaceComponentString() + "' on left-hand-side (LHS) of assignment expression");
                }
            } else {
                ScigolTreeParser.semanticError(a, "unknown name '" + lhs.getNamespaceComponentString() + "' on left-hand-side (LHS) of assignment expression");
            }
        } else {
            ScigolTreeParser.semanticError(a, "left-hand-side (LHS) of assignment expression is not assignable (not an lvalue)");
        }
        this._retTree = _t;
        return v;
    }

    public final Value typeofExpression(AST _t) throws RecognitionException {
        Value v = null;
        AST aST = _t == ASTNULL ? null : _t;
        Value e = null;
        AST __t32 = _t;
        this.match(_t, 37);
        _t = _t.getFirstChild();
        e = this.expr(_t);
        _t = this._retTree;
        _t = __t32;
        _t = _t.getNextSibling();
        if (e == null) {
            v = new Value(TypeSpec.anyTypeSpec);
        } else if (!TypeSpec.typeOf(e).isType()) {
            boolean isNull;
            boolean bl = isNull = e.getValue() == null || e.getValue() instanceof Any && ((Any)e.getValue()).value == null;
            if (e.isLValue() && isNull) {
                v = new Value(e.getLValue().getSymbol().getType());
            } else if (e.getValue() instanceof Any) {
                e = new Value(((Any)e.getValue()).value);
            }
            if (v == null) {
                v = new Value(TypeSpec.typeOf(e));
            }
        } else {
            v = new Value(TypeSpec.typeTypeSpec);
        }
        this._retTree = _t;
        return v;
    }

    public final Value symbol(AST _t) throws RecognitionException {
        Entry entry;
        Value v = null;
        AST aST = _t == ASTNULL ? null : _t;
        AST id = null;
        int esc = 0;
        while (true) {
            if (_t == null) {
                _t = ASTNULL;
            }
            if (_t.getType() != 68) break;
            this.match(_t, 68);
            _t = _t.getNextSibling();
            ++esc;
        }
        id = _t;
        this.match(_t, 30);
        _t = _t.getNextSibling();
        String ident = id.getText();
        Scope searchScope = this.scope;
        int numEscs = esc;
        while (esc-- > 0) {
            if (searchScope.getOuter() == null) continue;
            searchScope = searchScope.getOuter();
        }
        Symbol thiss = new Symbol(this.scope, "this", null);
        Object instance = thiss.exists() ? thiss.getValue() : null;
        Symbol s = new Symbol(searchScope, ident, instance);
        s.setDefinitionLocation(ScigolTreeParser.locationOf(id));
        if (instance == null && s.exists() && !s.isAmbiguous() && (entry = s.getEntry()).isClassMember() && !entry.isStatic()) {
            TypeSpec declaringClass = ((ClassScope)entry.scope).getClassType();
            ScigolTreeParser.semanticError(id, "the instance member named '" + ident + "' of class '" + declaringClass + "' cannot be accessed without an instance object");
        }
        if (!s.exists()) {
            if (numEscs == 0) {
                v = new Value(ident);
                v.setValueIsNamespaceComponent(ScigolTreeParser.locationOf(id));
            } else {
                ScigolTreeParser.semanticError(id, "undefined identifier '" + ident + "' in the specified scope:\n" + searchScope);
            }
        } else {
            v = new Value(new LValue(s));
        }
        this._retTree = _t;
        return v;
    }

    public final Value applicationExpression(AST _t) throws RecognitionException {
        Object fo;
        Value v = null;
        AST aST = _t == ASTNULL ? null : _t;
        AST app = null;
        ArrayList args = null;
        AST __t14 = _t;
        app = _t == ASTNULL ? null : _t;
        this.match(_t, 16);
        _t = _t.getFirstChild();
        Value f = this.expr(_t);
        _t = this._retTree;
        args = this.applicationArgs(_t);
        _t = this._retTree;
        _t = __t14;
        _t = _t.getNextSibling();
        FuncInfo callSig = new FuncInfo(args);
        callSig.setDefinitionLocation(ScigolTreeParser.locationOf(app));
        boolean isFunc = false;
        Func func = null;
        if (!f.isLValue() || f.isLValue() && !f.getLValue().getSymbol().isAmbiguous()) {
            boolean isProperty = false;
            if (f.isLValue()) {
                Symbol s = f.getLValue().getSymbol();
                isProperty = s.getEntry().isProperty();
            }
            if (isProperty) {
                isFunc = false;
            } else {
                fo = f.getValue();
                if (fo != null) {
                    isFunc = f.getType().isFunc();
                    if (isFunc) {
                        func = (Func)fo;
                    }
                } else {
                    isFunc = true;
                }
            }
        } else {
            Symbol s = f.getLValue().getSymbol();
            s.disambiguate(callSig, args);
            isFunc = true;
            fo = f.getValue();
            if (fo != null) {
                func = (Func)fo;
            }
        }
        if (isFunc) {
            if (func == null) {
                v = null;
            } else {
                Object[] convertedArgs = func.getInfo().convertParameters(callSig, args, func.isExternal());
                Object instance = null;
                if (f.isLValue()) {
                    instance = f.getLValue().getSymbol().getInstance();
                }
                v = new Value(func.call(instance, convertedArgs));
            }
        } else if (f.getType().isType()) {
            TypeSpec t = (TypeSpec)f.getValue();
            v = null;
            if (callSig.numArgs() == 1) {
                v = TypeManager.performExplicitConversion(callSig.getParamTypes()[0], t, new Value(args.get(0)));
            }
            if (v == null) {
                v = new Value(t.constructValue(callSig, args, this));
            }
            Debug.Assert(v != null, "construction/conversion failed");
        } else {
            Symbol s = f.getLValue().getSymbol();
            boolean isProperty = s.getEntry().isProperty();
            if (isProperty) {
                if (f.getLValue().isBoundProperty()) {
                    Debug.Unimplemented("property already bound");
                }
                v = new Value(new LValue(f.getLValue().getSymbol(), callSig, FuncInfo.toArray(args)));
            } else {
                TypeSpec ftype = f.getType();
                boolean isClass = false;
                if (ftype.isClass() || ftype.isBuiltinClass()) {
                    isClass = true;
                } else if (ftype.isAny() || ftype.isNum()) {
                    ftype = (f = TypeSpec.unwrapAnyOrNumValue(f)).getType();
                    boolean bl = isClass = ftype.isClass() || ftype.isBuiltinClass();
                }
                if (isClass) {
                    ClassScope classScope = new ClassScope(ftype);
                    Symbol pSymbol = new Symbol(classScope, "operator()", f.getValue());
                    if (!pSymbol.exists()) {
                        ScigolTreeParser.semanticError(ScigolTreeParser.locationOf(app), "object of type '" + ftype + "' has no indexer ('operator()' property) defined, hence cannot be called (with call signature " + callSig + ")");
                    }
                    v = new Value(new LValue(pSymbol, callSig, FuncInfo.toArray(args)));
                } else {
                    ScigolTreeParser.semanticError(ScigolTreeParser.locationOf(app), "cannot call an object of type '" + f.getType() + "'.  To be `called` it must be either a type (construction), a func (call), or an object with an 'operator()' property (indexing).");
                }
            }
        }
        this._retTree = _t;
        return v;
    }

    public final Value selectionExpression(AST _t) throws RecognitionException {
        Value v = null;
        AST aST = _t == ASTNULL ? null : _t;
        AST id = null;
        AST __t12 = _t;
        this.match(_t, 4);
        _t = _t.getFirstChild();
        Value f = this.expr(_t);
        id = _t = this._retTree;
        this.match(_t, 30);
        _t = _t.getNextSibling();
        _t = __t12;
        _t = _t.getNextSibling();
        String name = id.getText();
        String fid = "";
        if (f.isLValue()) {
            fid = "'" + f.getLValue().getSymbol().getName() + "' ";
        }
        if (f.isNamespaceComponent()) {
            String component = f.getNamespaceComponentString();
            NamespaceScope nsScope = this.scope.getGlobalScope().getNamespaceScope(component);
            if (nsScope != null && nsScope.contains(name)) {
                Symbol s = new Symbol(nsScope, name, null);
                LValue lv = new LValue(s);
                v = new Value(lv);
            } else {
                TypeSpec gt;
                String qualifiedName = String.valueOf(component) + "." + name;
                Type javaType = NamespaceScope.loadedLibrariesGetType(qualifiedName);
                TypeSpec typeSpec = gt = javaType != null ? new TypeSpec(javaType) : null;
                if (gt != null) {
                    v = new Value(gt);
                } else {
                    v = new Value(qualifiedName);
                    v.setValueIsNamespaceComponent(ScigolTreeParser.locationOf(id));
                }
            }
        } else {
            TypeSpec t = TypeSpec.typeOf(f.getValue());
            if (t.isAny()) {
                f = new Value(((Any)f.getValue()).value);
                t = TypeSpec.typeOf(f.getValue());
            }
            if (t.isClass() || t.isBuiltinClass()) {
                ClassScope classScope = new ClassScope(t);
                Symbol s = new Symbol(classScope, name, f.getValue());
                if (!s.exists()) {
                    ScigolTreeParser.semanticError(id, "object " + fid + "of type '" + t + "' has no member named '" + name + "'");
                }
                v = new Value(new LValue(s));
            } else if (t.isType()) {
                ClassScope classScope;
                Symbol s;
                TypeSpec typeExpr = (TypeSpec)f.getValue();
                if (!typeExpr.isClass()) {
                    ScigolTreeParser.semanticError(id, "cannot select a member of object " + fid + "of non-class type '" + t + "'");
                }
                if (!(s = new Symbol(classScope = new ClassScope(typeExpr), name, null)).exists()) {
                    ScigolTreeParser.semanticError(id, "object " + fid + "of type '" + typeExpr + "' has no member named '" + name + "'");
                }
                v = new Value(new LValue(s));
            } else {
                ScigolTreeParser.semanticError(id, "cannot select member '" + name + "' from object " + fid + "of type '" + t + "'");
            }
        }
        this._retTree = _t;
        return v;
    }

    public final Value ifExpression(AST _t) throws RecognitionException {
        Value v = null;
        AST ifExpression_AST_in = _t == ASTNULL ? null : _t;
        AST ift = null;
        Value test = null;
        AST __t103 = _t;
        ift = _t == ASTNULL ? null : _t;
        this.match(_t, 112);
        _t = _t.getFirstChild();
        test = this.expr(_t);
        _t = this._retTree;
        _t = __t103;
        _t = _t.getNextSibling();
        TypeSpec t = TypeSpec.typeOf(test);
        if (!TypeManager.existsImplicitConversion(t, TypeSpec.boolTypeSpec, test)) {
            ScigolTreeParser.semanticError(ift, "'if' test expression must be of type 'bool'");
        }
        boolean btest = (Boolean)TypeManager.performImplicitConversion(t, TypeSpec.boolTypeSpec, test).getValue();
        AST ifAST = ifExpression_AST_in;
        AST thenAST = ifAST.getFirstChild().getNextSibling();
        AST elseAST = thenAST.getNextSibling();
        if (btest) {
            v = this.expr(thenAST);
        } else if (elseAST != null) {
            v = this.expr(elseAST);
        }
        this._retTree = _t;
        return v;
    }

    public final Value whileExpression(AST _t) throws RecognitionException {
        Value v = null;
        AST whileExpression_AST_in = _t == ASTNULL ? null : _t;
        AST w = null;
        AST d = null;
        Value test = null;
        if (_t == null) {
            _t = ASTNULL;
        }
        switch (_t.getType()) {
            case 116: {
                AST __t105 = _t;
                w = _t == ASTNULL ? null : _t;
                this.match(_t, 116);
                _t = _t.getFirstChild();
                test = this.expr(_t);
                _t = this._retTree;
                _t = __t105;
                _t = _t.getNextSibling();
                AST whileAST = whileExpression_AST_in;
                AST testAST = whileAST.getFirstChild();
                AST bodyAST = whileAST.getFirstChild().getNextSibling();
                TypeSpec t = TypeSpec.typeOf(test);
                if (!TypeManager.existsImplicitConversion(t, TypeSpec.boolTypeSpec, test)) {
                    ScigolTreeParser.semanticError(w, "'while' test expression must be of type 'bool'");
                }
                boolean btest = (Boolean)TypeManager.performImplicitConversion(t, TypeSpec.boolTypeSpec, test).getValue();
                while (btest) {
                    v = this.expr(bodyAST);
                    test = this.expr(testAST);
                    t = TypeSpec.typeOf(test);
                    if (!TypeManager.existsImplicitConversion(t, TypeSpec.boolTypeSpec, test)) {
                        ScigolTreeParser.semanticError(w, "'while' test expression must be of type 'bool'");
                    }
                    btest = (Boolean)TypeManager.performImplicitConversion(t, TypeSpec.boolTypeSpec, test).getValue();
                }
                break;
            }
            case 115: {
                boolean btest;
                AST __t106 = _t;
                d = _t == ASTNULL ? null : _t;
                this.match(_t, 115);
                _t = _t.getFirstChild();
                v = this.expr(_t);
                _t = this._retTree;
                test = this.expr(_t);
                _t = this._retTree;
                _t = __t106;
                _t = _t.getNextSibling();
                AST whileAST = whileExpression_AST_in;
                AST bodyAST = whileAST.getFirstChild();
                AST testAST = whileAST.getFirstChild().getNextSibling();
                TypeSpec t = TypeSpec.typeOf(test);
                if (!TypeManager.existsImplicitConversion(t, TypeSpec.boolTypeSpec, test)) {
                    ScigolTreeParser.semanticError(d, "'do...while' test expression must be of type 'bool'");
                }
                if (!(btest = ((Boolean)TypeManager.performImplicitConversion(t, TypeSpec.boolTypeSpec, test).getValue()).booleanValue())) break;
                do {
                    v = this.expr(bodyAST);
                    test = this.expr(testAST);
                    t = TypeSpec.typeOf(test);
                    if (TypeManager.existsImplicitConversion(t, TypeSpec.boolTypeSpec, test)) continue;
                    ScigolTreeParser.semanticError(d, "'do...while' test expression must be of type 'bool'");
                } while (btest = ((Boolean)TypeManager.performImplicitConversion(t, TypeSpec.boolTypeSpec, test).getValue()).booleanValue());
                break;
            }
            default: {
                throw new NoViableAltException(_t);
            }
        }
        this._retTree = _t;
        return v;
    }

    public final Value forExpression(AST _t) throws RecognitionException {
        Value v = null;
        AST aST = _t == ASTNULL ? null : _t;
        AST __t108 = _t;
        this.match(_t, 117);
        _t = _t.getFirstChild();
        this.expr(_t);
        _t = this._retTree;
        this.expr(_t);
        _t = this._retTree;
        this.expr(_t);
        _t = this._retTree;
        _t = __t108;
        _t = _t.getNextSibling();
        Debug.Unimplemented();
        this._retTree = _t;
        return v;
    }

    public final Value forEachExpression(AST _t) throws RecognitionException {
        Value v = null;
        AST aST = _t == ASTNULL ? null : _t;
        AST __t110 = _t;
        this.match(_t, 118);
        _t = _t.getFirstChild();
        this.match(_t, 30);
        _t = _t.getNextSibling();
        this.expr(_t);
        _t = this._retTree;
        if (_t == null) {
            _t = ASTNULL;
        }
        switch (_t.getType()) {
            case 72: {
                AST __t112 = _t;
                this.match(_t, 72);
                _t = _t.getFirstChild();
                this.expr(_t);
                _t = this._retTree;
                this.expr(_t);
                _t = this._retTree;
                if (_t == null) {
                    _t = ASTNULL;
                }
                switch (_t.getType()) {
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 10: 
                    case 11: 
                    case 12: 
                    case 13: 
                    case 14: 
                    case 15: 
                    case 16: 
                    case 18: 
                    case 19: 
                    case 20: 
                    case 21: 
                    case 23: 
                    case 28: 
                    case 30: 
                    case 34: 
                    case 37: 
                    case 43: 
                    case 44: 
                    case 45: 
                    case 46: 
                    case 47: 
                    case 48: 
                    case 49: 
                    case 50: 
                    case 51: 
                    case 52: 
                    case 53: 
                    case 54: 
                    case 55: 
                    case 56: 
                    case 57: 
                    case 58: 
                    case 59: 
                    case 60: 
                    case 61: 
                    case 62: 
                    case 63: 
                    case 64: 
                    case 65: 
                    case 66: 
                    case 67: 
                    case 68: 
                    case 70: 
                    case 73: 
                    case 74: 
                    case 75: 
                    case 76: 
                    case 77: 
                    case 82: 
                    case 86: 
                    case 87: 
                    case 112: 
                    case 115: 
                    case 116: 
                    case 117: 
                    case 118: 
                    case 121: {
                        this.expr(_t);
                        _t = this._retTree;
                        break;
                    }
                    case 3: {
                        break;
                    }
                    default: {
                        throw new NoViableAltException(_t);
                    }
                }
                _t = __t112;
                _t = _t.getNextSibling();
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 28: 
            case 30: 
            case 34: 
            case 37: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 70: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 82: 
            case 86: 
            case 87: 
            case 112: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 121: {
                this.expr(_t);
                _t = this._retTree;
                break;
            }
            default: {
                throw new NoViableAltException(_t);
            }
        }
        _t = __t110;
        _t = _t.getNextSibling();
        Debug.Unimplemented();
        this._retTree = _t;
        return v;
    }

    public final Value exceptionBlock(AST _t) throws RecognitionException {
        Value v = null;
        AST exceptionBlock_AST_in = _t == ASTNULL ? null : _t;
        this.match(_t, 70);
        _t = _t.getNextSibling();
        AST blockAST = exceptionBlock_AST_in;
        blockAST.getFirstChild().getFirstChild();
        AST ast = blockAST.getFirstChild().getNextSibling();
        Debug.WriteLine("blockAST=\n" + blockAST.toStringTree());
        Debug.WriteLine("\nast=\n" + ast.toStringTree());
        this._retTree = _t;
        return v;
    }

    public final Value throwExpression(AST _t) throws RecognitionException {
        Value v = null;
        AST aST = _t == ASTNULL ? null : _t;
        AST th = null;
        Value e = null;
        AST __t116 = _t;
        th = _t == ASTNULL ? null : _t;
        this.match(_t, 121);
        _t = _t.getFirstChild();
        e = this.expr(_t);
        _t = this._retTree;
        _t = __t116;
        _t = _t.getNextSibling();
        Object o = e.getValue();
        if (o instanceof Any) {
            o = ((Any)o).value;
        }
        if (!(o instanceof Exception)) {
            ScigolTreeParser.semanticError(th, "only exceptions can be thrown (not objects of type '" + TypeSpec.typeOf(e) + "')");
        }
        Debug.Unimplemented();
        this._retTree = _t;
        return v;
    }

    public final ArrayList applicationArgs(AST _t) throws RecognitionException {
        ArrayList<Object> args = new ArrayList<Object>();
        AST aST = _t == ASTNULL ? null : _t;
        AST c = null;
        boolean sawNamedArg = false;
        AST __t16 = _t;
        this.match(_t, 38);
        _t = _t.getFirstChild();
        Value e = null;
        if (_t == null) {
            _t = ASTNULL;
        }
        switch (_t.getType()) {
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 28: 
            case 30: 
            case 34: 
            case 37: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 70: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 82: 
            case 86: 
            case 87: 
            case 112: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 121: {
                e = this.expr(_t);
                _t = this._retTree;
                break;
            }
            case 17: {
                e = this.namedArg(_t);
                _t = this._retTree;
                sawNamedArg = true;
                break;
            }
            case 3: 
            case 41: {
                break;
            }
            default: {
                throw new NoViableAltException(_t);
            }
        }
        if (e != null) {
            args.add(e);
        } else {
            args.add(FuncInfo.defaultArg);
        }
        while (true) {
            if (_t == null) {
                _t = ASTNULL;
            }
            if (_t.getType() != 41) break;
            e = null;
            c = _t;
            this.match(_t, 41);
            _t = _t.getNextSibling();
            if (_t == null) {
                _t = ASTNULL;
            }
            switch (_t.getType()) {
                case 17: {
                    e = this.namedArg(_t);
                    _t = this._retTree;
                    sawNamedArg = true;
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 23: 
                case 28: 
                case 30: 
                case 34: 
                case 37: 
                case 43: 
                case 44: 
                case 45: 
                case 46: 
                case 47: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 58: 
                case 59: 
                case 60: 
                case 61: 
                case 62: 
                case 63: 
                case 64: 
                case 65: 
                case 66: 
                case 67: 
                case 68: 
                case 70: 
                case 73: 
                case 74: 
                case 75: 
                case 76: 
                case 77: 
                case 82: 
                case 86: 
                case 87: 
                case 112: 
                case 115: 
                case 116: 
                case 117: 
                case 118: 
                case 121: {
                    e = this.expr(_t);
                    _t = this._retTree;
                    if (!sawNamedArg) break;
                    ScigolTreeParser.semanticError(ScigolTreeParser.locationOf(c), "a positional argument cannot follow a named argument in an application");
                    break;
                }
                case 3: 
                case 41: {
                    break;
                }
                default: {
                    throw new NoViableAltException(_t);
                }
            }
            if (e != null) {
                args.add(e);
                continue;
            }
            args.add(FuncInfo.defaultArg);
        }
        _t = __t16;
        _t = _t.getNextSibling();
        if (args.size() == 1 && args.get(0) == FuncInfo.defaultArg) {
            args.clear();
        }
        this._retTree = _t;
        return args;
    }

    public final Value namedArg(AST _t) throws RecognitionException {
        Value v = null;
        AST aST = _t == ASTNULL ? null : _t;
        AST id = null;
        AST __t24 = _t;
        this.match(_t, 17);
        id = _t = _t.getFirstChild();
        this.match(_t, 30);
        _t = _t.getNextSibling();
        Value e = this.expr(_t);
        _t = this._retTree;
        _t = __t24;
        _t = _t.getNextSibling();
        FuncInfo.NamedArgument na = new FuncInfo.NamedArgument(id.getText(), e);
        v = new Value(na);
        this._retTree = _t;
        return v;
    }

    public final Value number(AST _t) throws RecognitionException {
        Value v = null;
        AST aST = _t == ASTNULL ? null : _t;
        AST i = null;
        AST d = null;
        AST r = null;
        AST s = null;
        if (_t == null) {
            _t = ASTNULL;
        }
        switch (_t.getType()) {
            case 73: {
                i = _t;
                this.match(_t, 73);
                _t = _t.getNextSibling();
                v = new Value(new Integer(i.getText()));
                break;
            }
            case 74: {
                d = _t;
                this.match(_t, 74);
                _t = _t.getNextSibling();
                v = new Value(new Long(d.getText()));
                break;
            }
            case 75: {
                r = _t;
                this.match(_t, 75);
                _t = _t.getNextSibling();
                v = new Value(new Double(r.getText()));
                break;
            }
            case 76: {
                s = _t;
                this.match(_t, 76);
                _t = _t.getNextSibling();
                v = new Value(new Float(s.getText()));
                break;
            }
            case 18: {
                this.match(_t, 18);
                _t = _t.getNextSibling();
                v = new Value(new Boolean(true));
                break;
            }
            case 19: {
                this.match(_t, 19);
                _t = _t.getNextSibling();
                v = new Value(new Boolean(false));
                break;
            }
            case 20: {
                this.match(_t, 20);
                _t = _t.getNextSibling();
                v = new Value(new Any(null));
                break;
            }
            case 10: {
                v = this.matrixexpr(_t);
                _t = this._retTree;
                break;
            }
            default: {
                throw new NoViableAltException(_t);
            }
        }
        this._retTree = _t;
        return v;
    }

    public final Value stringLit(AST _t) throws RecognitionException {
        Value v = null;
        AST aST = _t == ASTNULL ? null : _t;
        AST s = null;
        s = _t;
        this.match(_t, 34);
        _t = _t.getNextSibling();
        String str = new String(s.getText());
        str = str.charAt(0) == '\"' ? str.substring(1, str.length() - 1) : str.substring(2, str.length() - 2);
        v = new Value(str);
        this._retTree = _t;
        return v;
    }

    public final Value charLit(AST _t) throws RecognitionException {
        Value v = null;
        AST aST = _t == ASTNULL ? null : _t;
        AST c = null;
        c = _t;
        this.match(_t, 77);
        _t = _t.getNextSibling();
        String str = new String(c.getText());
        if (str.charAt(0) == '\"') {
            str = str.substring(1, str.length() - 2);
        }
        if (str.length() != 1) {
            ScigolTreeParser.semanticError(ScigolTreeParser.locationOf(c), "character literals must contain a single character within the quotes");
        }
        v = new Value(Character.valueOf(str.charAt(0)));
        this._retTree = _t;
        return v;
    }

    public final TypeSpec typeLiteral(AST _t) throws RecognitionException {
        TypeSpec t = null;
        AST aST = _t == ASTNULL ? null : _t;
        AST b = null;
        FuncInfo fi = null;
        if (_t == null) {
            _t = ASTNULL;
        }
        switch (_t.getType()) {
            case 23: {
                b = _t;
                this.match(_t, 23);
                _t = _t.getNextSibling();
                t = new TypeSpec(b.getText());
                if (t != null) break;
                ScigolTreeParser.semanticError(b, "undefined type " + b.getText());
                break;
            }
            case 13: {
                fi = this.funcType(_t);
                _t = this._retTree;
                t = new TypeSpec(fi);
                break;
            }
            case 86: {
                t = this.classType(_t);
                _t = this._retTree;
                break;
            }
            case 87: {
                t = this.interfaceType(_t);
                _t = this._retTree;
                break;
            }
            default: {
                throw new NoViableAltException(_t);
            }
        }
        this._retTree = _t;
        return t;
    }

    public final Func functionLiteral(AST _t) throws RecognitionException {
        Func v = null;
        AST aST = _t == ASTNULL ? null : _t;
        AST __t179 = _t;
        this.match(_t, 21);
        _t = _t.getFirstChild();
        FuncInfo sig = this.funcSignature(_t);
        _t = this._retTree;
        v = this.functionLiteralBody(_t, sig);
        _t = this._retTree;
        _t = __t179;
        this._retTree = _t = _t.getNextSibling();
        return v;
    }

    public final String namespaceName(AST _t) throws RecognitionException {
        String name = "";
        AST aST = _t == ASTNULL ? null : _t;
        AST i = null;
        AST i2 = null;
        i = _t;
        this.match(_t, 30);
        _t = _t.getNextSibling();
        name = String.valueOf(name) + i.getText();
        while (true) {
            if (_t == null) {
                _t = ASTNULL;
            }
            if (_t.getType() != 4) break;
            this.match(_t, 4);
            i2 = _t = _t.getNextSibling();
            this.match(_t, 30);
            _t = _t.getNextSibling();
            name = String.valueOf(name) + "." + i2.getText();
        }
        this._retTree = _t;
        return name;
    }

    public final void usingDecl(AST _t) throws RecognitionException {
        int lastDot;
        AST aST = _t == ASTNULL ? null : _t;
        AST aliasId = null;
        String id = null;
        Value source = null;
        AST __t49 = _t;
        AST aST2 = _t == ASTNULL ? null : _t;
        this.match(_t, 31);
        _t = _t.getFirstChild();
        id = this.namespaceName(_t);
        _t = this._retTree;
        if (_t == null) {
            _t = ASTNULL;
        }
        switch (_t.getType()) {
            case 32: {
                this.match(_t, 32);
                aliasId = _t = _t.getNextSibling();
                this.match(_t, 30);
                _t = _t.getNextSibling();
                break;
            }
            case 3: 
            case 33: {
                break;
            }
            default: {
                throw new NoViableAltException(_t);
            }
        }
        if (_t == null) {
            _t = ASTNULL;
        }
        switch (_t.getType()) {
            case 33: {
                this.match(_t, 33);
                _t = _t.getNextSibling();
                source = this.stringLit(_t);
                _t = this._retTree;
                break;
            }
            case 3: {
                break;
            }
            default: {
                throw new NoViableAltException(_t);
            }
        }
        _t = __t49;
        _t = _t.getNextSibling();
        if (source != null) {
            Debug.WriteLine("using ... from is not implemented!");
        }
        Debug.Assert(this.scope.isNamespaceScope(), "using can only appear in namespace scope!");
        NamespaceScope nsscope = (NamespaceScope)this.scope;
        String alias = aliasId != null ? aliasId.getText() : null;
        String aliased = null;
        String nsName = id;
        if (nsscope.getNamespaceScope(nsName) == null && (lastDot = id.lastIndexOf(46)) != -1) {
            nsName = id.substring(0, lastDot);
            aliased = id.substring(lastDot + 1);
        }
        if (alias == null) {
            if (aliased == null) {
                nsscope.addUsingNamespace(nsName);
            } else {
                nsscope.addUsingName(aliased, nsName);
            }
        } else {
            if (aliased == null) {
                aliased = nsName;
                nsName = nsscope.fullNamespaceName();
            }
            nsscope.addUsingAlias(alias, aliased, nsName);
        }
        this._retTree = _t;
    }

    public final Value prefixExpression(AST _t) throws RecognitionException {
        Value v = null;
        AST aST = _t == ASTNULL ? null : _t;
        if (_t == null) {
            _t = ASTNULL;
        }
        switch (_t.getType()) {
            case 61: {
                AST __t88 = _t;
                this.match(_t, 61);
                _t = _t.getFirstChild();
                this.expr(_t);
                _t = this._retTree;
                _t = __t88;
                _t = _t.getNextSibling();
                break;
            }
            case 62: {
                AST __t89 = _t;
                this.match(_t, 62);
                _t = _t.getFirstChild();
                this.expr(_t);
                _t = this._retTree;
                _t = __t89;
                _t = _t.getNextSibling();
                break;
            }
            default: {
                throw new NoViableAltException(_t);
            }
        }
        Debug.Unimplemented("prefix");
        this._retTree = _t;
        return v;
    }

    public final Value postfixExpression(AST _t) throws RecognitionException {
        Value v = null;
        AST aST = _t == ASTNULL ? null : _t;
        Value e = null;
        boolean prime = false;
        if (_t == null) {
            _t = ASTNULL;
        }
        switch (_t.getType()) {
            case 14: {
                AST __t92 = _t;
                this.match(_t, 14);
                _t = _t.getFirstChild();
                e = this.expr(_t);
                _t = this._retTree;
                _t = __t92;
                _t = _t.getNextSibling();
                break;
            }
            case 15: {
                AST __t93 = _t;
                this.match(_t, 15);
                _t = _t.getFirstChild();
                e = this.expr(_t);
                _t = this._retTree;
                _t = __t93;
                _t = _t.getNextSibling();
                break;
            }
            case 66: {
                AST __t94 = _t;
                this.match(_t, 66);
                _t = _t.getFirstChild();
                e = this.expr(_t);
                _t = this._retTree;
                prime = true;
                _t = __t94;
                _t = _t.getNextSibling();
                break;
            }
            default: {
                throw new NoViableAltException(_t);
            }
        }
        if (prime) {
            v = Math.performOverloadedOperation("operator'", e, null);
        } else {
            Debug.Unimplemented("post ++/--");
        }
        this._retTree = _t;
        return v;
    }

    public final Value logicalAndExpression(AST _t) throws RecognitionException {
        Value v = null;
        AST logicalAndExpression_AST_in = _t == ASTNULL ? null : _t;
        AST __t81 = _t;
        this.match(_t, 46);
        _t = _t.getFirstChild();
        Value lhs = this.expr(_t);
        _t = this._retTree;
        _t = __t81;
        _t = _t.getNextSibling();
        if (!Math.isLogicalTrue(lhs)) {
            v = new Value(new Boolean(false));
        } else {
            AST logAndAST = logicalAndExpression_AST_in;
            AST rhsAST = logAndAST.getFirstChild().getNextSibling();
            Value rhs = this.expr(rhsAST);
            v = new Value(Math.isLogicalTrue(rhs));
        }
        this._retTree = _t;
        return v;
    }

    public final Value logicalOrExpression(AST _t) throws RecognitionException {
        Value v = null;
        AST logicalOrExpression_AST_in = _t == ASTNULL ? null : _t;
        AST __t75 = _t;
        this.match(_t, 45);
        _t = _t.getFirstChild();
        Value lhs = this.expr(_t);
        _t = this._retTree;
        _t = __t75;
        _t = _t.getNextSibling();
        if (Math.isLogicalTrue(lhs)) {
            v = new Value(true);
        } else {
            AST logOrAST = logicalOrExpression_AST_in;
            AST rhsAST = logOrAST.getFirstChild().getNextSibling();
            Value rhs = this.expr(rhsAST);
            v = new Value(Math.isLogicalTrue(rhs));
        }
        this._retTree = _t;
        return v;
    }

    public final Value logicalNotExpression(AST _t) throws RecognitionException {
        Value rhs;
        Value v = null;
        AST aST = _t == ASTNULL ? null : _t;
        if (_t == null) {
            _t = ASTNULL;
        }
        switch (_t.getType()) {
            case 63: {
                AST __t84 = _t;
                this.match(_t, 63);
                _t = _t.getFirstChild();
                rhs = this.expr(_t);
                _t = this._retTree;
                _t = __t84;
                _t = _t.getNextSibling();
                break;
            }
            case 64: {
                AST __t85 = _t;
                this.match(_t, 64);
                _t = _t.getFirstChild();
                rhs = this.expr(_t);
                _t = this._retTree;
                _t = __t85;
                _t = _t.getNextSibling();
                break;
            }
            default: {
                throw new NoViableAltException(_t);
            }
        }
        v = Math.isLogicalTrue(rhs) ? new Value(new Boolean(false)) : new Value(new Boolean(true));
        this._retTree = _t;
        return v;
    }

    public final Value isExpression(AST _t) throws RecognitionException {
        Value rhs;
        Value v = null;
        AST aST = _t == ASTNULL ? null : _t;
        Value lhs = null;
        boolean neg = false;
        if (_t == null) {
            _t = ASTNULL;
        }
        switch (_t.getType()) {
            case 49: {
                AST __t72 = _t;
                this.match(_t, 49);
                _t = _t.getFirstChild();
                lhs = this.expr(_t);
                _t = this._retTree;
                rhs = this.expr(_t);
                _t = this._retTree;
                _t = __t72;
                _t = _t.getNextSibling();
                break;
            }
            case 50: {
                AST __t73 = _t;
                this.match(_t, 50);
                _t = _t.getFirstChild();
                lhs = this.expr(_t);
                _t = this._retTree;
                rhs = this.expr(_t);
                _t = this._retTree;
                neg = true;
                _t = __t73;
                _t = _t.getNextSibling();
                break;
            }
            default: {
                throw new NoViableAltException(_t);
            }
        }
        TypeSpec anyType = new TypeSpec(TypeSpec.anyType);
        if (lhs.getValue() == null || TypeSpec.typeOf(lhs).equals(anyType) && ((Any)lhs.getValue()).value == null) {
            if (rhs != null) {
                TypeSpec trhs = TypeSpec.typeOf(rhs);
                if (trhs.equals(anyType)) {
                    rhs = new Value(((Any)rhs.getValue()).value);
                    trhs = TypeSpec.typeOf(rhs);
                }
                v = trhs.isType() && rhs.getValue().equals(anyType) ? new Value(true) : new Value(rhs.getValue() == null);
            } else {
                v = new Value(true);
            }
        } else if (rhs.getValue() == null || TypeSpec.typeOf(rhs).equals(anyType) && ((Any)rhs.getValue()).value == null) {
            v = new Value(lhs.getValue() == null || TypeSpec.typeOf(lhs).equals(anyType) && ((Any)lhs.getValue()).value == null);
        } else {
            TypeSpec tlhs = TypeSpec.typeOf(lhs);
            TypeSpec trhs = TypeSpec.typeOf(rhs);
            if (tlhs.equals(anyType)) {
                lhs = new Value(((Any)lhs.getValue()).value);
                tlhs = TypeSpec.typeOf(lhs);
            }
            if (trhs.equals(anyType)) {
                rhs = new Value(((Any)rhs.getValue()).value);
                trhs = TypeSpec.typeOf(rhs);
            }
            v = trhs.isType() ? (rhs.getValue().equals(anyType) ? new Value(true) : new Value(TypeSpec.typeOf(lhs).equals(rhs.getValue()))) : new Value(lhs.getValue() == rhs.getValue());
        }
        if (neg) {
            v = new Value(new Boolean((Boolean)v.getValue() == false));
        }
        Debug.Assert(v.getValue() instanceof Boolean);
        this._retTree = _t;
        return v;
    }

    public final Value rangeExpression(AST _t) throws RecognitionException {
        Value v = null;
        AST aST = _t == ASTNULL ? null : _t;
        AST dd = null;
        Value lhs = null;
        Value rhs = null;
        AST __t68 = _t;
        dd = _t == ASTNULL ? null : _t;
        this.match(_t, 5);
        _t = _t.getFirstChild();
        if (_t == null) {
            _t = ASTNULL;
        }
        switch (_t.getType()) {
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 28: 
            case 30: 
            case 34: 
            case 37: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 70: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 82: 
            case 86: 
            case 87: 
            case 112: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 121: {
                lhs = this.expr(_t);
                _t = this._retTree;
                rhs = this.expr(_t);
                _t = this._retTree;
                break;
            }
            case 3: {
                break;
            }
            default: {
                throw new NoViableAltException(_t);
            }
        }
        _t = __t68;
        _t = _t.getNextSibling();
        if (lhs == null) {
            lhs = new Value(0);
        }
        if (rhs == null) {
            rhs = new Value(-1);
        }
        lhs.rvalue();
        rhs.rvalue();
        TypeSpec tlhs = TypeSpec.typeOf(lhs);
        TypeSpec trhs = TypeSpec.typeOf(rhs);
        TypeSpec intType = new TypeSpec(TypeSpec.intType);
        if (!TypeManager.existsImplicitConversion(tlhs, intType, lhs) || !TypeManager.existsImplicitConversion(trhs, intType, rhs)) {
            ScigolTreeParser.semanticError(ScigolTreeParser.locationOf(dd), "both the RHS and LHS of the range operator '..' must be compatible with type 'int'");
        }
        int from = (Integer)TypeManager.performImplicitConversion(tlhs, intType, lhs).getValue();
        int to = (Integer)TypeManager.performImplicitConversion(trhs, intType, rhs).getValue();
        if (from < 0 && to < 0 && from > to || from > 0 && to > 0 && from > to) {
            ScigolTreeParser.semanticError(ScigolTreeParser.locationOf(dd), "invalid range '" + from + ".." + to + "'");
        }
        v = new Value(new Range(from, to));
        this._retTree = _t;
        return v;
    }

    public final Value normExpression(AST _t) throws RecognitionException {
        Value v = null;
        AST aST = _t == ASTNULL ? null : _t;
        AST bl = null;
        Value e = null;
        AST __t77 = _t;
        bl = _t == ASTNULL ? null : _t;
        this.match(_t, 67);
        _t = _t.getFirstChild();
        e = this.expr(_t);
        _t = this._retTree;
        _t = __t77;
        _t = _t.getNextSibling();
        if (e.getValue() == null) {
            ScigolTreeParser.semanticError(ScigolTreeParser.locationOf(bl), "null value in operator|| (norm)");
        }
        v = Math.performOverloadedOperation("operator||", e, null);
        this._retTree = _t;
        return v;
    }

    public final Value cardinalityExpression(AST _t) throws RecognitionException {
        Value v = null;
        AST aST = _t == ASTNULL ? null : _t;
        Value e = null;
        AST __t79 = _t;
        this.match(_t, 65);
        _t = _t.getFirstChild();
        e = this.expr(_t);
        _t = this._retTree;
        _t = __t79;
        _t = _t.getNextSibling();
        v = e.getValue() == null ? new Value(new Integer(0)) : Math.performOverloadedOperation("operator#", null, e);
        this._retTree = _t;
        return v;
    }

    public final ArrayList indexing(AST _t) throws RecognitionException {
        ArrayList indexValues = null;
        AST aST = _t == ASTNULL ? null : _t;
        AST __t96 = _t;
        this.match(_t, 38);
        _t = _t.getFirstChild();
        this.eltRange(_t);
        _t = this._retTree;
        if (_t == null) {
            _t = ASTNULL;
        }
        switch (_t.getType()) {
            case 72: {
                this.eltRange(_t);
                _t = this._retTree;
                break;
            }
            case 3: {
                break;
            }
            default: {
                throw new NoViableAltException(_t);
            }
        }
        _t = __t96;
        this._retTree = _t = _t.getNextSibling();
        return indexValues;
    }

    public final Range eltRange(AST _t) throws RecognitionException {
        Range r = new Range();
        AST aST = _t == ASTNULL ? null : _t;
        AST __t99 = _t;
        this.match(_t, 72);
        _t = _t.getFirstChild();
        while (true) {
            if (_t == null) {
                _t = ASTNULL;
            }
            if (!_tokenSet_0.member(_t.getType())) break;
            this.expr(_t);
            _t = this._retTree;
        }
        _t = __t99;
        this._retTree = _t = _t.getNextSibling();
        return r;
    }

    public final String qualifiedIdent(AST _t) throws RecognitionException {
        String name = "";
        AST aST = _t == ASTNULL ? null : _t;
        AST i = null;
        AST i2 = null;
        i = _t;
        this.match(_t, 30);
        _t = _t.getNextSibling();
        name = i.getText();
        while (true) {
            if (_t == null) {
                _t = ASTNULL;
            }
            if (_t.getType() != 30) break;
            i2 = _t;
            this.match(_t, 30);
            _t = _t.getNextSibling();
            name = String.valueOf(name) + "." + i2.getText();
        }
        this._retTree = _t;
        return name;
    }

    public final ScigolAnnotation annotation(AST _t) throws RecognitionException {
        TypeSpec annotType;
        ScigolAnnotation a = null;
        AST aST = _t == ASTNULL ? null : _t;
        String annotName = null;
        ArrayList args = null;
        AST __t121 = _t;
        this.match(_t, 81);
        _t = _t.getFirstChild();
        annotName = this.qualifiedIdent(_t);
        _t = this._retTree;
        if (_t == null) {
            _t = ASTNULL;
        }
        switch (_t.getType()) {
            case 38: {
                args = this.applicationArgs(_t);
                _t = this._retTree;
                break;
            }
            case 3: {
                break;
            }
            default: {
                throw new NoViableAltException(_t);
            }
        }
        _t = __t121;
        _t = _t.getNextSibling();
        Type javaType = NamespaceScope.loadedLibrariesGetType(annotName);
        TypeSpec typeSpec = annotType = javaType != null ? new TypeSpec(javaType) : null;
        if (annotType == null) {
            ScigolTreeParser.semanticError("the annotation type '" + annotName + "' could not be found in the current scope");
        } else if (!annotType.isInterface() || !annotType.isA(new TypeSpec((Type)((Object)Annotation.class)))) {
            ScigolTreeParser.semanticError("the type '" + annotName + "' specified as an annotation must implement 'Annotation'");
        }
        a = new ScigolAnnotation(annotType);
        a.setMembers(args);
        this._retTree = _t;
        return a;
    }

    public final EnumSet<TypeSpec.Modifier> classModifiers(AST _t) throws RecognitionException {
        AST aST = _t == ASTNULL ? null : _t;
        EnumSet<TypeSpec.Modifier> modifiers = EnumSet.noneOf(TypeSpec.Modifier.class);
        AST __t162 = _t;
        this.match(_t, 22);
        _t = _t.getFirstChild();
        block8: while (true) {
            if (_t == null) {
                _t = ASTNULL;
            }
            switch (_t.getType()) {
                case 91: {
                    this.match(_t, 91);
                    _t = _t.getNextSibling();
                    modifiers.add(TypeSpec.Modifier.Public);
                    continue block8;
                }
                case 93: {
                    this.match(_t, 93);
                    _t = _t.getNextSibling();
                    modifiers.add(TypeSpec.Modifier.Protected);
                    continue block8;
                }
                case 92: {
                    this.match(_t, 92);
                    _t = _t.getNextSibling();
                    modifiers.add(TypeSpec.Modifier.Private);
                    continue block8;
                }
                case 84: {
                    this.match(_t, 84);
                    _t = _t.getNextSibling();
                    modifiers.add(TypeSpec.Modifier.Static);
                    continue block8;
                }
                case 89: {
                    this.match(_t, 89);
                    _t = _t.getNextSibling();
                    modifiers.add(TypeSpec.Modifier.Override);
                    continue block8;
                }
                case 85: {
                    this.match(_t, 85);
                    _t = _t.getNextSibling();
                    modifiers.add(TypeSpec.Modifier.Final);
                    continue block8;
                }
            }
            break;
        }
        _t = __t162;
        this._retTree = _t = _t.getNextSibling();
        return modifiers;
    }

    public final TypeSpec typeExpression(AST _t) throws RecognitionException {
        TypeSpec vtype;
        TypeSpec t = null;
        AST aST = _t == ASTNULL ? null : _t;
        Value v = null;
        v = this.expr(_t);
        _t = this._retTree;
        if (v.getValue() == null) {
            ScigolTreeParser.semanticError("found null where type expression was required");
        }
        if (!(vtype = TypeSpec.typeOf(v)).isType()) {
            if (vtype.isFunc() && vtype.getFuncInfo().getReturnType().isType() && vtype.getFuncInfo().numRequiredArgs() == 0) {
                Func f = (Func)v.getValue();
                FuncInfo callSig = new FuncInfo(new TypeSpec[0], new TypeSpec(TypeSpec.typeType));
                callSig.setDefinitionLocation(new Location());
                Object[] convertedArgs = f.getInfo().convertParameters(callSig, new Object[0], f.isExternal());
                if (v.isLValue()) {
                    v.getLValue().getSymbol().getInstance();
                }
                Object ret = f.call(null, convertedArgs);
                Debug.Assert(TypeSpec.typeOf(ret).isType(), "expected type return");
                t = (TypeSpec)ret;
            } else {
                ScigolTreeParser.semanticError("an expression of type '" + TypeSpec.typeOf(v) + "' was found where type expression was required");
            }
        } else {
            t = (TypeSpec)v.getValue();
        }
        this._retTree = _t;
        return t;
    }

    public final FuncInfo funcType(AST _t) throws RecognitionException {
        FuncInfo v = null;
        AST aST = _t == ASTNULL ? null : _t;
        AST fl = null;
        TypeSpec rt = null;
        FuncInfo fi = null;
        AST __t166 = _t;
        fl = _t == ASTNULL ? null : _t;
        this.match(_t, 13);
        _t = _t.getFirstChild();
        fi = this.paramTypeList(_t);
        _t = this._retTree;
        if (_t == null) {
            _t = ASTNULL;
        }
        switch (_t.getType()) {
            case 80: {
                this.match(_t, 80);
                _t = _t.getNextSibling();
                rt = this.typeExpression(_t);
                _t = this._retTree;
                break;
            }
            case 3: {
                break;
            }
            default: {
                throw new NoViableAltException(_t);
            }
        }
        _t = __t166;
        _t = _t.getNextSibling();
        if (rt != null) {
            fi.setReturnType(rt);
        }
        fi.setDefinitionLocation(ScigolTreeParser.locationOf(fl));
        v = fi;
        this._retTree = _t;
        return v;
    }

    public final TypeSpec classType(AST _t) throws RecognitionException {
        TypeSpec firstType;
        TypeSpec t = null;
        AST aST = _t == ASTNULL ? null : _t;
        AST ct = null;
        AST i = null;
        EnumSet<TypeSpec.Modifier> modifiers = EnumSet.noneOf(TypeSpec.Modifier.class);
        ArrayList baseTypes = new ArrayList();
        AST __t133 = _t;
        ct = _t == ASTNULL ? null : _t;
        this.match(_t, 86);
        _t = _t.getFirstChild();
        if (_t == null) {
            _t = ASTNULL;
        }
        switch (_t.getType()) {
            case 22: {
                modifiers = this.classModifiers(_t);
                _t = this._retTree;
                break;
            }
            case 3: 
            case 24: 
            case 30: 
            case 72: {
                break;
            }
            default: {
                throw new NoViableAltException(_t);
            }
        }
        if (_t == null) {
            _t = ASTNULL;
        }
        switch (_t.getType()) {
            case 72: {
                baseTypes = this.classBase(_t);
                _t = this._retTree;
                break;
            }
            case 3: 
            case 24: 
            case 30: {
                break;
            }
            default: {
                throw new NoViableAltException(_t);
            }
        }
        TypeSpec baseType = TypeSpec.objectTypeSpec;
        int firstInterface = 0;
        if (baseTypes != null && baseTypes.size() > 0 && !(firstType = (TypeSpec)baseTypes.get(0)).isInterface()) {
            baseType = firstType;
            ++firstInterface;
        }
        ClassInfo info = new ClassInfo(this.scope, baseType);
        info.setModifiers(modifiers);
        if (ct instanceof CommonASTWithLocation) {
            info.setDefinitionLocation(((CommonASTWithLocation)ct).loc);
        }
        if (baseTypes.size() > 1) {
            int ii = firstInterface;
            while (ii < baseTypes.size()) {
                TypeSpec iType = (TypeSpec)baseTypes.get(ii);
                info.addInterface(iType);
                ++ii;
            }
        }
        if (this.scope.topDeclarationIdent() != null) {
            info.setIdentityHint(this.scope.topDeclarationIdent());
        }
        this.scope = new ClassScope(new TypeSpec(info));
        this.scope.setDefinitionLocation(ScigolTreeParser.locationOf(ct));
        block13: while (true) {
            if (_t == null) {
                _t = ASTNULL;
            }
            switch (_t.getType()) {
                case 24: {
                    AST __t138 = _t;
                    this.match(_t, 24);
                    _t = _t.getFirstChild();
                    this.classConstructor(_t, info);
                    _t = this._retTree;
                    _t = __t138;
                    _t = _t.getNextSibling();
                    continue block13;
                }
                case 30: {
                    AST __t140 = _t;
                    i = _t == ASTNULL ? null : _t;
                    this.match(_t, 30);
                    _t = _t.getFirstChild();
                    this.scope.pushDeclarationIdent(i.getText());
                    this.classMember(_t, i, false);
                    _t = this._retTree;
                    _t = __t140;
                    _t = _t.getNextSibling();
                    this.scope.popDeclarationIdent();
                    continue block13;
                }
            }
            break;
        }
        info.completeDefinition();
        t = ((ClassScope)this.scope).getClassType();
        this.scope = this.scope.getOuter();
        _t = __t133;
        this._retTree = _t = _t.getNextSibling();
        return t;
    }

    public final TypeSpec interfaceType(AST _t) throws RecognitionException {
        TypeSpec t = null;
        AST aST = _t == ASTNULL ? null : _t;
        AST it = null;
        AST i = null;
        EnumSet<TypeSpec.Modifier> modifiers = EnumSet.noneOf(TypeSpec.Modifier.class);
        ArrayList baseTypes = new ArrayList();
        AST __t143 = _t;
        it = _t == ASTNULL ? null : _t;
        this.match(_t, 87);
        _t = _t.getFirstChild();
        if (_t == null) {
            _t = ASTNULL;
        }
        switch (_t.getType()) {
            case 22: {
                modifiers = this.classModifiers(_t);
                _t = this._retTree;
                break;
            }
            case 3: 
            case 30: 
            case 72: {
                break;
            }
            default: {
                throw new NoViableAltException(_t);
            }
        }
        if (_t == null) {
            _t = ASTNULL;
        }
        switch (_t.getType()) {
            case 72: {
                baseTypes = this.classBase(_t);
                _t = this._retTree;
                break;
            }
            case 3: 
            case 30: {
                break;
            }
            default: {
                throw new NoViableAltException(_t);
            }
        }
        ClassInfo info = new ClassInfo(this.scope, null);
        info.setModifiers(modifiers);
        if (it instanceof CommonASTWithLocation) {
            info.setDefinitionLocation(((CommonASTWithLocation)it).loc);
        }
        if (baseTypes == null) {
            baseTypes = new ArrayList();
        }
        if (baseTypes.size() > 0) {
            int ii = 0;
            while (ii < baseTypes.size()) {
                TypeSpec iType = (TypeSpec)baseTypes.get(ii);
                if (!iType.isBuiltinObject()) {
                    if (!iType.isInterface()) {
                        ScigolTreeParser.semanticError(ScigolTreeParser.locationOf(it), "interfaces can only inherit other interfaces (and 'object')");
                    }
                    info.addInterface(iType);
                }
                ++ii;
            }
        }
        if (this.scope.topDeclarationIdent() != null) {
            info.setIdentityHint(this.scope.topDeclarationIdent());
        }
        this.scope = new ClassScope(new TypeSpec(info));
        this.scope.setDefinitionLocation(ScigolTreeParser.locationOf(it));
        while (true) {
            if (_t == null) {
                _t = ASTNULL;
            }
            if (_t.getType() != 30) break;
            AST __t148 = _t;
            i = _t == ASTNULL ? null : _t;
            this.match(_t, 30);
            _t = _t.getFirstChild();
            this.scope.pushDeclarationIdent(i.getText());
            this.classMember(_t, i, true);
            _t = this._retTree;
            _t = __t148;
            _t = _t.getNextSibling();
            this.scope.popDeclarationIdent();
        }
        info.completeDefinition();
        t = ((ClassScope)this.scope).getClassType();
        this.scope = this.scope.getOuter();
        _t = __t143;
        this._retTree = _t = _t.getNextSibling();
        return t;
    }

    public final ArrayList classBase(AST _t) throws RecognitionException {
        ArrayList<TypeSpec> baseTypes = new ArrayList<TypeSpec>();
        AST aST = _t == ASTNULL ? null : _t;
        AST __t158 = _t;
        this.match(_t, 72);
        _t = _t.getFirstChild();
        while (true) {
            if (_t == null) {
                _t = ASTNULL;
            }
            if (!_tokenSet_0.member(_t.getType())) break;
            TypeSpec baseType = this.typeExpression(_t);
            _t = this._retTree;
            baseTypes.add(baseType);
        }
        _t = __t158;
        this._retTree = _t = _t.getNextSibling();
        return baseTypes;
    }

    public final void classConstructor(AST _t, ClassInfo declaringClass) throws RecognitionException {
        AST aST = _t == ASTNULL ? null : _t;
        EnumSet<TypeSpec.Modifier> modifiers = EnumSet.noneOf(TypeSpec.Modifier.class);
        Func func = null;
        if (_t == null) {
            _t = ASTNULL;
        }
        switch (_t.getType()) {
            case 22: {
                modifiers = this.classModifiers(_t);
                _t = this._retTree;
                break;
            }
            case 21: {
                break;
            }
            default: {
                throw new NoViableAltException(_t);
            }
        }
        func = this.functionLiteral(_t);
        _t = this._retTree;
        Debug.Assert(func.getOuterScope().isClassScope(), "members can only be in class scope");
        if (!modifiers.contains((Object)TypeSpec.Modifier.Private) && !modifiers.contains((Object)TypeSpec.Modifier.Protected)) {
            modifiers.add(TypeSpec.Modifier.Public);
        }
        modifiers.add(TypeSpec.Modifier.Static);
        func.setIsConstructor(true);
        if (func.getInfo().getReturnType() == null || !func.getInfo().getReturnType().equals(new TypeSpec(declaringClass))) {
            ScigolTreeParser.semanticError(func.getInfo().getDefinitionLocation(), "class constructors must return the declaring class type (i.e. 'self')");
        }
        this.scope.addEntry(".ctor", TypeSpec.typeOf(func), func, null, modifiers);
        this._retTree = _t;
    }

    public final void classMember(AST _t, AST memberName, boolean declaringInInterface) throws RecognitionException {
        boolean staticOrConst;
        AST aST = _t == ASTNULL ? null : _t;
        AST t = null;
        AST a = null;
        AST p = null;
        EnumSet<TypeSpec.Modifier> modifiers = EnumSet.noneOf(TypeSpec.Modifier.class);
        TypeSpec dt = null;
        if (_t == null) {
            _t = ASTNULL;
        }
        switch (_t.getType()) {
            case 22: {
                AST aST2 = _t == ASTNULL ? null : _t;
                modifiers = this.classModifiers(_t);
                _t = this._retTree;
                break;
            }
            case 3: 
            case 25: 
            case 44: 
            case 72: {
                break;
            }
            default: {
                throw new NoViableAltException(_t);
            }
        }
        if (_t == null) {
            _t = ASTNULL;
        }
        switch (_t.getType()) {
            case 72: {
                t = _t;
                this.match(_t, 72);
                _t = _t.getNextSibling();
                dt = this.typeExpression(_t);
                _t = this._retTree;
                break;
            }
            case 3: 
            case 25: 
            case 44: {
                break;
            }
            default: {
                throw new NoViableAltException(_t);
            }
        }
        if (_t == null) {
            _t = ASTNULL;
        }
        switch (_t.getType()) {
            case 44: {
                a = _t;
                this.match(_t, 44);
                _t = _t.getNextSibling();
                break;
            }
            case 25: {
                p = _t;
                this.match(_t, 25);
                _t = _t.getNextSibling();
                break;
            }
            case 3: {
                break;
            }
            default: {
                throw new NoViableAltException(_t);
            }
        }
        boolean propertyDecl = p != null;
        boolean isConst = modifiers.contains((Object)TypeSpec.Modifier.Const);
        boolean isStatic = modifiers.contains((Object)TypeSpec.Modifier.Static);
        boolean bl = staticOrConst = isStatic || isConst;
        if (!modifiers.contains((Object)TypeSpec.Modifier.Private) && !modifiers.contains((Object)TypeSpec.Modifier.Protected)) {
            modifiers.add(TypeSpec.Modifier.Public);
        }
        if (propertyDecl) {
            String ident = memberName.getText();
            if (dt == null) {
                ScigolTreeParser.semanticError(ScigolTreeParser.locationOf(memberName), "property member '" + ident + "' must explicitly declare a type");
            }
            if (isStatic && ident.equals("operator()")) {
                ScigolTreeParser.semanticError(ScigolTreeParser.locationOf(memberName), "property member 'operator()' - an indexer - cannot be static");
            }
            FuncInfo propSig = new FuncInfo();
            boolean gotGetAccessor = false;
            boolean gotSetAccessor = false;
            Entry getterEntry = null;
            Entry setterEntry = null;
            AST propAST = p.getFirstChild();
            AST nextAST = propAST.getFirstChild();
            if (nextAST.getType() == 38) {
                AST paramListAST = nextAST.getFirstChild();
                propSig = this.formalParamList(paramListAST);
                nextAST = nextAST.getNextSibling();
            }
            while (nextAST != null && nextAST.getType() == 30) {
                Location loc;
                AST initializerAST = null;
                Object staticValue = null;
                String accessorName = nextAST.getText();
                CommonASTWithLocation astWithLoc = (CommonASTWithLocation)nextAST;
                Location location = loc = astWithLoc != null ? astWithLoc.loc : new Location();
                if (!accessorName.equals("set") && !accessorName.equals("get")) {
                    ScigolTreeParser.semanticError(loc, "the only valid property accessor names are 'get' and 'set'");
                }
                if (accessorName.equals("set")) {
                    if (gotSetAccessor) {
                        ScigolTreeParser.semanticError(loc, "a property can only have one 'set' accessor");
                    }
                    gotSetAccessor = true;
                } else if (accessorName.equals("get")) {
                    if (gotGetAccessor) {
                        ScigolTreeParser.semanticError(loc, "a property can only have one 'get' accessor");
                    }
                    gotGetAccessor = true;
                }
                AST accessorBodyAST = nextAST.getFirstChild();
                FuncInfo accessorSig = propSig.accessorSig(accessorName, dt);
                if (accessorBodyAST.getType() == 35 || accessorBodyAST.getType() == 36 || accessorBodyAST.getType() == 8) {
                    staticValue = this.functionLiteralBody(accessorBodyAST, accessorSig);
                } else {
                    initializerAST = accessorBodyAST;
                    if (staticOrConst) {
                        Value v = this.expr(initializerAST);
                        staticValue = v.getValue();
                        initializerAST = null;
                    }
                }
                String funcName = FuncInfo.accessorName(ident, accessorName.equals("get"));
                Entry accessorEntry = new Entry(funcName, new TypeSpec(accessorSig), staticValue, initializerAST, modifiers, EnumSet.of(Entry.Flags.Method, Entry.Flags.Accessor), -1, this.scope, loc);
                if (accessorName.equals("get")) {
                    getterEntry = accessorEntry;
                } else {
                    setterEntry = accessorEntry;
                }
                this.scope.addEntry(accessorEntry);
                nextAST = nextAST.getNextSibling();
            }
            EnumSet<Entry.Flags> flags = EnumSet.of(Entry.Flags.Property);
            if (gotGetAccessor) {
                flags.add(Entry.Flags.HasGetter);
            }
            if (gotSetAccessor) {
                flags.add(Entry.Flags.HasSetter);
            }
            Entry propEntry = new Entry(ident, dt, null, null, modifiers, flags, -1, this.scope, ScigolTreeParser.locationOf(memberName));
            Entry.EntryPair accessors = new Entry.EntryPair();
            accessors.setter = setterEntry;
            accessors.getter = getterEntry;
            propEntry.setStaticValue(accessors);
            this.scope.addEntry(propEntry);
            if (gotGetAccessor) {
                getterEntry.propertyEntry = propEntry;
            }
            if (gotSetAccessor) {
                setterEntry.propertyEntry = propEntry;
            }
        } else {
            String name;
            Value v;
            boolean initializerSupplied;
            boolean typeSupplied = t != null;
            boolean bl2 = initializerSupplied = a != null;
            if (!typeSupplied && !initializerSupplied) {
                ScigolTreeParser.semanticError(t, "member declaration must include a type or an initializer (or both)");
            }
            AST initializerAST = null;
            if (initializerSupplied) {
                initializerAST = a.getNextSibling();
            }
            Object staticValue = null;
            boolean typeKnown = typeSupplied;
            if (initializerSupplied) {
                if (staticOrConst) {
                    v = this.expr(initializerAST);
                    staticValue = v.getValue();
                    initializerAST = null;
                    if (!typeSupplied) {
                        dt = TypeSpec.typeOf(staticValue);
                        typeKnown = true;
                    }
                } else if (!typeSupplied && initializerAST.getType() == 21) {
                    v = this.expr(initializerAST);
                    staticValue = v.getValue();
                    initializerAST = null;
                    dt = TypeSpec.typeOf(staticValue);
                    typeKnown = true;
                }
            } else {
                Debug.Assert(typeSupplied);
                if (staticOrConst) {
                    v = dt.constructValue(null, null, this);
                    staticValue = v.getValue();
                } else {
                    staticValue = null;
                }
            }
            if (!typeKnown) {
                dt = new TypeSpec(TypeSpec.anyType);
            }
            if (this.scope.contains(name = this.scope.topDeclarationIdent()) && (!typeKnown || typeKnown && !dt.isFunc())) {
                ScigolTreeParser.semanticError(t, "class already has a member named '" + name + "'");
            }
            this.scope.addEntry(name, dt, staticValue, initializerAST, modifiers, ScigolTreeParser.locationOf(memberName));
        }
        this._retTree = _t;
    }

    public final FuncInfo paramTypeList(AST _t) throws RecognitionException {
        FuncInfo fi = null;
        AST aST = _t == ASTNULL ? null : _t;
        ArrayList<TypeSpec> ptypes = new ArrayList<TypeSpec>();
        while (true) {
            if (_t == null) {
                _t = ASTNULL;
            }
            if (!_tokenSet_0.member(_t.getType())) break;
            TypeSpec t = this.typeExpression(_t);
            _t = this._retTree;
            ptypes.add(t);
        }
        int numArgs = ptypes.size();
        TypeSpec[] ptypesa = new TypeSpec[numArgs];
        int p = 0;
        while (p < numArgs) {
            ptypesa[p] = (TypeSpec)ptypes.get(p);
            ++p;
        }
        fi = new FuncInfo(ptypesa, null);
        this._retTree = _t;
        return fi;
    }

    public final FuncInfo funcSignature(AST _t) throws RecognitionException {
        FuncInfo v = null;
        AST aST = _t == ASTNULL ? null : _t;
        AST fl = null;
        TypeSpec rt = null;
        FuncInfo fi = null;
        AST __t169 = _t;
        fl = _t == ASTNULL ? null : _t;
        this.match(_t, 13);
        _t = _t.getFirstChild();
        fi = this.formalParamList(_t);
        _t = this._retTree;
        if (_t == null) {
            _t = ASTNULL;
        }
        switch (_t.getType()) {
            case 80: {
                this.match(_t, 80);
                _t = _t.getNextSibling();
                rt = this.typeExpression(_t);
                _t = this._retTree;
                break;
            }
            case 3: {
                break;
            }
            default: {
                throw new NoViableAltException(_t);
            }
        }
        _t = __t169;
        _t = _t.getNextSibling();
        if (rt != null) {
            fi.setReturnType(rt);
        }
        fi.setDefinitionLocation(ScigolTreeParser.locationOf(fl));
        v = fi;
        this._retTree = _t;
        return v;
    }

    public final FuncInfo formalParamList(AST _t) throws RecognitionException {
        FuncInfo fi = null;
        AST aST = _t == ASTNULL ? null : _t;
        AST i = null;
        Value e = null;
        ArrayList<String> pnames = new ArrayList<String>();
        ArrayList<TypeSpec> ptypes = new ArrayList<TypeSpec>();
        ArrayList<Object> pdefaults = new ArrayList<Object>();
        ArrayList<Boolean> phasdefault = new ArrayList<Boolean>();
        while (true) {
            if (_t == null) {
                _t = ASTNULL;
            }
            if (_t.getType() != 30) break;
            i = _t;
            this.match(_t, 30);
            _t = _t.getNextSibling();
            TypeSpec t = this.typeExpression(_t);
            _t = this._retTree;
            if (_t == null) {
                _t = ASTNULL;
            }
            switch (_t.getType()) {
                case 44: {
                    this.match(_t, 44);
                    _t = _t.getNextSibling();
                    e = this.expr(_t);
                    _t = this._retTree;
                    break;
                }
                case 3: 
                case 30: 
                case 80: {
                    break;
                }
                default: {
                    throw new NoViableAltException(_t);
                }
            }
            String paramName = i.getText();
            TypeSpec paramType = t;
            pnames.add(paramName);
            ptypes.add(paramType);
            phasdefault.add(e != null);
            if (e != null) {
                pdefaults.add(e.getValue());
            } else {
                pdefaults.add(null);
            }
            e = null;
        }
        String[] pnamesa = new String[pnames.size()];
        TypeSpec[] ptypesa = new TypeSpec[ptypes.size()];
        Object[] pdefaultsa = new Object[pdefaults.size()];
        boolean[] phasdefaulta = new boolean[phasdefault.size()];
        int p = 0;
        while (p < pnamesa.length) {
            pnamesa[p] = (String)pnames.get(p);
            ptypesa[p] = (TypeSpec)ptypes.get(p);
            pdefaultsa[p] = pdefaults.get(p);
            phasdefaulta[p] = (Boolean)phasdefault.get(p);
            ++p;
        }
        fi = new FuncInfo(pnamesa, ptypesa, pdefaultsa, phasdefaulta, null);
        fi.setDefinitionLocation(ScigolTreeParser.locationOf(i));
        this._retTree = _t;
        return fi;
    }

    public final Func functionLiteralBody(AST _t, FuncInfo sig) throws RecognitionException {
        Func v = null;
        AST functionLiteralBody_AST_in = _t == ASTNULL ? null : _t;
        if (_t == null) {
            _t = ASTNULL;
        }
        switch (_t.getType()) {
            case 35: {
                this.match(_t, 35);
                _t = _t.getNextSibling();
                break;
            }
            case 36: {
                this.match(_t, 36);
                _t = _t.getNextSibling();
                break;
            }
            case 8: {
                this.match(_t, 8);
                _t = _t.getNextSibling();
                break;
            }
            default: {
                throw new NoViableAltException(_t);
            }
        }
        AST funcBodyAST = null;
        AST preBodyAST = null;
        AST postBodyAST = null;
        AST funcAST = functionLiteralBody_AST_in;
        if (funcAST.getType() == 8) {
            funcBodyAST = funcAST;
        } else {
            int type;
            if (funcAST.getType() == 35 || funcAST.getType() == 36) {
                type = funcAST.getType();
                funcAST = funcAST.getNextSibling();
                if (type == 35) {
                    preBodyAST = funcAST;
                } else {
                    postBodyAST = funcAST;
                }
                funcAST = funcAST.getNextSibling();
            }
            if (funcAST.getType() == 8) {
                funcBodyAST = funcAST;
            } else if (funcAST.getType() == 35 || funcAST.getType() == 36) {
                type = funcAST.getType();
                funcAST = funcAST.getNextSibling();
                if (type == 36) {
                    if (postBodyAST != null) {
                        ScigolTreeParser.semanticError(sig.getDefinitionLocation(), "a func can only define a 'pre' expression, a 'post' expression or both (but not multiple of either)");
                    }
                    postBodyAST = funcAST;
                } else {
                    if (preBodyAST != null) {
                        ScigolTreeParser.semanticError(sig.getDefinitionLocation(), "a func can only define a 'pre' expression, a 'post' expression or both (but not multiple of either)");
                    }
                    preBodyAST = funcAST;
                }
                funcBodyAST = funcAST = funcAST.getNextSibling();
            } else {
                Debug.Assert(false, "couldn't match pre/post or body");
            }
        }
        Debug.Assert(funcBodyAST != null, "no func body!?");
        v = new Func(sig, this.scope, this, funcBodyAST, preBodyAST, postBodyAST);
        this._retTree = _t;
        return v;
    }

    public final Value matrixexpr(AST _t) throws RecognitionException {
        Value v = null;
        AST aST = _t == ASTNULL ? null : _t;
        AST __t190 = _t;
        this.match(_t, 10);
        _t = _t.getFirstChild();
        Vector r = this.matrixrow(_t);
        _t = this._retTree;
        v = new Value(r);
        while (true) {
            if (_t == null) {
                _t = ASTNULL;
            }
            if (_t.getType() != 27) break;
            int _cnt193 = 0;
            while (true) {
                if (_t == null) {
                    _t = ASTNULL;
                }
                if (_t.getType() != 27) {
                    if (_cnt193 >= 1) break;
                    throw new NoViableAltException(_t);
                }
                this.match(_t, 27);
                _t = _t.getNextSibling();
                ++_cnt193;
            }
            r = this.matrixrow(_t);
            _t = this._retTree;
            if (v.getValue() instanceof Vector) {
                v = new Value(new Matrix((Vector)v.getValue()));
            }
            ((Matrix)v.getValue()).appendRowVector(r);
        }
        _t = __t190;
        this._retTree = _t = _t.getNextSibling();
        return v;
    }

    public final Vector matrixrow(AST _t) throws RecognitionException {
        Vector v = new Vector();
        AST aST = _t == ASTNULL ? null : _t;
        int _cnt197 = 0;
        while (true) {
            if (_t == null) {
                _t = ASTNULL;
            }
            if (!_tokenSet_0.member(_t.getType())) {
                if (_cnt197 >= 1) break;
                throw new NoViableAltException(_t);
            }
            Value e = this.expr(_t);
            _t = this._retTree;
            v.appendElement(e.getValue());
            ++_cnt197;
        }
        this._retTree = _t;
        return v;
    }

    private static final long[] mk_tokenSet_0() {
        long[] lArray = new long[4];
        lArray[0] = -8640119570960L;
        lArray[1] = 178173660270706271L;
        long[] data = lArray;
        return data;
    }
}

