/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.sanger.artemis;

import java.io.IOException;
import java.util.StringTokenizer;
import uk.ac.sanger.artemis.AlignMatch;
import uk.ac.sanger.artemis.ComparisonData;
import uk.ac.sanger.artemis.ComparisonDataParseException;
import uk.ac.sanger.artemis.SimpleComparisonData;
import uk.ac.sanger.artemis.util.LinePushBackReader;

public class MSPcrunchComparisonData
extends SimpleComparisonData
implements ComparisonData {
    public MSPcrunchComparisonData(LinePushBackReader stream) throws IOException {
        super(stream);
    }

    protected MSPcrunchComparisonData() {
    }

    protected SimpleComparisonData getNewSimpleComparisonData() {
        return new MSPcrunchComparisonData();
    }

    private static AlignMatch makeMatchFromStringStatic(String line) throws IOException {
        StringTokenizer tokenizer = new StringTokenizer(line, " ");
        if (tokenizer.countTokens() < 8) {
            String message = "while reading MSPcrunch data: not enough fields in this line: " + line;
            throw new ComparisonDataParseException(message);
        }
        String score_token = tokenizer.nextToken();
        String percent_ident_token = tokenizer.nextToken();
        String q_start_token = tokenizer.nextToken();
        String q_end_token = tokenizer.nextToken();
        tokenizer.nextToken();
        String s_start_token = tokenizer.nextToken();
        String s_end_token = tokenizer.nextToken();
        try {
            int score = Integer.valueOf(score_token);
            int percent_ident = (int)Float.valueOf(percent_ident_token).floatValue();
            int q_start = Integer.valueOf(q_start_token);
            int q_end = Integer.valueOf(q_end_token);
            int s_start = Integer.valueOf(s_start_token);
            int s_end = Integer.valueOf(s_end_token);
            AlignMatch new_match = MSPcrunchComparisonData.makeAlignMatch(s_start, s_end, q_start, q_end, score, percent_ident);
            return new_match;
        }
        catch (NumberFormatException e) {
            throw new IOException("while reading MSPcrunch data: failed to parse a number from this string: " + e.getMessage());
        }
    }

    protected AlignMatch makeMatchFromString(String line) throws IOException {
        return MSPcrunchComparisonData.makeMatchFromStringStatic(line);
    }

    public static boolean formatCorrect(String line) {
        try {
            MSPcrunchComparisonData.makeMatchFromStringStatic(line);
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }
}

