/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.sanger.artemis.components;

import java.awt.Component;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import javax.swing.JLabel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import uk.ac.sanger.artemis.Entry;
import uk.ac.sanger.artemis.EntryChangeEvent;
import uk.ac.sanger.artemis.EntryChangeListener;
import uk.ac.sanger.artemis.EntryGroup;
import uk.ac.sanger.artemis.EntryGroupChangeEvent;
import uk.ac.sanger.artemis.EntryGroupChangeListener;
import uk.ac.sanger.artemis.components.FileViewer;
import uk.ac.sanger.artemis.io.ReadFormatException;

public class EntryHeaderEdit
implements EntryChangeListener,
EntryGroupChangeListener,
DocumentListener {
    private EntryGroup entry_group;
    private Entry edit_entry;
    private FileViewer file_viewer;
    private String current_text = "";
    private JLabel error_text = new JLabel("");

    public EntryHeaderEdit(EntryGroup entry_group, Entry edit_entry) {
        this.edit_entry = edit_entry;
        this.entry_group = entry_group;
        this.file_viewer = new FileViewer("Artemis Entry Header Editor: " + edit_entry.getName() == null ? "" : edit_entry.getName());
        this.file_viewer.getContentPane().add((Component)this.error_text, "North");
        this.readHeader();
        this.file_viewer.getTextArea().setEditable(true);
        this.file_viewer.getTextArea().getDocument().addDocumentListener(this);
        this.getEntry().addEntryChangeListener(this);
        entry_group.addEntryGroupChangeListener(this);
        this.file_viewer.addWindowListener(new WindowAdapter(){

            public void windowClosed(WindowEvent event) {
                EntryHeaderEdit.this.stopListening();
            }
        });
    }

    public void stopListening() {
        this.getEntry().removeEntryChangeListener(this);
        this.entry_group.removeEntryGroupChangeListener(this);
    }

    public void entryChanged(EntryChangeEvent event) {
        switch (event.getType()) {
            case 4: {
                if (event.getSource() == this.current_text) {
                    return;
                }
                this.readHeader();
                break;
            }
        }
    }

    public void entryGroupChanged(EntryGroupChangeEvent event) {
        switch (event.getType()) {
            case 1: {
                if (event.getEntry() != this.edit_entry) break;
                this.stopListening();
                this.file_viewer.dispose();
                break;
            }
        }
    }

    public void changedUpdate(DocumentEvent e) {
        this.textValueChanged();
    }

    public void insertUpdate(DocumentEvent e) {
        this.textValueChanged();
    }

    public void removeUpdate(DocumentEvent e) {
        this.textValueChanged();
    }

    public void textValueChanged() {
        if (this.current_text.equals(this.file_viewer.getText())) {
            return;
        }
        this.current_text = this.file_viewer.getText();
        try {
            this.edit_entry.setHeaderText(this.current_text);
            this.error_text.setText("");
        }
        catch (ReadFormatException e) {
            this.error_text.setText(e + (e.getLineNumber() > 1 ? " at line: " + e.getLineNumber() : ""));
        }
        catch (IOException e) {
            this.error_text.setText(e.toString());
        }
    }

    public void readHeader() {
        String header = this.edit_entry.getHeaderText();
        if (header != null) {
            this.file_viewer.setText(header);
            this.current_text = this.file_viewer.getText();
        }
    }

    private Entry getEntry() {
        return this.edit_entry;
    }
}

