/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.sanger.artemis.components;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import uk.ac.sanger.artemis.EntryGroup;
import uk.ac.sanger.artemis.EntryGroupChangeEvent;
import uk.ac.sanger.artemis.EntryGroupChangeListener;
import uk.ac.sanger.artemis.GotoEventSource;
import uk.ac.sanger.artemis.Options;
import uk.ac.sanger.artemis.Selection;
import uk.ac.sanger.artemis.components.BasePlotGroup;
import uk.ac.sanger.artemis.components.EditMenu;
import uk.ac.sanger.artemis.components.FeatureList;
import uk.ac.sanger.artemis.components.GotoMenu;
import uk.ac.sanger.artemis.components.RunMenu;
import uk.ac.sanger.artemis.components.SelectMenu;
import uk.ac.sanger.artemis.components.ViewMenu;
import uk.ac.sanger.artemis.components.WriteMenu;

public class FeatureListFrame
extends JFrame
implements EntryGroupChangeListener {
    private FeatureList feature_list;
    private EntryGroup entry_group;

    public FeatureListFrame(String title, Selection selection, GotoEventSource goto_event_source, final EntryGroup entry_group, BasePlotGroup base_plot_group) {
        super(title);
        this.entry_group = entry_group;
        this.feature_list = new FeatureList(entry_group, selection, goto_event_source, base_plot_group);
        Font default_font = Options.getOptions().getFont();
        this.setFont(default_font);
        JMenuBar menu_bar = new JMenuBar();
        menu_bar.setFont(default_font);
        this.setJMenuBar(menu_bar);
        JMenu file_menu = new JMenu("File");
        JMenuItem close = new JMenuItem("Close");
        close.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                FeatureListFrame.this.setVisible(false);
                FeatureListFrame.this.dispose();
                FeatureListFrame.this.feature_list.stopListening();
            }
        });
        file_menu.add(close);
        menu_bar.add(file_menu);
        SelectMenu select_menu = new SelectMenu(this, selection, goto_event_source, entry_group, base_plot_group);
        menu_bar.add(select_menu);
        ViewMenu view_menu = new ViewMenu(this, selection, goto_event_source, entry_group, base_plot_group);
        menu_bar.add(view_menu);
        GotoMenu goto_menu = new GotoMenu(this, selection, goto_event_source, entry_group);
        menu_bar.add(goto_menu);
        if (Options.readWritePossible()) {
            EditMenu edit_menu = new EditMenu(this, selection, goto_event_source, entry_group, base_plot_group);
            menu_bar.add(edit_menu);
            WriteMenu write_menu = new WriteMenu((JFrame)this, selection, entry_group);
            menu_bar.add(write_menu);
            RunMenu run_menu = new RunMenu(this, selection);
            menu_bar.add(run_menu);
        }
        this.getContentPane().add((Component)this.feature_list, "Center");
        JPanel panel = new JPanel();
        JButton close_button = new JButton("Close");
        panel.add(close_button);
        close_button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FeatureListFrame.this.setVisible(false);
                FeatureListFrame.this.dispose();
                FeatureListFrame.this.feature_list.stopListening();
            }
        });
        this.getContentPane().add((Component)panel, "South");
        this.pack();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent event) {
                FeatureListFrame.this.setVisible(false);
                entry_group.removeEntryGroupChangeListener(FeatureListFrame.this);
                FeatureListFrame.this.dispose();
                FeatureListFrame.this.feature_list.stopListening();
            }
        });
        entry_group.addEntryGroupChangeListener(this);
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        int screen_height = screen.height;
        int screen_width = screen.width;
        if (screen_width <= 700 || screen_height <= 400) {
            this.setSize(screen_width * 9 / 10, screen_height * 9 / 10);
        } else {
            this.setSize(700, 400);
        }
        this.setLocation(new Point((screen.width - this.getSize().width) / 2, (screen.height - this.getSize().height) / 2));
    }

    public void entryGroupChanged(EntryGroupChangeEvent event) {
        switch (event.getType()) {
            case 6: {
                this.entry_group.removeEntryGroupChangeListener(this);
                this.dispose();
            }
        }
    }

    public FeatureList getFeatureList() {
        return this.feature_list;
    }
}

