/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.sanger.artemis.components;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import uk.ac.sanger.artemis.Entry;
import uk.ac.sanger.artemis.EntryChangeEvent;
import uk.ac.sanger.artemis.EntryChangeListener;
import uk.ac.sanger.artemis.Feature;
import uk.ac.sanger.artemis.FeatureChangeEvent;
import uk.ac.sanger.artemis.FeatureChangeListener;
import uk.ac.sanger.artemis.Options;
import uk.ac.sanger.artemis.components.DisplayAdjustmentEvent;
import uk.ac.sanger.artemis.components.DisplayAdjustmentListener;
import uk.ac.sanger.artemis.components.FeaturePlot;
import uk.ac.sanger.artemis.plot.CoilFeatureAlgorithm;
import uk.ac.sanger.artemis.plot.FeatureAlgorithm;
import uk.ac.sanger.artemis.plot.HydrophilicityAlgorithm;
import uk.ac.sanger.artemis.plot.HydrophobicityAlgorithm;

public class FeaturePlotGroup
extends JFrame
implements EntryChangeListener,
FeatureChangeListener {
    private final int SCROLL_BAR_SIZE = 100;
    private Feature feature;
    private Entry entry;
    private JButton close_button;
    private JPanel bottom_button_panel;
    private JScrollBar scrollbar;
    private final Vector adjustment_listener_list = new Vector();

    public FeaturePlotGroup(Feature feature) {
        super("Graphs for: " + feature.getIDString());
        this.feature = feature;
        this.entry = feature.getEntry();
        FeatureAlgorithm[] plot_value_producers = new FeatureAlgorithm[]{new HydrophobicityAlgorithm(this.getFeature()), new HydrophilicityAlgorithm(this.getFeature()), new CoilFeatureAlgorithm(this.getFeature())};
        Font font = Options.getOptions().getFont();
        this.setFont(font);
        GridBagLayout gridbag = new GridBagLayout();
        this.getContentPane().setLayout(gridbag);
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 11;
        c.gridwidth = 0;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.fill = 1;
        c.weighty = 1.0;
        int i = 0;
        while (i < plot_value_producers.length) {
            FeatureAlgorithm this_algorithm = plot_value_producers[i];
            FeaturePlot new_feature_plot = new FeaturePlot(this_algorithm);
            gridbag.setConstraints(new_feature_plot, c);
            this.getContentPane().add(new_feature_plot);
            new_feature_plot.setVisible(true);
            ++i;
        }
        this.getFeature().getEntry().addEntryChangeListener(this);
        this.getFeature().addFeatureChangeListener(this);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent event) {
                FeaturePlotGroup.this.stopListening();
                FeaturePlotGroup.this.dispose();
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent event) {
                FeaturePlotGroup.this.fixScrollbar();
                FeaturePlotGroup.this.fireAdjustmentEvent(FeaturePlotGroup.this.scrollbar.getValue());
            }
        });
        int new_x_size = feature.getTranslation().length() + 100;
        if (new_x_size > 1000) {
            new_x_size = 1000;
        }
        if (new_x_size < 300) {
            new_x_size = 300;
        }
        this.scrollbar = new JScrollBar(0);
        c.fill = 2;
        c.weighty = 0.0;
        gridbag.setConstraints(this.scrollbar, c);
        this.scrollbar.addAdjustmentListener(new AdjustmentListener(){

            public void adjustmentValueChanged(AdjustmentEvent e) {
                FeaturePlotGroup.this.fireAdjustmentEvent(e.getValue());
            }
        });
        this.getContentPane().add(this.scrollbar);
        Component[] children = this.getContentPane().getComponents();
        int i2 = 0;
        while (i2 < children.length) {
            if (children[i2] instanceof FeaturePlot) {
                this.addDisplayAdjustmentListener((FeaturePlot)children[i2]);
            }
            ++i2;
        }
        this.bottom_button_panel = new JPanel();
        c.fill = 2;
        c.weighty = 0.0;
        gridbag.setConstraints(this.bottom_button_panel, c);
        this.getContentPane().add(this.bottom_button_panel);
        this.close_button = new JButton("Close");
        this.close_button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FeaturePlotGroup.this.stopListening();
                FeaturePlotGroup.this.dispose();
            }
        });
        this.bottom_button_panel.add(this.close_button);
        this.pack();
        this.setSize(new_x_size, this.getSize().height);
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation(new Point((screen.width - this.getSize().width) / 2, (screen.height - this.getSize().height) / 2));
        this.show();
        this.fixScrollbar();
        this.fireAdjustmentEvent(1);
    }

    private void stopListening() {
        this.getEntry().removeEntryChangeListener(this);
        Component[] children = this.getComponents();
        int i = 0;
        while (i < children.length) {
            if (children[i] instanceof FeaturePlot) {
                ((FeaturePlot)children[i]).stopListening();
            }
            ++i;
        }
        this.getFeature().getEntry().removeEntryChangeListener(this);
        this.getFeature().removeFeatureChangeListener(this);
    }

    private void fixScrollbar() {
        int feature_length = this.getFeature().getTranslation().length();
        int scroll_max = feature_length;
        if (scroll_max < 1) {
            scroll_max = 1;
        }
        this.scrollbar.setValues(1, this.getSize().width, 1, scroll_max + 100);
        this.scrollbar.setBlockIncrement(this.getSize().width);
    }

    private void addDisplayAdjustmentListener(DisplayAdjustmentListener l) {
        this.adjustment_listener_list.addElement(l);
    }

    private void removeDisplayAdjustmentListener(DisplayAdjustmentListener l) {
        this.adjustment_listener_list.removeElement(l);
    }

    public void featureChanged(FeatureChangeEvent event) {
        this.fixScrollbar();
        this.fireAdjustmentEvent(this.scrollbar.getValue());
    }

    public void entryChanged(EntryChangeEvent event) {
        switch (event.getType()) {
            case 1: {
                if (event.getFeature() != this.getFeature()) break;
                this.stopListening();
                this.dispose();
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireAdjustmentEvent(int scroll_value) {
        Vector targets;
        int end_value = scroll_value + this.getSize().width;
        int feature_length = this.getFeature().getTranslation().length();
        if (end_value > feature_length) {
            end_value = feature_length;
        }
        DisplayAdjustmentEvent event = new DisplayAdjustmentEvent(this, scroll_value, end_value, this.getSize().width, 1.0f, 0, false, 0);
        FeaturePlotGroup featurePlotGroup = this;
        synchronized (featurePlotGroup) {
            targets = (Vector)this.adjustment_listener_list.clone();
        }
        int i = 0;
        while (i < targets.size()) {
            DisplayAdjustmentListener target = (DisplayAdjustmentListener)targets.elementAt(i);
            target.displayAdjustmentValueChanged(event);
            ++i;
        }
    }

    private Feature getFeature() {
        return this.feature;
    }

    private Entry getEntry() {
        return this.entry;
    }
}

