/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.sanger.artemis.components;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import uk.ac.sanger.artemis.EntryGroup;
import uk.ac.sanger.artemis.Feature;
import uk.ac.sanger.artemis.FeatureSegment;
import uk.ac.sanger.artemis.FeatureSegmentVector;
import uk.ac.sanger.artemis.FeatureVector;
import uk.ac.sanger.artemis.GotoEvent;
import uk.ac.sanger.artemis.GotoEventSource;
import uk.ac.sanger.artemis.Selection;
import uk.ac.sanger.artemis.components.MessageDialog;
import uk.ac.sanger.artemis.components.Navigator;
import uk.ac.sanger.artemis.components.SelectionMenu;
import uk.ac.sanger.artemis.components.TextRequester;
import uk.ac.sanger.artemis.components.TextRequesterEvent;
import uk.ac.sanger.artemis.components.TextRequesterListener;
import uk.ac.sanger.artemis.sequence.Marker;
import uk.ac.sanger.artemis.sequence.MarkerRange;
import uk.ac.sanger.artemis.util.OutOfRangeException;

public class GotoMenu
extends SelectionMenu {
    static final KeyStroke NAVIGATOR_KEY = KeyStroke.getKeyStroke(71, 2);
    static final KeyStroke START_OF_SELECTION_KEY = KeyStroke.getKeyStroke(37, 2);
    static final KeyStroke END_OF_SELECTION_KEY = KeyStroke.getKeyStroke(39, 2);
    static final KeyStroke START_OF_SEQUENCE_KEY = KeyStroke.getKeyStroke(38, 2);
    static final KeyStroke END_OF_SEQUENCE_KEY = KeyStroke.getKeyStroke(40, 2);
    private GotoEventSource goto_event_source;
    private Feature selection_feature;
    private FeatureSegment selection_segment;
    private JMenuItem navigator_item = null;
    private JMenuItem goto_feature_start_item = null;
    private JMenuItem goto_feature_end_item = null;
    private JMenuItem goto_selection_end_item = null;
    private JMenuItem goto_selection_start_item = null;
    private JMenuItem goto_first_item = null;
    private JMenuItem goto_last_item = null;
    private JMenuItem goto_feature_base = null;
    private JMenuItem goto_feature_aa_position = null;

    public GotoMenu(JFrame frame, Selection selection, final GotoEventSource goto_event_source, final EntryGroup entry_group, String menu_name) {
        super(frame, menu_name, selection);
        this.goto_event_source = goto_event_source;
        this.navigator_item = new JMenuItem("Navigator ...");
        this.navigator_item.setAccelerator(NAVIGATOR_KEY);
        this.navigator_item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                new Navigator(GotoMenu.this.getSelection(), GotoMenu.this.goto_event_source, entry_group);
            }
        });
        this.goto_selection_start_item = new JMenuItem("Start of Selection");
        this.goto_selection_start_item.setAccelerator(START_OF_SELECTION_KEY);
        this.goto_selection_start_item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                GotoMenu.this.makeSelectionStartVisible();
            }
        });
        this.goto_selection_end_item = new JMenuItem("End of Selection");
        this.goto_selection_end_item.setAccelerator(END_OF_SELECTION_KEY);
        this.goto_selection_end_item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                GotoMenu.this.makeSelectionEndVisible();
            }
        });
        this.goto_feature_start_item = new JMenuItem("Feature Start");
        this.goto_feature_start_item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                GotoMenu.this.gotoFeatureStart();
            }
        });
        this.goto_feature_end_item = new JMenuItem("Feature End");
        this.goto_feature_end_item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                GotoMenu.this.gotoFeatureEnd();
            }
        });
        this.goto_feature_base = new JMenuItem("Feature Base Position ...");
        this.goto_feature_base.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                GotoMenu.this.gotoFeaturePosition(false);
            }
        });
        this.goto_feature_aa_position = new JMenuItem("Feature Amino Acid ...");
        this.goto_feature_aa_position.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                GotoMenu.this.gotoFeaturePosition(true);
            }
        });
        this.goto_first_item = new JMenuItem("Start of Sequence");
        this.goto_first_item.setAccelerator(START_OF_SEQUENCE_KEY);
        this.goto_first_item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                goto_event_source.gotoFirstBase();
            }
        });
        this.goto_last_item = new JMenuItem("End of Sequence");
        this.goto_last_item.setAccelerator(END_OF_SEQUENCE_KEY);
        this.goto_last_item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                goto_event_source.gotoLastBase();
            }
        });
        this.add(this.navigator_item);
        this.addSeparator();
        this.add(this.goto_selection_start_item);
        this.add(this.goto_selection_end_item);
        this.add(this.goto_feature_start_item);
        this.add(this.goto_feature_end_item);
        this.add(this.goto_first_item);
        this.add(this.goto_last_item);
        this.add(this.goto_feature_base);
        this.add(this.goto_feature_aa_position);
    }

    public GotoMenu(JFrame frame, Selection selection, GotoEventSource goto_event_source, EntryGroup entry_group) {
        this(frame, selection, goto_event_source, entry_group, "Goto");
    }

    private void makeSelectionStartVisible() {
        GotoEvent new_event = new GotoEvent(this, this.getSelection().getStartBaseOfSelection());
        this.goto_event_source.sendGotoEvent(new_event);
    }

    private void makeSelectionEndVisible() {
        GotoEvent new_event = new GotoEvent(this, this.getSelection().getEndBaseOfSelection());
        this.goto_event_source.sendGotoEvent(new_event);
    }

    private void gotoFeatureStart() {
        this.setInternalVariables();
        if (this.selection_feature == null) {
            if (this.selection_segment != null) {
                Feature segment_feature = this.selection_segment.getFeature();
                this.makeFeatureStartVisible(segment_feature);
            }
        } else {
            this.makeFeatureStartVisible(this.selection_feature);
        }
    }

    private void gotoFeatureEnd() {
        this.setInternalVariables();
        if (this.selection_feature == null) {
            if (this.selection_segment != null) {
                Feature segment_feature = this.selection_segment.getFeature();
                this.makeFeatureEndVisible(segment_feature);
            }
        } else {
            this.makeFeatureEndVisible(this.selection_feature);
        }
    }

    private void gotoSegmentStart() {
        this.setInternalVariables();
        if (this.selection_segment == null) {
            if (this.selection_feature != null) {
                this.makeFeatureStartVisible(this.selection_feature);
            }
        } else {
            this.makeSegmentStartVisible(this.selection_segment);
        }
    }

    private void gotoSegmentEnd() {
        this.setInternalVariables();
        if (this.selection_segment == null) {
            if (this.selection_feature != null) {
                this.makeFeatureEndVisible(this.selection_feature);
            }
        } else {
            this.makeSegmentEndVisible(this.selection_segment);
        }
    }

    private void gotoFeaturePosition(final boolean goto_aa_position) {
        if (!this.checkForSelectionFeatures()) {
            return;
        }
        FeatureVector selected_features = this.getSelection().getAllFeatures();
        if (selected_features.size() > 1) {
            new MessageDialog(this.getParentFrame(), "select only one feature");
            return;
        }
        final Feature first_feature = selected_features.elementAt(0);
        TextRequester text_requester = goto_aa_position ? new TextRequester("amino acid position within selected feature:", 18, "") : new TextRequester("base position within selected feature:", 18, "");
        text_requester.addTextRequesterListener(new TextRequesterListener(){

            public void actionPerformed(TextRequesterEvent event) {
                String position_string = event.getRequesterText().trim();
                if (position_string.length() == 0) {
                    return;
                }
                try {
                    MarkerRange selection_range;
                    Marker sequence_marker;
                    int feature_position = Integer.valueOf(position_string);
                    if (goto_aa_position) {
                        int aa_position = (feature_position - 1) * 3 + 1;
                        sequence_marker = first_feature.getPositionInSequence(aa_position);
                    } else {
                        sequence_marker = first_feature.getPositionInSequence(feature_position);
                    }
                    MarkerRange range = new MarkerRange(sequence_marker);
                    GotoMenu.this.goto_event_source.gotoBase(sequence_marker);
                    if (goto_aa_position) {
                        try {
                            MarkerRange codon_end_marker_range = new MarkerRange(sequence_marker.moveBy(2));
                            selection_range = range.combineRanges(codon_end_marker_range, false);
                        }
                        catch (OutOfRangeException outOfRangeException) {
                            selection_range = range;
                        }
                    } else {
                        selection_range = range;
                    }
                    GotoMenu.this.getSelection().setMarkerRange(selection_range);
                }
                catch (NumberFormatException numberFormatException) {
                    new MessageDialog(GotoMenu.this.getParentFrame(), "this is not a number: " + position_string);
                }
                catch (OutOfRangeException outOfRangeException) {
                    new MessageDialog(GotoMenu.this.getParentFrame(), "the base position is not within the selection feature: " + position_string);
                }
            }
        });
        text_requester.show();
    }

    private void makeBaseVisible(Marker base_marker) {
        this.goto_event_source.gotoBase(base_marker);
    }

    private void makeFeatureStartVisible(Feature feature) {
        if (feature == null) {
            return;
        }
        this.makeBaseVisible(feature.getFirstBaseMarker());
    }

    private void makeFeatureEndVisible(Feature feature) {
        if (feature == null) {
            return;
        }
        this.makeBaseVisible(feature.getLastBaseMarker());
    }

    private void makeSegmentStartVisible(FeatureSegment segment) {
        if (segment == null) {
            return;
        }
        Marker first_base = segment.getStart();
        this.makeBaseVisible(first_base);
    }

    private void makeSegmentEndVisible(FeatureSegment segment) {
        if (segment == null) {
            return;
        }
        Marker last_base = segment.getEnd();
        this.makeBaseVisible(last_base);
    }

    private void setInternalVariables() {
        FeatureVector selection_features = this.getSelection().getSelectedFeatures();
        FeatureSegmentVector selection_segments = this.getSelection().getSelectedSegments();
        this.selection_feature = selection_features.size() > 0 ? selection_features.elementAt(0) : null;
        this.selection_segment = selection_segments.size() > 0 ? selection_segments.elementAt(0) : null;
    }

    protected boolean checkForSelection() {
        FeatureVector features_to_check = this.getSelection().getAllFeatures();
        if (features_to_check.size() == 0) {
            new MessageDialog(this.getParentFrame(), "No features selected");
            return false;
        }
        return true;
    }
}

