/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.sanger.artemis.components;

import javax.swing.JFrame;
import uk.ac.sanger.artemis.components.MarkerRangeRequester;
import uk.ac.sanger.artemis.components.MessageDialog;
import uk.ac.sanger.artemis.components.TextRequesterEvent;
import uk.ac.sanger.artemis.io.LocationLexer;
import uk.ac.sanger.artemis.io.Range;
import uk.ac.sanger.artemis.sequence.Bases;
import uk.ac.sanger.artemis.sequence.MarkerRange;
import uk.ac.sanger.artemis.sequence.Strand;
import uk.ac.sanger.artemis.util.OutOfRangeException;

public class MarkerRangeRequesterEvent
extends TextRequesterEvent {
    public MarkerRangeRequesterEvent(MarkerRangeRequester source, String requester_text, int type) {
        super(source, requester_text, type);
    }

    private int[] getRangeInternal() {
        if (this.getRequesterText().length() == 0) {
            return null;
        }
        LocationLexer lexer = new LocationLexer(this.getRequesterText());
        LocationLexer.TokenEnumeration _enum = lexer.getTokens();
        boolean complement_flag = false;
        if (_enum.peekElement() instanceof String && ((String)_enum.peekElement()).equals("complement")) {
            complement_flag = true;
            _enum.nextElement();
        }
        _enum.eatToken('(');
        if (_enum.peekElement() instanceof Integer) {
            int first_base = (Integer)_enum.nextElement();
            if (_enum.peekElement() instanceof Integer || (_enum.eatToken("..") || _enum.eatToken('.') || _enum.eatToken("-")) && _enum.peekElement() instanceof Integer) {
                int last_base = (Integer)_enum.nextElement();
                _enum.eatToken(')');
                if (_enum.peekElement() == null) {
                    if (complement_flag) {
                        int temp = first_base;
                        first_base = last_base;
                        last_base = temp;
                    }
                    return new int[]{first_base, last_base};
                }
                new MessageDialog((JFrame)this.getSource(), "garbage at the end of the range: " + _enum);
                return null;
            }
        }
        new MessageDialog((JFrame)this.getSource(), "error in range: the range should have this form: 100..200 - error at: " + _enum);
        return null;
    }

    public MarkerRange getMarkerRange(Bases bases) {
        try {
            MarkerRange marker_range;
            int[] return_values = this.getRangeInternal();
            if (return_values == null) {
                return null;
            }
            int first_base = return_values[0];
            int last_base = return_values[1];
            if (first_base <= last_base) {
                Strand strand = bases.getForwardStrand();
                marker_range = strand.makeMarkerRangeFromPositions(first_base, last_base);
            } else {
                Strand strand = bases.getReverseStrand();
                int raw_first = bases.getComplementPosition(first_base);
                int raw_last = bases.getComplementPosition(last_base);
                marker_range = strand.makeMarkerRangeFromPositions(raw_last, raw_first);
            }
            return marker_range;
        }
        catch (OutOfRangeException outOfRangeException) {
            new MessageDialog((JFrame)this.getSource(), "the bases are out of range for this sequence");
            return null;
        }
    }

    public Range getRawRange() {
        int[] return_values = this.getRangeInternal();
        if (return_values == null) {
            return null;
        }
        int first_base = return_values[0];
        int last_base = return_values[1];
        try {
            if (first_base < last_base) {
                return new Range(first_base, last_base);
            }
            return new Range(last_base, first_base);
        }
        catch (OutOfRangeException e) {
            throw new Error("internal error - unexpected exception: " + e);
        }
    }
}

