/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.sanger.artemis.editor;

import java.awt.Component;
import java.awt.Dimension;
import java.io.File;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import uk.ac.sanger.artemis.editor.Annotation;
import uk.ac.sanger.artemis.editor.DBViewer;
import uk.ac.sanger.artemis.editor.DataCollectionPane;
import uk.ac.sanger.artemis.editor.FastaTextPane;

public class DataViewInternalFrame
extends JInternalFrame {
    private JTabbedPane tabPane = new JTabbedPane();
    private Annotation ann;

    public DataViewInternalFrame(Object[] dataFile, JDesktopPane desktop, int wid, String qualifier_txt) {
        super("Document " + dataFile[0], true, true, true, true);
        this.ann = new Annotation(desktop);
        StringBuffer annFormat = new StringBuffer();
        annFormat.append(this.htmlBreaks(qualifier_txt.trim()));
        int i = 0;
        while (i < dataFile.length) {
            File fdata = new File((String)dataFile[i]);
            if (!fdata.exists() && !(fdata = new File(String.valueOf((String)dataFile[i]) + ".gz")).exists()) {
                JOptionPane.showMessageDialog(desktop, "Results file: \n" + dataFile[i] + "\ndoes not exist!", "File Not Found", 2);
            } else {
                FastaTextPane fastaPane = new FastaTextPane((String)dataFile[i]);
                if (qualifier_txt.indexOf("/" + fastaPane.getFormat() + "_file=\"") == -1) {
                    if (i > 0) {
                        annFormat.append("\n<br>");
                    }
                    annFormat.append("/" + fastaPane.getFormat() + "_file=\"" + dataFile[i] + "\"");
                }
                JScrollPane dbviewScroll = new JScrollPane();
                DBViewer dbview = new DBViewer(fastaPane, dbviewScroll);
                dbviewScroll.setViewportView(dbview);
                fastaPane.addFastaListener(dbview);
                DataCollectionPane dataPane = new DataCollectionPane(fastaPane, this.ann, desktop);
                fastaPane.addFastaListener(dataPane);
                JSplitPane split = new JSplitPane(0, fastaPane, dataPane);
                split.setDividerLocation(150);
                split.setOneTouchExpandable(true);
                JSplitPane tabPanel = new JSplitPane(1, split, dbviewScroll);
                tabPanel.setDividerLocation(wid / 2);
                tabPanel.setOneTouchExpandable(true);
                String tabName = (String)dataFile[i];
                int ind = tabName.lastIndexOf("/");
                if (ind > -1) {
                    String go = "";
                    if (tabName.indexOf("blastp+go") > -1) {
                        go = ":: GO :: ";
                    }
                    tabName = String.valueOf(go) + tabName.substring(ind + 1);
                }
                this.tabPane.add(String.valueOf(fastaPane.getFormat()) + " " + tabName, tabPanel);
            }
            ++i;
        }
        this.ann.setAnnotation(annFormat.toString().trim());
        JScrollPane annotationScroll = new JScrollPane(this.ann);
        annotationScroll.setPreferredSize(new Dimension(500, 300));
        JSplitPane split = new JSplitPane(0, annotationScroll, this.tabPane);
        split.setDividerLocation(250);
        this.getContentPane().add(split);
        this.setVisible(true);
    }

    protected String getFeatureText() {
        return this.ann.getFeatureText();
    }

    protected void reReadSelectedResults() {
        JSplitPane split = (JSplitPane)this.tabPane.getSelectedComponent();
        Component[] comps = split.getComponents();
        int i = 0;
        while (i < comps.length) {
            if (comps[i] instanceof JSplitPane) {
                Component[] comps2 = ((JSplitPane)comps[i]).getComponents();
                int j = 0;
                while (j < comps2.length) {
                    if (comps2[j] instanceof FastaTextPane) {
                        ((FastaTextPane)comps2[j]).reRead();
                        return;
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    private String htmlBreaks(String t) {
        int ind = 0;
        while ((ind = t.indexOf("\n", ind + 5)) > -1) {
            t = String.valueOf(t.substring(0, ind)) + "<br>" + t.substring(ind);
        }
        return t;
    }
}

