/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.sanger.artemis.editor;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import javax.swing.JComponent;
import javax.swing.JToolTip;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.ToolTipUI;
import uk.ac.sanger.artemis.editor.PlafMacros;

public class MultiLineToolTipUI
extends ToolTipUI {
    static MultiLineToolTipUI SINGLETON = new MultiLineToolTipUI();
    static boolean DISPLAY_ACCELERATOR = true;
    static boolean displayAccelerator;
    int accelerator_offset = 15;
    int inset = 3;
    Graphics g;

    private MultiLineToolTipUI() {
    }

    public static void initialize() {
        String key = "ToolTipUI";
        Class<?> cls = SINGLETON.getClass();
        String name = cls.getName();
        UIManager.put(key, name);
        UIManager.put(name, cls);
    }

    public static ComponentUI createUI(JComponent c) {
        return SINGLETON;
    }

    public void installUI(JComponent c) {
        LookAndFeel.installColorsAndFont(c, "ToolTip.background", "ToolTip.foreground", "ToolTip.font");
        LookAndFeel.installBorder(c, "ToolTip.border");
    }

    public void uninstallUI(JComponent c) {
        LookAndFeel.uninstallBorder(c);
    }

    public static void setDisplayAcceleratorKey(boolean val) {
        displayAccelerator = val;
    }

    public Dimension getPreferredSize(JComponent c) {
        Font font = c.getFont();
        String tipText = ((JToolTip)c).getTipText();
        MyToolTip mtt = new MyToolTip();
        FontMetrics fontMetrics = mtt.toolTipFontMetrics(font);
        int fontHeight = fontMetrics.getHeight();
        if (tipText == null) {
            tipText = "";
        }
        String[] lines = PlafMacros.breakupLines(tipText);
        int num_lines = lines.length;
        int height = num_lines * fontHeight;
        int width = 0;
        int i = 0;
        while (i < num_lines) {
            String keyText;
            int onewidth = fontMetrics.stringWidth(lines[i]);
            if (displayAccelerator && i == num_lines - 1 && !(keyText = this.getAcceleratorString((JToolTip)c)).equals("")) {
                onewidth += fontMetrics.stringWidth(keyText) + this.accelerator_offset;
            }
            width = Math.max(width, onewidth);
            ++i;
        }
        return new Dimension(width + this.inset * 2, height + this.inset * 2);
    }

    public Dimension getMinimumSize(JComponent c) {
        return this.getPreferredSize(c);
    }

    public Dimension getMaximumSize(JComponent c) {
        return this.getPreferredSize(c);
    }

    public void paint(Graphics g, JComponent c) {
        Font font = c.getFont();
        MyToolTip mtt = new MyToolTip();
        FontMetrics fontMetrics = mtt.toolTipFontMetrics(font);
        Dimension dimension = c.getSize();
        int fontHeight = fontMetrics.getHeight();
        int fontAscent = fontMetrics.getAscent();
        String tipText = ((JToolTip)c).getTipText();
        String[] lines = PlafMacros.breakupLines(tipText);
        int num_lines = lines.length;
        g.setColor(c.getBackground());
        g.fillRect(0, 0, dimension.width, dimension.height);
        g.setColor(c.getForeground());
        int i = 0;
        int height = 2 + fontAscent;
        while (i < num_lines) {
            String keyText;
            g.drawString(lines[i], this.inset, height);
            if (displayAccelerator && i == num_lines - 1 && !(keyText = this.getAcceleratorString((JToolTip)c)).equals("")) {
                Font smallFont = new Font(font.getName(), font.getStyle(), font.getSize() - 2);
                g.setFont(smallFont);
                g.drawString(keyText, fontMetrics.stringWidth(lines[i]) + this.accelerator_offset, height);
            }
            ++i;
            height += fontHeight;
        }
    }

    public String getAcceleratorString(JToolTip tip) {
        JComponent comp = tip.getComponent();
        if (comp == null) {
            return "";
        }
        KeyStroke[] keys = comp.getRegisteredKeyStrokes();
        String controlKeyStr = "";
        KeyStroke postTip = KeyStroke.getKeyStroke(112, 2);
        int i = 0;
        while (i < keys.length) {
            if (!postTip.equals(keys[i])) {
                char cfr_ignored_0 = (char)keys[i].getKeyCode();
                int mod = keys[i].getModifiers();
                if (mod == 2) {
                    controlKeyStr = "Ctrl+" + (char)keys[i].getKeyCode();
                    break;
                }
                if (mod == 8) {
                    controlKeyStr = "Alt+" + (char)keys[i].getKeyCode();
                    break;
                }
            }
            ++i;
        }
        return controlKeyStr;
    }

    private class MyToolTip
    extends JToolTip {
        MyToolTip() {
        }

        protected FontMetrics toolTipFontMetrics(Font currentFont) {
            return this.getFontMetrics(currentFont);
        }
    }
}

