/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.sanger.artemis.io;

import java.io.IOException;
import java.io.Writer;
import uk.ac.sanger.artemis.io.ReadFormatException;
import uk.ac.sanger.artemis.io.Sequence;
import uk.ac.sanger.artemis.io.StreamSequence;
import uk.ac.sanger.artemis.util.LinePushBackReader;

public class GenbankStreamSequence
extends StreamSequence {
    private String header_line = null;

    public GenbankStreamSequence(LinePushBackReader in_stream) throws IOException {
        this.readHeader(in_stream);
        this.readSequence(in_stream);
    }

    public GenbankStreamSequence(Sequence sequence) {
        this.setFromString(sequence.toString());
    }

    public GenbankStreamSequence(String sequence_string) {
        this.setFromString(sequence_string);
    }

    public StreamSequence copy() {
        return new GenbankStreamSequence(this);
    }

    public int getFormatType() {
        return 2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void readHeader(LinePushBackReader in_stream) throws IOException {
        String sequence_header = in_stream.readLine();
        if (sequence_header.startsWith("BASE COUNT")) {
            String next_line = in_stream.readLine();
            if (!next_line.startsWith("ORIGIN")) throw new ReadFormatException("Genbank sequence data should have \"ORIGIN\" on the second line");
            sequence_header = String.valueOf(sequence_header) + next_line;
        } else if (!sequence_header.startsWith("ORIGIN")) {
            throw new ReadFormatException("Genbank sequence data should begin with \"BASE COUNT\" or \"ORIGIN\"");
        }
        this.setHeader(sequence_header);
    }

    public String getHeader() {
        return this.header_line;
    }

    public void setHeader(String sequence_string) {
        this.header_line = sequence_string;
    }

    protected void readSequence(LinePushBackReader in_stream) throws IOException {
        String line;
        StringBuffer sequence_buffer = new StringBuffer(50000);
        while ((line = in_stream.readLine()) != null) {
            if (line.equals("//")) {
                in_stream.pushBack(line);
                break;
            }
            if (line.length() < 10) continue;
            line = line.substring(10).toLowerCase();
            int i = 0;
            while (i < line.length()) {
                char this_char = line.charAt(i);
                if (Character.isLetter(this_char) || this_char == '.' || this_char == '-' || this_char == '*') {
                    sequence_buffer.append(this_char);
                } else if (!Character.isSpaceChar(this_char)) {
                    throw new ReadFormatException("GENBANK sequence file contains a character that is not a letter: " + this_char, in_stream.getLineNumber());
                }
                ++i;
            }
        }
        this.setFromString(sequence_buffer.toString());
    }

    public synchronized void writeToStream(Writer writer) throws IOException {
        StringBuffer line_buffer = new StringBuffer(90);
        String sequence = this.toString();
        line_buffer.setLength(0);
        line_buffer.ensureCapacity(90);
        line_buffer.append("BASE COUNT  ");
        this.appendAndPad(line_buffer, 7, String.valueOf(this.getACount()));
        line_buffer.append(" a");
        this.appendAndPad(line_buffer, 7, String.valueOf(this.getCCount()));
        line_buffer.append(" c");
        this.appendAndPad(line_buffer, 7, String.valueOf(this.getGCount()));
        line_buffer.append(" g");
        this.appendAndPad(line_buffer, 7, String.valueOf(this.getTCount()));
        line_buffer.append(" t");
        writer.write(line_buffer + "\nORIGIN\n");
        int i = 0;
        while (i < sequence.length()) {
            int this_line_length = sequence.length() - i < 60 ? sequence.length() - i : 60;
            line_buffer.setLength(0);
            line_buffer.ensureCapacity(90);
            int base_count = i + 1;
            String string_base_count = String.valueOf(base_count);
            this.appendAndPad(line_buffer, 9, string_base_count);
            int j = 0;
            while (j < this_line_length) {
                line_buffer.append(' ');
                int this_block_length = this_line_length - j < 10 ? this_line_length - j : 10;
                line_buffer.append(sequence.substring(i + j, i + j + this_block_length));
                j += 10;
            }
            line_buffer.append("\n");
            writer.write(line_buffer.toString());
            i += 60;
        }
    }

    private void appendAndPad(StringBuffer line_buffer, int max_width, String string) {
        int string_width = string.length();
        int char_index = 0;
        while (char_index < max_width - string_width) {
            line_buffer.append(' ');
            ++char_index;
        }
        line_buffer.append(string);
    }
}

