/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.sanger.artemis.io;

import uk.ac.sanger.artemis.io.EMBLObject;
import uk.ac.sanger.artemis.io.LocationParseNodeVector;
import uk.ac.sanger.artemis.io.Range;
import uk.ac.sanger.artemis.util.OutOfRangeException;

class LocationParseNode
extends EMBLObject {
    public static final int UNKNOWN = 0;
    public static final int COMPLEMENT = 1;
    public static final int JOIN = 2;
    public static final int ORDER = 3;
    public static final int RANGE = 4;
    public static final int ENTRY_RANGE = 5;
    private int node_type;
    private Object child;
    private String entry_name;

    LocationParseNode(int node_type, LocationParseNodeVector children) {
        if (node_type != 2 && node_type != 3) {
            throw new Error("LocationParseNode constructor was called with the wrong type");
        }
        this.node_type = node_type;
        this.child = children;
        if (children.size() < 1) {
            throw new Error("A functional must have at least one argument");
        }
    }

    LocationParseNode(int type, LocationParseNode child) {
        if (type != 1) {
            throw new Error("LocationParseNode constructor was called with the wrong type");
        }
        this.node_type = 1;
        this.child = child;
    }

    LocationParseNode(String entry_name, LocationParseNode node) {
        this.node_type = 5;
        this.child = node;
        this.entry_name = entry_name;
    }

    public LocationParseNode(Range range) {
        this.node_type = 4;
        this.child = range;
    }

    public int getType() {
        return this.node_type;
    }

    public String toString() {
        String return_string;
        switch (this.getType()) {
            case 1: {
                return_string = "complement(" + this.toStringChild() + ")";
                break;
            }
            case 2: {
                return_string = "join(" + this.toStringChildren() + ")";
                break;
            }
            case 3: {
                return_string = "order(" + this.toStringChildren() + ")";
                break;
            }
            case 4: {
                return_string = this.child.toString();
                break;
            }
            case 5: {
                return_string = String.valueOf(this.entry_name) + ":" + this.toStringChild();
                break;
            }
            default: {
                return_string = null;
            }
        }
        return return_string;
    }

    boolean changeRange(Range old_range, Range new_range) {
        switch (this.getType()) {
            case 1: 
            case 5: {
                return ((LocationParseNode)this.child).changeRange(old_range, new_range);
            }
            case 2: 
            case 3: {
                LocationParseNodeVector children = this.getChildren();
                int i = 0;
                while (i < children.size()) {
                    LocationParseNode this_child = children.elementAt(i);
                    boolean return_value = this_child.changeRange(old_range, new_range);
                    if (return_value) {
                        return true;
                    }
                    ++i;
                }
                return false;
            }
            case 4: {
                if (this.getRange().equals(old_range)) {
                    this.setRange(new_range);
                    return true;
                }
                return false;
            }
        }
        return false;
    }

    private LocationParseNode makeJoinFromRange(LocationParseNode node) {
        LocationParseNodeVector children = new LocationParseNodeVector();
        children.addElement(node);
        return new LocationParseNode(2, children);
    }

    private void addRangeToJoin(LocationParseNode new_node) {
        LocationParseNodeVector children = this.getChildren();
        int new_range_start = new_node.getRange().getStart();
        if (children.elementAt(0).getType() == 1) {
            LocationParseNode complement_node = new LocationParseNode(1, new_node);
            int i = children.size() - 1;
            while (i >= 0) {
                Range child_range;
                LocationParseNode complement_child;
                LocationParseNode this_child = children.elementAt(i);
                if (this_child.getType() == 1 && (complement_child = this_child.getComplementChild()).getType() == 4 && (child_range = complement_child.getRange()).getStart() > new_range_start) {
                    children.insertElementAt(complement_node, i + 1);
                    return;
                }
                --i;
            }
            children.insertElementAt(complement_node, 0);
        } else {
            int i = 0;
            while (i < children.size()) {
                LocationParseNode this_child = children.elementAt(i);
                if (this_child.getType() == 4 && this_child.getRange().getStart() > new_range_start) {
                    children.insertElementAt(new_node, i);
                    return;
                }
                ++i;
            }
            children.addElementAtEnd(new_node);
        }
    }

    LocationParseNode addRangeNode(LocationParseNode new_node) {
        switch (this.getType()) {
            case 5: {
                return this;
            }
            case 1: 
            case 4: {
                return this.makeJoinFromRange(this).addRangeNode(new_node);
            }
            case 2: 
            case 3: {
                this.addRangeToJoin(new_node);
                return this;
            }
        }
        throw new Error("internal error - unknown location node type");
    }

    private LocationParseNode removeRangeFromJoin(Range remove_range) {
        LocationParseNodeVector children = this.getChildren();
        if (children.size() > 2) {
            int i = 0;
            while (i < children.size()) {
                LocationParseNode this_child = children.elementAt(i);
                if (this_child.getType() == 1) {
                    LocationParseNode complement_child = this_child.getComplementChild();
                    if (complement_child.getType() == 4 && complement_child.getRange().equals(remove_range)) {
                        children.removeElement(this_child);
                        return this;
                    }
                } else if (this_child.getType() == 4 && this_child.getRange().equals(remove_range)) {
                    children.removeElement(this_child);
                    return this;
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < children.size()) {
                LocationParseNode this_child = children.elementAt(i);
                if (this_child.getType() == 1) {
                    LocationParseNode complement_child = this_child.getComplementChild();
                    if (complement_child.getType() == 4 && complement_child.getRange().equals(remove_range)) {
                        children.removeElement(this_child);
                        return children.elementAt(0);
                    }
                } else if (this_child.getType() == 4 && this_child.getRange().equals(remove_range)) {
                    children.removeElement(this_child);
                    return children.elementAt(0);
                }
                ++i;
            }
        }
        return this;
    }

    LocationParseNode removeRange(Range remove_range) {
        switch (this.getType()) {
            case 5: {
                return this;
            }
            case 1: 
            case 4: {
                throw new Error("internal error - inconsistent location");
            }
            case 2: 
            case 3: {
                return this.removeRangeFromJoin(remove_range);
            }
        }
        throw new Error("internal error - unknown location node type");
    }

    LocationParseNode reverseComplement(int sequence_length) {
        try {
            switch (this.getType()) {
                case 5: {
                    return this;
                }
                case 4: {
                    Range range = this.getRange();
                    Range new_range = new Range(sequence_length - range.getEnd() + 1, sequence_length - range.getStart() + 1);
                    LocationParseNode new_range_node = new LocationParseNode(new_range);
                    return new LocationParseNode(1, new_range_node);
                }
                case 1: {
                    LocationParseNode child = this.getComplementChild();
                    if (child.getType() == 4) {
                        Range range = child.getRange();
                        Range new_range = new Range(sequence_length - range.getEnd() + 1, sequence_length - range.getStart() + 1);
                        return new LocationParseNode(new_range);
                    }
                    return child;
                }
                case 2: 
                case 3: {
                    LocationParseNodeVector children = this.getChildren();
                    LocationParseNodeVector new_children = new LocationParseNodeVector();
                    int i = 0;
                    while (i < children.size()) {
                        LocationParseNode this_child = children.elementAt(i);
                        LocationParseNode new_child = this_child.reverseComplement(sequence_length);
                        new_children.addElementAtEnd(new_child);
                        ++i;
                    }
                    this.child = new_children;
                    return this;
                }
            }
            throw new Error("internal error - unknown location node type: " + this.getType());
        }
        catch (OutOfRangeException e) {
            throw new Error("internal error - unexpected exception: " + e);
        }
    }

    LocationParseNode getCanonical() {
        if (!this.isValid()) {
            return null;
        }
        LocationParseNode new_tree = this.getCanonicalComplement();
        if (new_tree.getType() != 2 && new_tree.getType() != 3) {
            return new_tree;
        }
        LocationParseNodeVector new_children = (LocationParseNodeVector)new_tree.child;
        if (new_children.size() >= 2) {
            LocationParseNode next_node;
            LocationParseNode this_node;
            int i;
            boolean change_happened;
            LocationParseNodeVector entry_range_nodes = new LocationParseNodeVector();
            int i2 = new_children.size() - 1;
            while (i2 >= 0) {
                LocationParseNode node = new_children.elementAt(i2);
                if (node.getType() == 5) {
                    new_children.removeElementAt(i2);
                    entry_range_nodes.addElementAtEnd(node);
                } else if (node.getType() == 1 && node.getComplementChild().getType() == 5) {
                    new_children.removeElementAt(i2);
                    entry_range_nodes.addElementAtEnd(node);
                }
                --i2;
            }
            if (new_children.size() > 0 && new_children.elementAt(0).getType() == 1) {
                do {
                    change_happened = false;
                    i = 0;
                    while (i < new_children.size() - 1) {
                        this_node = new_children.elementAt(i);
                        next_node = new_children.elementAt(i + 1);
                        if (this_node.getComplementChild().getRange().getEnd() < next_node.getComplementChild().getRange().getEnd()) {
                            new_children.setElementAt(next_node, i);
                            new_children.setElementAt(this_node, i + 1);
                            change_happened = true;
                        }
                        ++i;
                    }
                } while (change_happened);
            } else {
                do {
                    change_happened = false;
                    i = 0;
                    while (i < new_children.size() - 1) {
                        this_node = new_children.elementAt(i);
                        next_node = new_children.elementAt(i + 1);
                        if (this_node.getRange().getStart() > next_node.getRange().getStart()) {
                            new_children.setElementAt(next_node, i);
                            new_children.setElementAt(this_node, i + 1);
                            change_happened = true;
                        }
                        ++i;
                    }
                } while (change_happened);
            }
            i2 = 0;
            while (i2 < entry_range_nodes.size()) {
                new_children.addElementAtEnd(entry_range_nodes.elementAt(i2));
                ++i2;
            }
        } else {
            throw new Error("internal error - a JOIN should have > 1 child");
        }
        return new_tree;
    }

    public boolean isValid() {
        return this.isValid(2, 0);
    }

    public LocationParseNode getComplementChild() {
        if (this.getType() != 1) {
            throw new Error("in LocationParseNode.getComplementChild () - node is not a COMPLEMENT");
        }
        return (LocationParseNode)this.child;
    }

    public LocationParseNodeVector getChildren() {
        if (this.getType() != 2 && this.getType() != 3) {
            throw new Error("in LocationParseNode.getChildren () - node is not a JOIN or ORDER");
        }
        return (LocationParseNodeVector)this.child;
    }

    public LocationParseNodeVector getJoinChildren() {
        if (this.getType() != 2) {
            throw new Error("in LocationParseNode.getJoinChildren () - node is not a JOIN");
        }
        return (LocationParseNodeVector)this.child;
    }

    public LocationParseNodeVector getOrderChildren() {
        if (this.getType() != 3) {
            throw new Error("in LocationParseNode.getOrderChildren () - node is not an ORDER");
        }
        return (LocationParseNodeVector)this.child;
    }

    public LocationParseNode getEntryRangeChild() {
        if (this.getType() != 5) {
            throw new Error("in LocationParseNode.getEntryRangeChild () - node is not an ENTRY_RANGE");
        }
        return (LocationParseNode)this.child;
    }

    public Range getRange() {
        if (this.getType() != 4) {
            throw new Error("in LocationParseNode.getRange () - node is not a RANGE " + this.getType());
        }
        return (Range)this.child;
    }

    private LocationParseNode copyInternal(boolean copy_user_data) {
        LocationParseNode new_node;
        switch (this.getType()) {
            case 1: {
                LocationParseNode new_child = this.getComplementChild().copyInternal(copy_user_data);
                new_node = new LocationParseNode(this.getType(), new_child);
                break;
            }
            case 2: 
            case 3: {
                LocationParseNodeVector children_copy = new LocationParseNodeVector();
                LocationParseNodeVector children = (LocationParseNodeVector)this.child;
                int i = 0;
                while (i < children.size()) {
                    LocationParseNode new_child = children.elementAt(i).copyInternal(copy_user_data);
                    children_copy.addElement(new_child);
                    ++i;
                }
                new_node = new LocationParseNode(this.getType(), children_copy);
                break;
            }
            case 4: {
                new_node = new LocationParseNode(this.getRange().copy());
                break;
            }
            case 5: {
                LocationParseNode new_child = ((LocationParseNode)this.child).copyInternal(copy_user_data);
                new_node = new LocationParseNode(this.entry_name, new_child);
                break;
            }
            default: {
                throw new Error("internal error - unknown location node type");
            }
        }
        if (copy_user_data) {
            new_node.setUserData(this.getUserData());
        } else {
            new_node.setUserData(null);
        }
        return new_node;
    }

    LocationParseNode copyClean() {
        return this.copyInternal(false);
    }

    LocationParseNode copy() {
        return this.copyInternal(true);
    }

    void setRange(Range range) {
        if (this.getType() != 4) {
            throw new Error("in LocationParseNode.getRange () - node is not a RANGE " + this.getType());
        }
        this.child = range;
    }

    private String toStringChildren() {
        String return_string = "";
        LocationParseNodeVector children = (LocationParseNodeVector)this.child;
        if (this.getType() == 2 || this.getType() == 3) {
            int i = 0;
            while (i < children.size()) {
                if (i != 0) {
                    return_string = String.valueOf(return_string) + ",";
                }
                return_string = String.valueOf(return_string) + children.elementAt(i).toString();
                ++i;
            }
        } else {
            throw new Error("LocationParseNode.toStringChildren (): Illegal type");
        }
        return return_string;
    }

    private String toStringChild() {
        if (this.child instanceof LocationParseNode) {
            return ((LocationParseNode)this.child).toString();
        }
        throw new Error("LocationParseNode.toStringChild () was called on the wrong type of Object");
    }

    LocationParseNode getNodeComplement() {
        if (this.getType() == 1) {
            return this.getComplementChild().copy();
        }
        return new LocationParseNode(1, this.copy());
    }

    private LocationParseNode getCanonicalComplement() {
        if (this.getType() == 1 && (this.getComplementChild().getType() == 2 || this.getComplementChild().getType() == 3)) {
            LocationParseNode complement_child = this.getComplementChild();
            LocationParseNodeVector complemented_children = new LocationParseNodeVector();
            LocationParseNodeVector complement_children = (LocationParseNodeVector)complement_child.child;
            int i = 0;
            while (i < complement_children.size()) {
                LocationParseNode complemented_child = complement_children.elementAt(i).getNodeComplement();
                complemented_children.addElement(complemented_child);
                ++i;
            }
            return new LocationParseNode(complement_child.getType(), complemented_children);
        }
        return this.copy();
    }

    private boolean isValid(int max_levels, int parent_type) {
        if (this.getType() == 4) {
            return true;
        }
        if (this.getType() == 5) {
            return this.getEntryRangeChild().isValid();
        }
        if (max_levels == 0) {
            return false;
        }
        switch (this.getType()) {
            case 2: 
            case 3: {
                if (parent_type == 0 || parent_type == 1) {
                    boolean found_range_child = false;
                    boolean found_complement_child = false;
                    LocationParseNodeVector children = (LocationParseNodeVector)this.child;
                    int i = 0;
                    while (i < children.size()) {
                        LocationParseNode child_node = children.elementAt(i);
                        boolean return_val = child_node.isValid(max_levels - 1, this.getType());
                        if (!return_val) {
                            return false;
                        }
                        if (child_node.getType() == 4) {
                            found_range_child = true;
                        }
                        if (child_node.getType() == 1) {
                            found_complement_child = true;
                        }
                        ++i;
                    }
                    return !found_range_child || !found_complement_child;
                }
                return false;
            }
            case 1: {
                if (parent_type == 0 || parent_type == 2 || parent_type == 3) {
                    return this.getComplementChild().isValid(max_levels - 1, this.getType());
                }
                return false;
            }
        }
        return false;
    }
}

