/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.sanger.artemis.io;

import java.io.IOException;
import java.util.Hashtable;
import nsdb.CommitFailed;
import nsdb.EmblSeqWriter;
import nsdb.EmblSeqWriterHelper;
import nsdb.InvalidKey;
import nsdb.LocationParse;
import nsdb.NucFeature;
import nsdb.NucFeatureWriter;
import nsdb.NucFeatureWriterHelper;
import type.IndexOutOfRange;
import type.NoResult;
import uk.ac.sanger.artemis.io.CorbaSequence;
import uk.ac.sanger.artemis.io.EMBLObject;
import uk.ac.sanger.artemis.io.Entry;
import uk.ac.sanger.artemis.io.EntryInformation;
import uk.ac.sanger.artemis.io.EntryInformationException;
import uk.ac.sanger.artemis.io.Feature;
import uk.ac.sanger.artemis.io.FeatureEnumeration;
import uk.ac.sanger.artemis.io.FeatureVector;
import uk.ac.sanger.artemis.io.InvalidKeyException;
import uk.ac.sanger.artemis.io.InvalidRelationException;
import uk.ac.sanger.artemis.io.Key;
import uk.ac.sanger.artemis.io.Location;
import uk.ac.sanger.artemis.io.LocationParseException;
import uk.ac.sanger.artemis.io.NucFeatureHasher;
import uk.ac.sanger.artemis.io.QualifierVector;
import uk.ac.sanger.artemis.io.RWCorbaFeature;
import uk.ac.sanger.artemis.io.Range;
import uk.ac.sanger.artemis.io.Sequence;
import uk.ac.sanger.artemis.util.OutOfRangeException;
import uk.ac.sanger.artemis.util.ReadOnlyException;

public class RWCorbaEntry
extends EMBLObject
implements Entry {
    private EmblSeqWriter corba_handle;
    private CorbaSequence sequence = null;
    private Hashtable feature_dictionary = new Hashtable();
    private final EntryInformation entry_information;

    public RWCorbaEntry(EntryInformation entry_information, EmblSeqWriter corba_handle) throws LocationParseException, InvalidKeyException, NoResult, EntryInformationException {
        this.corba_handle = corba_handle;
        this.sequence = new CorbaSequence(corba_handle);
        this.entry_information = entry_information;
        if (this.sequence.length() == 0) {
            this.sequence = null;
        }
    }

    public boolean hasUnsavedChanges() {
        return false;
    }

    public boolean isReadOnly() {
        return false;
    }

    public String getHeaderText() {
        return null;
    }

    public boolean setHeaderText(String new_header) {
        return false;
    }

    public void save() throws IOException {
        try {
            this.corba_handle.commit();
        }
        catch (CommitFailed e) {
            throw new IOException("save failed: " + e.reason);
        }
    }

    public String getName() {
        return "CORBA-" + this.corba_handle.getBioSeqId();
    }

    public boolean setName(String name) {
        return false;
    }

    public Feature createFeature(Key key, Location location, QualifierVector qualifiers) throws InvalidRelationException, ReadOnlyException, EntryInformationException {
        EmblSeqWriter embl_writer = EmblSeqWriterHelper.narrow(this.corba_handle);
        if (embl_writer == null) {
            throw new ReadOnlyException();
        }
        try {
            NucFeatureWriter nuc_feature_writer = embl_writer.createNucFeature(key.toString(), location.toString());
            RWCorbaFeature corba_feature = new RWCorbaFeature(this.getEntryInformation(), nuc_feature_writer);
            corba_feature.setRWCorbaEntry(this);
            corba_feature.setQualifiers(qualifiers);
            NucFeatureHasher hasher = new NucFeatureHasher(nuc_feature_writer);
            this.feature_dictionary.put(hasher, corba_feature);
            return corba_feature;
        }
        catch (LocationParse locationParse) {
            throw new Error("internal error - server doesn't understand this location: " + location.toString());
        }
        catch (IndexOutOfRange e) {
            throw new Error("internal error - location out of range: " + (Object)((Object)e));
        }
        catch (InvalidKey invalidKey) {
            throw new Error("internal error - server won't use this feature key: " + key.toString());
        }
        catch (NoResult e) {
            throw new Error("internal error - unexpected exception: " + (Object)((Object)e));
        }
        catch (nsdb.ReadOnlyException readOnlyException) {
            throw new ReadOnlyException();
        }
    }

    public int getFeatureCount() {
        return this.corba_handle.getNucFeatureCount();
    }

    public Feature add(Feature feature) throws EntryInformationException, ReadOnlyException {
        if (feature.getEntry() != null) {
            throw new Error("internal error - a feature must have one owner");
        }
        try {
            return this.createFeature(feature.getKey(), feature.getLocation(), feature.getQualifiers());
        }
        catch (InvalidRelationException e) {
            throw new Error("internal error - unexpected exception: " + e);
        }
    }

    public Feature forcedAdd(Feature feature) throws ReadOnlyException {
        if (feature.getEntry() != null) {
            throw new Error("internal error - a feature must have one owner");
        }
        try {
            return this.createFeature(feature.getKey(), feature.getLocation(), feature.getQualifiers());
        }
        catch (InvalidRelationException e) {
            throw new Error("internal error - unexpected exception: " + e);
        }
        catch (EntryInformationException e) {
            throw new Error("internal error - unexpected exception: " + e);
        }
    }

    public boolean remove(Feature feature) throws ReadOnlyException {
        if (feature instanceof RWCorbaFeature) {
            RWCorbaFeature corba_feature = (RWCorbaFeature)feature;
            NucFeatureWriter nuc_feature = corba_feature.getNucFeatureWriter();
            if (this.contains(nuc_feature)) {
                try {
                    this.corba_handle.remove(nuc_feature);
                    corba_feature.setRWCorbaEntry(null);
                    return true;
                }
                catch (nsdb.ReadOnlyException readOnlyException) {
                    throw new ReadOnlyException();
                }
            }
            return false;
        }
        return false;
    }

    public Feature getFeatureAtIndex(int index) {
        try {
            NucFeature nuc_feature = this.corba_handle.getFeatureAtIndex(index);
            NucFeatureWriter nuc_feature_writer = NucFeatureWriterHelper.narrow(nuc_feature);
            return this.getFeatureOfNucFeature(nuc_feature_writer);
        }
        catch (IndexOutOfRange indexOutOfRange) {
            throw new IndexOutOfBoundsException();
        }
    }

    public int indexOf(Feature feature) {
        if (!(feature instanceof RWCorbaFeature)) {
            return -1;
        }
        NucFeatureWriter nuc_feature = ((RWCorbaFeature)feature).getNucFeatureWriter();
        return this.corba_handle.indexOf(nuc_feature);
    }

    public boolean contains(Feature feature) {
        if (feature instanceof RWCorbaFeature) {
            NucFeatureWriter nuc_feature = ((RWCorbaFeature)feature).getNucFeatureWriter();
            return this.contains(nuc_feature);
        }
        return false;
    }

    public FeatureEnumeration features() {
        return new FeatureEnumeration(){
            private int i = 0;
            private FeatureVector features;
            {
                this.features = RWCorbaEntry.this.getAllFeatures();
            }

            public boolean hasMoreFeatures() {
                return this.i < this.features.size();
            }

            public Feature nextFeature() {
                return this.features.elementAt(this.i++);
            }
        };
    }

    public FeatureVector getFeaturesInRange(Range range) throws OutOfRangeException {
        FeatureVector return_features = new FeatureVector();
        try {
            NucFeature[] feature_handles = this.corba_handle.getNucFeaturesInRange(range.getStart(), range.getEnd());
            int i = 0;
            while (i < feature_handles.length) {
                NucFeatureWriter this_nuc_feature = NucFeatureWriterHelper.narrow(feature_handles[i]);
                RWCorbaFeature rw_corba_feature = this.getFeatureOfNucFeature(this_nuc_feature);
                return_features.add(rw_corba_feature);
                ++i;
            }
        }
        catch (NoResult noResult) {
        }
        catch (IndexOutOfRange indexOutOfRange) {
            throw new OutOfRangeException(range.toString());
        }
        return return_features;
    }

    public FeatureVector getAllFeatures() {
        FeatureVector return_features = new FeatureVector();
        try {
            NucFeature[] feature_handles = this.corba_handle.getNucFeatures();
            int i = 0;
            while (i < feature_handles.length) {
                NucFeatureWriter this_nuc_feature = NucFeatureWriterHelper.narrow(feature_handles[i]);
                RWCorbaFeature this_feature = this.getFeatureOfNucFeature(this_nuc_feature);
                return_features.add(this_feature);
                ++i;
            }
        }
        catch (NoResult noResult) {}
        return return_features;
    }

    public Sequence getSequence() {
        return this.sequence;
    }

    public EntryInformation getEntryInformation() {
        return this.entry_information;
    }

    private RWCorbaFeature getFeatureOfNucFeature(NucFeatureWriter nuc_feature) {
        NucFeatureHasher hasher = new NucFeatureHasher(nuc_feature);
        RWCorbaFeature feature = (RWCorbaFeature)this.feature_dictionary.get(hasher);
        if (feature == null || feature.getEntry() == null) {
            try {
                RWCorbaFeature new_feature = new RWCorbaFeature(this.getEntryInformation(), nuc_feature);
                this.feature_dictionary.put(hasher, new_feature);
                new_feature.setRWCorbaEntry(this);
                return new_feature;
            }
            catch (NoResult e) {
                throw new Error("internal error - unexpected exception: " + (Object)((Object)e));
            }
            catch (EntryInformationException e) {
                throw new Error("internal error - unexpected exception: " + e);
            }
        }
        return feature;
    }

    private boolean contains(NucFeatureWriter nuc_feature) {
        NucFeatureHasher hasher = new NucFeatureHasher(nuc_feature);
        Object feature = this.feature_dictionary.get(hasher);
        return feature != null;
    }
}

