/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide.registry;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.internal.ide.Category;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.ide.registry.Capability;
import org.eclipse.ui.internal.ide.registry.CapabilityRegistry;
import org.eclipse.ui.internal.ide.registry.IDERegistryReader;

public class CapabilityRegistryReader
extends IDERegistryReader {
    private static final String TAG_CAPABILITY = "capability";
    private static final String TAG_CATEGORY = "category";
    private static final String TAG_HANDLE_UI = "handleUI";
    private static final String TAG_PERSPECTIVE_CHOICE = "perspectiveChoice";
    private static final String ATT_ID = "id";
    private CapabilityRegistry capabilityRegistry;
    private Capability currentCapability;

    protected boolean readElement(IConfigurationElement element) {
        String name = element.getName();
        if (name.equals(TAG_CAPABILITY)) {
            return this.readCapability(element);
        }
        if (name.equals(TAG_CATEGORY)) {
            return this.readCategory(element);
        }
        if (name.equals(TAG_HANDLE_UI)) {
            return this.readHandleUI(element);
        }
        if (name.equals(TAG_PERSPECTIVE_CHOICE)) {
            return this.readPerspectiveChoice(element);
        }
        return false;
    }

    private boolean readCapability(IConfigurationElement element) {
        try {
            Capability capability = new Capability(element, this);
            this.capabilityRegistry.addCapability(capability);
            this.currentCapability = capability;
            this.readElementChildren(element);
            this.currentCapability = null;
            return true;
        }
        catch (WorkbenchException workbenchException) {
            this.currentCapability = null;
            return false;
        }
    }

    private boolean readCategory(IConfigurationElement element) {
        try {
            Category category = new Category(element);
            this.capabilityRegistry.addCategory(category);
        }
        catch (WorkbenchException e) {
            IDEWorkbenchPlugin.log("Unable to create capability category. ", e.getStatus());
        }
        return true;
    }

    private boolean readHandleUI(IConfigurationElement element) {
        String capabilityId = element.getAttribute(ATT_ID);
        if (capabilityId == null) {
            this.logMissingAttribute(element, ATT_ID);
        }
        if (this.currentCapability != null) {
            this.currentCapability.addHandleUI(capabilityId);
        }
        return true;
    }

    private boolean readPerspectiveChoice(IConfigurationElement element) {
        String perspId = element.getAttribute(ATT_ID);
        if (perspId == null) {
            this.logMissingAttribute(element, ATT_ID);
        }
        if (this.currentCapability != null) {
            this.currentCapability.addPerspectiveChoice(perspId);
        }
        return true;
    }

    public void read(IExtensionRegistry registry, CapabilityRegistry out) {
        this.capabilityRegistry = out;
        this.readRegistry(registry, "org.eclipse.ui.ide", "capabilities");
    }
}

