package nsdb;


/**
* nsdb/EntryInfoOperations.java .
* Generated by the IDL-to-Java compiler (portable), version "3.1"
* from corba/nsdb.idl
* Monday, August 23, 2004 12:02:40 PM BST
*/


/**
       * The EMBL database contains information, which is not really part of the
       * sequence information. This information is stored in the EntryInfo.
       */
public interface EntryInfoOperations 
{

  /**
  	 * Retrieve entry indentifier. More information on the 
  	 * <A href="http://www.ebi.ac.uk/ebi_docs/embl_db/usrman/id_line.html">format</A> of
  	 * an entry name is available in the
  	 *  <A href="http://www.ebi.ac.uk/ebi_docs/embl_db/usrman/usrman.html">
  	 * EMBL User Manual</A>.
  	 */
  String getEntryName ();

  /**
  	 * The entry version defines the current version of an EMBL Sequence Database
  	 * Entry. I.e. the complete set information related to a particular sequence.
  	 * The Entry version is incremented whenever anything changes in the sequence or it's 
  	 * associated information.
  	 */
  int getEntryVersion ();

  /**
  	 * Get entry status code.
  	 * @see meta::nsdb
  	 */
  String getEntryStatus ();

  /**
  	 * Sequence of revisions when Entry was created/changed.
  	 */
  type.Revision[] getRevisions ();

  /**
  	 * List of secondary accession numbers. I.e. accession numbers
  	 * of deprecated entries, now merged into the current entry or
  	 * split over multiple entries, as decribed in the 
  	 * <A href="http://www.ebi.ac.uk/ebi_docs/embl_db/usrman/ac_line.html">
  	 * AC line</A> documentation in the User manual.
  	 */
  String[] getSecondaryIds ();

  /**
           * number of adenine
           */
  int getCountA ();

  /**
           * number of cytosine
           */
  int getCountC ();

  /**
           * number of guanine 
           */
  int getCountG ();

  /**
           * number of thymine (in DNA sequence)
           *    or
           * number of uracil (in RNA sequence)
           */
  int getCountT ();
} // interface EntryInfoOperations
