#include <arpa/inet.h>
#include <net/ethernet.h>
#include <netdb.h>
#include <netinet/ether.h>
#include <netinet/if_ether.h>
#include <netinet/ip.h>
#include <pthread.h>
#include <sys/time.h>
#include <unistd.h>
#include <syslog.h>

extern "C" {
#include <pcap.h>
}

#include <unistd.h>
#include <stdio.h>
#include <getopt.h>
#include <time.h>
#include <string.h>
#include <stdlib.h>
#include <iostream>

#include <list>
#include <map>
#include <string>

using namespace std;


#include "ip.h"
#include "dns.h"
#include "prio.h"
#include "monlist.h"

EXEC SQL INCLUDE sqlca;

static pthread_mutex_t SqlWriteMutex;

void	SQLConnect(char *connectionInfo)
{
	EXEC SQL BEGIN DECLARE SECTION;
	char	*connection;
	EXEC SQL END DECLARE SECTION;

	connection = connectionInfo;

	EXEC SQL CONNECT TO :connection;
	if(sqlca.sqlcode) {
		cerr << "connect Error # " << sqlca.sqlerrm.sqlerrml << " '" << sqlca.sqlerrm.sqlerrmc << "'" << endl;
		exit(0);
	}
	pthread_mutex_init(&SqlWriteMutex, NULL);
}

static void timevalToDate(const struct timeval *in, char *out)
{
   struct tm *ti = localtime(&in->tv_sec);
	sprintf(out, "%04d-%02d-%02d %02d:%02d:%02d.%d", 
			ti->tm_year + 1900, ti->tm_mon + 1, ti->tm_mday,
			ti->tm_hour, ti->tm_min, ti->tm_sec,
			in->tv_usec);
}
static int SizeIfExpanded(int count, const unsigned char *in, char *out)
{
	int	ii;
	int	size = 0;

	for (ii = 0; ii < count; ii++, in++) {
		switch (*in) {
		case 0:
			size += 5;
			if (out) {
				*out++ = '\\';
				*out++ = '\\';
				*out++ = '0';
				*out++ = '0';
				*out++ = '0';
			}
			break;
		case '\'':
			size += 2;
			if (out) {
				*out++ = '\\';
				*out++ = '\'';
			}
			break;
		case '\\':
			size += 4;
			if (out) {
				*out++ = '\\';
				*out++ = '\\';
				*out++ = '\\';
				*out++ = '\\';
			}
			break;
		default:
			size++;
			if (out) {
				*out++= *in;
			}
			break;
		}
	}
	return size;
}

static char	*ToPsqlBinaryString(CDataBlockList& dbl)
{
	int	totalSize = 0;
	int	chunks = 0;
	// cout << "segment" << endl;
	for (CDataBlockListIter iter = dbl.begin(); iter != dbl.end(); iter++, chunks++) {
      	int segSize = SizeIfExpanded((*iter)->size_m, (*iter)->data_m, 0);
		// cout << "\tsegment size " << segSize << " in " << chunks << endl;
		totalSize += segSize;
	}
	// cout << "\t\ttotal" << totalSize << endl;
	return "crapola";
}

bool	SQlSaveRecord(CRecord *cr, string interfaceName,  struct timeval *now)
{
	struct in_addr kk;
	EXEC SQL BEGIN DECLARE SECTION;
	int	f_src_ip_serial;
	int	f_dst_ip_serial;
	int	f_port_src;
	int 	f_port_dst;
	int	f_protocol_number;
	int 	f_volume;
	int	f_packets;
	char	f_flushed_at[30];
	int	ind_flushed_at;
	char	f_lastUpdate[30];
	char  f_firstUpdate[30];
	const char	*f_interface;	
	int		ind_contents;
	char	*f_contents;
	EXEC SQL END DECLARE SECTION;

	f_port_src = cr->port_src_m;
	f_src_ip_serial = cr->srcSerial_m;
	f_port_dst = cr->port_dst_m;
	f_dst_ip_serial = cr->dstSerial_m;
	f_protocol_number = cr->ip_proto_m;
	f_volume = cr->volume_m;
	f_packets = cr->packets_m;
	if (now) {
		timevalToDate(now, f_flushed_at);
		ind_flushed_at = 0;
	} else
		ind_flushed_at = -1;
	timevalToDate(&cr->lastUpdate_, f_lastUpdate);
	timevalToDate(&cr->firstUpdate_, f_firstUpdate);
	f_interface = interfaceName.c_str();
	if (cr->dataBlockList_m.size()) {
		ind_contents = 1;
		f_contents = ToPsqlBinaryString(cr->dataBlockList_m);
	} else {
		ind_contents = -1;
	}
	pthread_mutex_lock(&SqlWriteMutex);

	EXEC SQL BEGIN;
	EXEC SQL INSERT INTO usage (src_ip_serial, dst_ip_serial,
		port_src, port_dst, 
		protocol_number, 
		first_seen, last_seen, packets,
		volume, interface, flushed_at)
		/* contents) */
			VALUES (:f_src_ip_serial, :f_dst_ip_serial,
				:f_port_src, :f_port_dst,
				:f_protocol_number, 
				:f_firstUpdate, :f_lastUpdate,
				:f_packets,
				:f_volume,
				:f_interface,
				:f_flushed_at:ind_flushed_at);

	/*			:f_contents:ind_contents); */
	if (sqlca.sqlcode != 0) {//  && sqlca.sqlerrm.sqlerrml != 69) {
		syslog(LOG_MAKEPRI(LOG_DAEMON, LOG_ERR), "insert into usage Error %d message '%s'",
					sqlca.sqlerrm.sqlerrml, sqlca.sqlerrm.sqlerrmc);
		// delete f_contents;
		EXEC SQL ROLLBACK;
		pthread_mutex_unlock(&SqlWriteMutex);
		return false;
	}
	EXEC SQL COMMIT;
	//delete f_contents;
	pthread_mutex_unlock(&SqlWriteMutex);
	return true;
}

int	SQLGetDNS(string resolvedName, const struct in_addr& ip, const char *mac)
{
	int		retCode= 0;
	EXEC SQL BEGIN DECLARE SECTION;
	int 	f_serial;
	char	f_hostname[512];
	char	f_ip_address[16];

	const char	*q_hostname;
	const char	*q_ip_address;
	const char	*q_mac;
	int		ind_mac;
	EXEC SQL END DECLARE SECTION;
	char	ip_char[inet_to_stringSize];


	q_hostname = resolvedName.c_str();
	inet_to_char(ip, ip_char);
	q_ip_address = ip_char;
	if (mac != NULL) {
		ind_mac = 1;
		q_mac = mac;
	} else {
		ind_mac = -1;
	}

	pthread_mutex_lock(&SqlWriteMutex);
	for (;;) {
		EXEC SQL BEGIN;
		EXEC SQL SELECT serial, hostname, ip
				INTO :f_serial, :f_hostname, :f_ip_address
				FROM dnsentry 
				WHERE hostname = :q_hostname AND ip = :q_ip_address;
		
		if (sqlca.sqlcode == 0) {
			retCode = f_serial;
			break;
		} else if (sqlca.sqlcode != ECPG_NOT_FOUND) {
			syslog(LOG_MAKEPRI(LOG_DAEMON, LOG_INFO), "select from dnsentry Error %d message '%s' ip '%s' host '%s'",
					sqlca.sqlerrm.sqlerrml, sqlca.sqlerrm.sqlerrmc, q_ip_address, q_hostname);
			EXEC SQL ROLLBACK;
			break;
		} else {
			EXEC SQL INSERT INTO dnsentry  (hostname, ip, mac)
					VALUES (:q_hostname, :q_ip_address, :q_mac:ind_mac);

			if (sqlca.sqlcode != 0) {
				syslog(LOG_MAKEPRI(LOG_DAEMON, LOG_INFO), "insert into dnsentry Error %d message '%s'",
						sqlca.sqlerrm.sqlerrml, sqlca.sqlerrm.sqlerrmc);
				EXEC SQL ROLLBACK;
				break;
			}
			// continue on to do select to get serial and return it.
		}
		EXEC SQL COMMIT;
	}
	pthread_mutex_unlock(&SqlWriteMutex);
	return retCode;
}

