#ifndef __WP_H
#define __WP_H

#include <linux/ax25.h>
#include <linux/in.h>
#include <linux/rose.h>
#include <sys/socket.h>

#define WP_VECTOR_SIZE	16
#define WP_API_TIMEOUT	10	/* Timeout for access to wp server */

#define MIN(a,b)	((a) < (b) ? (a) : (b))

typedef struct {
	time_t date;
	struct sockaddr_rose address;
	char name[22];
	char city[22];
	char qra_locator[7];
	char free[24];		/* For futur extension */
} wp_t;

typedef struct {
	time_t		date_base;
	unsigned short	interval;
	unsigned short	seed;
	unsigned short	crc[WP_VECTOR_SIZE];	
} vector_t;

typedef enum {
	wp_type_set = 0,
	wp_type_get,
	wp_type_get_response,
	wp_type_response,
	wp_type_vector_request,
	wp_type_vector_response,
	wp_type_ascii = ':',
} wp_pdu_type;

typedef struct {
	wp_pdu_type	type:8;
	union {
		ax25_address	call;
		wp_t		wp;
		unsigned char	status;
		char		string[85];
		vector_t	vector;
	} data;
} wp_pdu;

#define WP_OK			0
#define WP_INVALID_COMMAND	1
#define WP_SET_ERROR		2
#define WP_GET_ERROR		3

#define FPACWP "/var/ax25/fpac/fpacwp.dat"
#define FILE_SIGNATURE	"FPACWP_V001"

typedef struct {
	char	signature[16];
	int	nb_record;
} wp_header;

/* Public fonctions provided by libwp.a */

int wp_check_call(const char *callsign);
int wp_get(ax25_address *call, wp_t *wp);
int wp_listen(void);
int wp_open(char *);
int wp_open_remote(char *source_call, struct sockaddr_rose *remote, int non_block);
int wp_receive_pdu(int s, wp_pdu *pdu);
int wp_search(ax25_address *call, struct sockaddr_rose *addr);
int wp_send_pdu(int s, wp_pdu *pdu);
int wp_set(wp_t *wp);
int wp_update_addr(struct sockaddr_rose *addr);

long wp_nb_records(void);

void wp_close(void);

#endif /* __WP_H */
