/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model.dataformat;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlTransient;
import org.apache.camel.builder.DataFormatBuilder;
import org.apache.camel.model.DataFormatDefinition;
import org.apache.camel.spi.Metadata;

@Metadata(firstVersion="2.11.0", label="dataformat,transformation", title="Base64")
@XmlRootElement(name="base64")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class Base64DataFormat
extends DataFormatDefinition {
    @XmlAttribute
    @Metadata(defaultValue="76", javaType="java.lang.Integer")
    private String lineLength;
    @XmlAttribute
    @Metadata(label="advanced")
    private String lineSeparator;
    @XmlAttribute
    @Metadata(label="advanced", javaType="java.lang.Boolean")
    private String urlSafe;

    public Base64DataFormat() {
        super("base64");
    }

    protected Base64DataFormat(Base64DataFormat source) {
        super(source);
        this.lineLength = source.lineLength;
        this.lineSeparator = source.lineSeparator;
        this.urlSafe = source.urlSafe;
    }

    private Base64DataFormat(Builder builder) {
        this();
        this.lineLength = builder.lineLength;
        this.lineSeparator = builder.lineSeparator;
        this.urlSafe = builder.urlSafe;
    }

    @Override
    public Base64DataFormat copyDefinition() {
        return new Base64DataFormat(this);
    }

    public String getLineLength() {
        return this.lineLength;
    }

    public void setLineLength(String lineLength) {
        this.lineLength = lineLength;
    }

    public String getLineSeparator() {
        return this.lineSeparator;
    }

    public void setLineSeparator(String lineSeparator) {
        this.lineSeparator = lineSeparator;
    }

    public String getUrlSafe() {
        return this.urlSafe;
    }

    public void setUrlSafe(String urlSafe) {
        this.urlSafe = urlSafe;
    }

    @XmlTransient
    public static class Builder
    implements DataFormatBuilder<Base64DataFormat> {
        private String lineLength;
        private String lineSeparator;
        private String urlSafe;

        public Builder lineLength(String lineLength) {
            this.lineLength = lineLength;
            return this;
        }

        public Builder lineLength(int lineLength) {
            this.lineLength = Integer.toString(lineLength);
            return this;
        }

        public Builder lineSeparator(String lineSeparator) {
            this.lineSeparator = lineSeparator;
            return this;
        }

        public Builder urlSafe(String urlSafe) {
            this.urlSafe = urlSafe;
            return this;
        }

        public Builder urlSafe(boolean urlSafe) {
            this.urlSafe = Boolean.toString(urlSafe);
            return this;
        }

        @Override
        public Base64DataFormat end() {
            return new Base64DataFormat(this);
        }
    }
}

