/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.client;

import java.io.IOException;
import java.net.InetSocketAddress;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.retry.FailoverProxyProvider;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.yarn.client.RMFailoverProxyProvider;
import org.apache.hadoop.yarn.client.RMProxy;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class DefaultNoHARMFailoverProxyProvider<T>
implements RMFailoverProxyProvider<T> {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultNoHARMFailoverProxyProvider.class);
    protected T proxy;
    protected Class<T> protocol;

    @Override
    public void init(Configuration conf, RMProxy<T> proxy, Class<T> protocol) {
        this.protocol = protocol;
        try {
            YarnConfiguration yarnConf = new YarnConfiguration(conf);
            InetSocketAddress rmAddress = proxy.getRMAddress(yarnConf, protocol);
            LOG.info("Connecting to ResourceManager at {}", (Object)rmAddress);
            this.proxy = proxy.getProxy(yarnConf, protocol, rmAddress);
        }
        catch (IOException ioe) {
            LOG.error("Unable to create proxy to the ResourceManager ", ioe);
        }
    }

    @Override
    public Class<T> getInterface() {
        return this.protocol;
    }

    @Override
    public FailoverProxyProvider.ProxyInfo<T> getProxy() {
        return new FailoverProxyProvider.ProxyInfo<T>(this.proxy, null);
    }

    @Override
    public void performFailover(T currentProxy) {
    }

    @Override
    public void close() throws IOException {
        RPC.stopProxy(this.proxy);
    }
}

